/***************************************************************************
                          kountdown.cpp  -  the screensaver
                             -------------------
    begin                : Sun Feb 10 09:52:20 CET 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : erre@telia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcolor.h>
#include <qstring.h>
#include <qpainter.h>
#include <qdatetime.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qfontdatabase.h>
#include <qrect.h>
#include <qpoint.h>
#include <qtimer.h>
#include <qregexp.h> // To compile with qt3

#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <kapp.h>

#include "kountdown.h"
#include "kdtimer.h"

Kountdown::Kountdown(WId id)
	: KScreenSaver (id)
{
	listRepaint[0] = &Kountdown::slotRepaintNone;
 	listRepaint[1] = &Kountdown::slotRepaintLoop;
  	listRepaint[2] = &Kountdown::slotRepaintPopup;

   qpixmap = 0;
   repaintTimer = 0;
   tiden = 0;

	readGlobalSettings();
	readSettings(0);
	kountdown();
}

Kountdown::~Kountdown()
{
	repaintTimer->stop();
	delete timer;
}

void Kountdown::readGlobalSettings()
{
	int startFor, halfFor, startRound, halfRound;
	KConfig *config = KGlobal::config();
	
	config->setGroup( "Start settings" );
	startFor = config->readNumEntry( "Display", 127 );
	startRound = config->readNumEntry( "Round Off", 0 );
	
	config->setGroup( "HalfWay settings" );
	halfFor = config->readNumEntry( "Display", 127 );
	halfRound = config->readNumEntry( "Round Off", 0 );	
	
	config->setGroup("Global settings");
	QDateTime temp( QDate::currentDate().addDays(10), QTime::currentTime() );
	QDateTime finish = config->readDateTimeEntry( "FinishDateTime", &temp);
	//QDateTime finish = QDateTime::currentDateTime().addSecs(10);
	targetDate = finish.date().toString();
	targetTime = finish.time().toString();
	
	if ( config->readBoolEntry( "UseHalfWay", false ) )
	{
		temp = QDateTime( finish.addDays(-2) );		
		QDateTime half = config->readDateTimeEntry( "HalfDateTime", &temp);
		//QDateTime half = QDateTime::currentDateTime().addSecs(5);
		timer = new KDTimer( &finish, startFor, startRound, &half, halfFor, halfRound );
	}
	else
		timer = new KDTimer( &finish, startFor, startRound );

	CHECK_PTR( timer );
	connect(timer, SIGNAL( changeSettings(int) ), this, SLOT( readSettings(int) ));
}

void Kountdown::readSettings( int setting )
{
	KConfig *config = KGlobal::config();

	switch (setting)
	{
	case 0:
		config->setGroup( "Start settings" );
		break;
	case 1:
		config->setGroup( "HalfWay settings" );
		break;
  case 2:
    config->setGroup( "Finish settings" );
    break;
  }

  text = config->readEntry( "Text", i18n( "Default text, please setup the screensaver first" ));
  if ( config->readBoolEntry( "RandomBackCol", false ) )
    backCol = randomColor();
  else
    backCol = config->readColorEntry( "BackCol", &Qt::black );
  if ( config->readBoolEntry( "RandomFontCol", false ) )
    fontCol = randomColor();
  else
    fontCol = config->readColorEntry( "FontCol", &Qt::blue );
  if ( config->readBoolEntry( "RandomFont", false ) )
    font = randomFont();
  else
    font = config->readFontEntry( "Font" );
  speed = config->readNumEntry( "Speed", 50 );
  textEffect = config->readNumEntry( "Text effect", 0 );
  repaint = listRepaint[textEffect];

  if ( setting > 0 ) // We have been called to change settings (not setting them)
    kountdown();
}

QFont Kountdown::randomFont()
{
  QFontDatabase fdb;

  QStringList fam = fdb.families();
  QString family( fam[ kapp->random() % fam.count() ] );

  QStringList st = fdb.styles( family );
  QString style( st[ kapp->random() % st.count() ] );

  QValueList<int> si = fdb.pointSizes( family, style );
  int size = si[ kapp->random() % si.count() ];

  return fdb.font( family, style, size );
}

QColor Kountdown::randomColor()
{
  int r = kapp->random() % 255;
  int g = kapp->random() % 255;
  int b = kapp->random() % 255;
  return QColor( r, g, b );
}

void Kountdown::kountdown()
{
	// The pixmap we are painting on
	if ( qpixmap != 0 )
 		delete qpixmap;
	qpixmap = new QPixmap (width(), height());
	
	// The "update screen" timer
 	if ( repaintTimer == 0 )
  	{
   	repaintTimer = new QTimer( this );
		connect( repaintTimer, SIGNAL( timeout() ), this, SLOT( slotRepaint() ) );
	}

	// ----------------------------------------------
	// Copied from kbanner - Basic screen saver for KDE
	// Copyright (c)  Martin R. Jones 1996	
	step = 5 * width() / QApplication::desktop()->width();
	if ( step == 0 )
		step = 1;
	//-----------------------------------------------
		
	erase();
 	
  if ( tiden == 0 )
	{
 		tiden = timer->start();
		connect( timer, SIGNAL( timeLeftChanged() ), this, SLOT( slotGetText() ) );
  	}
	slotGetText(); // Make sure we have some text to display, before painting screen
	
	// Repaint screen, then start timer	
 	if ( textEffect == 0 ) // None text effect
	{
  	  	(this->*repaint)();
		repaintTimer->start( 1000 );  // Repaint every 1s
  	}
	else if ( textEffect == 1 ) // Loop text
	{
		temp = QRect( width(), 0, 0, height() ); // start outside of screen
		(this->*repaint)();
 		repaintTimer->start( 150 - speed );
	}
   else // Popup
   {
		temp = QRect( 0, 0, width(), height() ); // start on screen
		popupTime = 0;
		speed = 100 - speed; 	
		(this->*repaint)();
   	repaintTimer->start( 1000 ); // 1sec
   }
}

void Kountdown::slotGetText()
{
	textDisplay = text;
	textDisplay.replace( QRegExp( "%[Yy]" ), QString::number(tiden->years) );
	textDisplay.replace( QRegExp( "%[Oo]" ), QString::number(tiden->months) );
	textDisplay.replace( QRegExp( "%[Ww]" ), QString::number(tiden->weeks) );		
	textDisplay.replace( QRegExp( "%[Dd]" ), QString::number(tiden->days) );
	textDisplay.replace( QRegExp( "%[Hh]" ), QString::number(tiden->hours) );
	textDisplay.replace( QRegExp( "%[Mm]" ), QString::number(tiden->mins) );
	textDisplay.replace( QRegExp( "%[Ss]" ), QString::number(tiden->secs) );
	textDisplay.replace( QRegExp( "%[Ff]" ), targetDate );
	textDisplay.replace( QRegExp( "%[Tt]" ), targetTime );
}

void Kountdown::slotRepaintNone()
{
 	QPainter paint(qpixmap);
	paint.fillRect( qpixmap->rect(), backCol );
	paint.setPen( fontCol );
	paint.setFont( font );

	paint.drawText( qpixmap->rect(), AlignCenter, textDisplay );
	bitBlt( this, 0, 0, qpixmap, 0, 0, -1, -1, CopyROP );
}

void Kountdown::slotRepaintLoop()
{
	QPainter paint(qpixmap);
	paint.fillRect( qpixmap->rect(), backCol );
	paint.setPen( fontCol );
	paint.setFont( font );

	rect = paint.boundingRect( temp, AlignVCenter, textDisplay );
	paint.drawText( rect, AlignCenter, textDisplay );
	temp.setX( temp.x() - step );
	if ( temp.x() < -rect.width())
		temp.setX( width() );
	
 	bitBlt( this, 0, 0, qpixmap, 0, 0, -1, -1, CopyROP );
}

void Kountdown::slotRepaintPopup()
{
	if (popupTime > 0 && popupTime < speed )
	  	popupTime++;
   else
   {
		if ( popupTime >= speed )
    		popupTime = 0;
		popupTime++;

    	QPainter paint(qpixmap);
		paint.fillRect( qpixmap->rect(), backCol );
		paint.setPen( fontCol );
		paint.setFont( font );

		rect = paint.boundingRect( 0, 0, width(), height(), 0, textDisplay );
		int wid = kapp->random() % ( width() - rect.width() );
  		int hig = kapp->random() % ( height() - rect.height() );

		temp = QRect( wid, hig, width(), height() );
		rect = paint.boundingRect( temp, 0, textDisplay );
		if ( rect.right() > width() )
			rect.moveBottomRight( QPoint( width() - 1, rect.bottom() ) );
		if ( rect.bottom() > height() )
			rect.moveBottomRight( QPoint( rect.right(), height() - 1 ) );
		paint.drawText( rect, AlignCenter, textDisplay );
   }
  	bitBlt( this, 0, 0, qpixmap, 0, 0, -1, -1, CopyROP );
}
