# software-lib.pl
# A generalized system for package management on solaris, linux, etc..

do '../web-lib.pl';
&init_config();

# Use the appropriate function set for whatever package management system
# we are using.
if (-r "./$config{package_system}-lib.pl") {
	do "./$config{package_system}-lib.pl";
	}
else {
	&error("Failed to load functions for $config{package_system} ",
	       "package system");
	}

# uncompress_if_needed(file, disposable)
# If some file needs to be uncompressed or ungzipped, do it and return the
# new temp file path. Otherwise, return the original path.
sub uncompress_if_needed
{
open(PFILE, $_[0]);
read(PFILE, $two, 2);
close(PFILE);
if ($two eq "\037\235") {
	if (!&has_command("uncompress")) {
		unlink($_[0]) if ($_[1]);
		&error("File is compressed, but the uncompress ",
		       "command was not found on your system");
		}
	local $temp = $_[0] =~ /\/([^\/]+)\.Z/i ? "/tmp/$1" : &tempname();
	local $out = `uncompress -c $_[0] 2>&1 >$temp`;
	unlink($_[0]) if ($_[1]);
	if ($?) {
		unlink($temp);
		&error("Failed to uncompress file : $out");
		}
	return $temp;
	}
elsif ($two eq "\037\213") {
	if (!&has_command("gunzip")) {
		unlink($_[0]) if ($_[1]);
		&error("File is gzipped, but the gzip ",
		       "command was not found on your system");
		}
	local $temp = $_[0] =~ /\/([^\/]+)\.gz/i ? "/tmp/$1" : &tempname();
	local $out = `gunzip -c $_[0] 2>&1 >$temp`;
	unlink($_[0]) if ($_[1]);
	if ($?) {
		unlink($temp);
		&error("Failed to gunzip file : $out");
		}
	return $temp;
	}
return $_[0];
}

@type_map = (	"Regular File",		"Directory",	"Special File",
		"Symbolic Link",	"Hard Link",	"Editable File" );

