#!/usr/local/bin/perl
# index.cgi
# Lists all installed packages

require './software-lib.pl';
&header($text{'index_title'}, "", "intro", 0, 1);
print "<hr>\n";
$spacer = "&nbsp;"x3;

# work out the package heirarchy..
$n = &list_packages();
for($i=0; $i<$n; $i++) {
	push(@pack, $packages{$i,'name'});
	push(@class, $packages{$i,'class'});
	push(@desc, $packages{$i,'desc'});
	}
$heir{""} = "";
foreach $c (sort { $a cmp $b } &unique(@class)) {
	if (!$c) { next; }
	@w = split(/\//, $c);
	$p = join('/', @w[0..$#w-1]);
	if (!defined($heir{$p})) {
		$pp = join('/', @w[0..$#w-2]);
		$heir{$pp} .= "$p\0";
		}
	$heir{$p} .= "$c\0";
	$hasclasses++;
	}

# get the current open list
open(HEIROPEN, "$module_config_directory/heiropen");
while(<HEIROPEN>) {
	chop;
	$heiropen{$_}++;
	}
close(HEIROPEN);
$heiropen{""}++;

# traverse the heirarchy
print "<h3>$text{'index_installed'}</h3>\n";
print "<table width=100%>\n";
&traverse("", 0);
print "</table>\n";
if ($hasclasses) {
	print "<a href=closeall.cgi>$text{'index_close'}</a> $spacer\n";
	print "<a href=openall.cgi>$text{'index_open'}</a><p>\n";
	}

print "<form action=search.cgi>\n";
print "<input type=submit value=\"$text{'index_search'}\">\n";
print "<input name=search size=30>\n";
print "</form>\n";

print "<hr>\n";
print "<h3>$text{'index_install'}</h3>\n";
print &text('index_installmsg', &package_system()),"<p>\n";
print "<form action=install_pack.cgi method=post ",
      "enctype=multipart/form-data>\n";
print "<input type=radio name=source value=0 checked> $text{'index_local'}\n";
print "<input name=local size=50>\n";
print &file_chooser_button("local", 0, 1); print "<br>\n";
print "<input type=radio name=source value=1> $text{'index_uploaded'}\n";
print "<input type=file name=upload size=20><br>\n";
print "<input type=radio name=source value=2> $text{'index_ftp'}\n";
print "<input name=url size=50><br>\n";
print "<input type=submit value=\"$text{'index_installok'}\">\n";
print "</form>\n";

print "<hr>\n";
print "<h3>$text{'index_ident'}</h3>\n";
print &text('index_identmsg', &package_system()),"<br>\n";
print "<form action=file_info.cgi>\n";
print "<input type=submit value=\"$text{'index_identok'}\">\n";
print "<input name=file size=30>\n";
print &file_chooser_button("file", 0, 2);
print "</form>\n";

print "<hr>\n";
&footer("/", $text{'index'});

sub traverse
{
local($s, $act, $i);
print "<tr> <td>", $spacer x $_[1];
if ($_[0]) {
	print "<a name=\"$_[0]\"></a>\n";
	$act = $heiropen{$_[0]} ? "close" : "open";
	print "<a href=\"$act.cgi?what=",&urlize($_[0]),"\">";
	$_[0] =~ /([^\/]+)$/;
	print "<img border=0 src=images/$act.gif></a>&nbsp; $1</td>\n",
	}
else { print "<img src=images/close.gif> <i>All Packages</i></td>\n"; }
print "<td><br></td> </tr>\n";
if ($heiropen{$_[0]}) {
	# print sub-folders followed by packages
	for($i=0; $i<@pack; $i++) {
		if ($class[$i] eq $_[0]) {
			print "<tr> <td>", $spacer x ($_[1]+1);
			print "<img border=0 src=images/pack.gif></a>&nbsp;\n";
			print "<a href=\"edit_pack.cgi?package=",
			      &urlize($pack[$i]),"\">$pack[$i]</a></td>\n";
			print "<td>$desc[$i]</td>\n";
			print "</tr>\n";
			}
		}
	foreach $s (&unique(split(/\0+/, $heir{$_[0]}))) {
		&traverse($s, $_[1]+1);
		}
	}
}

