#!/usr/local/bin/perl
# edit_secret.cgi
# Displays a form for editing or creating a pap secret

require './pap-lib.pl';
if (@ARGV) {
	$idx = $ARGV[0];
	&header("Edit PPP Account", "");
	@seclist = &list_secrets();
	%sec = %{$seclist[$idx]};
	}
else {
	&header("Create PPP Account", "");
	}
print "<hr>\n";

print "<form action=save_secret.cgi>\n";
if (%sec) { print "<input type=hidden name=idx value=$idx>\n"; }
print "<table border width=100%>\n";
print "<tr $tb> <td colspan=4><b>PPP Account</b></td> </tr>\n";

print "<tr $cb> <td><b>Username</b></td>\n";
printf "<td><input type=radio name=client_def value=1 %s> Any\n",
	%sec && !$sec{'client'} ? "checked" : "";
printf "<input type=radio name=client_def value=0 %s> ",
	%sec && !$sec{'client'} ? "" : "checked";
print "<input name=client size=20 value=\"$sec{'client'}\"></td>\n";

print "<td><b>Server</b></td>\n";
printf "<td><input type=radio name=server_def value=1 %s> Any\n",
	$sec{'server'} eq "*" ? "checked" : "";
printf "<input type=radio name=server_def value=0 %s> ",
	$sec{'server'} eq "*" ? "" : "checked";
printf "<input name=server size=20 value=\"%s\"></td> </tr>\n",
	$sec{'server'} eq "*" ? "" : $sec{'server'};

print "<tr $cb> <td valign=top><b>Password</b></td>\n";
printf "<td valign=top><input type=radio name=pass_mode value=0 %s> None<br>\n",
	%sec && $sec{'secret'} eq "" ? "checked" : "";
printf "<input type=radio name=pass_mode value=1 %s> From file ",
	$sec{'secret'} =~ /^@(.*)$/ ? "checked" : "";
printf "<input name=pass_file size=20 value=\"%s\">\n",
	$sec{'secret'} =~ /^@(.*)$/ ? $1 : "";
print &file_chooser_button("pass_file", 0);
print "<br>\n";
if (%sec) {
	printf "<input type=radio name=pass_mode value=2 %s> ",
		$sec{'secret'} !~ /^(@.*|)$/ ? "checked" : "";
	print "Leave unchanged<br>\n";
	}
printf "<input type=radio name=pass_mode value=3 %s> Set to\n",
	%sec ? "" : "checked";
print "<input type=password name=pass_text size=15></td>\n";

@ips = @{$sec{'ips'}};
print "<td valign=top><b>Valid Addresses</b></td>\n";
printf "<td><input type=radio name=ips_mode value=0 %s> Allow any<br>\n",
	@ips ? "" : "checked";
printf "<input type=radio name=ips_mode value=1 %s> Allow none<br>\n",
	$ips[0] eq "-" ? "checked" : "";
printf "<input type=radio name=ips_mode value=2 %s> Allow listed..<br>\n",
	@ips && $ips[0] ne "-" ? "checked" : "";
printf "<textarea name=ips rows=5 cols=20>%s</textarea></td> </tr>\n",
	@ips && $ips[0] ne "-" ? join("\n", @ips) : "";

print "</table>\n";
print "<table width=100%><tr><td align=left>\n";
print "<input type=submit value=Save></td>\n";
if (%sec) {
	print "<td align=right>\n";
	print "<input type=submit name=delete value=Delete></td>\n";
	}
print "</tr></table></form>\n";

print "<hr>\n";
&footer("", "account list");

