#!/usr/local/bin/perl
# save_mount.cgi
# Save or create a mount. When saving an existing mount, at lot of different
# things can happen. 

require './mount-lib.pl';
&error_setup($text{'save_err'});
&ReadParse();
$| = 1;

# check inputs
if ($in{type} ne "swap") {
	$in{directory} =~ /^\// ||
		&error(&text('save_edirname', $in{'directory'}));
	if (-r $in{'directory'} && !(-d $in{'directory'})) {
		&error(&text('save_edir', $in{'directory'}));
		}
	# non-existant directories get created later
	}
else {
	# for swap files, set the directory to 'swap'
	$in{directory} = "swap";
	}

# Get user choices
@mmodes = &mount_modes($in{type});
$msave = ($mmodes[0]==0 ? 0 : $in{msave});
$mnow = ($mmodes[1]==0 ? $msave : $in{mmount});

if (defined($in{old})) {
	# Get info about the old mount
	if ($in{temp}) { @mlist = &list_mounted(); }
	else { @mlist = &list_mounts(); }
	@mold = @{$mlist[$in{old}]};

	if (!$mnow && !$in{oldmnow} && !$msave) {
		# Not mounted, so remove from fstab without checking
		$dev = $mold[1];
		}
	else {
		# Changing an existing mount
		$dev = &check_location($in{'type'});
		&parse_options($mold[2], $mold[3]);
		$opts = &check_options($in{'type'}, $dev, $in{'directory'});
		@minfo = ($in{'directory'}, $dev, $in{'type'}, $opts,
			  $mmodes[2] ? $in{'order'} : "-",
			  $in{'msave'}==2||$mmodes[0]==1 ? "yes" : "no");
		}

	# Check for change in device
	if ($mold[1] ne $dev) {
		# Device has changed..check it
		if (!&multiple_mount($minfo[2]) && &get_mounted("*", $dev)>=0) {
			&error(&text('save_ealready', $dev));
			}
		if (!&multiple_mount($minfo[2]) && &get_mount("*", $dev) != -1){
			&error(&text('save_ealready2', $dev));
			}
		$changed = 1;
		}

	# Check for change in directory
	if ($in{type} ne "swap" && $mold[0] ne $in{directory}) {
		# Directory has changed.. check it too
		if (&get_mounted($in{directory}, "*")>=0) {
			&error(&text('save_ealready3', $in{'directory'}));
			}
		if (&get_mount($in{directory}, "*") != -1) {
			&error(&text('save_ealready4', $in{'directory'}));
			}
		$changed = 1;

		if (!(-d $in{directory})) {
			# Create the new directory
			mkdir($in{directory}, 0755) ||
				&error(&text('save_emkdir',
					     $in{'directory'}, $!));
			$made_dir = 1;
			}
		}

	# Check for change in current mount status
	if ($in{'oldmnow'} && $mmodes[3] == 1) {
		# Mounted, and cannot be unmounted
		}
	elsif ($in{'oldmnow'} && !$mnow) {
		# Just been unmounted..
		if ($error = &unmount_dir($mold[0], $mold[1], $in{type})) {
			#if ($error =~ /busy/) {
				# Mount is busy.. most likely because it is
				# currently in use. Offer the user a choice
				# to remove from the mount table only
			#	}
			#else { &error("Unmount failed : $error"); }
			&error(&text('save_eumount', $error));
			}
		}
	elsif ($mnow && !$in{oldmnow}) {
		# Just been mounted..
		if ($error = &mount_dir(@minfo)) {
			&error(&text('save_emount', $error));
			}
		}
	elsif (!$mnow && !$in{oldmnow}) {
		# Not mounted, and doesn't need to be
		}
	elsif (($mold[0] ne $minfo[0] || $mold[1] ne $minfo[1] ||
	       $mold[3] ne $minfo[3]) && !$in{'perm_only'}) {
		# Need to unmount/mount to apply new options
		if ($error = &unmount_dir($mold[0], $mold[1], $in{type})) {
			if ($error =~ /busy|Invalid argument/ && $msave) {
				# Mount is busy.. most likely because it is
				# currently in use. Offer the user a choice
				# to update only the fstab file, rather than
				# the real mount
				&header($text{'edit_title'}, "");
				print "<hr>\n";
				print &text('save_perm', "<tt>$mold[0]</tt>"),
				      "<p>\n";
				print "<form action=save_mount.cgi>\n";
				print "<input type=hidden name=perm_only ",
				      "value=1>\n";
				foreach $k (keys %in) {
					print "<input type=hidden name=$k ",
					      "value=\"$in{$k}\">\n";
					}
				print "<center><input type=submit ",
				      "value=\"$text{'save_apply'}\">",
				      "</center>\n";
				print "</form>\n";

				print "<hr>\n";
				&footer("", $text{'index_return'});
				exit;
				}
			else { &error(&text('save_eremount', $error)); }
			}
		if ($error = &mount_dir(@minfo)) {
			&error(&text('save_eremount', $error));
			}
		}

	# Check for change in permanence
	if ($in{oldmsave} && !$msave) {
		# Delete from mount table
		&delete_mount($in{old});
		}
	elsif ($msave && !$in{oldmsave}) {
		# Add to mount table
		&create_mount(@minfo);
		}
	elsif (!$msave && !$in{oldmsave}) {
		# Not in mount table
		}
	else {
		# Apply any changes in mount options
		&change_mount($in{old}, @minfo);
		}
	}
else {
	# Creating a new mount
	$dev = &check_location($in{type});
	&parse_options($minfo[3]);
	$opts = &check_options($in{type}, $dev, $in{'directory'});
	@minfo = ($in{directory}, $dev, $in{type}, $opts,
		  $mmodes[2] ? $in{order} : "-",
		  $in{msave}==2||$mmodes[0]==1 ? "yes" : "no");

	# Check if anything is being done
	if (!$msave && !$mnow) {
		&error($text{'save_enone'});
		}

	# Check if the device is in use
	if (!&multiple_mount($minfo[2]) && &get_mounted("*", $dev)>=0) {
		&error(&text('save_ealready', $dev));
		}
	if (!&multiple_mount($minfo[2]) && &get_mount("*", $dev) != -1) {
		&error(&text('save_ealready2', $dev));
		}

	# Check if the directory is in use
	if ($in{type} ne "swap") {
		if (&get_mounted($in{directory}, "*")>=0) {
			&error(&text('save_ealready2', $in{'directory'}));
			}
		if (&get_mount($in{directory}, "*") != -1) {
			&error(&text('save_ealready3', $in{'directory'}));
			}
		}

	# Create the directory
	if ($in{type} ne "swap" && !(-d $in{directory})) {
		mkdir($in{directory}, 0755) ||
		  &error(&text('save_emkdir', $in{'directory'}, $!));
		$made_dir = 1;
		}

	# If mounting now, attempt to do it
	if ($mnow) {
		# If the mount fails, give up totally
		if ($error = &mount_dir($minfo[0], $minfo[1],
					$minfo[2], $minfo[3])) {
			if ($made_dir) { rmdir($in{directory}); }
			&error(&text('save_emount', $error));
			}
		}

	# If saving, save now
	if ($msave) {
		&create_mount(@minfo);
		}
	}
&redirect("");
print "done redirect\n";


# undo_changes
# Put back any changes to the fstab file
sub undo_changes
{
if ($in{temp} && $in{mboot}) {
	# a mount was made permanent.. undo by deleting it
	&delete_mount($idx);
	}
elsif (!$in{temp} && !$in{mboot}) {
	# a permanent mount was made temporary.. undo by making it permanent
	&create_mount(@mold);
	}
elsif ($in{mboot}) {
	# some mount options were changed.. undo by changing back
	&change_mount($in{old}, @mold);
	}
if ($made_dir) {
	# A directory for mounting was created.. delete it
	rmdir($in{directory});
	}
}

