#!/usr/local/bin/perl
# save_members.cgi
# Store the members of some list

require './majordomo-lib.pl';
&ReadParse();
%access = &get_module_acl();
&can_edit_list(\%access, $in{'name'}) ||
	&error("You are not allowed to edit this mailing list");
$access{'edit'} ||
	&error("You are not allowed to edit the members of this list");
$list = &get_list($in{'name'}, &get_config());
$conf = &get_list_config($list->{'config'});
$pass = &find_value("admin_passwd", $conf);

# find the list owner's email address
$aliases_files = &get_aliases_file();
@aliases = &foreign_call("sendmail", "list_aliases", $aliases_files);
foreach $a (@aliases) {
	if ($a->{'name'} eq "owner-$in{'name'}" ||
	    $a->{'name'} eq "$in{'name'}-owner") {
		$owner = $a->{'values'}->[0];
		}
	}

if ($in{'update'}) {
	# save the new list of members
	$in{'members'} =~ s/\r//g;
	$in{'members'} =~ s/\n*$/\n/;
	open(MEMS, ">$list->{'members'}");
	print MEMS $in{'members'};
	close(MEMS);
	}
elsif ($in{'add'}) {
	# call majordomo to subscribe an address
	$pass || &error("You must choose a maintenance password before ",
			"subscribing addresses to this list");
	$in{'addr_a'} =~ /^(\S+)\@(\S+)\.(\S+)$/ ||
		&error("The address to subscribe must have be contain a full ",
		       "domain name, like <tt>foo\@bar.com</tt>");
	open(WRAPPER, "|$config{'program_dir'}/wrapper majordomo");
	printf WRAPPER "From: %s\n\n",
		$owner ? $owner : $in{'addr_a'};
	print WRAPPER "approve $pass subscribe $in{'name'} $in{'addr_a'}\n\n";
	close(WRAPPER);
	}
elsif ($in{'remove'}) {
	# call majordomo to unsubscribe an address
	$pass || &error("You must choose a maintenance password before ",
			"unsubscribing addresses from this list");
	$in{'addr_r'} =~ /^(\S+)\@(\S+)\.(\S+)$/ ||
		&error("The address to unsubscribe must have be contain a ",
		       "full domain name, like <tt>foo\@bar.com</tt>");
	open(WRAPPER, "|$config{'program_dir'}/wrapper majordomo");
	printf WRAPPER "From: %s\n\n",
		$owner ? $owner : $in{'addr_r'};
	print WRAPPER "approve $pass unsubscribe $in{'name'} $in{'addr_r'}\n\n";
	close(WRAPPER);
	}
&redirect("edit_list.cgi?name=$in{'name'}");

