#!/usr/local/bin/perl
# index.cgi
# Display a list of run-levels and the actions that are run at boot and
# shutdown time for each level

require './init-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
%access = &get_module_acl();
print "<hr>\n";

if ($config{'init_base'} && $access{'bootup'}) {
	# build list of normal and broken actions
	@iacts = &list_actions();
	foreach $a (@iacts) {
		@ac = split(/\s+/, $a);
		$nodemap{$ac[1]} = $ac[0];
		push(@acts, $ac[0]);
		push(@actsl, "0+$ac[0]");
		push(@actsf, $ac[0] =~ /^\// ? $ac[0]
					     : "$config{'init_dir'}/$ac[0]");
		}
	foreach $r (&list_runlevels()) {
		foreach $w ("S", "K") {
			foreach $a (&runlevel_actions($r, $w)) {
				@ac = split(/\s+/, $a);
				if (!$nodemap{$ac[2]}) {
					push(@acts, $ac[1]);
					push(@actsl,
					     "1+$r+$ac[0]+$ac[1]+$ac[2]+$w");
					push(@actsf, "$config{'init_base'}/rc$r.d/$w$ac[0]$ac[1]");
					}
				}
			}
		}

	if (!$config{'desc'}) {
		# Display actions by name only
		print "<table width=100% border>\n";
		print "<tr $tb> <td><b>$text{'index_title'}</b></td> </tr>\n";
		print "<tr $cb> <td><table width=100%>\n";
		$len = @acts; $len = int(($len+3)/4)*4;
		for($i=0; $i<$len; $i++) {
			if ($i%4 == 0) { print "<tr>\n"; }
			print "<td width=25%>";
			if ($acts[$i]) {
				print "<a href=\"edit_action.cgi?$actsl[$i]\">",
				      "$acts[$i]</a>\n";
				}
			print "</td>\n";
			if ($i%4 == 3) { print "</tr>\n"; }
			}
		print "</table></td></tr></table>\n";
		}
	else {
		# Display actions and descriptions
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'index_action'}</b></td> ",
		      "<td><b>$text{'index_desc'}</b></td> </tr>\n";
		for($i=0; $i<@acts; $i++) {
			print "<tr $cb>\n";
			print "<td><a href=\"edit_action.cgi?$actsl[$i]\">",
			      "$acts[$i]</a></td>\n";
			$d = &html_escape(&init_description($actsf[$i]));
			print "<td>",$d ? $d : "<br>","</td>\n";
			print "</tr>\n";
			}
		print "</table>\n";
		}
	print "<a href=\"edit_action.cgi?2\">$text{'index_add'}</a><p>\n";
	print "<hr>\n";
	}
elsif ($config{'local_script'} && $access{'bootup'}) {
	# Display local bootup script
	print &text('index_script',
		    "<tt>$config{'local_script'}</tt>"),"<br>\n";
	print "<form action=save_local.cgi method=post>\n";
	print "<textarea name=local rows=20 cols=80>";
	open(LOCAL, $config{'local_script'});
	while(<LOCAL>) { print; }
	close(LOCAL);
	print "</textarea><br>\n";
	print "<input type=submit value='$text{'save'}'></form>\n";
	print "<hr>\n";
	}

# reboot/shutdown buttons
print "<table cellpadding=5 width=100%>\n";
if ($access{'reboot'}) {
	print "<form action=reboot.cgi>\n";
	print "<tr> <td><input type=submit ",
	      "value=\"$text{'index_reboot'}\"></td>\n";
	print "</form>\n";
	print "<td>$text{'index_rebootmsg'}</td> </tr>\n";
	}

if ($access{'shutdown'}) {
	print "<form action=shutdown.cgi>\n";
	print "<tr> <td><input type=submit ",
	      "value=\"$text{'index_shutdown'}\"></td>\n";
	print "</form>\n";
	print "<td>$text{'index_shutdownmsg'}</td> </tr>\n";
	}
print "</table>\n";

print "<hr>\n";
&footer("/", $text{'index'});

