#!/usr/local/bin/perl
# atboot.pl
# Called by setup.sh to have webmin started at boot time

$no_acl_check++;
require './init-lib.pl';
if (!$config{'init_base'}) {
	# Add to the boot time rc script
	open(LOCAL, ">>$config{'local_script'}");
	print LOCAL "$config_directory/start	# Start webmin\n";
	close(LOCAL);
	print "Added to bootup script $config{'local_script'}\n";
	}
else {
	# Create a bootup action
	$fn = &action_filename("webmin");
	open(ACTION,">$fn");
	print ACTION "#!/bin/sh\n";
	print ACTION ($config{'chkconfig'} ? "# description: " : "# "),
		     "Start/stop Webmin\n";
	$start_order = "9" x $config{'order_digits'};
	$stop_order = "9" x $config{'order_digits'};
	if ($config{'chkconfig'}) {
		print ACTION "# chkconfig: $config{'chkconfig'} ",
			     "$start_order $stop_order\n";
		}
	print ACTION "\n";
	print ACTION "case \"\$1\" in\n";
	print ACTION "'start')\n";
	print ACTION "\t$config_directory/start\n";
	print ACTION "\ttouch $config{'subsys'}/webmin\n"
		if ($config{'subsys'});
	print ACTION "\t;;\n";
	print ACTION "'stop')\n";
	print ACTION "\t$config_directory/stop\n";
	print ACTION "\trm -f $config{'subsys'}/webmin\n"
		if ($config{'subsys'});
	print ACTION "\t;;\n";
	print ACTION "*)\n";
	print ACTION "\techo \"Usage: \$0 { start | stop }\"\n";
	print ACTION "\t;;\n";
	print ACTION "esac\n";
	print ACTION "exit 0\n";
	close(ACTION);
	chmod(0755, $fn);
	($initrl) = &get_inittab_runlevel();
	&add_rl_action("webmin", $initrl, "S", $start_order);
	&add_rl_action("webmin", $initrl, "K", $stop_order);
	print "Created init script $fn\n";
	}

