#!/usr/local/bin/perl
# edit_part.cgi
# Edit an existing partition

require './format-lib.pl';
$d = $ARGV[0]; $p = $ARGV[1];
@dlist = &list_disks();
$dinfo = $dlist[$d];
&can_edit_disk($dinfo->{'device'}) ||
	&error("You are not allowed to edit this disk");
&header("Edit Partition", "");
print "<hr>\n";
print "<table width=100%><tr> <td valign=top>\n";

print "<table border width=100%>\n";
print "<tr $tb> <td><b>Partition Details</b></td> </tr>\n";
print "<form action=save_part.cgi><tr $cb><td><table>\n";
print "<input type=hidden name=disk value=$d>\n";
print "<input type=hidden name=part value=$p>\n";
@plist = &list_partitions($dinfo->{'device'});
$pinfo = $plist[$p];
$new = !$pinfo->{'end'};

$dinfo->{'device'} =~ /c(\d+)t(\d+)d(\d+)/;
print "<tr> <td valign=top><b>Location:</b></td> <td><table>\n";
print "<tr><td>Controller:</td> <td>$1</td>\n";
print "<td>Target:</td> <td>$2</td> </tr>\n";
print "<tr><td>Unit:</td> <td>$3</td>\n";
print "<td>Partition:</td> <td>$p</td> </tr></table></td> </tr>\n";

$dev = $pinfo->{'device'};
print "<tr> <td><b>Device:</b></td> <td><tt>$dev</tt></td> </tr>\n";

print "<tr> <td><b>Type:</b></td> <td><select name=tag>\n";
foreach $t (&list_tags()) {
	printf "<option %s>$t\n", $t eq $pinfo->{'tag'} ? "selected" : "";
	}
print "</select></td> </tr>\n";

print "<tr> <td><b>Flags:</b></td>\n";
printf "<td nowrap><input type=checkbox name=writable value=1 %s> Writable\n",
	$pinfo->{'flag'} =~ /^w.$/ ? "checked" : "";
printf "<input type=checkbox name=mountable value=1 %s> Mountable</td> </tr>\n",
	$pinfo->{'flag'} =~ /^.m$/ ? "checked" : "";

print "<tr> <td><b>Extent:</b></td>\n";
printf "<td nowrap><input name=start size=6 value=\"%s\"> - \n",
	$pinfo->{'end'} ? $pinfo->{'start'} : "";
printf "<input name=end size=6 value=\"%s\">\n",
	$pinfo->{'end'} ? $pinfo->{'end'} : "";
print "of $dinfo->{'cyl'}</td> </tr>\n";

if ($pinfo->{'end'}) {
	print "<tr> <td><b>Status:</b></td>\n";
	@stat = &device_status($dev);
	if ($stat[1] eq "meta") {
		print "<td>Part of MetaDisk</td> </tr>\n";
		}
	elsif ($stat[1] eq "metadb") {
		print "<td>Part of MetaDisk database</td> </tr>\n";
		}
	elsif (@stat) {
		print "<td>",($stat[2] ? "Mounted" : "For mounting");
		if ($stat[1] eq "swap") {
			print " as Virtual Memory</td> ";
			}
		else { print " on <tt>$stat[0]</tt> as ",
			     "<tt>$stat[1]</tt></td> "; }
		print "</tr>\n";
		}
	else { print "<td>Not in use</td> </tr>\n"; }

	if ($stat[1] !~ /^meta/) {
		print "<tr> <td><b>Filesystem:</b></td>\n";
		$fs = &filesystem_type($dev);
		printf "<td>%s</td> </tr>\n", $fs ? &fstype_name($fs) : "None";
		}
	}

print "</table></td></tr></table><p>\n";
if (@stat) { print "<b>This partition cannot be changed as it is ",
		   "currently in use</b>.\n"; }
elsif ($new) {
	print "<input type=submit value=Setup>\n";
	}
else {
	print "<input type=submit value=Change>\n";
	print "<input type=submit name=delete value=Delete>\n";
	}
print "</form>\n";

print "</td> <td valign=top>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td colspan=2><b>Partition Tasks</b></td> </tr>\n";

print "<tr $cb> <form action=newfs_form.cgi>\n";
print "<td valign=top nowrap><b>New Filesystem</b><br>\n";
if (!$new && (!@stat || $stat[2] == 0)) {
	print "<input type=hidden name=dev value=$dev>\n";
	print "<input type=submit value=Create></td>\n";
	print "<td>Builds a new filesystem on this partition, permanently\n";
	print "erasing any existing files. You must do this after creating\n";
	print "a new partition or changing an existing one.</td>\n";
	}
elsif ($new) {
	print "</td> <td>You cannot build a new filesysten on\n";
	print "this partition as it has not been been setup yet.</td>\n";
	}
else {
	print "</td> <td>You cannot build a new filesystem on\n";
	print "this partition as it is currently mounted. Use the\n";
	print "<a href=/mount/>filesystems module</a> to unmount this\n";	
	print "partition first.</td>\n";
	}
print "</form> </tr>\n";


print "<tr $cb> <form action=fsck_form.cgi>\n";
print "<td valign=top><b>Repair Filesystem</b><br>\n";
if (!$new && (!@stat || $stat[2] == 0) && $fs eq "ufs") {
	print "<input type=hidden name=dev value=$dev>\n";
	print "<input type=submit value=\"Repair\"></td>\n";
	print "<td>Calls the <tt>fsck</tt> program to repair a filesystem\n";
	print "so that it can be mounted. This may be necessary if your\n";
	print "system was not shut down properly.</td>\n";
	}
elsif ($new) {
	print "</td> <td>You cannot check the filesystem on this\n";
	print "partition because it has not been setup yet.</td>\n";
	}
elsif (@stat && $stat[2]) {
	print "</td> <td>You cannot check the filesystem on this\n";
	print "partition because it is currently mounted. Use the\n";
	print "<a href=/mount/>filesystems module</a> to unmount it\n";
	print "first.</td>\n";
	}
elsif (!$fs) {
	print "</td> <td>You cannot check the filesystem on this\n";
	print "partition because it does not have a filesystem.</td>\n";
	}
else {
	print "</td> <td>You cannot check the filesystem on this\n";
	print "partition because only <tt>UFS</tt> filesystems can\n";
	print "be checked.</td>\n";
	}
print "</form> </tr>\n";

print "<tr $cb> <form action=tunefs_form.cgi>\n";
print "<td valign=top><b>Tune Filesystem</b><br>\n";
if (!$new && (!@stat || $stat[2] == 0) && $fs eq "ufs") {
	print "<input type=hidden name=dev value=$dev>\n";
	print "<input type=submit value=\"Tune\"></td>\n";
	print "<td>Allows you to modify various parameters of an existing\n";
	print "filesystem</td> </tr>\n";
	}
elsif ($new) {
	print "</td> <td>You cannot tune the filesystem on this\n";
	print "partition because it has not been setup yet.</td>\n";
	}
elsif (@stat && $stat[2]) {
	print "</td> <td>You cannot tune the filesystem on this\n";
	print "partition because it is currently mounted. Use the\n";
	print "<a href=/mount/>filesystems module</a> to unmount it\n";
	print "first.</td>\n";
	}
elsif (!$fs) {
	print "</td> <td>You cannot tune the filesystem on this\n";
	print "partition because it does not have a filesystem.</td>\n";
	}
elsif ($fs ne "ufs") {
	print "</td> <td>You cannot tune the filesystem on this partition\n";
	print "because only <tt>UFS</tt> filesystems can be tuned.</td></tr>\n";
	}
print "</form> </tr>\n";

print "</table>\n";
print "</td></tr></table>\n";
print "<hr>\n";
&footer("", "disk list");

