#!/usr/local/bin/perl
# edit_options.cgi
# Edit client options for some subnet, shared net, group, host or global

require './dhcpd-lib.pl';
&ReadParse();
$conf = &get_config();
&header($text{'eopt_header'}, "");
if ($in{'pidx'} ne "") {
	$client = $conf->[$in{'pidx'}]->{'members'}->[$in{'idx'}];
	}
elsif ($in{'idx'} ne "") {
	$client = $conf->[$in{'idx'}];
	}
else {
	$client = &get_parent_config();
	}

if ($client->{'name'} eq 'subnet') {
	$title = &text('eopt_subtitle',$client->{'values'}->[0]);
	$back = $text{'eopt_returnsub'};
	}
elsif ($client->{'name'} eq 'shared-network') {
	$title = &text('eopt_snettitle',$client->{'values'}->[0]);
	$back = $text{'eopt_returnsub'};
	}
elsif ($client->{'name'} eq 'host') {
	$title = &text('eopt_hosttitle',$client->{'values'}->[0]);
	$back = $text{'eopt_returnhost'};
	}
elsif ($client->{'name'} eq 'group') {
	@mc = &find("host", $client->{'members'});
	$title = &text('eopt_grouptitle',scalar(@mc));
	$back = $text{'eopt_returnhost'};
	}
else {
	$title = $text{'eopt_alltitle'};
	$back = $text{'eopt_returnindex'};
	}
print "<center><font size=+2>$title</font></center>\n";
print "<hr>\n";

print "<form action=save_options.cgi>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<input type=hidden name=pidx value='$in{'pidx'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'eopt_tabhdr'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
@opts = &find("option", $client->{'members'});

print "<tr>\n";
print &option_input($text{'eopt_chost'}, "host-name", \@opts, 3);
print &option_input($text{'eopt_defrouters'}, "routers", \@opts, 2);
print "</tr>\n";

print "<tr>\n";
print &option_input($text{'eopt_smask'}, "subnet-mask", \@opts, 0);
print &option_input($text{'eopt_baddr'}, "broadcast-address", \@opts, 0);
print "</tr>\n";

print "<tr>\n";
print &option_input($text{'eopt_domname'}, "domain-name", \@opts, 3);
print &option_input($text{'eopt_dnsserv'}, "domain-name-servers", \@opts, 2);
print "</tr>\n";

print "<tr>\n";
print &option_input($text{'eopt_timeserv'}, "time-servers", \@opts, 2);
print &option_input($text{'eopt_logserv'}, "log-servers", \@opts, 2);
print "</tr>\n";

print "<tr>\n";
print &option_input($text{'eopt_swapserv'}, "swap-server", \@opts, 2);
print &option_input($text{'eopt_rdpath'}, "root-path", \@opts, 3);
print "</tr>\n";

print "<tr>\n";
print &option_input($text{'eopt_nisdom'}, "nis-domain", \@opts, 3);
print &option_input($text{'eopt_nisserv'}, "nis-servers", \@opts, 2);
print "</tr>\n";

print "<tr>\n";
print &option_input($text{'eopt_fontserv'}, "font-servers", \@opts, 2);
print &option_input($text{'eopt_xdmserv'}, "x-display-manager", \@opts, 2);
print "</tr>\n";

print "<tr>\n";
print &option_input($text{'eopt_statrouters'}, "static-routes", \@opts, 5);
print "</tr>\n";

print "<tr>\n";
print &option_input($text{'eopt_ntpserv'}, "ntp-servers", \@opts, 2);
print &option_input($text{'eopt_nbns'}, "netbios-name-servers", \@opts, 2);
print "</tr>\n";

print "<tr>\n";
print &option_input($text{'eopt_nbs'}, "netbios-scope", \@opts, 3);
print &option_input($text{'eopt_nbntype'}, "netbios-node-type", \@opts, 1);
print "</tr>\n";

print "</table></td></tr></table>\n";
print "<input type=submit value=\"$text{'save'}\"></form>\n";
print "<hr>\n";
&footer("", $back);

# option_input(text, name, &config, type)
# types values:	0  - IP address
#		1  - Integer
#		2  - IP address list
#		3  - String
#		4  - Yes/no flag
#		5  - IP address pairs
sub option_input
{
local($rv, $v, $i);
for($i=0; $i<@{$_[2]}; $i++) {
	if ($_[2]->[$i]->{'values'}->[0] eq $_[1]) {
		$v = $_[2]->[$i];
		last;
		}
	}
$rv = "<td><b>$_[0]</b></td>\n";
if ($_[3] == 5) { $rv .= "<td colspan=3 nowrap>"; }
else { $rv .= "<td nowrap>"; }
$rv .= sprintf "<input type=radio name=$_[1]_def value=1 %s> $text{'default'}\n",
	$v ? "" : "checked";
$rv .= sprintf "<input type=radio name=$_[1]_def value=0 %s> ",
	$v ? "checked" : "";
local @vl = $v ? @{$v->{'values'}} : ();
@vl = @vl[1..$#vl];
if ($_[3] == 0) {
	$rv .= "<input name=$_[1] size=15 value=\"$vl[0]\">\n";
	}
elsif ($_[3] == 1) {
	$rv .= "<input name=$_[1] size=4 value=\"$vl[0]\">\n";
	}
elsif ($_[3] == 2) {
	@vl = grep { $_ ne "," } @vl;
	$rv .= "<input name=$_[1] size=20 value=\"".join(" ", @vl)."\">\n";
	}
elsif ($_[3] == 3) {
	local $str = &oct_to_string($vl[0]);
	$rv .= "<input name=$_[1] size=10 value=\"$str\">\n";
	}
elsif ($_[3] == 4) {
	$rv .= sprintf "<input name=$_[1] value=1 %s> Yes\n",
			$vl[0] eq "1" ? "checked" : "";
	$rv .= sprintf "<input name=$_[1] value=0 %s> No\n",
			$vl[0] eq "0" ? "checked" : "";
	}
elsif ($_[3] == 5) {
	@vl = grep { $_ ne "," } @vl;
	$rv .= "<input name=$_[1] size=50 value=\"";
	for($i=0; $i<@vl; $i+=2) {
		$rv .= $vl[$i].",".$vl[$i+1];
		}
	$rv .= "\">\n";
	}
$rv .= "</td>\n";
return $rv;
}

sub oct_to_string
{
local @b = split(/:/, $_[0]);
local $rv;
foreach $b (@b) {
	if ($b !~ /^[A-z0-9]{1,2}$/) {
		# Wasn't actually in octet format after all.
		return $_[0];
		}
	$rv .= chr(hex($b));
	}
return $rv;
}

