
require './custom-lib.pl';

# acl_security_form(&options)
# Output HTML for editing security options for the custom module
sub acl_security_form
{
print "<tr> <td valign=top><b>Commands this user can run</b></td>\n";
print "<td><select name=cmds size=5 multiple width=200>\n";
local @cmds = &list_commands();
local ($c, %ccan);
map { $ccan{$_}++ } split(/\s+/, $_[0]->{'cmds'});
foreach $c (@cmds) {
	printf "<option value=%s %s> %s\n",
		$c->{'id'},
		$ccan{$c->{'id'}} || $ccan{"*"} ? "selected" : "",
		$c->{'desc'};
	}
print "</select></td> </tr>\n";

print "<tr> <td><b>Can create and edit commands?</b></td> <td>\n";
printf "<input type=radio name=edit value=1 %s> Yes\n",
	$_[0]->{'edit'} ? "checked" : "";
printf "<input type=radio name=edit value=0 %s> No</td> </tr>\n",
	$_[0]->{'edit'} ? "" : "checked";
}

# acl_security_save(&options)
# Parse the form for security options for the custom module
sub acl_security_save
{
local @cmds = &list_commands();
local @sel = split(/\0/, $in{'cmds'});
if (scalar(@sel) == scalar(@cmds)) {
	$_[0]->{'cmds'} = "*";
	}
else {
	$_[0]->{'cmds'} = join(" ", @sel);
	}
$_[0]->{'edit'} = $in{'edit'};
}

