#!/usr/local/bin/perl
# edit_cron.cgi
# Edit an existing or new cron job

require './cron-lib.pl';
%access = &get_module_acl();
&ReadParse();

if (!$in{'new'}) {
	@jobs = &list_cron_jobs();
	$job = $jobs[$in{'idx'}];
	&can_edit_user(\%access, $job->{'user'}) ||
		&error($text{'edit_ecannot'});
	&header($text{'edit_title'}, "");
	}
else {
	&header($text{'create_title'}, "");
	$job = { 'mins' => '*',
		 'hours' => '*',
		 'days' => '*',
		 'months' => '*',
		 'weekdays' => '*',
		 'active' => 1 };
	}
print "<hr>\n";

print "<form action=save_cron.cgi>\n";
print "<input type=hidden name=new value='$in{'new'}'>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'edit_details'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'edit_user'}</b></td>\n";
if ($access{'mode'} == 1) {
	print "<td><select name=user>\n";
	foreach $u (split(/\s+/, $access{'users'})) {
		printf "<option %s>$u\n",
			$job->{'user'} eq $u ? "selected" : "";
		}
	print "</select></td>\n";
	}
else {
	print "<td><input name=user size=8 value=\"$job->{'user'}\"> ",
		&user_chooser_button("user", 0),"</td>\n";
	}

print "<td> <b>$text{'edit_active'}</b></td>\n";
printf "<td><input type=radio name=active value=1 %s> $text{'yes'}\n",
	$job->{'active'} ? "checked" : "";
printf "<input type=radio name=active value=0 %s> $text{'no'}</td> </tr>\n",
	$job->{'active'} ? "" : "checked";

$rpd = &is_run_parts($job->{'command'});
if ($rpd) {
	# run-parts command.. just show scripts that will be run
	print "<tr> <td valign=top><b>$text{'edit_commands'}</b></td>\n";
	print "<td><tt>",join("<br>",&expand_run_parts($rpd)),
	      "</tt></td> </tr>\n";
	print "<input type=hidden name=cmd value='$job->{'command'}'>\n";
	}
else {
	# Normal cron job.. can edit command
	$job->{'command'} =~ s/\\%/\0/g;
	@lines = split(/%/ , $job->{'command'});
	foreach (@lines) { s/\0/%/g; }
	print "<tr> <td><b>$text{'edit_command'}</b></td>\n";
	$q = $lines[0] =~ /'/ ? '"' : "'";
	print "<td colspan=3><input name=cmd size=50 ",
	      "value=$q$lines[0]$q></td> </tr>\n";

	if ($config{'cron_input'}) {
		print "<tr> <td valign=top><b>$text{'edit_input'}</b></td>\n";
		print "<td colspan=3><textarea name=input rows=3 cols=50>",
		      join("\n" , @lines[1 .. @lines-1]),"</textarea></td> </tr>\n";
		}
	}

print "</table></td></tr></table><p>\n";

print "<table border width=100%>\n";
print "<tr $tb> <td colspan=5><b>$text{'edit_when'}</b></td> </tr> <tr $tb>\n";
print "<td><b>$text{'edit_minutes'}</b></td> <td><b>$text{'edit_hours'}</b></td> ",
      "<td><b>$text{'edit_days'}</b></td> <td><b>$text{'edit_months'}</b></td>",
      "<td><b>$text{'edit_weekdays'}</b></td> </tr> <tr $cb>\n";

@mins = (0..59);
@hours = (0..23);
@days = (1..31);
@months = map { $text{"month_$_"}."=".$_ } (1 .. 12);
@weekdays = map { $text{"day_$_"}."=".$_ } (0 .. 6);

foreach $arr ("mins", "hours", "days", "months", "weekdays") {
	# Find out which ones are being used
	local %inuse;
	$min = ($arr =~ /days|months/ ? 1 : 0);
	$max = $min+scalar(@$arr)-1;
	foreach $w (split(/,/ , $job->{$arr})) {
		if ($w eq "*") {
			# all values
			for($j=$min; $j<=$max; $j++) { $inuse{$j}++; }
			}
		elsif ($w =~ /^\*\/(\d+)$/) {
			# only every Nth
			for($j=$min; $j<=$max; $j+=$1) { $inuse{$j}++; }
			}
		elsif ($w =~ /^(\d+)-(\d+)\/(\d+)$/) {
			# only every Nth of some range
			for($j=$1; $j<=$2; $j+=$3) { $inuse{int($j)}++; }
			}
		elsif ($w =~ /^(\d+)-(\d+)$/) {
			# all of some range
			for($j=$1; $j<=$2; $j++) { $inuse{int($j)}++; }
			}
		else {
			# One value
			$inuse{int($w)}++;
			}
		}
	if ($job->{$arr} eq "*") { undef(%inuse); }

	# Output selection list
	print "<td valign=top>\n";
	printf "<input type=radio name=all_$arr value=1 %s> $text{'edit_all'}<br>\n",
		$job->{$arr} eq "*" ? "checked" : "";
	printf "<input type=radio name=all_$arr value=0 %s> $text{'edit_selected'}<br>\n",
		$job->{$arr} ne "*" ? "checked" : "";
	print "<table> <tr>\n";
	for($j=0; $j<@$arr; $j+=12) {
		$jj = $j+11;
		if ($jj >= @$arr) { $jj = @$arr - 1; }
		@sec = @$arr[$j .. $jj];
		printf "<td valign=top><select multiple size=%d name=$arr>\n",
			@sec > 12 ? 12 : scalar(@sec);
		foreach $v (@sec) {
			if ($v =~ /^(.*)=(.*)$/) { $disp = $1; $code = $2; }
			else { $disp = $code = $v; }
			printf "<option value=\"$code\" %s>$disp\n",
				$inuse{$code} ? "selected" : "";
			}
		print "</select></td>\n";
		}
	print "</tr></table></td>\n";
	}
print "</tr> </table>\n";
if (!$in{'new'}) {
	print "<table width=100%>\n";
	print "<tr> <td align=left><input type=submit value=\"$text{'save'}\"></td>\n";
	if (!$rpd) {
		print "</form><form action=\"exec_cron.cgi\">\n";
		print "<input type=hidden name=idx value=\"$in{'idx'}\">\n";
		print "<td align=center>",
		      "<input type=submit value=\"$text{'edit_run'}\"></td>\n";
		}
	print "</form><form action=\"delete_cron.cgi\">\n";
	print "<input type=hidden name=idx value=\"$in{'idx'}\">\n";
	print "<td align=right><input type=submit value=\"$text{'delete'}\"></td> </tr>\n";
	print "</form></table><p>\n";
	}
else {
	print "<input type=submit value=\"$text{'create'}\"></form><p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

