/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Configuration;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.parser.ModuleDescriptorParserRegistry;
import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;

public class IvyInfo
extends IvyTask {
    private File _file = null;

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void execute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        if (this._file == null) {
            this._file = new File(this.getProject().getBaseDir(), this.getProperty(ivy, "ivy.dep.file"));
        }
        try {
            ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(ivy, this._file.toURL(), this.doValidate(ivy));
            this.getProject().setProperty("ivy.organisation", md.getModuleRevisionId().getOrganisation());
            this.getProject().setProperty("ivy.module", md.getModuleRevisionId().getName());
            if (md.getModuleRevisionId().getRevision() != null) {
                this.getProject().setProperty("ivy.revision", md.getModuleRevisionId().getRevision());
            } else {
                this.getProject().setProperty("ivy.revision", "working@" + Ivy.getLocalHostName());
            }
            this.getProject().setProperty("ivy.configurations", this.mergeConfs(md.getConfigurationsNames()));
            Configuration[] configs = md.getConfigurations();
            ArrayList<String> publicConfigsList = new ArrayList<String>();
            for (int i = 0; i < configs.length; ++i) {
                if (!Configuration.Visibility.PUBLIC.equals(configs[i].getVisibility())) continue;
                publicConfigsList.add(configs[i].getName());
            }
            String[] publicConfigs = publicConfigsList.toArray(new String[publicConfigsList.size()]);
            this.getProject().setProperty("ivy.public.configurations", this.mergeConfs(publicConfigs));
        }
        catch (MalformedURLException e) {
            throw new BuildException("unable to convert given ivy file to url: " + this._file + ": " + e, (Throwable)e);
        }
        catch (ParseException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file: " + e, (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException("impossible to resolve dependencies: " + e, (Throwable)e);
        }
    }
}

