/************************************************************************/
/*									*/
/*  Attributes of text.							*/
/*									*/
/************************************************************************/

#   ifndef	UTIL_TEXT_ATTRIBUTE_H
#   define	UTIL_TEXT_ATTRIBUTE_H

#   include	<utilPropMask.h>

typedef struct TextAttribute
    {
    short int		taFontNumber;
    unsigned int	taFontSizeHalfPoints:10;
    unsigned int	taFontIsBold:1;
    unsigned int	taFontIsSlanted:1;
    unsigned int	taIsUnderlined:1;
    unsigned int	taShowAsLink:1;

    unsigned int	taSmallCaps:1;
    unsigned int	taHasStrikeThrough:1;
    unsigned int	taCapitals:1;

    unsigned int	taSuperSub:2;
#   define		DOCfontREGULAR		0
#   define		DOCfontSUPERSCRIPT	1
#   define		DOCfontSUBSCRIPT	2
    } TextAttribute;

typedef enum TextProperty
    {
    TAprop_NONE= -1,

    TApropFONTFAMILY= 0,
    TApropFONTSIZE,
    TApropFONTBOLD,
    TApropFONTSLANTED,
    TApropTEXTUNDERLINED,
    TApropSHOWASLINK,
    TApropSUPERSUB,
    TApropSMALLCAPS,
    TApropCAPITALS,
    TApropSTRIKETHROUGH,

    TAprop_COUNT
    } TextProperty;

#   define	docEqualFontAttributes(ta1,ta2) ( \
		(ta1)->taFontIsBold == (ta2)->taFontIsBold && \
		(ta1)->taFontIsSlanted == (ta2)->taFontIsSlanted )

#   define	docEqualFont(ta1,ta2) ( \
		(ta1)->taFontNumber == (ta2)->taFontNumber && \
		(ta1)->taFontSizeHalfPoints == (ta2)->taFontSizeHalfPoints && \
		(ta1)->taSuperSub == (ta2)->taSuperSub && \
		(ta1)->taSmallCaps == (ta2)->taSmallCaps && \
		docEqualFontAttributes( (ta1), (ta2) ) )

#   define	docEqualTextAttributes(ta1,ta2) ( \
		docEqualFont((ta1),(ta2)) && \
		(ta1)->taIsUnderlined == (ta2)->taIsUnderlined && \
		(ta1)->taHasStrikeThrough == (ta2)->taHasStrikeThrough && \
		(ta1)->taCapitals == (ta2)->taCapitals && \
		(ta1)->taShowAsLink == (ta2)->taShowAsLink )

#   define	SUPERSUB_SIZE( sz )	( 7*(sz)/10 )

/************************************************************************/
/*									*/
/*  Default attributes.							*/
/*									*/
/************************************************************************/

extern TextAttribute   DocDefaultAttributes;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitTextAttribute(	TextAttribute *		ta );

extern void docAttributeDifference(	PropertyMask *		pChangeMask,
					TextAttribute		taTo,
					TextAttribute		taFrom,
					const PropertyMask *	updMask );

extern void docUpdateTextAttribute(	PropertyMask *		pChangeMask,
					TextAttribute *		taTo,
					TextAttribute		taFrom,
					const PropertyMask *	updMask );

#   endif	/*  UTIL_TEXT_ATTRIBUTE_H	*/
