/************************************************************************/
/*									*/
/*  Utility functionality for 'Inspector' like tools.			*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<appDebugon.h>

#   include	<appFrame.h>

/************************************************************************/
/*									*/
/*  Pull a particular subject of the inspector to front.		*/
/*									*/
/************************************************************************/

void appInspectorSelectSubject(	AppInspector *		ai,
				int			subject )
    {
    const int	andMenu= 1;

    appInspectorChoosePage( ai, andMenu, subject );

    ai->aiCurrentSubject= subject;
    }

/************************************************************************/
/*									*/
/*  An inspector tool must be destroyed.				*/
/*									*/
/************************************************************************/

static void appDestroyInspector(	AppInspector *	ai )
    {
    if  ( ai->aiDestroy )
	{ (*ai->aiDestroy)( ai->aiTarget );	}

    appDestroyShellWidget( ai->aiTopWidget );

    free( ai );

    return;
    }

static APP_CLOSE_CALLBACK( appCloseInspector, w, voidast )
    {
    AppInspector *	ast= (AppInspector *)voidast;

    appDestroyInspector( ast );

    return;
    }

/************************************************************************/
/*									*/
/*  Make the form with the two buttons.					*/
/*									*/
/************************************************************************/

void appInspectorMakeButtonRow(	APP_WIDGET *		pRow,
				APP_WIDGET		parent,
				APP_WIDGET *		pLeftButton,
				APP_WIDGET *		pRightButton,
				char *			leftLabel,
				char *			rightLabel,
				APP_BUTTON_CALLBACK	leftCallback,
				APP_BUTTON_CALLBACK	rightCallback,
				void *			through )
    {
    const int	heightResizable= 0;
    const int	showAsDefault= 0;

    APP_WIDGET	row= appMakeRowInColumn( parent, 2, heightResizable );

    APP_WIDGET	leftButton;
    APP_WIDGET	rightButton;

    appMakeButtonInRow( &leftButton, row, leftLabel, leftCallback, through,
							    0, showAsDefault );
    appMakeButtonInRow( &rightButton, row, rightLabel,rightCallback, through,
							    1, showAsDefault );

    *pRow= row;
    *pLeftButton= leftButton;
    *pRightButton= rightButton;

    return;
    }

void appInspectorMakeToggleRow(		APP_WIDGET *		pRow,
					APP_WIDGET		parent,
					APP_WIDGET *		pLeftToggle,
					APP_WIDGET *		pRightToggle,
					char *			leftText,
					char *			rightText,
					APP_TOGGLE_CALLBACK	leftCallback,
					APP_TOGGLE_CALLBACK	rightCallback,
					void *			through )
    {
    const int	heightResizable= 0;
    APP_WIDGET	row= appMakeRowInColumn( parent, 2, heightResizable );

    APP_WIDGET	leftToggle;
    APP_WIDGET	rightToggle;

    const int	leftColumn= 0;
    const int	rightColumn= 1;

    leftToggle= appMakeToggleInRow( row, leftText, leftCallback,
						    through, leftColumn );
    rightToggle= appMakeToggleInRow( row, rightText, rightCallback,
						    through, rightColumn );

    *pRow= row;
    *pLeftToggle= leftToggle;
    *pRightToggle= rightToggle;

    return;
    }

void appInspectorMakeMenuRow(	APP_WIDGET *		pRow,
				AppOptionmenu *		aom,
				APP_WIDGET *		pLabel,
				APP_WIDGET		parent,
				const char *		labelText )
    {
    APP_WIDGET	row;
    APP_WIDGET	label;

    const int	labelColumn= 0;
    const int	labelColspan= 1;

    const int	menuColumn= labelColumn+ labelColspan;
    const int	menuColspan= 1;
    const int	heightResizable= 0;

    row= appMakeRowInColumn( parent, 2, heightResizable );

    /**************/
    appMakeLabelInRow( &label, row, labelColumn, labelColspan, labelText );

    /**************/
    appMakeOptionmenuInRow( aom, row, menuColumn, menuColspan );

    /**************/

    *pRow= row;
    *pLabel= label;

    return;
    }

/************************************************************************/
/*									*/
/*  Make the pages,							*/
/*  Fill the menu for the pages.					*/
/*									*/
/************************************************************************/

static void appInspectorFillSubjects(	InspectorSubjectResources *	isr,
					AppInspector *			ai )
    {
    int				subject;
    InspectorSubject *		is;

    is= ai->aiSubjects;
    for ( subject= 0; subject < ai->aiSubjectCount; is++, isr++, subject++ )
	{
	appMakeVerticalInspectorPage( &(is->isPage), &(is->isMenuitem),
						    ai, isr->isrSubjectName );
	is->isEnabled= 1;
	}
    }

/************************************************************************/
/*									*/
/*  Turn an inspector or one of its subjects on or off.			*/
/*									*/
/************************************************************************/

void appEnableInspector(	AppInspector *	ai,
				int		enabled )
    {
    appGuiEnableWidget( ai->aiPaned, enabled != 0 );

    return;
    }

void appEnableInspectorSubject(		AppInspector *		ai,
					int			subject ,
					int			enabled )
    {
    appInspectorEnablePage( ai, subject, enabled );

    ai->aiSubjects[subject].isEnabled= enabled != 0;

    return;
    }

/************************************************************************/
/*									*/
/*  Fill an inspector menu.						*/
/*									*/
/************************************************************************/

void appFillInspectorMenu(	int			count,
				int			current,
				APP_WIDGET *		items,
				char * const *		texts,
				AppOptionmenu *		aom,
				APP_BUTTON_CALLBACK	callBack,
				void *			target )
    {
    int			i;

    appEmptyOptionmenu( aom );

    for ( i= 0; i < count; i++ )
	{
	items[i]= appAddItemToOptionmenu( aom, texts[i], callBack, target );
	}

    appSetOptionmenu( aom, current );

    appOptionmenuRefreshWidth( aom );

    return;
    }

AppInspector * appMakeInspector(    EditApplication *		ea,
				    APP_WIDGET			option,
				    const char *		pixmapName,
				    const char *		widgetName,
				    InspectorSubjectResources * isr,
				    int				subjectCount,
				    AppToolDestroy		destroy,
				    void *			through )
    {
    AppInspector *		ai;

    APP_BITMAP_IMAGE		iconPixmap;
    APP_BITMAP_MASK		iconMask;

    const int			userResizable= 0;

    if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap, &iconMask )  )
	{ SDEB(pixmapName); return (AppInspector *)0; }

    ai= (AppInspector *)malloc( sizeof(AppInspector)+ 
				subjectCount* sizeof(InspectorSubject) );
    if  ( ! ai )
	{ LXDEB(subjectCount,ai); return ai;	}

    ai->aiCurrentSubject= -1;
    ai->aiSubjectCount= subjectCount;
    ai->aiDestroy= destroy;
    ai->aiTarget= through;

    appMakeVerticalTool( &(ai->aiTopWidget), &(ai->aiPaned), ea,
				iconPixmap, iconMask,
				widgetName, userResizable,
				option, appCloseInspector, (void *)ai );

    appMakeOptionmenuInColumn( &(ai->aiSubjectOptionmenu), ai->aiPaned );

    appGuiInsertSeparatorInColumn( &(ai->aiSeparator), ai->aiPaned );

    appInspectorMakePageParent( ai );

    appInspectorFillSubjects( isr, ai );

    return ai;
    }

void appFinishInspector(	AppInspector *		ai )
    {
    appShowShellWidget( ai->aiTopWidget );

    appOptionmenuRefreshWidth( &(ai->aiSubjectOptionmenu) );

    return;
    }

