/************************************************************************/
/*									*/
/*  Run file choosers for edit applications.				*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>
#   include	<locale.h>

#   include	<appSystem.h>

#   include	<appFrame.h>
#   include	<appDebugon.h>

#   include	"appFileChooser.h"

/************************************************************************/
/*									*/
/*  Error messages.							*/
/*									*/
/************************************************************************/

static AppConfigurableResource APP_ChooserResourceTable[]=
    {
	APP_RESOURCE( "chooserNoFilename",
		    offsetof(AppChooserInformation,aciNoFilenameMessage),
		    "Please Give a Name" ),
	APP_RESOURCE( "chooserIsDirectory",
		    offsetof(AppChooserInformation,aciIsDirecoryMessage),
		    "Is a directory" ),
	APP_RESOURCE( "chooserNotWritable",
		    offsetof(AppChooserInformation,aciNotWritableMessage),
		    "You have no permission to write this file." ),
	APP_RESOURCE( "chooserNotReadable",
		    offsetof(AppChooserInformation,aciNotReadableMessage),
		    "You have no permission to read this file." ),
	APP_RESOURCE( "chooserOverwrite",
		    offsetof(AppChooserInformation,aciOverwriteMessage),
		    "Do you want to overwrite this file?" ),
	APP_RESOURCE( "chooserNoSuchDir",
		    offsetof(AppChooserInformation,aciNoSuchDirMessage),
		    "This directory does not exist." ),
    };

/************************************************************************/
/*									*/
/*  Retrieve the configurable texts of a file chooser.			*/
/*									*/
/************************************************************************/

void appFileChooserGetTexts(	EditApplication *		ea,
				AppChooserInformation *		aci )
    {
    appGuiGetResourceValues( ea, (void *)aci, APP_ChooserResourceTable,
				    sizeof(APP_ChooserResourceTable)/
				    sizeof(AppConfigurableResource) );

    return;
    }

/************************************************************************/
/*									*/
/*  Some tests on the name of a file that is to be opened.		*/
/*									*/
/************************************************************************/

int appFileChooserTestNameForOpen(
				const AppChooserInformation *	aci,
				const char *			filename  )
    {
    EditApplication *		ea= aci->aciApplication;
    APP_WIDGET			option= aci->aciOption;

    int				fileExists= 0;
    int				fileReadable= 0;
    int				isDir= 0;

    fileExists= appTestFileExists( filename ) == 0;

    if  ( fileExists )
	{ fileReadable= appTestFileReadable( filename ) == 0;	}
    else{ isDir= appTestDirectory( filename ) == 0;		}

    if  ( isDir )
	{
	appQuestionRunSubjectErrorDialog( ea, aci->aciDialog.adTopWidget,
				option, filename, aci->aciIsDirecoryMessage );
	return -1;
	}

    if  ( ! fileExists )
	{
	AppFileMessageResources *	afmr= &(ea->eaFileMessageResources);

	appQuestionRunSubjectErrorDialog( ea, aci->aciDialog.adTopWidget,
			    option, filename, afmr->afmrNoSuchFileMessage );

	return -1;
	}

    if  ( ! fileReadable )
	{
	appQuestionRunSubjectErrorDialog( ea, aci->aciDialog.adTopWidget,
			    option, filename, aci->aciNotReadableMessage );
	return -1;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Save and partially validate the file name of a file chooser.	*/
/*									*/
/************************************************************************/

int appChooserSaveFilename(		AppChooserInformation *	aci,
					const char *		filename )
    {
    EditApplication *			ea= aci->aciApplication;
    APP_WIDGET				option= aci->aciOption;

    char *				extension= (char *)0;
    const char *			slash;
    const char *			relative;

    int					fileNameLength;

    char *				fresh;

    fileNameLength= strlen( filename );
    fresh= malloc( fileNameLength+ 11 );
    if  ( ! fresh )
	{
	LXDEB(fileNameLength,fresh);
	appGuiBreakDialog( &(aci->aciDialog), ACIrespFAILURE );
	return -1;
	}
    strcpy( fresh, filename );

    if  ( aci->aciFilename )
	{ free( aci->aciFilename ); aci->aciFilename= (char *)0;	}
    aci->aciFilename= fresh;

    if  ( aci->aciExtensionCount > 0 )
	{
	if  ( aci->aciFormat >= 0 && aci->aciFormat < aci->aciExtensionCount )
	    {
	    const AppFileExtension *	afe= aci->aciExtensions+ aci->aciFormat;

	    extension= afe->afeExtension;
	    }
	}
    else{ extension= aci->aciExtension;	}

    slash= strrchr( filename, '/' );
    if  ( ! slash )
	{ relative= filename;		}
    else{ relative= slash+ 1;		}

    if  ( ! relative[0] )
	{
	appQuestionRunErrorDialog( ea, aci->aciDialog.adTopWidget, option,
						aci->aciNoFilenameMessage );

	free( aci->aciFilename ); aci->aciFilename= (char *)0;
	/* NO: just stay in the loop.
	appGuiBreakDialog( &(aci->aciDialog, ACIrespFAILURE );
	*/
	return -1;
	}

    if  ( extension && extension[0] )
	{
	char *	dot;

	dot= strrchr( relative, '.' );

	if  ( ! dot				||
	      strcmp( dot+ 1, extension )	)
	    {
	    int		le;

	    le= strlen( extension );

	    fresh= malloc( fileNameLength+ le+ 2+ 11 );
	    if  ( ! fresh )
		{
		LXDEB(fileNameLength,fresh);
		appGuiBreakDialog( &(aci->aciDialog), ACIrespFAILURE );
		return -1;
		}

	    strcpy( fresh, filename );

	    if  ( aci->aciFilename )
		{ free( aci->aciFilename ); aci->aciFilename= (char *)0; }
	    aci->aciFilename= fresh;

	    if  ( dot && ! dot[1] )
		{
		strcpy( fresh+ fileNameLength,    extension );
		}
	    else{
		strcpy( fresh+ fileNameLength   , "." );
		strcpy( fresh+ fileNameLength+ 1, extension );
		}
	    }
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Some tests on the name for a file to save a document to.		*/
/*									*/
/************************************************************************/

int appFileChooserTestNameForSave(
				const AppChooserInformation *	aci,
				const char *			filename  )
    {
    EditApplication *		ea= aci->aciApplication;
    APP_WIDGET			option= aci->aciOption;

    int				isDir= 0;
    int				fileExists= 0;
    int				dirExists= 0;
    int				fileWritable= 0;

    fileExists= appTestFileExists( filename ) == 0;

    if  ( fileExists )
	{ fileWritable= appTestFileWritable( filename ) == 0;	}
    else{ isDir= appTestDirectory( filename ) == 0;		}

    if  ( ! fileExists && ! isDir )
	{
	char *	scratch;
	char *	slash;

	scratch= (char *)malloc( strlen( filename )+ 11 );
	if  ( ! scratch )
	    { XDEB(scratch); return ACIrespFAILURE;	}

	strcpy( scratch, filename );
	slash= strrchr( scratch, '/' );
	if  ( slash )
	    {
	    *slash= '\0';
	    dirExists= appTestDirectory( scratch ) == 0;
	    }

	free( scratch );
	}

    if  ( isDir )
	{
	appQuestionRunSubjectErrorDialog( ea, aci->aciDialog.adTopWidget,
				option, filename, aci->aciIsDirecoryMessage );
	return ACIrespNONE;
	}

    if  ( fileExists )
	{
	if  ( ! fileWritable )
	    {
	    appQuestionRunSubjectErrorDialog(
			ea, aci->aciDialog.adTopWidget, option,
			filename, aci->aciNotWritableMessage );
	    return ACIrespNONE;
	    }
	else{
	    int		rcc;

	    rcc= appQuestionRunSubjectYesNoCancelDialog(
			ea, aci->aciDialog.adTopWidget, option,
			filename, aci->aciOverwriteMessage,
			(char *)0, (char *)0, (char *)0 );

	    switch( rcc )
		{
		case AQDrespYES:
		    return ACIrespSAVE;
		case AQDrespNO:
		    return ACIrespNONE;
		default:
		    LDEB(rcc);
		    /*FALLTHROUGH*/
		case AQDrespCANCEL:
		    return ACIrespCANCEL;
		}
	    }
	}
    else{
	if  ( ! dirExists )
	    {
	    char *	slash= strrchr( filename+ 1, '/' );

	    if  ( slash )
		{
		*slash= '\0';

		appQuestionRunSubjectErrorDialog(
			    ea, aci->aciDialog.adTopWidget, option,
			    filename, aci->aciNoSuchDirMessage );
		return ACIrespNONE;
		}
	    }
	}

    return ACIrespSAVE;
    }

void appDocPrintToFile(	APP_WIDGET			option,
			APP_WIDGET			panel,
			EditDocument *			ed,
			const PrintGeometry *		pg,
			int				firstPage,
			int				lastPage )
    {
    EditApplication *	ea= ed->edApplication;
    int			response;
    char *		filename;

    FILE *		f;

    PrintJob		pj;

    if  ( ! ea->eaPrintDocument )
	{ XDEB(ea->eaPrintDocument); return;	}

    appPrintJobForEditDocument( &pj, ed );

    response= appRunPrintToFileChooser( option, panel, ea, ed, &filename );

    switch( response )
	{
	case ACIrespCANCEL:
	    break;
	case ACIrespSAVE:
	    f= fopen( filename, "w" );

	    if  ( ! f )
		{ SXDEB(filename,f); free( filename ); return;	}

	    appCallPrintFunction( f, &pj, pg, firstPage, lastPage );

	    fclose( f );

	    free( filename );
	    break;
	default:
	    LDEB(response); break;
	}
    }

