 /*Copyright (C) Martin Robinson 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
#include <X11/xpm.h>
#include <X11/keysym.h>
#include <X11/Xatom.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/* tab completion */
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#include "MwmUtil.h"

/* These are the icon files, included at compile time */
#include "xpm/mterm.xpm"
#include "xpm/mask.xpm"
#include "xpm/mask.xbm"
#include "xpm/alpha.xpm"

#define CHAR_WIDTH 8
#define CHAR_HEIGHT 11
#define FALSE 0
#define COMMAND_SIZE 256
#define SPEC_WIN_SIZE 25
#define WM_EVENTS   (ExposureMask | ButtonPressMask | StructureNotifyMask | KeyPressMask)
#define OUTPUT_MODIFIER 1<<2 /* /control key is down */

#ifdef DEBUG
#define DEBUG_PRINT(args) fprintf args;
#else
#define DEBUG_PRINT(args)
#endif

/* Really, this comes from asclock. A good solution, as far as I'm
 * concerned*/
typedef struct {
    Pixmap          pixmap;
    Pixmap          mask;
    XpmAttributes   attr;
} xpixmap;

typedef struct hist_def {
		struct hist_def *next;
		struct hist_def *prev;

		char command[COMMAND_SIZE];
} hist_node;
			
/* Prototypes                        */
void usage(); 
int pixmap_from_data(char **data, xpixmap* icon); 
int prepare_pixmaps();
int redraw_window();
int flush_expose (Window w);
int key_pressed(int key, KeySym ks, unsigned int state);
short int strings_filled();
short int add_to_history(char *exec);
void clear_history();
void size_spec_window(); 
void pos_spec_window(); 
void paste_selection (Time time, int x, int y);
int parse_options();
int parse_history_file();
int write_history();
void quit_program(); 

void init_tab_complete();
int vcompstr(const void *one, const void *two);
void swap(char **input, int i, int j);
void tab_complete(int tabpos, KeySym ks);
int get_files(char *path, struct dirent ***namelist);
int is_match(char *filename, char *substring);
int is_exec(char *directory, char *filename);

hist_node *alloc_node(void);
void print_history(void);
void create_history();
char *history_index(int index);

/* End of Prototypes                 */

/* X11 Variables */
Display	*display; /* Main Display */
Window root; /* Root Window */
Window win; /* A window's window */
Window iconwin; /* A window's icon window */
Window act_win; /* The active window */
Window swin; /* Special long window */
GC main_gc; /* Really... */
int screen; /* Screen Number */
xpixmap	pix_main, pix_alpha;

/* Other Variables */
char command [COMMAND_SIZE];
int hist_loc = 0, spec_map = 0;
int opt_icon_win = 0;
int opt_withdrawn = 1; /* Withdrawn by default */
int opt_shaped = 0; /* Shaped by default */
int opt_spec_win = 1; /* Long command window */
int opt_autokill = 0; /* Kill after each command */
int opt_rem_hist = 0; /* Save history to a file */
int opt_hist_size = 10; /* History size */
int opt_window_chars = 20;	/* Specifies the length of the window when */
							/* Not Withdrawn */
char **exec_files;
unsigned int totalexec = 0;

int spec_x, spec_y; /* Keeping track of the spec window */
int max_chars; /* Maximum amount of chars in normal sized window */

hist_node *root_node, *last_node; /* The First and Last Nodes respectively */

char *c_name = "mterm";
char *c_ver = "0.4.2b";

static char *help_msg[] = {
"where options include:",
" -a 			enable auto-kill mode",
" -d DISPLAY		display name",
" -i			enable icon window mode",
" -l LENGTH		length of the text box in windowed mode in pixels",
" -n SIZE		size of the history in number of commands",
" -o			disable the long command window",
" -position [+|-]x[+|-]y position of mterm",
" -r			remember history between sessions",
" -s  			without groundplate",
" -w  			do not withdraw window",
NULL};					

