#!/usr/bin/env perl

# Some tests for 'darcs whatsnew '

use lib 'lib/perl';
use Test::More qw/no_plan/;
use Shell::Command;
use Test::Darcs;
use Shell::Command;
use strict;

rm_rf 'temp1';
mkpath 'temp1';
chdir 'temp1';
darcs 'init';

{
    my $test_name = 'RT#245 --look-for-adds implies --summary';
    touch('look_summary.txt');
    like( darcs('whatsnew -l'), qr!a ./look_summary.txt!i, $test_name);
}


TODO: {
    local $TODO =  "waiting on code for whatsnews to work with uncommon file names";
    my $test_name = 'whatsnew works with uncommon file names';
    touch(qw/\\/);

    my $before  = darcs(qw/add \\\\/);
    my $what = darcs('whatsnew');
    unlike($what, qr/no changes/i, $test_name);
}

TODO: {
    local $TODO =  "waiting on code for whatsnews to work with absolute paths";
    my $test_name = 'whatsnew works with absolute paths';
    touch('date.t');
     darcs(qw/add date.t/);
    like( darcs('whatsnew', "$ENV{PWD}/date.t"), qr/hunk/i, $test_name);
}

chdir '../';
rm_rf('temp1');
ok((!-d 'temp1'), 'temp1 directory was deleted');




