/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-2000, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/util.e,v 4.6 2000/01/15 22:25:13 william Exp $
 */

#ifndef _TGIF_UTIL_E_
#define _TGIF_UTIL_E_

#ifdef _INCLUDE_FROM_UTIL_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_UTIL_C_*/

extern void	UtilFree ARGS_DECL((char *pszStr));
extern char	*UtilFreeStringArray ARGS_DECL((char **ppsz, int nItems));
extern char	*UtilStrDup ARGS_DECL((char *pszStr));
extern int	UtilStrCpyN ARGS_DECL((char *pszDest, int nMaxDestSz,
		                      char *pszSrc));
extern void	UtilLeftTrim ARGS_DECL((char *pszStr));
extern void	UtilRightTrim ARGS_DECL((char *pszStr));
extern void	UtilTrimBlanks ARGS_DECL((char *pszStr));
extern void	UtilStrUpper ARGS_DECL((char *pszStr));
extern void	UtilStrLower ARGS_DECL((char *pszStr));
extern int	UtilStrNCaseCmp ARGS_DECL((char *pszStr1, char *pszStr2,
		                           int nCount));
extern int	UtilStrICmp ARGS_DECL((char *pszStr1, char *pszStr2));
extern char	*UtilStrRChr ARGS_DECL((char *pszStr, int int_ch));
#ifdef NO_STRSTR
extern char	*strstr ARGS_DECL((char *pszStr, char *pszSubStr));
#endif /* NO_STRSTR */
extern int	UtilShrinkName ARGS_DECL((char *pszFile));
extern void	UtilRemoveQuotes ARGS_DECL((char *pszStr));
extern char	*UtilGetALine ARGS_DECL((FILE *lpFile));
extern char	*UtilGetAContinuedLine ARGS_DECL((FILE *lpFile));
extern int	UtilCopyFile ARGS_DECL((char *pszFromFile, char *pszToFile));

extern int	UtilPathExists ARGS_DECL((char *pszPath));
extern int	UtilIsDirectory ARGS_DECL((char *pszPath));

#ifdef _INCLUDE_FROM_UTIL_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_UTIL_C_*/

#endif /*_TGIF_UTIL_E_*/
