/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: save.c,v 1.4 2001/08/21 18:54:08 martine Exp $
 */

#include "config.h"

#include <gtk/gtk.h>
#include <stdio.h>
#include "lj.h"

typedef struct {
	ljwin *ljw;
	GtkWidget *filesel;
} filesel_dialog;

static void 
file_ok_sel(GtkWidget *w, filesel_dialog *fdlg) {
	gchar *subject = NULL, *text;
	gchar *filename = NULL;
	FILE *of;

	subject = gtk_editable_get_chars(GTK_EDITABLE(fdlg->ljw->esubject), 0, -1);
	text = gtk_editable_get_chars(GTK_EDITABLE(fdlg->ljw->eentry), 0, -1);
	if (text == NULL) return;
	if (text[0] == 0) {
		g_free(text);
		return;
	}
	filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fdlg->filesel));
	of = fopen(filename, "w");

	if (of == NULL) {
		/* FIXME lj_error_dlg("Unable to open file"); */
		if (text) g_free(text); 
		if (subject) g_free(subject);
		return;
	}

	fprintf(of, "Subject: %s\n", subject ? subject : "");
	fprintf(of, "Entry:\n%s", text);
	fclose(of);

	g_free(text);
	g_free(subject);

	gtk_widget_destroy(GTK_WIDGET(fdlg->filesel));
}

void 
lj_save_entry(ljwin *ljw) {
	filesel_dialog fdlg_actual = {0}, *fdlg = &fdlg_actual;

	fdlg->ljw = ljw;
	fdlg->filesel = gtk_file_selection_new("Save Entry");
	gtk_signal_connect(GTK_OBJECT(fdlg->filesel), "destroy",
			GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

	gtk_signal_connect_object(
			GTK_OBJECT(GTK_FILE_SELECTION(fdlg->filesel)->cancel_button),
			"clicked", (GtkSignalFunc) gtk_widget_destroy,
			GTK_OBJECT(fdlg->filesel));
	gtk_signal_connect(
			GTK_OBJECT(GTK_FILE_SELECTION(fdlg->filesel)->ok_button),
			"clicked", (GtkSignalFunc) file_ok_sel, fdlg);
	gtk_widget_show(fdlg->filesel);
	gtk_main();
}

