/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: dotconf.h,v 1.8 2002/05/02 06:18:14 martine Exp $
 */

#ifndef config_h
#define config_h

#define FINFO() printf("%s(%d):  %s(", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#define FUNCPRINT(fmt, args...) {FINFO(); printf(fmt, ##args); printf(")\n"); }

#include "security.h"

enum {
	POSTMODE_GUI,
	POSTMODE_CMD
};

enum {
  CONVERT_NONE = 0,
  CONVERT_KOI2WIN
};

typedef struct {
	char *username;
	char *password;
	int fastserver;
} user;

struct idhash {
	int id;
	char *name;
};

typedef struct idhash mood;

typedef struct {
	int id;
	char *name;
	gboolean ispublic;
} friendgroup;

typedef struct {
	int x, y, width, height;
} geometry;

typedef struct {
	char *version;

	char *fullname;
	char *username;
	char *password;
	int fastserver;
	GList *users;
	char *usejournal;

	int revertusejournalafterpost; /* silly name! */
	int savemetadata;

	GList *moods;
	GList *friendgroups;

	int rememberwindow;
	geometry mainwin_geom, hiwin_geom, friends_geom, console_geom;
	int netdump, nothread;

	int confirmdelete;

	int useproxy;
	char *proxyserver; int proxyport;
	int useproxyauth;
	char *proxyuser, *proxypass;

	char *ljserver;

	int convertcharset;

	SecurityType defaultsecurity;

	char *spellcheck;
	int usespellcheck;

	GList *pickws;	/* user picture keywords */

	/* not really configuration options, but this is a good place to store
	 * state. */
	int loginok; 
	int postmode;
	
} config;

extern config conf;
extern int config_read(config *conf);
extern int config_write(config *conf);
extern user* conf_user_by_name(config *conf, char *username);

extern int mood_get_last_cached(config *conf);
extern gint mood_compare_alpha(mood *a, mood *b);

#endif /* config_h */
