<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2073 $
 * $Id: ViewRequest.php 2073 2008-08-22 18:41:21Z ipso $
 * $Date: 2008-08-22 11:41:21 -0700 (Fri, 22 Aug 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

//Debug::setVerbosity(11);

if ( !$permission->Check('request','enabled')
		OR !( $permission->Check('request','edit')
				OR $permission->Check('request','edit_own')
				 ) ) {
	$permission->Redirect( FALSE ); //Redirect
}

$smarty->assign('title', TTi18n::gettext($title = 'View Request')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'request_id',
												'request_queue_ids',
												'selected_level'
												) ) );

if ( isset($request_queue_ids) ) {
	$request_queue_ids = unserialize( base64_decode( urldecode($request_queue_ids) ) );
	Debug::Arr($request_queue_ids, ' Input Request Queue IDs '. $action, __FILE__, __LINE__, __METHOD__,10);
}
if ( isset($data) ) {
	$data['date_stamp'] = TTDate::parseDateTime($data['date_stamp']);
}

$rf = new RequestFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'pass':
		if ( count($request_queue_ids) > 1 ) {
			//Remove the authorized/declined request from the stack.
			array_shift($request_queue_ids);
			Redirect::Page( URLBuilder::getURL( array('id' => $request_queue_ids[0], 'selected_level' => $selected_level, 'request_queue_ids' => base64_encode( serialize($request_queue_ids) ) ), 'ViewRequest.php') );
		} else {
			Redirect::Page( URLBuilder::getURL( array('refresh' => TRUE ), '../CloseWindow.php') );
		}
	case 'decline':
	case 'authorize':
		Debug::text(' Authorizing Request: Action: '. $action, __FILE__, __LINE__, __METHOD__,10);
		if ( !empty($request_id) ) {
			Debug::text(' Authorizing Request ID: '. $request_id, __FILE__, __LINE__, __METHOD__,10);

			$af = new AuthorizationFactory();
			$af->setObjectType('request');
			$af->setObject( $request_id );

			if ( $action == 'authorize' ) {
				Debug::text(' Approving Authorization: ', __FILE__, __LINE__, __METHOD__,10);
				$af->setAuthorized(TRUE);
			} else {
				Debug::text(' Declining Authorization: ', __FILE__, __LINE__, __METHOD__,10);
				$af->setAuthorized(FALSE);
			}

			if ( $af->isValid() ) {
				$af->Save();

				if ( count($request_queue_ids) > 1 ) {
					//Remove the authorized/declined request from the stack.
					array_shift($request_queue_ids);
					Redirect::Page( URLBuilder::getURL( array('id' => $request_queue_ids[0], 'selected_level' => $selected_level, 'request_queue_ids' => base64_encode( serialize($request_queue_ids) ) ), 'ViewRequest.php') );
				} else {
					Redirect::Page( URLBuilder::getURL( array('refresh' => TRUE ), '../CloseWindow.php') );
				}

				break;
			}
		}
	default:
		if ( (int)$id > 0 ) {
			Debug::Text(' ID was passed: '. $id, __FILE__, __LINE__, __METHOD__,10);

			$rlf = new RequestListFactory();
			$rlf->getByIDAndCompanyID( $id, $current_company->getId() );

			$type_options = $rlf->getOptions('type');
			foreach ($rlf as $r_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
									'id' => $r_obj->getId(),
									'user_date_id' => $r_obj->getId(),
									'user_id' => $r_obj->getUserDateObject()->getUser(),
									'user_full_name' => $r_obj->getUserDateObject()->getUserObject()->getFullName(),
									'date_stamp' => $r_obj->getUserDateObject()->getDateStamp(),
									'type' => $type_options[$r_obj->getType()],
									'type_id' => $r_obj->getType(),
									'status_id' => $r_obj->getStatus(),
									'created_date' => $r_obj->getCreatedDate(),
									'created_by' => $r_obj->getCreatedBy(),
									'updated_date' => $r_obj->getUpdatedDate(),
									'updated_by' => $r_obj->getUpdatedBy(),
									'deleted_date' => $r_obj->getDeletedDate(),
									'deleted_by' => $r_obj->getDeletedBy()
								);
			}

			//Get Next Request to authorize:
			if ( $permission->Check('request','authorize')
					AND $selected_level != NULL
					AND count($request_queue_ids) <= 1 ) {

				Debug::Text('Get Request Queue: ', __FILE__, __LINE__, __METHOD__,10);

				$ulf = new UserListFactory();
				$hlf = new HierarchyListFactory();
				$hotlf = new HierarchyObjectTypeListFactory();

				//Get Hierarchy Control ID
				$request_hierarchy_id = $hotlf->getByCompanyIdAndObjectTypeId( $current_company->getId(), 50 )->getCurrent()->getHierarchyControl();
				Debug::Text('Request Hierarchy ID: '. $request_hierarchy_id, __FILE__, __LINE__, __METHOD__,10);

				//Get all levels below us.
				$request_levels = $hlf->getLevelsByHierarchyControlIdAndUserId( $request_hierarchy_id, $current_user->getId() );
				Debug::Arr( $request_levels, 'Request Levels', __FILE__, __LINE__, __METHOD__,10);

				if ( isset($selected_levels['request']) AND in_array( $selected_levels['request'], array_keys($request_levels) ) ) {
					$request_selected_level = $selected_levels['request'];
					Debug::Text(' Switching Levels to Level: '. $request_selected_level, __FILE__, __LINE__, __METHOD__,10);
				} else {
					$request_selected_level = 0;
				}
				Debug::Text( 'Request Selected Level: '. $request_selected_level, __FILE__, __LINE__, __METHOD__,10);

				//Get all relevant hierarchy ids
				$request_hierarchy_user_ids = $hlf->getByHierarchyControlIdAndUserIdAndLevel( $request_hierarchy_id, $current_user->getId(), (int)$request_selected_level );
				//Debug::Arr( $request_hierarchy_user_ids, 'Request Hierarchy Ids', __FILE__, __LINE__, __METHOD__,10);

				if ( is_array($request_hierarchy_user_ids)
						AND isset($request_hierarchy_user_ids['child_level'])
						AND isset($request_hierarchy_user_ids['parent_level'])
						AND isset($request_hierarchy_user_ids['current_level']) ) {

					$rlf = new RequestListFactory();
					//$rlf->getByUserIdListAndStatusAndNotAuthorized($request_child_level_user_ids, 30, $request_parent_level_user_ids, $request_current_level_user_ids );
					$rlf->getByUserIdListAndStatusAndNotAuthorized($request_hierarchy_user_ids['child_level'], 30, $request_hierarchy_user_ids['parent_level'], $request_hierarchy_user_ids['current_level'] );

					//Get all IDs that need authorizing.
					//Only do 25 at a time, then grab more.
					$i=0;
					$start=FALSE;
					foreach( $rlf as $r_obj) {
						if ( $id == $r_obj->getId() ) {
							$start = TRUE;
						}

						if ( $start == TRUE ) {
							$request_queue_ids[] = $r_obj->getId();
						}

						if ( $i > 25 ) {
							break;
						}
						$i++;
					}

					if ( isset($request_queue_ids) ) {
						$request_queue_ids = array_unique($request_queue_ids);
					}
				}
			}
		}

		//Select box options;
		$data['status_options'] = $rf->getOptions('status');
		$data['type_options'] = $rf->getOptions('type');

		if ( isset($request_queue_ids) ) {
			Debug::Arr($request_queue_ids, ' Output Request Queue IDs '. $action, __FILE__, __LINE__, __METHOD__,10);
			$smarty->assign_by_ref('request_queue_ids', urlencode( base64_encode( serialize($request_queue_ids) ) ) );
		}

		$smarty->assign_by_ref('selected_level', $selected_level);
		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('rf', $rf);

$smarty->display('request/ViewRequest.tpl');
?>