<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1855 $
 * $Id: DatabaseSchema.php 1855 2008-05-08 23:14:41Z ipso $
 * $Date: 2008-05-08 16:14:41 -0700 (Thu, 08 May 2008) $
 */
require_once('../../includes/global.inc.php');
require_once('HTML/Progress.php');

ignore_user_abort(TRUE);
ini_set( 'max_execution_time', 3600 );
ini_set( 'memory_limit', '512M' ); //Just in case.

//Debug::setVerbosity(11);

$authenticate = FALSE;
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

/*
 *
 * START Progress Bar Header...
 *
 */
function InitProgressBar( $increment = 1 ) {
	global $progress_bar;

	$progress_bar = new HTML_Progress();
	$progress_bar->setAnimSpeed(100);

	//$progress_bar->setIncrement( (int)$increment );
	//$progress_bar->setIndeterminate(true);
	$progress_bar->setBorderPainted(true);


	$ui =& $progress_bar->getUI();
	$ui->setCellAttributes('active-color=#3874B4 inactive-color=#CCCCCC width=10');
	$ui->setBorderAttributes('width=1 color=navy');
	$ui->setStringAttributes('width=60 font-size=14 background-color=#FFFFFF align=center');

	?>
	<html>
	<head>
	<style type="text/css">
	<!--
	<?php echo $progress_bar->getStyle(); ?>

	body {
			background-color: #FFFFFF;
			color: #FFFFFF;
			font-family: Verdana, freesans;
	}

	a:visited, a:active, a:link {
			color: yellow;
	}
	// -->
	</style>
	<script type="text/javascript">
	<!--
	<?php echo $progress_bar->getScript(); ?>
	//-->
	</script>
	</head>
	<body>

	<div align="center">
	<?php
	echo $progress_bar->toHtml();
}

/*
 *
 * END Progress Bar Header...
 *
 */

$smarty->assign('title', TTi18n::gettext($title = '3. Database Configuration')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'data',
												'external_installer',
												) ) );

$install_obj = new Install();
if ( $install_obj->isInstallMode() == FALSE ) {
	Redirect::Page( URLBuilder::getURL(NULL, 'install.php') );
}

$database_engine = TRUE;

$install_obj->setDatabaseConnection( $db ); //Default connection
if ( $install_obj->checkDatabaseExists( $config_vars['database']['database_name'] ) == TRUE ) {
	if ( $install_obj->checkTableExists( 'system_setting') == TRUE ) {
		$install_obj->setIsUpgrade( TRUE );
		//$upgrade = TRUE;
	} else {
		$install_obj->setIsUpgrade( FALSE );
		//$upgrade = FALSE;
	}
}

$action = Misc::findSubmitButton();
switch ($action) {
	case 'install_schema':
		//Need to create the tables after the database
		//exists and Database.inc.php has made a connection.
		//Otherwise we can't use objects yet.
		//Debug::setVerbosity(11);
		Debug::Text('Install Schema', __FILE__, __LINE__, __METHOD__,10);

		InitProgressBar();
		$progress_bar->setValue(1);
		$progress_bar->display();

		//$install_obj->setDatabaseConnection( $db ); //Default connection
		if ( $install_obj->checkDatabaseExists( $config_vars['database']['database_name'] ) == TRUE ) {
			//Create SQL, always try to install every schema version, as
			//installSchema() will check if its already been installed or not.
			$install_obj->setDatabaseDriver( $config_vars['database']['type'] );
			$install_obj->createSchemaRange( NULL, NULL ); //All schema versions
			//FIXME: Notify the user of any errors.
			$install_obj->setVersions();
		} else {
			Debug::Text('bDatabase does not exist.', __FILE__, __LINE__, __METHOD__,10);
		}

		$progress_bar->setValue( 100 );
		$progress_bar->display();

		if ( $install_obj->getIsUpgrade() == TRUE ) {
			//Make sure when using external installer that update notifications are always enabled.
			$sslf = new SystemSettingListFactory();
			$sslf->getByName('update_notify');
			if ( $sslf->getRecordCount() == 1 ) {
				$obj = $sslf->getCurrent();
			} else {
				$obj = new SystemSettingListFactory();
			}

			$obj->setName( 'update_notify' );
			if ( $external_installer == 1 ) {
				$obj->setValue( 1 );
			}
			if ( $obj->isValid() ) {
				$obj->Save();
			}

			$next_page = URLBuilder::getURL( array('external_installer' => $external_installer), 'PostUpgrade.php');
		} else {
			if ( $external_installer == 1 ) {
				$next_page = URLBuilder::getURL( array('action:next' => 1, 'external_installer' => $external_installer), 'SystemSettings.php');
			} else {
				$next_page = URLBuilder::getURL( array('external_installer' => $external_installer), 'SystemSettings.php');
			}
		}

		if ( Debug::getVerbosity() >= 11 ) {
			Debug::Display();
		} else {
			?>
			<script type="text/javascript">parent.location.href='<?php echo $next_page;?>'</script>
			<?php
		}
		exit;
		break;
	default:
		$handle = @fopen('http://www.timetrex.com/'.URLBuilder::getURL( array('v' => $install_obj->getFullApplicationVersion(), 'page' => 'database_schema'), 'pre_install.php'), "r");
		@fclose($handle);

		$smarty->assign_by_ref('install_obj', $install_obj);
		$smarty->assign_by_ref('external_installer', $external_installer);
		//$smarty->assign_by_ref('upgrade', $upgrade);

		$smarty->display('install/DatabaseSchema.tpl');

		break;
}
?>