<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1693 $
 * $Id: EditHierarchy.php 1693 2008-01-24 22:48:43Z ipso $
 * $Date: 2008-01-24 14:48:43 -0800 (Thu, 24 Jan 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

//Debug::setVerbosity( 11 );

if ( !$permission->Check('hierarchy','enabled')
		OR !( $permission->Check('hierarchy','edit') OR $permission->Check('hierarchy','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Hierarchy')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'hierarchy_id',
												'id',
												'old_id',
												'user_data'
												) ) );

$ft = new FastTree($fast_tree_options);
$ft->setTree( $hierarchy_id );

$hf = new HierarchyFactory();

$redirect=0;

$action = Misc::findSubmitButton();
switch ($action) {
	case 'submit':
		//Debug::setVerbosity( 11 );
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		if ( isset($user_data['user_id']) ) {
			foreach( $user_data['user_id'] as $user_id ) {
				if ( isset($id) AND $id != '') {
					$hf->setId( $id );
				}

				$hf->setHierarchyControl( $hierarchy_id );
				$hf->setPreviousUser( $old_id );
				//$hf->setUser( $user_data['user_id'] );
				$hf->setUser( $user_id );
				$hf->setParent( $user_data['parent_id'] );

				if ( isset($user_data['share']) ) {
					Debug::Text(' Setting share!: ', __FILE__, __LINE__, __METHOD__,10);
					$hf->setShared( TRUE );
				} else {
					$hf->setShared( FALSE );
				}

				if ( $hf->isValid() ) {
					Debug::Text(' Valid!: ', __FILE__, __LINE__, __METHOD__,10);

					if ( $hf->Save() === FALSE ) {
						$redirect++;
					}
				} else {
					$redirect++;
				}
			}
		}

		if ( $redirect == 0 ) {
			Redirect::Page( URLBuilder::getURL( array('hierarchy_id' => $hierarchy_id) , 'HierarchyList.php') );

			break;
		}

	default:
		//BreadCrumb::setCrumb($title);
		if ( isset($id) AND !isset($user_data['user_id']) ) {
			$user_data['user_id'] = $id;
		}

		$hlf = new HierarchyListFactory();

		//$nodes = $hlf->FormatArray( $hlf->getByHierarchyControlId( $hierarchy_id ), 'TEXT', TRUE);
		//$nodes = FastTree::FormatArray( $hlf->getByHierarchyControlId( $hierarchy_id ), 'TEXT', TRUE);
		$nodes = FastTree::FormatArray( $hlf->getByCompanyIdAndHierarchyControlId( $current_company->getId(), $hierarchy_id ), 'TEXT', TRUE);

		foreach($nodes as $node) {
			$parent_list_options[$node['id']] = $node['text'];
		}

		//Get include employee list.
		$ulf = new UserListFactory();
		$ulf->getByCompanyId( $current_company->getId() );
		$raw_user_options = $ulf->getArrayByListFactory( $ulf, FALSE, TRUE );
		//$raw_user_list_options = UserListFactory::getByCompanyIdArray( $current_company->getId() );

		//Only allow them to select employees not already in the tree.
		unset($parent_list_options[$id]); //If we're editing a single entry, include that user in the list.
		$parent_list_keys = array_keys($parent_list_options);
		$user_options = Misc::arrayDiffByKey( (array)$parent_list_keys, $raw_user_options );

		$src_user_options = Misc::arrayDiffByKey( (array)$user_data['user_id'], $user_options );
		$selected_user_options = Misc::arrayIntersectByKey( (array)$user_data['user_id'], $user_options );

		//$smarty->assign_by_ref('user_list_options', $user_list_options);
		$smarty->assign_by_ref('src_user_options', $src_user_options);
		$smarty->assign_by_ref('selected_user_options', $selected_user_options);
		$smarty->assign_by_ref('parent_list_options', $parent_list_options);


		if ( isset($id) AND $id != '' AND $redirect == 0) {
			Debug::Text(' ID: '. $id , __FILE__, __LINE__, __METHOD__,10);
			$node = $hlf->getByHierarchyControlIdAndUserId( $hierarchy_id, $id);

			$smarty->assign_by_ref('selected_node', $node );
		} else {
			$id = $user_data['user_id'][0];
		}

		break;
}

$smarty->assign_by_ref('hierarchy_id', $hierarchy_id);
$smarty->assign_by_ref('id', $id);
$smarty->assign_by_ref('old_id', $id);

$smarty->assign_by_ref('hf', $hf);

$smarty->display('hierarchy/EditHierarchy.tpl');
?>