<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditHelp.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('help','enabled')
		OR !( $permission->Check('help','edit') OR $permission->Check('help','edit_own') ) ) {
			
	$permission->Redirect( FALSE ); //Redirect
	
}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Help')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'help_data'
												) ) );

$hf = new HelpFactory();
		
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$hf->setId($help_data['id']);
		$hf->setStatus($help_data['status']);
		$hf->setType($help_data['type']);
		
		if ( isset($help_data['private']) ) {
			$hf->setPrivate( TRUE );
		} else {
			$hf->setPrivate( FALSE );
		}
		
		$hf->setHeading($help_data['heading']);
		$hf->setBody($help_data['body']);
		$hf->setKeywords($help_data['keywords']);

		if ( $hf->isValid() ) {
			$hf->Save();
			
			Redirect::Page( URLBuilder::getURL(NULL, 'HelpList.php') );
			
			break;
		}
        
	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);
			
			$hlf = new HelpListFactory();
			
			$hlf->getById($id);
			
			foreach ($hlf as $help_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);
			
				$help_data = array(
								'id' => $help_obj->GetId(),
								'type' => $help_obj->getType(),
								'status' => $help_obj->getStatus(),
								'heading' => $help_obj->getHeading(),
								'body' => $help_obj->getBody(),
								'keywords' => $help_obj->getKeywords(),
								'private' => $help_obj->getPrivate(),								
								'created_date' => $help_obj->getCreatedDate(),
								'created_by' => $help_obj->getCreatedBy(),
								'updated_date' => $help_obj->getUpdatedDate(),
								'updated_by' => $help_obj->getUpdatedBy(),
								'deleted_date' => $help_obj->getDeletedDate(),
								'deleted_by' => $help_obj->getDeletedBy(),
								'deleted' => $help_obj->getDeleted()	
								);	
			}
		}

		//Select box options;
		$help_data['status_options'] = $hf->getOptions('status');
		$help_data['type_options'] = $hf->getOptions('type');

		$smarty->assign_by_ref('help_data', $help_data);
				
		break;
}

$smarty->assign_by_ref('hf', $hf);

$smarty->display('help/EditHelp.tpl');
?>