<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditBranch.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('branch','enabled')
		OR !( $permission->Check('branch','edit') OR $permission->Check('branch','edit_own') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Branch')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'branch_data'
												) ) );

$bf = new BranchFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$bf->setId($branch_data['id']);
		$bf->setCompany( $current_company->getId() );
		$bf->setStatus($branch_data['status']);
		$bf->setName($branch_data['name']);
		$bf->setManualId($branch_data['manual_id']);

		if ($branch_data['address1'] != '') {
			$bf->setAddress1($branch_data['address1']);
		}
		if ($branch_data['address2'] != '') {
			$bf->setAddress2($branch_data['address2']);
		}

		$bf->setCity($branch_data['city']);
		$bf->setCountry($branch_data['country']);
		$bf->setProvince($branch_data['province']);

		if ($branch_data['postal_code'] != '') {
			$bf->setPostalCode($branch_data['postal_code']);
		}
		if ($branch_data['work_phone'] != '') {
			$bf->setWorkPhone($branch_data['work_phone']);
		}
		if ($branch_data['fax_phone'] != '') {
			$bf->setFaxPhone($branch_data['fax_phone']);
		}

		if ( $bf->isValid() ) {
			$bf->Save();

			Redirect::Page( URLBuilder::getURL(NULL, 'BranchList.php') );

			break;
		}
	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$blf = new BranchListFactory();

			$blf->GetByIdAndCompanyId($id, $current_company->getId() );

			foreach ($blf as $branch) {
				Debug::Arr($branch,'branch', __FILE__, __LINE__, __METHOD__,10);

				$branch_data = array(
									'id' => $branch->getId(),
									'status' => $branch->getStatus(),
									'manual_id' => $branch->getManualID(),
									'name' => $branch->getName(),
									'address1' => $branch->getAddress1(),
									'address2' => $branch->getAddress2(),
									'city' => $branch->getCity(),
									'province' => $branch->getProvince(),
									'country' => $branch->getCountry(),
									'postal_code' => $branch->getPostalCode(),
									'work_phone' => $branch->getWorkPhone(),
									'fax_phone' => $branch->getFaxPhone(),
									'created_date' => $branch->getCreatedDate(),
									'created_by' => $branch->getCreatedBy(),
									'updated_date' => $branch->getUpdatedDate(),
									'updated_by' => $branch->getUpdatedBy(),
									'deleted_date' => $branch->getDeletedDate(),
									'deleted_by' => $branch->getDeletedBy()
								);
			}
		} elseif ( $action != 'submit' ) {
			$next_available_manual_id = BranchListFactory::getNextAvailableManualId( $current_company->getId() );

			$branch_data = array(
							'country' => $current_company->getCountry(),
							'province' => $current_company->getProvince(),
							'next_available_manual_id' => $next_available_manual_id,
							);
		}

		//Select box options;
		$branch_data['status_options'] = $bf->getOptions('status');

		$cf = new CompanyFactory();
		$branch_data['country_options'] = $cf->getOptions('country');
		$branch_data['province_options'] = $cf->getOptions('province', $branch_data['country'] );

		$smarty->assign_by_ref('branch_data', $branch_data);

		break;
}

$smarty->assign_by_ref('bf', $bf);

$smarty->display('branch/EditBranch.tpl');
?>