<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: LA.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package PayrollDeduction
 */
class PayrollDeduction_US_LA extends PayrollDeduction_US {

	var $state_options = array(
								1136102400 => array(
													'rate1' => 2.1,
													'rate2' => 1.35,

													'm1' => array(
																	0 => 12500,
																	1 => 12500,
																	2 => 25000
																	),
													'm2' => array(
																	0 => 25000,
																	1 => 25000,
																	2 => 50000
																	),

													'allowance' => 4500,
													'dependant_allowance' => 1000,
													)
								);

	function getStatePayPeriodDeductions() {
		return $this->getStateTaxPayable();
	}

	function getStateAnnualTaxableIncome() {
		$annual_income = $this->getAnnualTaxableIncome();
		$income = $annual_income;

		Debug::text('State Annual Taxable Income: '. $income, __FILE__, __LINE__, __METHOD__,10);

		return $income;
	}

	function getStateAllowanceAmount() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;
		}

		$allowance_arr = $retarr['allowance'];

		$retval = bcmul( $this->getUserValue1(), $allowance_arr );

		Debug::text('State Allowance Amount: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

	function getStateDependantAllowanceAmount() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;
		}

		$allowance_arr = $retarr['dependant_allowance'];

		$retval = bcmul( $this->getUserValue2(), $allowance_arr );

		Debug::text('State Dependant Allowance Amount: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

	private function getPersonalExemptions() {
		$personal_exemptions = (int)$this->getUserValue1();
		if ( $personal_exemptions > 2 ) {
			$personal_exemptions = 2;
		}

		return $personal_exemptions;
	}

	private function getM1() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;
		}

		$retval = $retarr['m1'][$this->getPersonalExemptions()];

		Debug::text('M1: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

	private function getM2() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;
		}

		$retval = $retarr['m2'][$this->getPersonalExemptions()];

		Debug::text('M2: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

	function getStateTaxPayable() {
		$state_options = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $state_options == FALSE ) {
			return FALSE;
		}

		$rate1 = bcdiv( $state_options['rate1'], 100);
		$rate2 = bcdiv( $state_options['rate2'], 100);

		$pay_period_income = $this->getGrossPayPeriodIncome();

		$a = bcmul( $pay_period_income, bcdiv( $state_options['rate1'], 100) );

		if ( $pay_period_income > bcdiv( $this->getM1(), $this->getAnnualPayPeriods() ) ) {
			$b = bcmul( $rate2, bcsub( $pay_period_income, bcdiv( $this->getM1(), $this->getAnnualPayPeriods() ) ) );
		} else {
			$b = 0;
		}

		if ( $pay_period_income > bcdiv( $this->getM2(), $this->getAnnualPayPeriods() ) ) {
			$c = bcmul( $rate2, bcsub( $pay_period_income, bcdiv( $this->getM2(), $this->getAnnualPayPeriods() ) ) );
		} else {
			$c = 0;
		}

		$personal_exemptions = bcmul($this->getPersonalExemptions(), $state_options['allowance']);
		$dependant_exemptions = bcmul($this->getUserValue2(), $state_options['dependant_allowance']);
		$d = bcmul( $rate1, bcdiv( bcadd( $personal_exemptions, $dependant_exemptions), $this->getAnnualPayPeriods() ) );

		if ( bcadd( $personal_exemptions, $dependant_exemptions) > $this->getM1() ) {
			$e = bcmul( $rate2, bcdiv( bcsub( bcadd( $personal_exemptions, $dependant_exemptions), $this->getM1() ), $this->getAnnualPayPeriods() ) );
		} else {
			$e = 0;
		}

		Debug::text('A: '. $a .' B: '. $b .' C: '. $c .' D: '. $d .' E: '. $e, __FILE__, __LINE__, __METHOD__,10);
		$retval = bcsub( bcadd( bcadd($a, $b), $c),  bcadd($d, $e) );

		if ( $retval <= 0 ) {
			$retval = 0;
		}

		Debug::text('State Annual Tax Payable: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}
}
?>
