<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1595 $
 * $Id: ProgressBarControl.php 1595 2008-01-04 04:09:57Z ipso $
 * $Date: 2008-01-03 20:09:57 -0800 (Thu, 03 Jan 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');


//Debug::setVerbosity(11);

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'next_page',
												'pay_period_ids',
												'filter_user_id',
												'pay_stub_ids',
												'data',
												) ) );

$action = strtolower($action);
switch ($action) {
	case 'recalculate_company':
		Debug::Text('ProgressBarControl: Recalculating Company TimeSheet!', __FILE__, __LINE__, __METHOD__,10);

		if ( !$permission->Check('punch','enabled')
				OR !( $permission->Check('punch','edit') OR $permission->Check('punch','edit_own') ) ) {

			$permission->Redirect( FALSE ); //Redirect
		}

		$comment = TTi18n::gettext('Recalculating Company TimeSheet...');

		break;
	case 'recalculate_employee':
		Debug::Text('ProgressBarControl: Recalculating Employee / Company TimeSheet!', __FILE__, __LINE__, __METHOD__,10);

		if ( !$permission->Check('punch','enabled')
				OR !( $permission->Check('punch','edit') OR $permission->Check('punch','edit_own') ) ) {

			$permission->Redirect( FALSE ); //Redirect
		}

		$comment = TTi18n::gettext('Recalculating Employee TimeSheet...');

		break;
	case 'generate_paystubs':
		Debug::Text('Generate PayStubs!', __FILE__, __LINE__, __METHOD__,10);

		if ( !$permission->Check('pay_period_schedule','enabled')
				OR !( $permission->Check('pay_period_schedule','edit') OR $permission->Check('pay_period_schedule','edit_own') ) ) {

			$permission->Redirect( FALSE ); //Redirect
		}

		$comment = TTi18n::gettext('Generating Pay Stubs...');

		//$smarty->assign_by_ref('action', $action);
		//$smarty->assign_by_ref('pay_period_ids', $pay_period_ids);

		break;
	case 'recalculate_paystub_ytd':
		Debug::Text('Re-Calculating PayStub YTD values!', __FILE__, __LINE__, __METHOD__,10);

		if ( !$permission->Check('pay_period_schedule','enabled')
				OR !( $permission->Check('pay_period_schedule','edit') OR $permission->Check('pay_period_schedule','edit_own') ) ) {

			$permission->Redirect( FALSE ); //Redirect
		}

		$comment = TTi18n::gettext('Recalculating Pay Stub Year To Date (YTD) amounts...');

		break;
	case 'recalculate_accrual_policy':
		Debug::Text('Recalculate Accrual Policy!', __FILE__, __LINE__, __METHOD__,10);

		if ( !$permission->Check('accrual_policy','enabled')
				OR !( $permission->Check('accrual_policy','edit')
						OR $permission->Check('accrual_policy','edit_own')
						OR $permission->Check('accrual_policy','edit_child')
						 ) ) {
			$permission->Redirect( FALSE ); //Redirect
		}

		$comment = TTi18n::gettext('Recalculating Accrual Policy...');

		break;
	case 'add_mass_punch':
		Debug::Text('Add Mass Punch!', __FILE__, __LINE__, __METHOD__,10);

		if ( !$permission->Check('punch','enabled')
				OR !( $permission->Check('punch','edit')
						OR $permission->Check('punch','edit_own')
						OR $permission->Check('punch','edit_child')
						 ) ) {
			$permission->Redirect( FALSE ); //Redirect
		}

		$comment = TTi18n::gettext('Adding Punches...');

		break;
	case 'add_mass_schedule':
		Debug::Text('Add Mass Schedule!', __FILE__, __LINE__, __METHOD__,10);

		if ( !$permission->Check('schedule','enabled')
				OR !( $permission->Check('schedule','edit')
						OR $permission->Check('schedule','edit_own')
						OR $permission->Check('schedule','edit_child')
						 ) ) {
			$permission->Redirect( FALSE ); //Redirect
		}

		$comment = TTi18n::gettext('Adding Schedule Shifts...');

		break;
	default:
		$comment = TTi18n::gettext('Test Progress Bar...');
		//$smarty->assign_by_ref('user_data', $user_data);

		break;


}

$url = URLBuilder::getURL( array('action' => $action, 'pay_period_ids' => $pay_period_ids, 'filter_user_id' => $filter_user_id, 'pay_stub_ids' => $pay_stub_ids, 'data' => $data, 'next_page' => urlencode($next_page) ), Environment::getBaseURL().'/progress_bar/ProgressBar.php');

$smarty->assign_by_ref('comment', $comment);
//$smarty->assign_by_ref('next_page', $next_page);
$smarty->assign_by_ref('url', $url);

$smarty->display('progress_bar/ProgressBarControl.tpl');
?>