/*

Copyright (C) 2000 - 2007 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <nd.h>

static int calldepth = 0;

static void 
debug_whitespace(void)
{
  int i;
  
  for (i = 0; i < 2*calldepth; i++)
    printf("-");
}


void
nd_debug_enter(const char *function)
{
  if (nd_runtime_options.debug)
    {
      calldepth++;
      debug_whitespace();
      printf("> %s()\n", function);
    }
}


void
nd_debug_return(const char *function)
{
  if (nd_runtime_options.debug)
    {
      printf("<");
      debug_whitespace();
      printf(" %s()\n", function);
      
      if (--calldepth < 0)
	calldepth = 0;
    }
}


#ifdef gtk_object_set_data_full
#undef gtk_object_set_data_full
#endif

void	 
nd_debug_gtk_object_set_data_full(GtkObject	  *object,
				  const gchar     *key,
				  gpointer	   data,
				  GtkDestroyNotify destroy)
{
  D(("Setting data '%s' at %p\n", key, data));
  gtk_object_set_data_full(object, key, data, destroy);
}


#ifdef gtk_widget_unref
#undef gtk_widget_unref
#endif

void
nd_debug_gtk_widget_unref(GtkWidget *w)
{
  D(("Unreffing at %p\n", w));
  gtk_widget_unref(w);
}
