/*

Copyright (C) 2000 - 2007 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <nd.h>
#include <nd_gui.h>
#include <nd_packet.h>
#include <nd_dialog.h>

#include <nd_pcap.h>
void
pcap_tv_sec_cb(LND_Packet *packet, void *user_data, guint value)
{
  packet->ph.ts.tv_sec = value;
  libnd_packet_modified(packet);
  
  return;
  TOUCH(user_data);
}

void
nd_pcap_tv_sec_cb(LND_Packet   *packet,
		  guchar       *header,
		  guchar       *data)
{
  nd_dialog_number(_("Enter seconds part of packet timestamp:"),
		   ND_BASE_DEC, packet->ph.ts.tv_sec, (guint32) -1,
		   pcap_tv_sec_cb, NULL, packet, NULL);  

  return;
  TOUCH(header);
  TOUCH(data);
}

void
pcap_tv_usec_cb(LND_Packet *packet, void *user_data, guint value)
{
  packet->ph.ts.tv_usec = value;
  libnd_packet_modified(packet);
  
  return;
  TOUCH(user_data);
}

void
nd_pcap_tv_usec_cb(LND_Packet   *packet,
		   guchar       *header,
		   guchar       *data)
{
  nd_dialog_number(_("Enter microseconds part of packet timestamp:"),
		   ND_BASE_DEC, packet->ph.ts.tv_usec, (guint32) -1,
		   pcap_tv_usec_cb, NULL, packet, NULL);  

  return;
  TOUCH(header);
  TOUCH(data);
}

void
pcap_caplen_cb(LND_Packet *packet, void *user_data, guint value)
{
  libnd_packet_adjust_caplen(packet, value - packet->ph.caplen);
  
  return;
  TOUCH(user_data);
}

void
nd_pcap_caplen_cb(LND_Packet   *packet,
		  guchar        *header,
		  guchar        *data)
{
  nd_dialog_number(_("Enter packet capture length:"),
		   ND_BASE_DEC, packet->ph.caplen, (guint32) -1,
		   pcap_caplen_cb, NULL, packet, NULL);  

  return;
  TOUCH(header);
  TOUCH(data);
}

void
pcap_len_cb(LND_Packet *packet, void *user_data, guint value)
{
  libnd_packet_adjust_len(packet, value - packet->ph.len);
  
  return;
  TOUCH(user_data);
}

void
nd_pcap_len_cb(LND_Packet   *packet,
	       guchar        *header,
	       guchar        *data)
{
  nd_dialog_number(_("Enter packet length:"),
		   ND_BASE_DEC, packet->ph.len, (guint32) -1,
		   pcap_len_cb, NULL, packet, NULL);  

  return;
  TOUCH(header);
  TOUCH(data);
}
