/*
 * Michel Verdier, le 12.02.2000
 *
 * Importation de diffrents formats dans gAcc :
 * Importation of various formats in gAcc :
 * - CBB
 *
 *   Copyright (C) 2000 Michel Verdier
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _IMPORT_H_
#define _IMPORT_H_

#include "structs.h"

/* dcoupe une ligne en champs, renvoie le nombre de champs */
/* cut line into fields, return fields number */
int  fields_number (const char *line, const char delim);
char **line_to_field (const char *line, const char delim);
void delete_fields (char **champ, int num_champ);

/* formatte une opration  partir d'une ligne au format CBB */
/* format an operation from a CBB line */
void add_operation_from_cbb_fields (ACCOUNT *account, char **champ);
void add_operation_from_cbb_line   (ACCOUNT *account, const char *line);

/* cration d'un compte vide pour un import */
/* create an empty account for import */
ACCOUNT *create_import_account (const char *type);

/* lecture des oprations  partir d'un fichier au format CBB */
/* reads operations from a CBB file */
void read_from_cbb (FILE *file);

#endif
