/* anbio.h -- asynchronous/non-blocking input/output
 * 
 *   Copyright (C) 1996 1997 1998 1999 2000 2001 Ian Piumarta and individual
 *      authors/contributors listed elsewhere in this file.
 *   All rights reserved.
 *   
 *   This file is part of Unix Squeak.
 * 
 *   This file is distributed in the hope that it will be useful, but WITHOUT
 *   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *   FITNESS FOR A PARTICULAR PURPOSE.
 *   
 *   You may use and/or distribute this file ONLY as part of Squeak, under
 *   the terms of the Squeak License as described in `LICENSE' in the base of
 *   this distribution, subject to the following restrictions:
 * 
 *   1. The origin of this software must not be misrepresented; you must not
 *      claim that you wrote the original software.  If you use this software
 *      in a product, an acknowledgment to the original author(s) (and any
 *      other contributors mentioned herein) in the product documentation
 *      would be appreciated but is not required.
 * 
 *   2. This notice may not be removed or altered in any source distribution.
 * 
 *   Using or modifying this file for use in any context other than Squeak
 *   changes these copyright conditions.  Read the file `COPYING' in the base
 *   of the distribution before proceeding with any such use.
 * 
 *   You are STRONGLY DISCOURAGED from distributing a modified version of
 *   this file under its original name without permission.  If you must
 *   change it, rename it first.
 * 
 * Author: Ian.Piumarta@INRIA.Fr
 * 
 * Last edited: Fri Aug 25 04:37:22 2000 by piumarta (Ian Piumarta) on emilia
 * 
 * NOTE: client should #define aioClientData_t appropriately before
 *       including this file.
 */

#define AIO_RD	(1<<0)
#define AIO_WR	(1<<1)
#define AIO_EX	(1<<2)

#if !defined(aioClientData_t)
# define aioClientData_t	void *
#endif



typedef void *(*aioHandler_t)(int fd, int mask, aioClientData_t data);

extern char *maskString(int mask);

extern void nbioEnable(int fd);
extern void nbioDisable(int fd);

extern void aioEnable(int fd, aioClientData_t data);
extern void aioHandle(int fd, aioHandler_t hdlr);
extern void aioDisable(int fd);

extern void aioInit(void);
extern void aioFini(void);
