/*

  
  					W3C Sample Code Library libwww HTML DTD


!
  HTML Plus DTD - Software Interface
!
*/

/*
**	(c) COPYRIGHT MIT 1995.
**	Please first read the full copyright statement in the file COPYRIGH.
*/

/*

SGML purists should excuse the use of the term "DTD" in this file to represent
DTD-related information which is not exactly a DTD itself. The C modular
structure doesn't work very well here, as the dtd is partly in the .h and
partly in the .c which are not very independent. Tant pis! There
are a couple of HTML-specific utility routines also defined.

This module is a part of the  W3C Sample
Code Library.
*/

#ifndef HTMLDTD_H
#define HTMLDTD_H

#include "HTStruct.h"
#include "SGML.h"

/*
.
  Number of HTML Entities
.

The entity names are defined in the C file. This gives the number of them.
Must Match all tables by element!
*/

#define HTML_ENTITIES 67

/*
.
  HTML Element Enumeration
.

These include tables in HTMLPDTD.c and
code in HTML.c. Note that not everything from
HTML 4.0 is there!
*/

typedef enum _HTMLElement {
	HTML_A = 0,
	HTML_ABBR,
	HTML_ACRONYM,
	HTML_ADDRESS,
	HTML_APPLET,
	HTML_AREA,
	HTML_B,
	HTML_BASE,
	HTML_BASEFONT,
	HTML_BDO,
	HTML_BIG,
	HTML_BLOCKQUOTE,
	HTML_BODY,
	HTML_BR,
	HTML_BUTTON,
	HTML_CAPTION,
	HTML_CENTER,
	HTML_CITE,
	HTML_CODE,
	HTML_COL,
	HTML_COLGROUP,
	HTML_DD,
	HTML_DEL,
 	HTML_DFN,
	HTML_DIR,
	HTML_DIV,
 	HTML_DL,
 	HTML_DT,
	HTML_EM,
	HTML_FIELDSET,
	HTML_FONT,
	HTML_FORM,
	HTML_FRAME,
	HTML_FRAMESET,
	HTML_H1,
 	HTML_H2,
 	HTML_H3,
	HTML_H4,
	HTML_H5,
 	HTML_H6, 
	HTML_HEAD,
 	HTML_HR,
	HTML_HTML,
	HTML_I,
	HTML_IFRAME,
	HTML_IMG,
	HTML_INPUT,
	HTML_INS,
	HTML_ISINDEX,
 	HTML_KBD,
	HTML_LABEL,
	HTML_LEGEND,
 	HTML_LI,
 	HTML_LINK,
	HTML_MAP,
	HTML_MENU,
	HTML_META,
	HTML_NEXTID,	/* !!! */
	HTML_NOFRAMES,
	HTML_NOSCRIPT,
	HTML_OBJECT,
	HTML_OL,
	HTML_OPTGROUP,
	HTML_OPTION,
	HTML_P,
	HTML_PARAM,
	HTML_PRE,
	HTML_Q,
	HTML_S,
	HTML_SAMP,
	HTML_SCRIPT,
	HTML_SELECT,
	HTML_SMALL,
	HTML_SPAN,
	HTML_STRIKE,
	HTML_STRONG,
	HTML_STYLE,
	HTML_SUB,
	HTML_SUP,
	HTML_TABLE,
	HTML_TBODY,
	HTML_TD,
	HTML_TEXTAREA,
	HTML_TFOOT,
	HTML_TH,
	HTML_THEAD,
	HTML_TITLE,
	HTML_TR,
	HTML_TT,
	HTML_U,
	HTML_UL,
	HTML_VAR,
	HTML_ELEMENTS		/* This must be the last entry */
} HTMLElement;

/*
.
  Element Attribute Enumerations
.

Identifier is HTML_<element>_<attribute>. These
must match the tables in
HTMLPDTD.c!
(
  Attributes definition Macros
)
*/

/* Define an attribute as HTML__ */
#define	HTML_ATTR(t,a)		HTML_##t##_##a
#define	HTML_ATTRIBUTES(t)	HTML_##t##_ATTRIBUTES

/*
(
  A
)
*/

enum _HTML_A_Attributes {
	HTML_ATTR(A,ACCESSKEY) = 0,
	HTML_ATTR(A,CHARSET),
	HTML_ATTR(A,CLASS),
	HTML_ATTR(A,COORDS),
	HTML_ATTR(A,DIR),
	HTML_ATTR(A,HREF),
	HTML_ATTR(A,HREFLANG),
	HTML_ATTR(A,ID),
	HTML_ATTR(A,NAME),
	HTML_ATTR(A,REL),
	HTML_ATTR(A,REV),
	HTML_ATTR(A,SHAPE),
	HTML_ATTR(A,STYLE),
	HTML_ATTR(A,TABINDEX),
	HTML_ATTR(A,TARGET),
	HTML_ATTR(A,TYPE),
	HTML_ATTR(A,TITLE),
	HTML_ATTRIBUTES(A)
};

/*
(
  APPLET - Deprecated
)
*/

enum _HTML_APPLET_Attributes {
	HTML_ATTR(APPLET,ALIGN) = 0,
	HTML_ATTR(APPLET,ALT),
	HTML_ATTR(APPLET,ARCHIVE),
	HTML_ATTR(APPLET,CLASS),
	HTML_ATTR(APPLET,CODE),
	HTML_ATTR(APPLET,CODEBASE),
	HTML_ATTR(APPLET,HEIGHT),
	HTML_ATTR(APPLET,HSPACE),
	HTML_ATTR(APPLET,ID),
	HTML_ATTR(APPLET,NAME),
	HTML_ATTR(APPLET,OBJECT),
	HTML_ATTR(APPLET,STYLE),
	HTML_ATTR(APPLET,TITLE),
	HTML_ATTR(APPLET,VSPACE),
	HTML_ATTR(APPLET,WIDTH),
	HTML_ATTRIBUTES(APPLET)
};

/*
(
  AREA
)
*/

enum _HTML_AREA_Attributes {
	HTML_ATTR(AREA,ACCESSKEY) = 0,
	HTML_ATTR(AREA,ALT),
	HTML_ATTR(AREA,CLASS),
	HTML_ATTR(AREA,COORDS),
	HTML_ATTR(AREA,DIR),
	HTML_ATTR(AREA,HREF),
	HTML_ATTR(AREA,ID),
	HTML_ATTR(AREA,NAME),
	HTML_ATTR(AREA,NOHREF),
	HTML_ATTR(AREA,LANG),
	HTML_ATTR(AREA,SHAPE),
	HTML_ATTR(AREA,STYLE),
	HTML_ATTR(AREA,TABINDEX),
	HTML_ATTR(AREA,TARGET),
	HTML_ATTR(AREA,TITLE),
	HTML_ATTRIBUTES(AREA)
};


/*
(
  BASE
)
*/

enum _HTML_BASE_Attributes {
	HTML_ATTR(BASE,HREF) = 0,
	HTML_ATTR(BASE,TARGET),
	HTML_ATTRIBUTES(BASE)
};

/*
(
  BDO
)
*/

enum _HTML_BDO_Attributes {
	HTML_ATTR(BDO,CLASS) = 0,
	HTML_ATTR(BDO,DIR),
	HTML_ATTR(BDO,ID),
	HTML_ATTR(BDO,LANG),
	HTML_ATTR(BDO,STYLE),
	HTML_ATTR(BDO,TITLE),
	HTML_ATTRIBUTES(BDO)
};

/*
(
  BLOCKQUOTE
)
*/

enum _HTML_BQ_Attributes {
	HTML_ATTR(BQ,CITE) = 0,
	HTML_ATTR(BQ,CLASS),
	HTML_ATTR(BQ,DIR),
	HTML_ATTR(BQ,ID),
	HTML_ATTR(BQ,LANG),
	HTML_ATTR(BQ,STYLE),
	HTML_ATTR(BQ,TITLE),
	HTML_ATTRIBUTES(BQ)
};

/*
(
  BODY
)
*/

enum _HTML_BODY_Attributes {
	HTML_ATTR(BODY,ALINK) = 0,
	HTML_ATTR(BODY,BACKGROUND),
	HTML_ATTR(BODY,BGCOLOR),
	HTML_ATTR(BODY,CLASS),
	HTML_ATTR(BODY,DIR),
	HTML_ATTR(BODY,ID),
	HTML_ATTR(BODY,LANG),
	HTML_ATTR(BODY,LINK),
	HTML_ATTR(BODY,STYLE),
	HTML_ATTR(BODY,TEXT),
	HTML_ATTR(BODY,TITLE),
	HTML_ATTR(BODY,VLINK),
	HTML_ATTRIBUTES(BODY)
};

/*
(
  BR
)
*/

enum _HTML_BR_Attributes {
	HTML_ATTR(BR,CLASS) = 0,
	HTML_ATTR(BR,CLEAR),
	HTML_ATTR(BR,ID),
	HTML_ATTR(BR,STYLE),
	HTML_ATTR(BR,TITLE),
	HTML_ATTRIBUTES(BR)
};

/*
(
  BUTTON
)
*/

enum _HTML_BUTTON_Attributes {
	HTML_ATTR(BUTTON,ACCESSKEY) = 0,
	HTML_ATTR(BUTTON,CLASS),
	HTML_ATTR(BUTTON,DIR),
	HTML_ATTR(BUTTON,DISABLED),
	HTML_ATTR(BUTTON,ID),
	HTML_ATTR(BUTTON,LANG),
	HTML_ATTR(BUTTON,NAME),
	HTML_ATTR(BUTTON,STYLE),
	HTML_ATTR(BUTTON,TABINDEX),
	HTML_ATTR(BUTTON,TITLE),
	HTML_ATTR(BUTTON,TYPE),
	HTML_ATTR(BUTTON,VALUE),
	HTML_ATTRIBUTES(BUTTON),
};

/*
(
  COL
)
*/

enum _HTML_COL_Attributes {
	HTML_ATTR(COL,CLASS) = 0,
	HTML_ATTR(COL,DIR),
	HTML_ATTR(COL,ID),
	HTML_ATTR(COL,LANG),
	HTML_ATTR(COL,SPAN),
	HTML_ATTR(COL,STYLE),
	HTML_ATTR(COL,TITLE),
	HTML_ATTR(COL,WIDTH),
	HTML_ATTRIBUTES(COL)
};

/*
(
  DEL, INS
)
*/

enum _HTML_CHANGES_Attributes {
	HTML_ATTR(CHANGES,CITE) = 0,
	HTML_ATTR(CHANGES,CLASS),
	HTML_ATTR(CHANGES,DATETIME),
	HTML_ATTR(CHANGES,DIR),
	HTML_ATTR(CHANGES,ID),
	HTML_ATTR(CHANGES,LANG),
	HTML_ATTR(CHANGES,STYLE),
	HTML_ATTR(CHANGES,TITLE),
	HTML_ATTRIBUTES(CHANGES)
};

/*
(
  FONT - Deprecated
)
*/

enum _HTML_FONT_Attributes {
	HTML_ATTR(FONT,CLASS) = 0,
	HTML_ATTR(FONT,COLOR),
	HTML_ATTR(FONT,DIR),
	HTML_ATTR(FONT,FACE),
	HTML_ATTR(FONT,ID),
	HTML_ATTR(FONT,LANG),
	HTML_ATTR(FONT,SIZE),
	HTML_ATTR(FONT,STYLE),
	HTML_ATTR(FONT,TITLE),
	HTML_ATTRIBUTES(FONT)
};

/*
(
  FORM
)
*/

enum _HTML_FORM_Attributes {
	HTML_ATTR(FORM,ACCEPT) = 0,
	HTML_ATTR(FORM,ACCEPT_CHARSET), /* { "ACCEPT-CHARSET" } */
	HTML_ATTR(FORM,ACTION),
	HTML_ATTR(FORM,CLASS),
	HTML_ATTR(FORM,DIR),
	HTML_ATTR(FORM,ENCTYPE),
	HTML_ATTR(FORM,ID),
	HTML_ATTR(FORM,LANG),
	HTML_ATTR(FORM,METHOD),
	HTML_ATTR(FORM,STYLE),
	HTML_ATTR(FORM,TARGET),
	HTML_ATTR(FORM,TITLE),
	HTML_ATTRIBUTES(FORM)
};

/*
(
  FRAME
)
*/

enum _HTML_FRAME_Attributes {
	HTML_ATTR(FRAME,CLASS) = 0,
	HTML_ATTR(FRAME,FRAMEBORDER),
	HTML_ATTR(FRAME,ID),
	HTML_ATTR(FRAME,NAME),
	HTML_ATTR(FRAME,MARGINHEIGHT),
	HTML_ATTR(FRAME,MARGINWIDTH),
	HTML_ATTR(FRAME,NORESIZE),
	HTML_ATTR(FRAME,LONGDESC),
	HTML_ATTR(FRAME,SCROLLING),
	HTML_ATTR(FRAME,SRC),
	HTML_ATTR(FRAME,STYLE),
	HTML_ATTR(FRAME,TARGET),
	HTML_ATTR(FRAME,TITLE),
	HTML_ATTRIBUTES(FRAME)
};

/*
(
  FRAMESET
)
*/

enum _HTML_FRAMESET_Attributes {
	HTML_ATTR(FRAMESET,CLASS) = 0,
	HTML_ATTR(FRAMESET,COLS),
	HTML_ATTR(FRAMESET,ID),
	HTML_ATTR(FRAMESET,ROWS),
	HTML_ATTR(FRAMESET,STYLE),
	HTML_ATTR(FRAMESET,TITLE),
	HTML_ATTRIBUTES(FRAMESET)
};

/*
(
  Generic attributes
)
*/

enum _HTML_GEN_Attributes {
	HTML_ATTR(GEN,CLASS) = 0,
	HTML_ATTR(GEN,DIR),
	HTML_ATTR(GEN,ID),
	HTML_ATTR(GEN,LANG),
	HTML_ATTR(GEN,STYLE),
	HTML_ATTR(GEN,TITLE),
	HTML_ATTRIBUTES(GEN)
};

/*
(
  BLOCK
)
*/

enum _HTML_BLOCK_Attributes {
	HTML_ATTR(BLOCK,ALIGN) = 0,
	HTML_ATTR(BLOCK,CLASS),
	HTML_ATTR(BLOCK,DIR),
	HTML_ATTR(BLOCK,ID),
	HTML_ATTR(BLOCK,LANG),
	HTML_ATTR(BLOCK,STYLE),
	HTML_ATTR(BLOCK,TITLE),
	HTML_ATTRIBUTES(BLOCK)
};

/*
(
  HEAD
)
*/

enum _HTML_HEAD_Attributes {
	HTML_ATTR(HEAD,DIR) = 0,
	HTML_ATTR(HEAD,LANG),
	HTML_ATTR(HEAD,PROFILE),
	HTML_ATTRIBUTES(HEAD)
};

/*
(
  HR
)
*/

enum _HTML_HR_Attributes {
	HTML_ATTR(HR,ALIGN) = 0,
	HTML_ATTR(HR,CLASS),
	HTML_ATTR(HR,DIR),
	HTML_ATTR(HR,ID),
	HTML_ATTR(HR,LANG),
	HTML_ATTR(HR,NOSHADE),
	HTML_ATTR(HR,SIZE),
	HTML_ATTR(HR,STYLE),
	HTML_ATTR(HR,TITLE),
	HTML_ATTR(HR,WIDTH),
	HTML_ATTRIBUTES(HR)
};

/*
(
  HTML
)
*/

enum _HTML_HTML_Attributes {
	HTML_ATTR(HTML,DIR) = 0,
	HTML_ATTR(HTML,LANG),
	HTML_ATTR(HTML,VERSION),
	HTML_ATTRIBUTES(HTML)
};

/*
(
  IFRAME
)
*/

enum _HTML_IFRAME_Attributes {
	HTML_ATTR(IFRAME,ALIGN) = 0,
	HTML_ATTR(IFRAME,CLASS),
	HTML_ATTR(IFRAME,FRAMEBORDER),
	HTML_ATTR(IFRAME,HEIGHT),
	HTML_ATTR(IFRAME,ID),
	HTML_ATTR(IFRAME,LONGDESC),
	HTML_ATTR(IFRAME,MARGINHEIGHT),
	HTML_ATTR(IFRAME,MARGINWIDTH),
	HTML_ATTR(IFRAME,NAME),
	HTML_ATTR(IFRAME,SCROLLING),
	HTML_ATTR(IFRAME,SRC),
	HTML_ATTR(IFRAME,STYLE),
	HTML_ATTR(IFRAME,TARGET),
	HTML_ATTR(IFRAME,TITLE),
	HTML_ATTR(IFRAME,WIDTH),
	HTML_ATTRIBUTES(IFRAME)
};

/*
(
  IMG
)
*/

enum _HTML_IMG_Attributes {
	HTML_ATTR(IMG,ALIGN) = 0,
	HTML_ATTR(IMG,ALT),
	HTML_ATTR(IMG,BORDER),
	HTML_ATTR(IMG,CLASS),
	HTML_ATTR(IMG,DIR),
	HTML_ATTR(IMG,HEIGHT),
	HTML_ATTR(IMG,HSPACE),
	HTML_ATTR(IMG,ID),
	HTML_ATTR(IMG,ISMAP),
	HTML_ATTR(IMG,LANG),
	HTML_ATTR(IMG,LONGDESC),
	HTML_ATTR(IMG,SRC),
	HTML_ATTR(IMG,STYLE),
	HTML_ATTR(IMG,TITLE),
	HTML_ATTR(IMG,USEMAP),
	HTML_ATTR(IMG,VSPACE),
	HTML_ATTR(IMG,WIDTH),
	HTML_ATTRIBUTES(IMG)
};

/*
(
  INPUT
)
*/

enum _HTML_INPUT_Attributes {
	HTML_ATTR(INPUT,ACCEPT) = 0,
	HTML_ATTR(INPUT,ACCESSKEY),
	HTML_ATTR(INPUT,ALIGN),
	HTML_ATTR(INPUT,ALT),
	HTML_ATTR(INPUT,CHECKED),
	HTML_ATTR(INPUT,CLASS),
	HTML_ATTR(INPUT,DIR),
	HTML_ATTR(INPUT,DISABLED),
	HTML_ATTR(INPUT,ID),
	HTML_ATTR(INPUT,LANG),
	HTML_ATTR(INPUT,MAXLENGTH),
	HTML_ATTR(INPUT,NAME),
	HTML_ATTR(INPUT,READONLY),
	HTML_ATTR(INPUT,SIZE),
	HTML_ATTR(INPUT,SRC),
	HTML_ATTR(INPUT,STYLE),
	HTML_ATTR(INPUT,TABINDEX),
	HTML_ATTR(INPUT,TITLE),
	HTML_ATTR(INPUT,TYPE),
	HTML_ATTR(INPUT,USEMAP),
	HTML_ATTR(INPUT,VALUE),
	HTML_ATTRIBUTES(INPUT)
};

/*
(
)
*/

enum _HTML_ISINDEX_Attributes {
	HTML_ATTR(ISINDEX,CLASS) = 0,
	HTML_ATTR(ISINDEX,DIR),
	HTML_ATTR(ISINDEX,ID),
	HTML_ATTR(ISINDEX,LANG),
	HTML_ATTR(ISINDEX,PROMPT),
	HTML_ATTR(ISINDEX,STYLE),
	HTML_ATTR(ISINDEX,TITLE),
	HTML_ATTRIBUTES(ISINDEX)
};

/*
(
)
*/

enum _HTML_LABEL_Attributes {
	HTML_ATTR(LABEL,ACCESSKEY) = 0,
	HTML_ATTR(LABEL,CLASS),
	HTML_ATTR(LABEL,DIR),
	HTML_ATTR(LABEL,FOR),
	HTML_ATTR(LABEL,ID),
	HTML_ATTR(LABEL,LANG),
	HTML_ATTR(LABEL,STYLE),
	HTML_ATTR(LABEL,TITLE),
	HTML_ATTRIBUTES(LABEL)
};

/*
(
)
*/

enum _HTML_LEGEND_Attributes {
    HTML_ATTR(LEGEND,ACCESSKEY) = 0,
    HTML_ATTR(LEGEND,ALIGN),
	HTML_ATTR(LEGEND,CLASS),
	HTML_ATTR(LEGEND,DIR),
	HTML_ATTR(LEGEND,ID),
	HTML_ATTR(LEGEND,LANG),
	HTML_ATTR(LEGEND,STYLE),
	HTML_ATTR(LEGEND,TITLE),
	HTML_ATTRIBUTES(LEGEND)
};

/*
(
  LI
)
*/

enum _HTML_LI_Attributes {
	HTML_ATTR(LI,CLASS) = 0,
	HTML_ATTR(LI,COMPACT),
	HTML_ATTR(LI,DIR),
	HTML_ATTR(LI,ID),
	HTML_ATTR(LI,LANG),
	HTML_ATTR(LI,STYLE),
	HTML_ATTR(LI,TITLE),
	HTML_ATTR(LI,TYPE),
	HTML_ATTR(LI,VALUE),
	HTML_ATTRIBUTES(LI)
};

/*
(
  LINK
)
*/

enum _HTML_LINK_Attributes {
	HTML_ATTR(LINK,CHARSET) = 0,
	HTML_ATTR(LINK,CLASS),
	HTML_ATTR(LINK,DIR),
	HTML_ATTR(LINK,HREF),
	HTML_ATTR(LINK,HREFLANG),
	HTML_ATTR(LINK,ID),
	HTML_ATTR(LINK,LANG),
	HTML_ATTR(LINK,MEDIA),
	HTML_ATTR(LINK,REL),
	HTML_ATTR(LINK,REV),
	HTML_ATTR(LINK,STYLE),
	HTML_ATTR(LINK,TARGET),
	HTML_ATTR(LINK,TITLE),
	HTML_ATTR(LINK,TYPE),
	HTML_ATTRIBUTES(LINK)
};

/*
(
  MAP
)
*/

enum _HTML_MAP_Attributes {
	HTML_ATTR(MAP,CLASS) = 0,
	HTML_ATTR(MAP,DIR),
	HTML_ATTR(MAP,ID),
	HTML_ATTR(MAP,LANG),
	HTML_ATTR(MAP,NAME),
	HTML_ATTR(MAP,STYLE),
	HTML_ATTR(MAP,TITLE),
	HTML_ATTRIBUTES(MAP)
};

/*
(
  META
)
*/

enum _HTML_META_Attributes {
	HTML_ATTR(META,CONTENT) = 0,
	HTML_ATTR(META,DIR),
	HTML_ATTR(META,HTTP_EQUIV),    /* { "HTTP-EQUIV" ) */
	HTML_ATTR(META,LANG),
	HTML_ATTR(META,NAME),
	HTML_ATTR(META,SCHEME),
	HTML_ATTRIBUTES(META)
};	

/*
(
  NEXTID
)
*/

#define HTML_NEXTID_ATTRIBUTES  1
#define HTML_NEXTID_N 0

/*
(
  OBJECT
)
*/

enum _HTML_OBJECT_Attributes {
	HTML_ATTR(OBJECT,ALIGN) = 0,
	HTML_ATTR(OBJECT,ARCHIVE),
	HTML_ATTR(OBJECT,BORDER),
	HTML_ATTR(OBJECT,CLASS),
	HTML_ATTR(OBJECT,CLASSID),
	HTML_ATTR(OBJECT,CODEBASE),
	HTML_ATTR(OBJECT,CODETYPE),
	HTML_ATTR(OBJECT,DATA),
	HTML_ATTR(OBJECT,DECLARE),
	HTML_ATTR(OBJECT,DIR),
	HTML_ATTR(OBJECT,HEIGHT),
	HTML_ATTR(OBJECT,HSPACE),
	HTML_ATTR(OBJECT,ID),
	HTML_ATTR(OBJECT,LANG),
	HTML_ATTR(OBJECT,NAME),
	HTML_ATTR(OBJECT,STANDBY),
	HTML_ATTR(OBJECT,STYLE),
	HTML_ATTR(OBJECT,TABINDEX),
	HTML_ATTR(OBJECT,TITLE),
	HTML_ATTR(OBJECT,TYPE),
	HTML_ATTR(OBJECT,USEMAP),
	HTML_ATTR(OBJECT,VSPACE),
	HTML_ATTR(OBJECT,WIDTH),
	HTML_ATTRIBUTES(OBJECT)
};

/*
(
  OL
)
*/

enum _HTML_OL_Attributes {
	HTML_ATTR(OL,CLASS) = 0,
	HTML_ATTR(OL,COMPACT),
	HTML_ATTR(OL,DIR),
	HTML_ATTR(OL,ID),
	HTML_ATTR(OL,LANG),
	HTML_ATTR(OL,START),
	HTML_ATTR(OL,STYLE),
	HTML_ATTR(OL,TITLE),
	HTML_ATTR(OL,TYPE),
	HTML_ATTRIBUTES(OL)
};

/*
(
  OPTGROUP
)
*/

enum _HTML_OPTGROUP_Attributes {
	HTML_ATTR(OPTGROUP,CLASS) = 0,
	HTML_ATTR(OPTGROUP,DISABLED),
	HTML_ATTR(OPTGROUP,DIR),
	HTML_ATTR(OPTGROUP,ID),
	HTML_ATTR(OPTGROUP,LABEL),
	HTML_ATTR(OPTGROUP,LANG),
	HTML_ATTR(OPTGROUP,STYLE),
	HTML_ATTR(OPTGROUP,TITLE),
	HTML_ATTRIBUTES(OPTGROUP)
};

/*
(
  OPTION
)
*/

enum _HTML_OPTION_Attributes {
	HTML_ATTR(OPTION,CLASS) = 0,
	HTML_ATTR(OPTION,DISABLED),
	HTML_ATTR(OPTION,DIR),
	HTML_ATTR(OPTION,ID),
	HTML_ATTR(OPTION,LABEL),
	HTML_ATTR(OPTION,LANG),
	HTML_ATTR(OPTION,SELECTED),
	HTML_ATTR(OPTION,STYLE),
	HTML_ATTR(OPTION,TITLE),
	HTML_ATTR(OPTION,VALUE),
	HTML_ATTRIBUTES(OPTION)
};

/*
(
  PARAM
)
*/

enum _HTML_PARAM_Attributes {
	HTML_ATTR(PARAM,ID) = 0,
	HTML_ATTR(PARAM,NAME),
	HTML_ATTR(PARAM,TYPE),
	HTML_ATTR(PARAM,VALUE),
	HTML_ATTR(PARAM,VALUETYPE),
	HTML_ATTRIBUTES(PARAM)
};

/*
(
  PRE
)
*/

enum _HTML_PRE_Attributes {
	HTML_ATTR(PRE,CLASS) = 0,
	HTML_ATTR(PRE,DIR),
	HTML_ATTR(PRE,ID),
	HTML_ATTR(PRE,LANG),
	HTML_ATTR(PRE,STYLE),
	HTML_ATTR(PRE,TITLE),
	HTML_ATTR(PRE,WIDTH),
	HTML_ATTRIBUTES(PRE)
};

/*
(
  SCRIPT
)
*/

enum _HTML_SCRIPT_Attributes {
	HTML_ATTR(SCRIPT,CHARSET) = 0,
	HTML_ATTR(SCRIPT,DEFER),
	HTML_ATTR(SCRIPT,LANGUAGE),
	HTML_ATTR(SCRIPT,SRC),
	HTML_ATTR(SCRIPT,TYPE),
	HTML_ATTRIBUTES(SCRIPT)
};

/*
(
  SELECT
)
*/

enum _HTML_SELECT_Attributes {
	HTML_ATTR(SELECT,CLASS) = 0,
	HTML_ATTR(SELECT,DIR),
	HTML_ATTR(SELECT,DISABLED),
	HTML_ATTR(SELECT,ID),
	HTML_ATTR(SELECT,LANG),
	HTML_ATTR(SELECT,MULTIPLE),
	HTML_ATTR(SELECT,NAME),
	HTML_ATTR(SELECT,SIZE),
	HTML_ATTR(SELECT,STYLE),
	HTML_ATTR(SELECT,TABINDEX),
	HTML_ATTR(SELECT,TITLE),
	HTML_ATTRIBUTES(SELECT)
};

/*
(
  STYLE
)
*/

enum _HTML_STYLE_Attributes {
	HTML_ATTR(STYLE,DIR) = 0,
	HTML_ATTR(STYLE,LANG),
	HTML_ATTR(STYLE,MEDIA),
	HTML_ATTR(STYLE,TITLE),
	HTML_ATTR(STYLE,TYPE),
	HTML_ATTRIBUTES(STYLE)
};

/*
(
  TABLE
)
*/

enum _HTML_TABLE_Attributes {
	HTML_ATTR(TABLE,ALIGN) = 0,
	HTML_ATTR(TABLE,BGCOLOR),
	HTML_ATTR(TABLE,BORDER),
	HTML_ATTR(TABLE,CELLPADDING),
	HTML_ATTR(TABLE,CELLSPACING),
	HTML_ATTR(TABLE,CLASS),
	HTML_ATTR(TABLE,DIR),
	HTML_ATTR(TABLE,FRAME),
	HTML_ATTR(TABLE,ID),
	HTML_ATTR(TABLE,LANG),
	HTML_ATTR(TABLE,RULES),
	HTML_ATTR(TABLE,SUMMARY),
	HTML_ATTR(TABLE,STYLE),
	HTML_ATTR(TABLE,TITLE),
	HTML_ATTR(TABLE,WIDTH),
	HTML_ATTRIBUTES(TABLE)
};

/*
(
  TABLE Elements
)
*/

enum _HTML_TELE_Attributes {
	HTML_ATTR(TELE,ALIGN) = 0,
	HTML_ATTR(TELE,CHAR),
	HTML_ATTR(TELE,CHAROFF),
	HTML_ATTR(TELE,CLASS),
	HTML_ATTR(TELE,DIR),
	HTML_ATTR(TELE,ID),
	HTML_ATTR(TELE,LANG),
	HTML_ATTR(TELE,STYLE),
	HTML_ATTR(TELE,TITLE),
	HTML_ATTR(TELE,VALIGN),
	HTML_ATTRIBUTES(TELE)
};

/*
(
  TD
)
*/

enum _HTML_TD_Attributes {
	HTML_ATTR(TD,ABBR) = 0,
	HTML_ATTR(TD,ALIGN),
	HTML_ATTR(TD,AXIS),
	HTML_ATTR(TD,BGCOLOR),
	HTML_ATTR(TD,CHAR),
	HTML_ATTR(TD,CHAROFF),
	HTML_ATTR(TD,CLASS),
	HTML_ATTR(TD,COLSPAN),
	HTML_ATTR(TD,DIR),
	HTML_ATTR(TD,ID),
	HTML_ATTR(TD,HEADERS),
	HTML_ATTR(TD,HEIGHT),
	HTML_ATTR(TD,LANG),
	HTML_ATTR(TD,NOWRAP),
	HTML_ATTR(TD,ROWSPAN),
	HTML_ATTR(TD,SCOPE),
	HTML_ATTR(TD,STYLE),
	HTML_ATTR(TD,TITLE),
	HTML_ATTR(TD,VALIGN),
	HTML_ATTR(TD,WIDTH),
	HTML_ATTRIBUTES(TD)
};

/*
(
  TEXTAREA
)
*/

enum _HTML_TEXTAREA_Attributes {
	HTML_ATTR(TEXTAREA,CLASS) = 0,
	HTML_ATTR(TEXTAREA,COLS),
	HTML_ATTR(TEXTAREA,DIR),
	HTML_ATTR(TEXTAREA,DISABLED),
	HTML_ATTR(TEXTAREA,ID),
	HTML_ATTR(TEXTAREA,LANG),
	HTML_ATTR(TEXTAREA,NAME),
	HTML_ATTR(TEXTAREA,READONLY),
	HTML_ATTR(TEXTAREA,ROWS),
	HTML_ATTR(TEXTAREA,STYLE),
	HTML_ATTR(TEXTAREA,TABINDEX),
	HTML_ATTR(TEXTAREA,TITLE),
	HTML_ATTRIBUTES(TEXTAREA)
};

/*
(
  TITLE
)
*/

enum _HTML_TITLE_Attributes {
	HTML_ATTR(TITLE,DIR) = 0,
	HTML_ATTR(TITLE,LANG),
	HTML_ATTRIBUTES(TITLE)
};

/*
(
  UL
)
*/

enum _HTML_UL_Attributes {
	HTML_ATTR(UL,CLASS) = 0,
	HTML_ATTR(UL,COMPACT),
	HTML_ATTR(UL,DIR),
	HTML_ATTR(UL,ID),
	HTML_ATTR(UL,LANG),
	HTML_ATTR(UL,STYLE),
	HTML_ATTR(UL,TITLE),
	HTML_ATTR(UL,TYPE),
	HTML_ATTRIBUTES(UL)
};

/*
.
  The C Representation of the SGML DTD
.
*/

extern SGML_dtd * HTML_dtd (void);
extern BOOL HTML_setDtd (const SGML_dtd * dtd);

/*
.
  Utitity Functions
.
(
  Start anchor element
)

It is kinda convenient to have a particular routine for starting an anchor
element, as everything else for HTML is simple anyway.
*/

extern void HTStartAnchor (
		HTStructured * targetstream,
		const char *  	name,
		const char *  	href);

/*
(
  Put image element
)

This is the same idea but for images
*/

extern void HTMLPutImg (HTStructured *obj,
		 	       const char *src,
			       const char *alt,
			       const char *align);


/*
(
  Specify next ID to be used
)

This is another convenience routine, for specifying the next ID to be used
by an editor in the series z1. z2,...
*/

extern void HTNextID (HTStructured * targetStream, const char * s);

/*
*/

#endif /* HTMLDTD_H */

/*

  

  @(#) $Id: HTMLPDTD.html,v 2.30 1999/04/02 16:10:36 frystyk Exp $

*/
