/*
 *
 *  (c) COPYRIGHT MIT and INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/*
 * the colorname database, the biggest the best ...
 * Needed to interpret colornames received.
 */

typedef struct ColornameElem
  {
     STRING              name;
     unsigned short      red;
     unsigned short      green;
     unsigned short      blue;
  }
ColornameElem;

static ColornameElem ColornameTable[] =
{
					     /* values recommended in the CSS draft *//* red ,green, blue */
#  if defined (_I18N_) || defined (__JIS__)
   {L"aqua", /* #00ffff, */ 0, 255, 255},
   {L"black", /* #000000, */ 0, 0, 0},
   {L"blue", /* #0000ff, */ 0, 0, 255},
   {L"fuchsia", /* #ff00ff, */ 255, 0, 255},
   {L"gray", /* #808080, */ 128, 128, 128},
   {L"green", /* #008000, */ 0, 128, 0},
   {L"lime", /* #00ff00, */ 0, 255, 0},
   {L"maroon", /* #800000, */ 128, 0, 0},
   {L"navy", /* #000080, */ 0, 0, 128},
   {L"olive", /* #808000, */ 128, 128, 0},
   {L"purple", /* #800080 */ 128, 0, 128},
   {L"red", /* #ff0000, */ 255, 0, 0},
   {L"silver", /* #c0c0c0, */ 192, 192, 192},
   {L"teal", /* #008080, */ 0, 128, 128},
   {L"white", /* #ffffff, */ 255, 255, 255},
   {L"yellow", /* #ffff00, */ 255, 255, 0},

/* values recommended in the CSS draft old ones */
   {L"cyan", /* #00ffff, */ 0, 255, 255},
   {L"magenta", /* #ff00ff, */ 255, 0, 255},
   {L"pink", /* #ffc0cb, */ 255, 192, 203},
   {L"brown", /* #a52a2a, */ 165, 42, 42},
   {L"gray", /* #bebebe, */ 190, 190, 190},
   {L"orange", /* #ffa500, */ 255, 165, 0},
   {L"purple", /* #a020f0, */ 160, 32, 240},
   {L"turquoise", /* #40e0d0, */ 64, 224, 208},
   {L"violet", /* #ee82ee, */ 238, 130, 238},

/* other less commonly used values */
   {L"AliceBlue", /* #f0f8ff, */ 240, 248, 255},
   {L"AntiqueWhite", /* #faebd7, */ 250, 235, 215},
   {L"AntiqueWhite1", /* #ffefdb, */ 255, 239, 219},
   {L"AntiqueWhite2", /* #eedfcc, */ 238, 223, 204},
   {L"AntiqueWhite3", /* #cdc0b0, */ 205, 192, 176},
   {L"AntiqueWhite4", /* #8b8378, */ 139, 131, 120},
   {L"aquamarine1", /* #7fffd4, */ 127, 255, 212},
   {L"aquamarine2", /* #76eec6, */ 118, 238, 198},
   {L"aquamarine4", /* #458b74, */ 69, 139, 116},
   {L"azure1", /* #f0ffff, */ 240, 255, 255},
   {L"azure2", /* #e0eeee, */ 224, 238, 238},
   {L"azure3", /* #c1cdcd, */ 193, 205, 205},
   {L"azure4", /* #838b8b, */ 131, 139, 139},
   {L"beige", /* #f5f5dc, */ 245, 245, 220},
   {L"bisque1", /* #ffe4c4, */ 255, 228, 196},
   {L"bisque2", /* #eed5b7, */ 238, 213, 183},
   {L"bisque3", /* #cdb79e, */ 205, 183, 158},
   {L"bisque4", /* #8b7d6b, */ 139, 125, 107},
   {L"BlanchedAlmond", /* #ffebcd, */ 255, 235, 205},
   {L"blue1", /* #0000ff, */ 0, 0, 255},
   {L"blue2", /* #0000ee, */ 0, 0, 238},
   {L"blue4", /* #00008b, */ 0, 0, 139},
   {L"BlueViolet", /* #8a2be2, */ 138, 43, 226},
   {L"brown1", /* #ff4040, */ 255, 64, 64},
   {L"brown2", /* #ee3b3b, */ 238, 59, 59},
   {L"brown3", /* #cd3333, */ 205, 51, 51},
   {L"brown4", /* #8b2323, */ 139, 35, 35},
   {L"burlywood", /* #deb887, */ 222, 184, 135},
   {L"burlywood1", /* #ffd39b, */ 255, 211, 155},
   {L"burlywood2", /* #eec591, */ 238, 197, 145},
   {L"burlywood3", /* #cdaa7d, */ 205, 170, 125},
   {L"burlywood4", /* #8b7355, */ 139, 115, 85},
   {L"CadetBlue", /* #5f9ea0, */ 95, 158, 160},
   {L"CadetBlue1", /* #98f5ff, */ 152, 245, 255},
   {L"CadetBlue2", /* #8ee5ee, */ 142, 229, 238},
   {L"CadetBlue3", /* #7ac5cd, */ 122, 197, 205},
   {L"CadetBlue4", /* #53868b, */ 83, 134, 139},
   {L"chartreuse1", /* #7fff00, */ 127, 255, 0},
   {L"chartreuse2", /* #76ee00, */ 118, 238, 0},
   {L"chartreuse3", /* #66cd00, */ 102, 205, 0},
   {L"chartreuse4", /* #458b00, */ 69, 139, 0},
   {L"chocolate", /* #d2691e, */ 210, 105, 30},
   {L"chocolate1", /* #ff7f24, */ 255, 127, 36},
   {L"chocolate2", /* #ee7621, */ 238, 118, 33},
   {L"chocolate3", /* #cd661d, */ 205, 102, 29},
   {L"coral", /* #ff7f50, */ 255, 127, 80},
   {L"coral1", /* #ff7256, */ 255, 114, 86},
   {L"coral2", /* #ee6a50, */ 238, 106, 80},
   {L"coral3", /* #cd5b45, */ 205, 91, 69},
   {L"coral4", /* #8b3e2f, */ 139, 62, 47},
   {L"CornflowerBlue", /* #6495ed, */ 100, 149, 237},
   {L"cornsilk1", /* #fff8dc, */ 255, 248, 220},
   {L"cornsilk2", /* #eee8cd, */ 238, 232, 205},
   {L"cornsilk3", /* #cdc8b1, */ 205, 200, 177},
   {L"cornsilk4", /* #8b8878, */ 139, 136, 120},
   {L"cyan1", /* #00ffff, */ 0, 255, 255},
   {L"cyan2", /* #00eeee, */ 0, 238, 238},
   {L"cyan3", /* #00cdcd, */ 0, 205, 205},
   {L"cyan4", /* #008b8b, */ 0, 139, 139},
   {L"DarkGoldenrod", /* #b8860b, */ 184, 134, 11},
   {L"DarkGoldenrod1", /* #ffb90f, */ 255, 185, 15},
   {L"DarkGoldenrod2", /* #eead0e, */ 238, 173, 14},
   {L"DarkGoldenrod3", /* #cd950c, */ 205, 149, 12},
   {L"DarkGoldenrod4", /* #8b6508, */ 139, 101, 8},
   {L"DarkGreen", /* #006400, */ 0, 100, 0},
   {L"DarkKhaki", /* #bdb76b, */ 189, 183, 107},
   {L"DarkOliveGreen", /* #556b2f, */ 85, 107, 47},
   {L"DarkOliveGreen1", /* #caff70, */ 202, 255, 112},
   {L"DarkOliveGreen2", /* #bcee68, */ 188, 238, 104},
   {L"DarkOliveGreen3", /* #a2cd5a, */ 162, 205, 90},
   {L"DarkOliveGreen4", /* #6e8b3d, */ 110, 139, 61},
   {L"DarkOrange", /* #ff8c00, */ 255, 140, 0},
   {L"DarkOrange1", /* #ff7f00, */ 255, 127, 0},
   {L"DarkOrange2", /* #ee7600, */ 238, 118, 0},
   {L"DarkOrange3", /* #cd6600, */ 205, 102, 0},
   {L"DarkOrange4", /* #8b4500, */ 139, 69, 0},
   {L"DarkOrchid", /* #9932cc, */ 153, 50, 204},
   {L"DarkOrchid1", /* #bf3eff, */ 191, 62, 255},
   {L"DarkOrchid2", /* #b23aee, */ 178, 58, 238},
   {L"DarkOrchid3", /* #9a32cd, */ 154, 50, 205},
   {L"DarkOrchid4", /* #68228b, */ 104, 34, 139},
   {L"DarkSalmon", /* #e9967a, */ 233, 150, 122},
   {L"DarkSeaGreen", /* #8fbc8f, */ 143, 188, 143},
   {L"DarkSeaGreen1", /* #c1ffc1, */ 193, 255, 193},
   {L"DarkSeaGreen2", /* #b4eeb4, */ 180, 238, 180},
   {L"DarkSeaGreen3", /* #9bcd9b, */ 155, 205, 155},
   {L"DarkSeaGreen4", /* #698b69, */ 105, 139, 105},
   {L"DarkSlateBlue", /* #483d8b, */ 72, 61, 139},
   {L"DarkSlateGray", /* #2f4f4f, */ 47, 79, 79},
   {L"DarkSlateGray1", /* #97ffff, */ 151, 255, 255},
   {L"DarkSlateGray2", /* #8deeee, */ 141, 238, 238},
   {L"DarkSlateGray3", /* #79cdcd, */ 121, 205, 205},
   {L"DarkSlateGray4", /* #528b8b, */ 82, 139, 139},
   {L"DarkTurquoise", /* #00ced1, */ 0, 206, 209},
   {L"DarkViolet", /* #9400d3, */ 148, 0, 211},
   {L"DeepPink1", /* #ff1493, */ 255, 20, 147},
   {L"DeepPink2", /* #ee1289, */ 238, 18, 137},
   {L"DeepPink3", /* #cd1076, */ 205, 16, 118},
   {L"DeepPink4", /* #8b0a50, */ 139, 10, 80},
   {L"DeepSkyBlue1", /* #00bfff, */ 0, 191, 255},
   {L"DeepSkyBlue2", /* #00b2ee, */ 0, 178, 238},
   {L"DeepSkyBlue3", /* #009acd, */ 0, 154, 205},
   {L"DeepSkyBlue4", /* #00688b, */ 0, 104, 139},
   {L"DimGray", /* #696969, */ 105, 105, 105},
   {L"DodgerBlue1", /* #1e90ff, */ 30, 144, 255},
   {L"DodgerBlue2", /* #1c86ee, */ 28, 134, 238},
   {L"DodgerBlue3", /* #1874cd, */ 24, 116, 205},
   {L"DodgerBlue4", /* #104e8b, */ 16, 78, 139},
   {L"firebrick", /* #b22222, */ 178, 34, 34},
   {L"firebrick1", /* #ff3030, */ 255, 48, 48},
   {L"firebrick2", /* #ee2c2c, */ 238, 44, 44},
   {L"firebrick3", /* #cd2626, */ 205, 38, 38},
   {L"firebrick4", /* #8b1a1a, */ 139, 26, 26},
   {L"FloralWhite", /* #fffaf0, */ 255, 250, 240},
   {L"ForestGreen", /* #228b22, */ 34, 139, 34},
   {L"gainsboro", /* #dcdcdc, */ 220, 220, 220},
   {L"GhostWhite", /* #f8f8ff, */ 248, 248, 255},
   {L"gold1", /* #ffd700, */ 255, 215, 0},
   {L"gold2", /* #eec900, */ 238, 201, 0},
   {L"gold3", /* #cdad00, */ 205, 173, 0},
   {L"gold4", /* #8b7500, */ 139, 117, 0},
   {L"goldenrod", /* #daa520, */ 218, 165, 32},
   {L"goldenrod1", /* #ffc125, */ 255, 193, 37},
   {L"goldenrod2", /* #eeb422, */ 238, 180, 34},
   {L"goldenrod3", /* #cd9b1d, */ 205, 155, 29},
   {L"goldenrod4", /* #8b6914, */ 139, 105, 20},
   {L"gray1", /* #030303, */ 3, 3, 3},
   {L"gray10", /* #1a1a1a, */ 26, 26, 26},
   {L"gray11", /* #1c1c1c, */ 28, 28, 28},
   {L"gray12", /* #1f1f1f, */ 31, 31, 31},
   {L"gray13", /* #212121, */ 33, 33, 33},
   {L"gray14", /* #242424, */ 36, 36, 36},
   {L"gray15", /* #262626, */ 38, 38, 38},
   {L"gray16", /* #292929, */ 41, 41, 41},
   {L"gray17", /* #2b2b2b, */ 43, 43, 43},
   {L"gray18", /* #2e2e2e, */ 46, 46, 46},
   {L"gray19", /* #303030, */ 48, 48, 48},
   {L"gray2", /* #050505, */ 5, 5, 5},
   {L"gray20", /* #333333, */ 51, 51, 51},
   {L"gray21", /* #363636, */ 54, 54, 54},
   {L"gray22", /* #383838, */ 56, 56, 56},
   {L"gray23", /* #3b3b3b, */ 59, 59, 59},
   {L"gray24", /* #3d3d3d, */ 61, 61, 61},
   {L"gray25", /* #404040, */ 64, 64, 64},
   {L"gray26", /* #424242, */ 66, 66, 66},
   {L"gray27", /* #454545, */ 69, 69, 69},
   {L"gray28", /* #474747, */ 71, 71, 71},
   {L"gray29", /* #4a4a4a, */ 74, 74, 74},
   {L"gray3", /* #080808, */ 8, 8, 8},
   {L"gray30", /* #4d4d4d, */ 77, 77, 77},
   {L"gray31", /* #4f4f4f, */ 79, 79, 79},
   {L"gray32", /* #525252, */ 82, 82, 82},
   {L"gray33", /* #545454, */ 84, 84, 84},
   {L"gray34", /* #575757, */ 87, 87, 87},
   {L"gray35", /* #595959, */ 89, 89, 89},
   {L"gray36", /* #5c5c5c, */ 92, 92, 92},
   {L"gray37", /* #5e5e5e, */ 94, 94, 94},
   {L"gray38", /* #616161, */ 97, 97, 97},
   {L"gray39", /* #636363, */ 99, 99, 99},
   {L"gray4", /* #0a0a0a, */ 10, 10, 10},
   {L"gray40", /* #666666, */ 102, 102, 102},
   {L"gray41", /* #696969, */ 105, 105, 105},
   {L"gray42", /* #6b6b6b, */ 107, 107, 107},
   {L"gray43", /* #6e6e6e, */ 110, 110, 110},
   {L"gray44", /* #707070, */ 112, 112, 112},
   {L"gray45", /* #737373, */ 115, 115, 115},
   {L"gray46", /* #757575, */ 117, 117, 117},
   {L"gray47", /* #787878, */ 120, 120, 120},
   {L"gray48", /* #7a7a7a, */ 122, 122, 122},
   {L"gray49", /* #7d7d7d, */ 125, 125, 125},
   {L"gray5", /* #0d0d0d, */ 13, 13, 13},
   {L"gray50", /* #7f7f7f, */ 127, 127, 127},
   {L"gray51", /* #828282, */ 130, 130, 130},
   {L"gray52", /* #858585, */ 133, 133, 133},
   {L"gray53", /* #878787, */ 135, 135, 135},
   {L"gray54", /* #8a8a8a, */ 138, 138, 138},
   {L"gray55", /* #8c8c8c, */ 140, 140, 140},
   {L"gray56", /* #8f8f8f, */ 143, 143, 143},
   {L"gray57", /* #919191, */ 145, 145, 145},
   {L"gray58", /* #949494, */ 148, 148, 148},
   {L"gray59", /* #969696, */ 150, 150, 150},
   {L"gray6", /* #0f0f0f, */ 15, 15, 15},
   {L"gray60", /* #999999, */ 153, 153, 153},
   {L"gray61", /* #9c9c9c, */ 156, 156, 156},
   {L"gray62", /* #9e9e9e, */ 158, 158, 158},
   {L"gray63", /* #a1a1a1, */ 161, 161, 161},
   {L"gray64", /* #a3a3a3, */ 163, 163, 163},
   {L"gray65", /* #a6a6a6, */ 166, 166, 166},
   {L"gray66", /* #a8a8a8, */ 168, 168, 168},
   {L"gray67", /* #ababab, */ 171, 171, 171},
   {L"gray68", /* #adadad, */ 173, 173, 173},
   {L"gray69", /* #b0b0b0, */ 176, 176, 176},
   {L"gray7", /* #121212, */ 18, 18, 18},
   {L"gray70", /* #b3b3b3, */ 179, 179, 179},
   {L"gray71", /* #b5b5b5, */ 181, 181, 181},
   {L"gray72", /* #b8b8b8, */ 184, 184, 184},
   {L"gray73", /* #bababa, */ 186, 186, 186},
   {L"gray74", /* #bdbdbd, */ 189, 189, 189},
   {L"gray75", /* #bfbfbf, */ 191, 191, 191},
   {L"gray76", /* #c2c2c2, */ 194, 194, 194},
   {L"gray77", /* #c4c4c4, */ 196, 196, 196},
   {L"gray78", /* #c7c7c7, */ 199, 199, 199},
   {L"gray79", /* #c9c9c9, */ 201, 201, 201},
   {L"gray8", /* #141414, */ 20, 20, 20},
   {L"gray80", /* #cccccc, */ 204, 204, 204},
   {L"gray81", /* #cfcfcf, */ 207, 207, 207},
   {L"gray82", /* #d1d1d1, */ 209, 209, 209},
   {L"gray83", /* #d4d4d4, */ 212, 212, 212},
   {L"gray84", /* #d6d6d6, */ 214, 214, 214},
   {L"gray85", /* #d9d9d9, */ 217, 217, 217},
   {L"gray86", /* #dbdbdb, */ 219, 219, 219},
   {L"gray87", /* #dedede, */ 222, 222, 222},
   {L"gray88", /* #e0e0e0, */ 224, 224, 224},
   {L"gray89", /* #e3e3e3, */ 227, 227, 227},
   {L"gray9", /* #171717, */ 23, 23, 23},
   {L"gray90", /* #e5e5e5, */ 229, 229, 229},
   {L"gray91", /* #e8e8e8, */ 232, 232, 232},
   {L"gray92", /* #ebebeb, */ 235, 235, 235},
   {L"gray93", /* #ededed, */ 237, 237, 237},
   {L"gray94", /* #f0f0f0, */ 240, 240, 240},
   {L"gray95", /* #f2f2f2, */ 242, 242, 242},
   {L"gray97", /* #f7f7f7, */ 247, 247, 247},
   {L"gray98", /* #fafafa, */ 250, 250, 250},
   {L"gray99", /* #fcfcfc, */ 252, 252, 252},
   {L"green1", /* #00ff00, */ 0, 255, 0},
   {L"green2", /* #00ee00, */ 0, 238, 0},
   {L"green3", /* #00cd00, */ 0, 205, 0},
   {L"green4", /* #008b00, */ 0, 139, 0},
   {L"GreenYellow", /* #adff2f, */ 173, 255, 47},
   {L"honeydew1", /* #f0fff0, */ 240, 255, 240},
   {L"honeydew2", /* #e0eee0, */ 224, 238, 224},
   {L"honeydew3", /* #c1cdc1, */ 193, 205, 193},
   {L"honeydew4", /* #838b83, */ 131, 139, 131},
   {L"HotPink", /* #ff69b4, */ 255, 105, 180},
   {L"HotPink1", /* #ff6eb4, */ 255, 110, 180},
   {L"HotPink2", /* #ee6aa7, */ 238, 106, 167},
   {L"HotPink3", /* #cd6090, */ 205, 96, 144},
   {L"HotPink4", /* #8b3a62, */ 139, 58, 98},
   {L"IndianRed", /* #cd5c5c, */ 205, 92, 92},
   {L"IndianRed1", /* #ff6a6a, */ 255, 106, 106},
   {L"IndianRed2", /* #ee6363, */ 238, 99, 99},
   {L"IndianRed3", /* #cd5555, */ 205, 85, 85},
   {L"IndianRed4", /* #8b3a3a, */ 139, 58, 58},
   {L"ivory1", /* #fffff0, */ 255, 255, 240},
   {L"ivory2", /* #eeeee0, */ 238, 238, 224},
   {L"ivory3", /* #cdcdc1, */ 205, 205, 193},
   {L"ivory4", /* #8b8b83, */ 139, 139, 131},
   {L"khaki", /* #f0e68c, */ 240, 230, 140},
   {L"khaki1", /* #fff68f, */ 255, 246, 143},
   {L"khaki2", /* #eee685, */ 238, 230, 133},
   {L"khaki3", /* #cdc673, */ 205, 198, 115},
   {L"khaki4", /* #8b864e, */ 139, 134, 78},
   {L"lavender", /* #e6e6fa, */ 230, 230, 250},
   {L"LavenderBlush1", /* #fff0f5, */ 255, 240, 245},
   {L"LavenderBlush2", /* #eee0e5, */ 238, 224, 229},
   {L"LavenderBlush3", /* #cdc1c5, */ 205, 193, 197},
   {L"LavenderBlush4", /* #8b8386, */ 139, 131, 134},
   {L"LawnGreen", /* #7cfc00, */ 124, 252, 0},
   {L"LemonChiffon1", /* #fffacd, */ 255, 250, 205},
   {L"LemonChiffon2", /* #eee9bf, */ 238, 233, 191},
   {L"LemonChiffon3", /* #cdc9a5, */ 205, 201, 165},
   {L"LemonChiffon4", /* #8b8970, */ 139, 137, 112},
   {L"light", /* #eedd82, */ 238, 221, 130},
   {L"LightBlue", /* #add8e6, */ 173, 216, 230},
   {L"LightBlue1", /* #bfefff, */ 191, 239, 255},
   {L"LightBlue2", /* #b2dfee, */ 178, 223, 238},
   {L"LightBlue3", /* #9ac0cd, */ 154, 192, 205},
   {L"LightBlue4", /* #68838b, */ 104, 131, 139},
   {L"LightCoral", /* #f08080, */ 240, 128, 128},
   {L"LightCyan1", /* #e0ffff, */ 224, 255, 255},
   {L"LightCyan2", /* #d1eeee, */ 209, 238, 238},
   {L"LightCyan3", /* #b4cdcd, */ 180, 205, 205},
   {L"LightCyan4", /* #7a8b8b, */ 122, 139, 139},
   {L"LightGoldenrod1", /* #ffec8b, */ 255, 236, 139},
   {L"LightGoldenrod2", /* #eedc82, */ 238, 220, 130},
   {L"LightGoldenrod3", /* #cdbe70, */ 205, 190, 112},
   {L"LightGoldenrod4", /* #8b814c, */ 139, 129, 76},
   {L"LightGoldenrodYellow", /* #fafad2, */ 250, 250, 210},
   {L"LightGray", /* #d3d3d3, */ 211, 211, 211},
   {L"LightPink", /* #ffb6c1, */ 255, 182, 193},
   {L"LightPink1", /* #ffaeb9, */ 255, 174, 185},
   {L"LightPink2", /* #eea2ad, */ 238, 162, 173},
   {L"LightPink3", /* #cd8c95, */ 205, 140, 149},
   {L"LightPink4", /* #8b5f65, */ 139, 95, 101},
   {L"LightSalmon1", /* #ffa07a, */ 255, 160, 122},
   {L"LightSalmon2", /* #ee9572, */ 238, 149, 114},
   {L"LightSalmon3", /* #cd8162, */ 205, 129, 98},
   {L"LightSalmon4", /* #8b5742, */ 139, 87, 66},
   {L"LightSeaGreen", /* #20b2aa, */ 32, 178, 170},
   {L"LightSkyBlue", /* #87cefa, */ 135, 206, 250},
   {L"LightSkyBlue1", /* #b0e2ff, */ 176, 226, 255},
   {L"LightSkyBlue2", /* #a4d3ee, */ 164, 211, 238},
   {L"LightSkyBlue3", /* #8db6cd, */ 141, 182, 205},
   {L"LightSkyBlue4", /* #607b8b, */ 96, 123, 139},
   {L"LightSlateBlue", /* #8470ff, */ 132, 112, 255},
   {L"LightSlateGray", /* #778899, */ 119, 136, 153},
   {L"LightSteelBlue", /* #b0c4de, */ 176, 196, 222},
   {L"LightSteelBlue1", /* #cae1ff, */ 202, 225, 255},
   {L"LightSteelBlue2", /* #bcd2ee, */ 188, 210, 238},
   {L"LightSteelBlue3", /* #a2b5cd, */ 162, 181, 205},
   {L"LightSteelBlue4", /* #6e7b8b, */ 110, 123, 139},
   {L"LightYellow1", /* #ffffe0, */ 255, 255, 224},
   {L"LightYellow2", /* #eeeed1, */ 238, 238, 209},
   {L"LightYellow3", /* #cdcdb4, */ 205, 205, 180},
   {L"LightYellow4", /* #8b8b7a, */ 139, 139, 122},
   {L"LimeGreen", /* #32cd32, */ 50, 205, 50},
   {L"linen", /* #faf0e6, */ 250, 240, 230},
   {L"magenta", /* #ff00ff, */ 255, 0, 255},
   {L"magenta2", /* #ee00ee, */ 238, 0, 238},
   {L"magenta3", /* #cd00cd, */ 205, 0, 205},
   {L"magenta4", /* #8b008b, */ 139, 0, 139},
   {L"maroon", /* #b03060, */ 176, 48, 96},
   {L"maroon1", /* #ff34b3, */ 255, 52, 179},
   {L"maroon2", /* #ee30a7, */ 238, 48, 167},
   {L"maroon3", /* #cd2990, */ 205, 41, 144},
   {L"maroon4", /* #8b1c62, */ 139, 28, 98},
   {L"medium", /* #66cdaa, */ 102, 205, 170},
   {L"MediumAquamarine", /* #66cdaa, */ 102, 205, 170},
   {L"MediumBlue", /* #0000cd, */ 0, 0, 205},
   {L"MediumOrchid", /* #ba55d3, */ 186, 85, 211},
   {L"MediumOrchid1", /* #e066ff, */ 224, 102, 255},
   {L"MediumOrchid2", /* #d15fee, */ 209, 95, 238},
   {L"MediumOrchid3", /* #b452cd, */ 180, 82, 205},
   {L"MediumOrchid4", /* #7a378b, */ 122, 55, 139},
   {L"MediumPurple", /* #9370db, */ 147, 112, 219},
   {L"MediumPurple1", /* #ab82ff, */ 171, 130, 255},
   {L"MediumPurple2", /* #9f79ee, */ 159, 121, 238},
   {L"MediumPurple3", /* #8968cd, */ 137, 104, 205},
   {L"MediumPurple4", /* #5d478b, */ 93, 71, 139},
   {L"MediumSeaGreen", /* #3cb371, */ 60, 179, 113},
   {L"MediumSlateBlue", /* #7b68ee, */ 123, 104, 238},
   {L"MediumSpringGreen", /* #00fa9a, */ 0, 250, 154},
   {L"MediumTurquoise", /* #48d1cc, */ 72, 209, 204},
   {L"MediumVioletRed", /* #c71585, */ 199, 21, 133},
   {L"MidnightBlue", /* #191970, */ 25, 25, 112},
   {L"MintCream", /* #f5fffa, */ 245, 255, 250},
   {L"MistyRose1", /* #ffe4e1, */ 255, 228, 225},
   {L"MistyRose2", /* #eed5d2, */ 238, 213, 210},
   {L"MistyRose3", /* #cdb7b5, */ 205, 183, 181},
   {L"MistyRose4", /* #8b7d7b, */ 139, 125, 123},
   {L"moccasin", /* #ffe4b5, */ 255, 228, 181},
   {L"NavajoWhite1", /* #ffdead, */ 255, 222, 173},
   {L"NavajoWhite2", /* #eecfa1, */ 238, 207, 161},
   {L"NavajoWhite3", /* #cdb38b, */ 205, 179, 139},
   {L"NavajoWhite4", /* #8b795e, */ 139, 121, 94},
   {L"NavyBlue", /* #000080, */ 0, 0, 128},
   {L"OldLace", /* #fdf5e6, */ 253, 245, 230},
   {L"OliveDrab", /* #6b8e23, */ 107, 142, 35},
   {L"OliveDrab1", /* #c0ff3e, */ 192, 255, 62},
   {L"OliveDrab2", /* #b3ee3a, */ 179, 238, 58},
   {L"OliveDrab4", /* #698b22, */ 105, 139, 34},
   {L"orange1", /* #ffa500, */ 255, 165, 0},
   {L"orange2", /* #ee9a00, */ 238, 154, 0},
   {L"orange3", /* #cd8500, */ 205, 133, 0},
   {L"orange4", /* #8b5a00, */ 139, 90, 0},
   {L"OrangeRed1", /* #ff4500, */ 255, 69, 0},
   {L"OrangeRed2", /* #ee4000, */ 238, 64, 0},
   {L"OrangeRed3", /* #cd3700, */ 205, 55, 0},
   {L"OrangeRed4", /* #8b2500, */ 139, 37, 0},
   {L"orchid", /* #da70d6, */ 218, 112, 214},
   {L"orchid1", /* #ff83fa, */ 255, 131, 250},
   {L"orchid2", /* #ee7ae9, */ 238, 122, 233},
   {L"orchid3", /* #cd69c9, */ 205, 105, 201},
   {L"orchid4", /* #8b4789, */ 139, 71, 137},
   {L"pale", /* #db7093, */ 219, 112, 147},
   {L"PaleGoldenrod", /* #eee8aa, */ 238, 232, 170},
   {L"PaleGreen", /* #98fb98, */ 152, 251, 152},
   {L"PaleGreen1", /* #9aff9a, */ 154, 255, 154},
   {L"PaleGreen2", /* #90ee90, */ 144, 238, 144},
   {L"PaleGreen3", /* #7ccd7c, */ 124, 205, 124},
   {L"PaleGreen4", /* #548b54, */ 84, 139, 84},
   {L"PaleTurquoise", /* #afeeee, */ 175, 238, 238},
   {L"PaleTurquoise1", /* #bbffff, */ 187, 255, 255},
   {L"PaleTurquoise2", /* #aeeeee, */ 174, 238, 238},
   {L"PaleTurquoise3", /* #96cdcd, */ 150, 205, 205},
   {L"PaleTurquoise4", /* #668b8b, */ 102, 139, 139},
   {L"PaleVioletRed", /* #db7093, */ 219, 112, 147},
   {L"PaleVioletRed1", /* #ff82ab, */ 255, 130, 171},
   {L"PaleVioletRed2", /* #ee799f, */ 238, 121, 159},
   {L"PaleVioletRed3", /* #cd6889, */ 205, 104, 137},
   {L"PaleVioletRed4", /* #8b475d, */ 139, 71, 93},
   {L"PapayaWhip", /* #ffefd5, */ 255, 239, 213},
   {L"PeachPuff1", /* #ffdab9, */ 255, 218, 185},
   {L"PeachPuff2", /* #eecbad, */ 238, 203, 173},
   {L"PeachPuff3", /* #cdaf95, */ 205, 175, 149},
   {L"PeachPuff4", /* #8b7765, */ 139, 119, 101},
   {L"pink1", /* #ffb5c5, */ 255, 181, 197},
   {L"pink2", /* #eea9b8, */ 238, 169, 184},
   {L"pink3", /* #cd919e, */ 205, 145, 158},
   {L"pink4", /* #8b636c, */ 139, 99, 108},
   {L"plum", /* #dda0dd, */ 221, 160, 221},
   {L"plum1", /* #ffbbff, */ 255, 187, 255},
   {L"plum2", /* #eeaeee, */ 238, 174, 238},
   {L"plum3", /* #cd96cd, */ 205, 150, 205},
   {L"plum4", /* #8b668b, */ 139, 102, 139},
   {L"PowderBlue", /* #b0e0e6, */ 176, 224, 230},
   {L"purple1", /* #9b30ff, */ 155, 48, 255},
   {L"purple2", /* #912cee, */ 145, 44, 238},
   {L"purple3", /* #7d26cd, */ 125, 38, 205},
   {L"purple4", /* #551a8b, */ 85, 26, 139},
   {L"red1", /* #ff0000, */ 255, 0, 0},
   {L"red2", /* #ee0000, */ 238, 0, 0},
   {L"red3", /* #cd0000, */ 205, 0, 0},
   {L"red4", /* #8b0000, */ 139, 0, 0},
   {L"RosyBrown", /* #bc8f8f, */ 188, 143, 143},
   {L"RosyBrown1", /* #ffc1c1, */ 255, 193, 193},
   {L"RosyBrown2", /* #eeb4b4, */ 238, 180, 180},
   {L"RosyBrown3", /* #cd9b9b, */ 205, 155, 155},
   {L"RosyBrown4", /* #8b6969, */ 139, 105, 105},
   {L"RoyalBlue", /* #4169e1, */ 65, 105, 225},
   {L"RoyalBlue1", /* #4876ff, */ 72, 118, 255},
   {L"RoyalBlue2", /* #436eee, */ 67, 110, 238},
   {L"RoyalBlue3", /* #3a5fcd, */ 58, 95, 205},
   {L"RoyalBlue4", /* #27408b, */ 39, 64, 139},
   {L"SaddleBrown", /* #8b4513, */ 139, 69, 19},
   {L"salmon", /* #fa8072, */ 250, 128, 114},
   {L"salmon1", /* #ff8c69, */ 255, 140, 105},
   {L"salmon2", /* #ee8262, */ 238, 130, 98},
   {L"salmon3", /* #cd7054, */ 205, 112, 84},
   {L"salmon4", /* #8b4c39, */ 139, 76, 57},
   {L"SandyBrown", /* #f4a460, */ 244, 164, 96},
   {L"SeaGreen1", /* #54ff9f, */ 84, 255, 159},
   {L"SeaGreen2", /* #4eee94, */ 78, 238, 148},
   {L"SeaGreen3", /* #43cd80, */ 67, 205, 128},
   {L"SeaGreen4", /* #2e8b57, */ 46, 139, 87},
   {L"seashell1", /* #fff5ee, */ 255, 245, 238},
   {L"seashell2", /* #eee5de, */ 238, 229, 222},
   {L"seashell3", /* #cdc5bf, */ 205, 197, 191},
   {L"seashell4", /* #8b8682, */ 139, 134, 130},
   {L"sienna", /* #a0522d, */ 160, 82, 45},
   {L"sienna1", /* #ff8247, */ 255, 130, 71},
   {L"sienna2", /* #ee7942, */ 238, 121, 66},
   {L"sienna3", /* #cd6839, */ 205, 104, 57},
   {L"sienna4", /* #8b4726, */ 139, 71, 38},
   {L"SkyBlue", /* #87ceeb, */ 135, 206, 235},
   {L"SkyBlue1", /* #87ceff, */ 135, 206, 255},
   {L"SkyBlue2", /* #7ec0ee, */ 126, 192, 238},
   {L"SkyBlue3", /* #6ca6cd, */ 108, 166, 205},
   {L"SkyBlue4", /* #4a708b, */ 74, 112, 139},
   {L"SlateBlue", /* #6a5acd, */ 106, 90, 205},
   {L"SlateBlue1", /* #836fff, */ 131, 111, 255},
   {L"SlateBlue2", /* #7a67ee, */ 122, 103, 238},
   {L"SlateBlue3", /* #6959cd, */ 105, 89, 205},
   {L"SlateBlue4", /* #473c8b, */ 71, 60, 139},
   {L"SlateGray", /* #708090, */ 112, 128, 144},
   {L"SlateGray1", /* #c6e2ff, */ 198, 226, 255},
   {L"SlateGray2", /* #b9d3ee, */ 185, 211, 238},
   {L"SlateGray3", /* #9fb6cd, */ 159, 182, 205},
   {L"SlateGray4", /* #6c7b8b, */ 108, 123, 139},
   {L"snow1", /* #fffafa, */ 255, 250, 250},
   {L"snow2", /* #eee9e9, */ 238, 233, 233},
   {L"snow3", /* #cdc9c9, */ 205, 201, 201},
   {L"snow4", /* #8b8989, */ 139, 137, 137},
   {L"SpringGreen1", /* #00ff7f, */ 0, 255, 127},
   {L"SpringGreen2", /* #00ee76, */ 0, 238, 118},
   {L"SpringGreen3", /* #00cd66, */ 0, 205, 102},
   {L"SpringGreen4", /* #008b45, */ 0, 139, 69},
   {L"SteelBlue", /* #4682b4, */ 70, 130, 180},
   {L"SteelBlue1", /* #63b8ff, */ 99, 184, 255},
   {L"SteelBlue2", /* #5cacee, */ 92, 172, 238},
   {L"SteelBlue3", /* #4f94cd, */ 79, 148, 205},
   {L"SteelBlue4", /* #36648b, */ 54, 100, 139},
   {L"tan", /* #d2b48c, */ 210, 180, 140},
   {L"tan1", /* #ffa54f, */ 255, 165, 79},
   {L"tan2", /* #ee9a49, */ 238, 154, 73},
   {L"tan3", /* #cd853f, */ 205, 133, 63},
   {L"tan4", /* #8b5a2b, */ 139, 90, 43},
   {L"thistle", /* #d8bfd8, */ 216, 191, 216},
   {L"thistle1", /* #ffe1ff, */ 255, 225, 255},
   {L"thistle2", /* #eed2ee, */ 238, 210, 238},
   {L"thistle3", /* #cdb5cd, */ 205, 181, 205},
   {L"thistle4", /* #8b7b8b, */ 139, 123, 139},
   {L"tomato1", /* #ff6347, */ 255, 99, 71},
   {L"tomato2", /* #ee5c42, */ 238, 92, 66},
   {L"tomato3", /* #cd4f39, */ 205, 79, 57},
   {L"tomato4", /* #8b3626, */ 139, 54, 38},
   {L"turquoise1", /* #00f5ff, */ 0, 245, 255},
   {L"turquoise2", /* #00e5ee, */ 0, 229, 238},
   {L"turquoise3", /* #00c5cd, */ 0, 197, 205},
   {L"turquoise4", /* #00868b, */ 0, 134, 139},
   {L"VioletRed", /* #d02090, */ 208, 32, 144},
   {L"VioletRed1", /* #ff3e96, */ 255, 62, 150},
   {L"VioletRed2", /* #ee3a8c, */ 238, 58, 140},
   {L"VioletRed3", /* #cd3278, */ 205, 50, 120},
   {L"VioletRed4", /* #8b2252, */ 139, 34, 82},
   {L"wheat", /* #f5deb3, */ 245, 222, 179},
   {L"wheat1", /* #ffe7ba, */ 255, 231, 186},
   {L"wheat2", /* #eed8ae, */ 238, 216, 174},
   {L"wheat3", /* #cdba96, */ 205, 186, 150},
   {L"wheat4", /* #8b7e66, */ 139, 126, 102},
   {L"WhiteSmoke", /* #f5f5f5, */ 245, 245, 245},
   {L"yellow1", /* #ffff00, */ 255, 255, 0},
   {L"yellow2", /* #eeee00, */ 238, 238, 0},
   {L"yellow3", /* #cdcd00, */ 205, 205, 0},
   {L"yellow4", /* #8b8b00, */ 139, 139, 0},
   {L"YellowGreen", /* #9acd32, */ 154, 205, 50}
#  else /* !defined (_I18N_) && ! defined (__JIS__) */
   {"aqua", /* #00ffff, */ 0, 255, 255},
   {"black", /* #000000, */ 0, 0, 0},
   {"blue", /* #0000ff, */ 0, 0, 255},
   {"fuchsia", /* #ff00ff, */ 255, 0, 255},
   {"gray", /* #808080, */ 128, 128, 128},
   {"green", /* #008000, */ 0, 128, 0},
   {"lime", /* #00ff00, */ 0, 255, 0},
   {"maroon", /* #800000, */ 128, 0, 0},
   {"navy", /* #000080, */ 0, 0, 128},
   {"olive", /* #808000, */ 128, 128, 0},
   {"purple", /* #800080 */ 128, 0, 128},
   {"red", /* #ff0000, */ 255, 0, 0},
   {"silver", /* #c0c0c0, */ 192, 192, 192},
   {"teal", /* #008080, */ 0, 128, 128},
   {"white", /* #ffffff, */ 255, 255, 255},
   {"yellow", /* #ffff00, */ 255, 255, 0},

/* values recommended in the CSS draft old ones */
   {"cyan", /* #00ffff, */ 0, 255, 255},
   {"magenta", /* #ff00ff, */ 255, 0, 255},
   {"pink", /* #ffc0cb, */ 255, 192, 203},
   {"brown", /* #a52a2a, */ 165, 42, 42},
   {"gray", /* #bebebe, */ 190, 190, 190},
   {"orange", /* #ffa500, */ 255, 165, 0},
   {"purple", /* #a020f0, */ 160, 32, 240},
   {"turquoise", /* #40e0d0, */ 64, 224, 208},
   {"violet", /* #ee82ee, */ 238, 130, 238},

/* other less commonly used values */
   {"AliceBlue", /* #f0f8ff, */ 240, 248, 255},
   {"AntiqueWhite", /* #faebd7, */ 250, 235, 215},
   {"AntiqueWhite1", /* #ffefdb, */ 255, 239, 219},
   {"AntiqueWhite2", /* #eedfcc, */ 238, 223, 204},
   {"AntiqueWhite3", /* #cdc0b0, */ 205, 192, 176},
   {"AntiqueWhite4", /* #8b8378, */ 139, 131, 120},
   {"aquamarine1", /* #7fffd4, */ 127, 255, 212},
   {"aquamarine2", /* #76eec6, */ 118, 238, 198},
   {"aquamarine4", /* #458b74, */ 69, 139, 116},
   {"azure1", /* #f0ffff, */ 240, 255, 255},
   {"azure2", /* #e0eeee, */ 224, 238, 238},
   {"azure3", /* #c1cdcd, */ 193, 205, 205},
   {"azure4", /* #838b8b, */ 131, 139, 139},
   {"beige", /* #f5f5dc, */ 245, 245, 220},
   {"bisque1", /* #ffe4c4, */ 255, 228, 196},
   {"bisque2", /* #eed5b7, */ 238, 213, 183},
   {"bisque3", /* #cdb79e, */ 205, 183, 158},
   {"bisque4", /* #8b7d6b, */ 139, 125, 107},
   {"BlanchedAlmond", /* #ffebcd, */ 255, 235, 205},
   {"blue1", /* #0000ff, */ 0, 0, 255},
   {"blue2", /* #0000ee, */ 0, 0, 238},
   {"blue4", /* #00008b, */ 0, 0, 139},
   {"BlueViolet", /* #8a2be2, */ 138, 43, 226},
   {"brown1", /* #ff4040, */ 255, 64, 64},
   {"brown2", /* #ee3b3b, */ 238, 59, 59},
   {"brown3", /* #cd3333, */ 205, 51, 51},
   {"brown4", /* #8b2323, */ 139, 35, 35},
   {"burlywood", /* #deb887, */ 222, 184, 135},
   {"burlywood1", /* #ffd39b, */ 255, 211, 155},
   {"burlywood2", /* #eec591, */ 238, 197, 145},
   {"burlywood3", /* #cdaa7d, */ 205, 170, 125},
   {"burlywood4", /* #8b7355, */ 139, 115, 85},
   {"CadetBlue", /* #5f9ea0, */ 95, 158, 160},
   {"CadetBlue1", /* #98f5ff, */ 152, 245, 255},
   {"CadetBlue2", /* #8ee5ee, */ 142, 229, 238},
   {"CadetBlue3", /* #7ac5cd, */ 122, 197, 205},
   {"CadetBlue4", /* #53868b, */ 83, 134, 139},
   {"chartreuse1", /* #7fff00, */ 127, 255, 0},
   {"chartreuse2", /* #76ee00, */ 118, 238, 0},
   {"chartreuse3", /* #66cd00, */ 102, 205, 0},
   {"chartreuse4", /* #458b00, */ 69, 139, 0},
   {"chocolate", /* #d2691e, */ 210, 105, 30},
   {"chocolate1", /* #ff7f24, */ 255, 127, 36},
   {"chocolate2", /* #ee7621, */ 238, 118, 33},
   {"chocolate3", /* #cd661d, */ 205, 102, 29},
   {"coral", /* #ff7f50, */ 255, 127, 80},
   {"coral1", /* #ff7256, */ 255, 114, 86},
   {"coral2", /* #ee6a50, */ 238, 106, 80},
   {"coral3", /* #cd5b45, */ 205, 91, 69},
   {"coral4", /* #8b3e2f, */ 139, 62, 47},
   {"CornflowerBlue", /* #6495ed, */ 100, 149, 237},
   {"cornsilk1", /* #fff8dc, */ 255, 248, 220},
   {"cornsilk2", /* #eee8cd, */ 238, 232, 205},
   {"cornsilk3", /* #cdc8b1, */ 205, 200, 177},
   {"cornsilk4", /* #8b8878, */ 139, 136, 120},
   {"cyan1", /* #00ffff, */ 0, 255, 255},
   {"cyan2", /* #00eeee, */ 0, 238, 238},
   {"cyan3", /* #00cdcd, */ 0, 205, 205},
   {"cyan4", /* #008b8b, */ 0, 139, 139},
   {"DarkGoldenrod", /* #b8860b, */ 184, 134, 11},
   {"DarkGoldenrod1", /* #ffb90f, */ 255, 185, 15},
   {"DarkGoldenrod2", /* #eead0e, */ 238, 173, 14},
   {"DarkGoldenrod3", /* #cd950c, */ 205, 149, 12},
   {"DarkGoldenrod4", /* #8b6508, */ 139, 101, 8},
   {"DarkGreen", /* #006400, */ 0, 100, 0},
   {"DarkKhaki", /* #bdb76b, */ 189, 183, 107},
   {"DarkOliveGreen", /* #556b2f, */ 85, 107, 47},
   {"DarkOliveGreen1", /* #caff70, */ 202, 255, 112},
   {"DarkOliveGreen2", /* #bcee68, */ 188, 238, 104},
   {"DarkOliveGreen3", /* #a2cd5a, */ 162, 205, 90},
   {"DarkOliveGreen4", /* #6e8b3d, */ 110, 139, 61},
   {"DarkOrange", /* #ff8c00, */ 255, 140, 0},
   {"DarkOrange1", /* #ff7f00, */ 255, 127, 0},
   {"DarkOrange2", /* #ee7600, */ 238, 118, 0},
   {"DarkOrange3", /* #cd6600, */ 205, 102, 0},
   {"DarkOrange4", /* #8b4500, */ 139, 69, 0},
   {"DarkOrchid", /* #9932cc, */ 153, 50, 204},
   {"DarkOrchid1", /* #bf3eff, */ 191, 62, 255},
   {"DarkOrchid2", /* #b23aee, */ 178, 58, 238},
   {"DarkOrchid3", /* #9a32cd, */ 154, 50, 205},
   {"DarkOrchid4", /* #68228b, */ 104, 34, 139},
   {"DarkSalmon", /* #e9967a, */ 233, 150, 122},
   {"DarkSeaGreen", /* #8fbc8f, */ 143, 188, 143},
   {"DarkSeaGreen1", /* #c1ffc1, */ 193, 255, 193},
   {"DarkSeaGreen2", /* #b4eeb4, */ 180, 238, 180},
   {"DarkSeaGreen3", /* #9bcd9b, */ 155, 205, 155},
   {"DarkSeaGreen4", /* #698b69, */ 105, 139, 105},
   {"DarkSlateBlue", /* #483d8b, */ 72, 61, 139},
   {"DarkSlateGray", /* #2f4f4f, */ 47, 79, 79},
   {"DarkSlateGray1", /* #97ffff, */ 151, 255, 255},
   {"DarkSlateGray2", /* #8deeee, */ 141, 238, 238},
   {"DarkSlateGray3", /* #79cdcd, */ 121, 205, 205},
   {"DarkSlateGray4", /* #528b8b, */ 82, 139, 139},
   {"DarkTurquoise", /* #00ced1, */ 0, 206, 209},
   {"DarkViolet", /* #9400d3, */ 148, 0, 211},
   {"DeepPink1", /* #ff1493, */ 255, 20, 147},
   {"DeepPink2", /* #ee1289, */ 238, 18, 137},
   {"DeepPink3", /* #cd1076, */ 205, 16, 118},
   {"DeepPink4", /* #8b0a50, */ 139, 10, 80},
   {"DeepSkyBlue1", /* #00bfff, */ 0, 191, 255},
   {"DeepSkyBlue2", /* #00b2ee, */ 0, 178, 238},
   {"DeepSkyBlue3", /* #009acd, */ 0, 154, 205},
   {"DeepSkyBlue4", /* #00688b, */ 0, 104, 139},
   {"DimGray", /* #696969, */ 105, 105, 105},
   {"DodgerBlue1", /* #1e90ff, */ 30, 144, 255},
   {"DodgerBlue2", /* #1c86ee, */ 28, 134, 238},
   {"DodgerBlue3", /* #1874cd, */ 24, 116, 205},
   {"DodgerBlue4", /* #104e8b, */ 16, 78, 139},
   {"firebrick", /* #b22222, */ 178, 34, 34},
   {"firebrick1", /* #ff3030, */ 255, 48, 48},
   {"firebrick2", /* #ee2c2c, */ 238, 44, 44},
   {"firebrick3", /* #cd2626, */ 205, 38, 38},
   {"firebrick4", /* #8b1a1a, */ 139, 26, 26},
   {"FloralWhite", /* #fffaf0, */ 255, 250, 240},
   {"ForestGreen", /* #228b22, */ 34, 139, 34},
   {"gainsboro", /* #dcdcdc, */ 220, 220, 220},
   {"GhostWhite", /* #f8f8ff, */ 248, 248, 255},
   {"gold1", /* #ffd700, */ 255, 215, 0},
   {"gold2", /* #eec900, */ 238, 201, 0},
   {"gold3", /* #cdad00, */ 205, 173, 0},
   {"gold4", /* #8b7500, */ 139, 117, 0},
   {"goldenrod", /* #daa520, */ 218, 165, 32},
   {"goldenrod1", /* #ffc125, */ 255, 193, 37},
   {"goldenrod2", /* #eeb422, */ 238, 180, 34},
   {"goldenrod3", /* #cd9b1d, */ 205, 155, 29},
   {"goldenrod4", /* #8b6914, */ 139, 105, 20},
   {"gray1", /* #030303, */ 3, 3, 3},
   {"gray10", /* #1a1a1a, */ 26, 26, 26},
   {"gray11", /* #1c1c1c, */ 28, 28, 28},
   {"gray12", /* #1f1f1f, */ 31, 31, 31},
   {"gray13", /* #212121, */ 33, 33, 33},
   {"gray14", /* #242424, */ 36, 36, 36},
   {"gray15", /* #262626, */ 38, 38, 38},
   {"gray16", /* #292929, */ 41, 41, 41},
   {"gray17", /* #2b2b2b, */ 43, 43, 43},
   {"gray18", /* #2e2e2e, */ 46, 46, 46},
   {"gray19", /* #303030, */ 48, 48, 48},
   {"gray2", /* #050505, */ 5, 5, 5},
   {"gray20", /* #333333, */ 51, 51, 51},
   {"gray21", /* #363636, */ 54, 54, 54},
   {"gray22", /* #383838, */ 56, 56, 56},
   {"gray23", /* #3b3b3b, */ 59, 59, 59},
   {"gray24", /* #3d3d3d, */ 61, 61, 61},
   {"gray25", /* #404040, */ 64, 64, 64},
   {"gray26", /* #424242, */ 66, 66, 66},
   {"gray27", /* #454545, */ 69, 69, 69},
   {"gray28", /* #474747, */ 71, 71, 71},
   {"gray29", /* #4a4a4a, */ 74, 74, 74},
   {"gray3", /* #080808, */ 8, 8, 8},
   {"gray30", /* #4d4d4d, */ 77, 77, 77},
   {"gray31", /* #4f4f4f, */ 79, 79, 79},
   {"gray32", /* #525252, */ 82, 82, 82},
   {"gray33", /* #545454, */ 84, 84, 84},
   {"gray34", /* #575757, */ 87, 87, 87},
   {"gray35", /* #595959, */ 89, 89, 89},
   {"gray36", /* #5c5c5c, */ 92, 92, 92},
   {"gray37", /* #5e5e5e, */ 94, 94, 94},
   {"gray38", /* #616161, */ 97, 97, 97},
   {"gray39", /* #636363, */ 99, 99, 99},
   {"gray4", /* #0a0a0a, */ 10, 10, 10},
   {"gray40", /* #666666, */ 102, 102, 102},
   {"gray41", /* #696969, */ 105, 105, 105},
   {"gray42", /* #6b6b6b, */ 107, 107, 107},
   {"gray43", /* #6e6e6e, */ 110, 110, 110},
   {"gray44", /* #707070, */ 112, 112, 112},
   {"gray45", /* #737373, */ 115, 115, 115},
   {"gray46", /* #757575, */ 117, 117, 117},
   {"gray47", /* #787878, */ 120, 120, 120},
   {"gray48", /* #7a7a7a, */ 122, 122, 122},
   {"gray49", /* #7d7d7d, */ 125, 125, 125},
   {"gray5", /* #0d0d0d, */ 13, 13, 13},
   {"gray50", /* #7f7f7f, */ 127, 127, 127},
   {"gray51", /* #828282, */ 130, 130, 130},
   {"gray52", /* #858585, */ 133, 133, 133},
   {"gray53", /* #878787, */ 135, 135, 135},
   {"gray54", /* #8a8a8a, */ 138, 138, 138},
   {"gray55", /* #8c8c8c, */ 140, 140, 140},
   {"gray56", /* #8f8f8f, */ 143, 143, 143},
   {"gray57", /* #919191, */ 145, 145, 145},
   {"gray58", /* #949494, */ 148, 148, 148},
   {"gray59", /* #969696, */ 150, 150, 150},
   {"gray6", /* #0f0f0f, */ 15, 15, 15},
   {"gray60", /* #999999, */ 153, 153, 153},
   {"gray61", /* #9c9c9c, */ 156, 156, 156},
   {"gray62", /* #9e9e9e, */ 158, 158, 158},
   {"gray63", /* #a1a1a1, */ 161, 161, 161},
   {"gray64", /* #a3a3a3, */ 163, 163, 163},
   {"gray65", /* #a6a6a6, */ 166, 166, 166},
   {"gray66", /* #a8a8a8, */ 168, 168, 168},
   {"gray67", /* #ababab, */ 171, 171, 171},
   {"gray68", /* #adadad, */ 173, 173, 173},
   {"gray69", /* #b0b0b0, */ 176, 176, 176},
   {"gray7", /* #121212, */ 18, 18, 18},
   {"gray70", /* #b3b3b3, */ 179, 179, 179},
   {"gray71", /* #b5b5b5, */ 181, 181, 181},
   {"gray72", /* #b8b8b8, */ 184, 184, 184},
   {"gray73", /* #bababa, */ 186, 186, 186},
   {"gray74", /* #bdbdbd, */ 189, 189, 189},
   {"gray75", /* #bfbfbf, */ 191, 191, 191},
   {"gray76", /* #c2c2c2, */ 194, 194, 194},
   {"gray77", /* #c4c4c4, */ 196, 196, 196},
   {"gray78", /* #c7c7c7, */ 199, 199, 199},
   {"gray79", /* #c9c9c9, */ 201, 201, 201},
   {"gray8", /* #141414, */ 20, 20, 20},
   {"gray80", /* #cccccc, */ 204, 204, 204},
   {"gray81", /* #cfcfcf, */ 207, 207, 207},
   {"gray82", /* #d1d1d1, */ 209, 209, 209},
   {"gray83", /* #d4d4d4, */ 212, 212, 212},
   {"gray84", /* #d6d6d6, */ 214, 214, 214},
   {"gray85", /* #d9d9d9, */ 217, 217, 217},
   {"gray86", /* #dbdbdb, */ 219, 219, 219},
   {"gray87", /* #dedede, */ 222, 222, 222},
   {"gray88", /* #e0e0e0, */ 224, 224, 224},
   {"gray89", /* #e3e3e3, */ 227, 227, 227},
   {"gray9", /* #171717, */ 23, 23, 23},
   {"gray90", /* #e5e5e5, */ 229, 229, 229},
   {"gray91", /* #e8e8e8, */ 232, 232, 232},
   {"gray92", /* #ebebeb, */ 235, 235, 235},
   {"gray93", /* #ededed, */ 237, 237, 237},
   {"gray94", /* #f0f0f0, */ 240, 240, 240},
   {"gray95", /* #f2f2f2, */ 242, 242, 242},
   {"gray97", /* #f7f7f7, */ 247, 247, 247},
   {"gray98", /* #fafafa, */ 250, 250, 250},
   {"gray99", /* #fcfcfc, */ 252, 252, 252},
   {"green1", /* #00ff00, */ 0, 255, 0},
   {"green2", /* #00ee00, */ 0, 238, 0},
   {"green3", /* #00cd00, */ 0, 205, 0},
   {"green4", /* #008b00, */ 0, 139, 0},
   {"GreenYellow", /* #adff2f, */ 173, 255, 47},
   {"honeydew1", /* #f0fff0, */ 240, 255, 240},
   {"honeydew2", /* #e0eee0, */ 224, 238, 224},
   {"honeydew3", /* #c1cdc1, */ 193, 205, 193},
   {"honeydew4", /* #838b83, */ 131, 139, 131},
   {"HotPink", /* #ff69b4, */ 255, 105, 180},
   {"HotPink1", /* #ff6eb4, */ 255, 110, 180},
   {"HotPink2", /* #ee6aa7, */ 238, 106, 167},
   {"HotPink3", /* #cd6090, */ 205, 96, 144},
   {"HotPink4", /* #8b3a62, */ 139, 58, 98},
   {"IndianRed", /* #cd5c5c, */ 205, 92, 92},
   {"IndianRed1", /* #ff6a6a, */ 255, 106, 106},
   {"IndianRed2", /* #ee6363, */ 238, 99, 99},
   {"IndianRed3", /* #cd5555, */ 205, 85, 85},
   {"IndianRed4", /* #8b3a3a, */ 139, 58, 58},
   {"ivory1", /* #fffff0, */ 255, 255, 240},
   {"ivory2", /* #eeeee0, */ 238, 238, 224},
   {"ivory3", /* #cdcdc1, */ 205, 205, 193},
   {"ivory4", /* #8b8b83, */ 139, 139, 131},
   {"khaki", /* #f0e68c, */ 240, 230, 140},
   {"khaki1", /* #fff68f, */ 255, 246, 143},
   {"khaki2", /* #eee685, */ 238, 230, 133},
   {"khaki3", /* #cdc673, */ 205, 198, 115},
   {"khaki4", /* #8b864e, */ 139, 134, 78},
   {"lavender", /* #e6e6fa, */ 230, 230, 250},
   {"LavenderBlush1", /* #fff0f5, */ 255, 240, 245},
   {"LavenderBlush2", /* #eee0e5, */ 238, 224, 229},
   {"LavenderBlush3", /* #cdc1c5, */ 205, 193, 197},
   {"LavenderBlush4", /* #8b8386, */ 139, 131, 134},
   {"LawnGreen", /* #7cfc00, */ 124, 252, 0},
   {"LemonChiffon1", /* #fffacd, */ 255, 250, 205},
   {"LemonChiffon2", /* #eee9bf, */ 238, 233, 191},
   {"LemonChiffon3", /* #cdc9a5, */ 205, 201, 165},
   {"LemonChiffon4", /* #8b8970, */ 139, 137, 112},
   {"light", /* #eedd82, */ 238, 221, 130},
   {"LightBlue", /* #add8e6, */ 173, 216, 230},
   {"LightBlue1", /* #bfefff, */ 191, 239, 255},
   {"LightBlue2", /* #b2dfee, */ 178, 223, 238},
   {"LightBlue3", /* #9ac0cd, */ 154, 192, 205},
   {"LightBlue4", /* #68838b, */ 104, 131, 139},
   {"LightCoral", /* #f08080, */ 240, 128, 128},
   {"LightCyan1", /* #e0ffff, */ 224, 255, 255},
   {"LightCyan2", /* #d1eeee, */ 209, 238, 238},
   {"LightCyan3", /* #b4cdcd, */ 180, 205, 205},
   {"LightCyan4", /* #7a8b8b, */ 122, 139, 139},
   {"LightGoldenrod1", /* #ffec8b, */ 255, 236, 139},
   {"LightGoldenrod2", /* #eedc82, */ 238, 220, 130},
   {"LightGoldenrod3", /* #cdbe70, */ 205, 190, 112},
   {"LightGoldenrod4", /* #8b814c, */ 139, 129, 76},
   {"LightGoldenrodYellow", /* #fafad2, */ 250, 250, 210},
   {"LightGray", /* #d3d3d3, */ 211, 211, 211},
   {"LightPink", /* #ffb6c1, */ 255, 182, 193},
   {"LightPink1", /* #ffaeb9, */ 255, 174, 185},
   {"LightPink2", /* #eea2ad, */ 238, 162, 173},
   {"LightPink3", /* #cd8c95, */ 205, 140, 149},
   {"LightPink4", /* #8b5f65, */ 139, 95, 101},
   {"LightSalmon1", /* #ffa07a, */ 255, 160, 122},
   {"LightSalmon2", /* #ee9572, */ 238, 149, 114},
   {"LightSalmon3", /* #cd8162, */ 205, 129, 98},
   {"LightSalmon4", /* #8b5742, */ 139, 87, 66},
   {"LightSeaGreen", /* #20b2aa, */ 32, 178, 170},
   {"LightSkyBlue", /* #87cefa, */ 135, 206, 250},
   {"LightSkyBlue1", /* #b0e2ff, */ 176, 226, 255},
   {"LightSkyBlue2", /* #a4d3ee, */ 164, 211, 238},
   {"LightSkyBlue3", /* #8db6cd, */ 141, 182, 205},
   {"LightSkyBlue4", /* #607b8b, */ 96, 123, 139},
   {"LightSlateBlue", /* #8470ff, */ 132, 112, 255},
   {"LightSlateGray", /* #778899, */ 119, 136, 153},
   {"LightSteelBlue", /* #b0c4de, */ 176, 196, 222},
   {"LightSteelBlue1", /* #cae1ff, */ 202, 225, 255},
   {"LightSteelBlue2", /* #bcd2ee, */ 188, 210, 238},
   {"LightSteelBlue3", /* #a2b5cd, */ 162, 181, 205},
   {"LightSteelBlue4", /* #6e7b8b, */ 110, 123, 139},
   {"LightYellow1", /* #ffffe0, */ 255, 255, 224},
   {"LightYellow2", /* #eeeed1, */ 238, 238, 209},
   {"LightYellow3", /* #cdcdb4, */ 205, 205, 180},
   {"LightYellow4", /* #8b8b7a, */ 139, 139, 122},
   {"LimeGreen", /* #32cd32, */ 50, 205, 50},
   {"linen", /* #faf0e6, */ 250, 240, 230},
   {"magenta", /* #ff00ff, */ 255, 0, 255},
   {"magenta2", /* #ee00ee, */ 238, 0, 238},
   {"magenta3", /* #cd00cd, */ 205, 0, 205},
   {"magenta4", /* #8b008b, */ 139, 0, 139},
   {"maroon", /* #b03060, */ 176, 48, 96},
   {"maroon1", /* #ff34b3, */ 255, 52, 179},
   {"maroon2", /* #ee30a7, */ 238, 48, 167},
   {"maroon3", /* #cd2990, */ 205, 41, 144},
   {"maroon4", /* #8b1c62, */ 139, 28, 98},
   {"medium", /* #66cdaa, */ 102, 205, 170},
   {"MediumAquamarine", /* #66cdaa, */ 102, 205, 170},
   {"MediumBlue", /* #0000cd, */ 0, 0, 205},
   {"MediumOrchid", /* #ba55d3, */ 186, 85, 211},
   {"MediumOrchid1", /* #e066ff, */ 224, 102, 255},
   {"MediumOrchid2", /* #d15fee, */ 209, 95, 238},
   {"MediumOrchid3", /* #b452cd, */ 180, 82, 205},
   {"MediumOrchid4", /* #7a378b, */ 122, 55, 139},
   {"MediumPurple", /* #9370db, */ 147, 112, 219},
   {"MediumPurple1", /* #ab82ff, */ 171, 130, 255},
   {"MediumPurple2", /* #9f79ee, */ 159, 121, 238},
   {"MediumPurple3", /* #8968cd, */ 137, 104, 205},
   {"MediumPurple4", /* #5d478b, */ 93, 71, 139},
   {"MediumSeaGreen", /* #3cb371, */ 60, 179, 113},
   {"MediumSlateBlue", /* #7b68ee, */ 123, 104, 238},
   {"MediumSpringGreen", /* #00fa9a, */ 0, 250, 154},
   {"MediumTurquoise", /* #48d1cc, */ 72, 209, 204},
   {"MediumVioletRed", /* #c71585, */ 199, 21, 133},
   {"MidnightBlue", /* #191970, */ 25, 25, 112},
   {"MintCream", /* #f5fffa, */ 245, 255, 250},
   {"MistyRose1", /* #ffe4e1, */ 255, 228, 225},
   {"MistyRose2", /* #eed5d2, */ 238, 213, 210},
   {"MistyRose3", /* #cdb7b5, */ 205, 183, 181},
   {"MistyRose4", /* #8b7d7b, */ 139, 125, 123},
   {"moccasin", /* #ffe4b5, */ 255, 228, 181},
   {"NavajoWhite1", /* #ffdead, */ 255, 222, 173},
   {"NavajoWhite2", /* #eecfa1, */ 238, 207, 161},
   {"NavajoWhite3", /* #cdb38b, */ 205, 179, 139},
   {"NavajoWhite4", /* #8b795e, */ 139, 121, 94},
   {"NavyBlue", /* #000080, */ 0, 0, 128},
   {"OldLace", /* #fdf5e6, */ 253, 245, 230},
   {"OliveDrab", /* #6b8e23, */ 107, 142, 35},
   {"OliveDrab1", /* #c0ff3e, */ 192, 255, 62},
   {"OliveDrab2", /* #b3ee3a, */ 179, 238, 58},
   {"OliveDrab4", /* #698b22, */ 105, 139, 34},
   {"orange1", /* #ffa500, */ 255, 165, 0},
   {"orange2", /* #ee9a00, */ 238, 154, 0},
   {"orange3", /* #cd8500, */ 205, 133, 0},
   {"orange4", /* #8b5a00, */ 139, 90, 0},
   {"OrangeRed1", /* #ff4500, */ 255, 69, 0},
   {"OrangeRed2", /* #ee4000, */ 238, 64, 0},
   {"OrangeRed3", /* #cd3700, */ 205, 55, 0},
   {"OrangeRed4", /* #8b2500, */ 139, 37, 0},
   {"orchid", /* #da70d6, */ 218, 112, 214},
   {"orchid1", /* #ff83fa, */ 255, 131, 250},
   {"orchid2", /* #ee7ae9, */ 238, 122, 233},
   {"orchid3", /* #cd69c9, */ 205, 105, 201},
   {"orchid4", /* #8b4789, */ 139, 71, 137},
   {"pale", /* #db7093, */ 219, 112, 147},
   {"PaleGoldenrod", /* #eee8aa, */ 238, 232, 170},
   {"PaleGreen", /* #98fb98, */ 152, 251, 152},
   {"PaleGreen1", /* #9aff9a, */ 154, 255, 154},
   {"PaleGreen2", /* #90ee90, */ 144, 238, 144},
   {"PaleGreen3", /* #7ccd7c, */ 124, 205, 124},
   {"PaleGreen4", /* #548b54, */ 84, 139, 84},
   {"PaleTurquoise", /* #afeeee, */ 175, 238, 238},
   {"PaleTurquoise1", /* #bbffff, */ 187, 255, 255},
   {"PaleTurquoise2", /* #aeeeee, */ 174, 238, 238},
   {"PaleTurquoise3", /* #96cdcd, */ 150, 205, 205},
   {"PaleTurquoise4", /* #668b8b, */ 102, 139, 139},
   {"PaleVioletRed", /* #db7093, */ 219, 112, 147},
   {"PaleVioletRed1", /* #ff82ab, */ 255, 130, 171},
   {"PaleVioletRed2", /* #ee799f, */ 238, 121, 159},
   {"PaleVioletRed3", /* #cd6889, */ 205, 104, 137},
   {"PaleVioletRed4", /* #8b475d, */ 139, 71, 93},
   {"PapayaWhip", /* #ffefd5, */ 255, 239, 213},
   {"PeachPuff1", /* #ffdab9, */ 255, 218, 185},
   {"PeachPuff2", /* #eecbad, */ 238, 203, 173},
   {"PeachPuff3", /* #cdaf95, */ 205, 175, 149},
   {"PeachPuff4", /* #8b7765, */ 139, 119, 101},
   {"pink1", /* #ffb5c5, */ 255, 181, 197},
   {"pink2", /* #eea9b8, */ 238, 169, 184},
   {"pink3", /* #cd919e, */ 205, 145, 158},
   {"pink4", /* #8b636c, */ 139, 99, 108},
   {"plum", /* #dda0dd, */ 221, 160, 221},
   {"plum1", /* #ffbbff, */ 255, 187, 255},
   {"plum2", /* #eeaeee, */ 238, 174, 238},
   {"plum3", /* #cd96cd, */ 205, 150, 205},
   {"plum4", /* #8b668b, */ 139, 102, 139},
   {"PowderBlue", /* #b0e0e6, */ 176, 224, 230},
   {"purple1", /* #9b30ff, */ 155, 48, 255},
   {"purple2", /* #912cee, */ 145, 44, 238},
   {"purple3", /* #7d26cd, */ 125, 38, 205},
   {"purple4", /* #551a8b, */ 85, 26, 139},
   {"red1", /* #ff0000, */ 255, 0, 0},
   {"red2", /* #ee0000, */ 238, 0, 0},
   {"red3", /* #cd0000, */ 205, 0, 0},
   {"red4", /* #8b0000, */ 139, 0, 0},
   {"RosyBrown", /* #bc8f8f, */ 188, 143, 143},
   {"RosyBrown1", /* #ffc1c1, */ 255, 193, 193},
   {"RosyBrown2", /* #eeb4b4, */ 238, 180, 180},
   {"RosyBrown3", /* #cd9b9b, */ 205, 155, 155},
   {"RosyBrown4", /* #8b6969, */ 139, 105, 105},
   {"RoyalBlue", /* #4169e1, */ 65, 105, 225},
   {"RoyalBlue1", /* #4876ff, */ 72, 118, 255},
   {"RoyalBlue2", /* #436eee, */ 67, 110, 238},
   {"RoyalBlue3", /* #3a5fcd, */ 58, 95, 205},
   {"RoyalBlue4", /* #27408b, */ 39, 64, 139},
   {"SaddleBrown", /* #8b4513, */ 139, 69, 19},
   {"salmon", /* #fa8072, */ 250, 128, 114},
   {"salmon1", /* #ff8c69, */ 255, 140, 105},
   {"salmon2", /* #ee8262, */ 238, 130, 98},
   {"salmon3", /* #cd7054, */ 205, 112, 84},
   {"salmon4", /* #8b4c39, */ 139, 76, 57},
   {"SandyBrown", /* #f4a460, */ 244, 164, 96},
   {"SeaGreen1", /* #54ff9f, */ 84, 255, 159},
   {"SeaGreen2", /* #4eee94, */ 78, 238, 148},
   {"SeaGreen3", /* #43cd80, */ 67, 205, 128},
   {"SeaGreen4", /* #2e8b57, */ 46, 139, 87},
   {"seashell1", /* #fff5ee, */ 255, 245, 238},
   {"seashell2", /* #eee5de, */ 238, 229, 222},
   {"seashell3", /* #cdc5bf, */ 205, 197, 191},
   {"seashell4", /* #8b8682, */ 139, 134, 130},
   {"sienna", /* #a0522d, */ 160, 82, 45},
   {"sienna1", /* #ff8247, */ 255, 130, 71},
   {"sienna2", /* #ee7942, */ 238, 121, 66},
   {"sienna3", /* #cd6839, */ 205, 104, 57},
   {"sienna4", /* #8b4726, */ 139, 71, 38},
   {"SkyBlue", /* #87ceeb, */ 135, 206, 235},
   {"SkyBlue1", /* #87ceff, */ 135, 206, 255},
   {"SkyBlue2", /* #7ec0ee, */ 126, 192, 238},
   {"SkyBlue3", /* #6ca6cd, */ 108, 166, 205},
   {"SkyBlue4", /* #4a708b, */ 74, 112, 139},
   {"SlateBlue", /* #6a5acd, */ 106, 90, 205},
   {"SlateBlue1", /* #836fff, */ 131, 111, 255},
   {"SlateBlue2", /* #7a67ee, */ 122, 103, 238},
   {"SlateBlue3", /* #6959cd, */ 105, 89, 205},
   {"SlateBlue4", /* #473c8b, */ 71, 60, 139},
   {"SlateGray", /* #708090, */ 112, 128, 144},
   {"SlateGray1", /* #c6e2ff, */ 198, 226, 255},
   {"SlateGray2", /* #b9d3ee, */ 185, 211, 238},
   {"SlateGray3", /* #9fb6cd, */ 159, 182, 205},
   {"SlateGray4", /* #6c7b8b, */ 108, 123, 139},
   {"snow1", /* #fffafa, */ 255, 250, 250},
   {"snow2", /* #eee9e9, */ 238, 233, 233},
   {"snow3", /* #cdc9c9, */ 205, 201, 201},
   {"snow4", /* #8b8989, */ 139, 137, 137},
   {"SpringGreen1", /* #00ff7f, */ 0, 255, 127},
   {"SpringGreen2", /* #00ee76, */ 0, 238, 118},
   {"SpringGreen3", /* #00cd66, */ 0, 205, 102},
   {"SpringGreen4", /* #008b45, */ 0, 139, 69},
   {"SteelBlue", /* #4682b4, */ 70, 130, 180},
   {"SteelBlue1", /* #63b8ff, */ 99, 184, 255},
   {"SteelBlue2", /* #5cacee, */ 92, 172, 238},
   {"SteelBlue3", /* #4f94cd, */ 79, 148, 205},
   {"SteelBlue4", /* #36648b, */ 54, 100, 139},
   {"tan", /* #d2b48c, */ 210, 180, 140},
   {"tan1", /* #ffa54f, */ 255, 165, 79},
   {"tan2", /* #ee9a49, */ 238, 154, 73},
   {"tan3", /* #cd853f, */ 205, 133, 63},
   {"tan4", /* #8b5a2b, */ 139, 90, 43},
   {"thistle", /* #d8bfd8, */ 216, 191, 216},
   {"thistle1", /* #ffe1ff, */ 255, 225, 255},
   {"thistle2", /* #eed2ee, */ 238, 210, 238},
   {"thistle3", /* #cdb5cd, */ 205, 181, 205},
   {"thistle4", /* #8b7b8b, */ 139, 123, 139},
   {"tomato1", /* #ff6347, */ 255, 99, 71},
   {"tomato2", /* #ee5c42, */ 238, 92, 66},
   {"tomato3", /* #cd4f39, */ 205, 79, 57},
   {"tomato4", /* #8b3626, */ 139, 54, 38},
   {"turquoise1", /* #00f5ff, */ 0, 245, 255},
   {"turquoise2", /* #00e5ee, */ 0, 229, 238},
   {"turquoise3", /* #00c5cd, */ 0, 197, 205},
   {"turquoise4", /* #00868b, */ 0, 134, 139},
   {"VioletRed", /* #d02090, */ 208, 32, 144},
   {"VioletRed1", /* #ff3e96, */ 255, 62, 150},
   {"VioletRed2", /* #ee3a8c, */ 238, 58, 140},
   {"VioletRed3", /* #cd3278, */ 205, 50, 120},
   {"VioletRed4", /* #8b2252, */ 139, 34, 82},
   {"wheat", /* #f5deb3, */ 245, 222, 179},
   {"wheat1", /* #ffe7ba, */ 255, 231, 186},
   {"wheat2", /* #eed8ae, */ 238, 216, 174},
   {"wheat3", /* #cdba96, */ 205, 186, 150},
   {"wheat4", /* #8b7e66, */ 139, 126, 102},
   {"WhiteSmoke", /* #f5f5f5, */ 245, 245, 245},
   {"yellow1", /* #ffff00, */ 255, 255, 0},
   {"yellow2", /* #eeee00, */ 238, 238, 0},
   {"yellow3", /* #cdcd00, */ 205, 205, 0},
   {"yellow4", /* #8b8b00, */ 139, 139, 0},
   {"YellowGreen", /* #9acd32, */ 154, 205, 50}
#  endif /* defined (_I18N_) || defined (__JIS__) */
};

#define NBCOLORNAME (sizeof(ColornameTable)/sizeof(ColornameTable[0]))
