.TH  SROTMG 1 "February 2007" "BLAS routine" "BLAS routine" 
.SH NAME
SROTMG - THE MODIFIED GIVENS TRANSFORMATION MATRIX H WHICH ZEROS  THE SECOND COMPONENT OF THE 2-VECTOR (SQRT(SD1)*SX1,SQRT(SD2)*
.SH SYNOPSIS
.TP 42
SUBROUTINE SROTMG(SD1,SD2,SX1,SY1,SPARAM)
.TP 42
.ti +4
REAL
SD1,SD2,SX1,SY1
.TP 42
.ti +4
REAL
SPARAM(5)
.SH PURPOSE
   CONSTRUCT THE MODIFIED GIVENS TRANSFORMATION MATRIX H WHICH ZEROS
   THE SECOND COMPONENT OF THE 2-VECTOR  (SQRT(SD1)*SX1,SQRT(SD2)*
   SY2)**T.
.br
   WITH SPARAM(1)=SFLAG, H HAS ONE OF THE FOLLOWING FORMS..

   SFLAG=-1.E0     SFLAG=0.E0        SFLAG=1.E0     SFLAG=-2.E0

     (SH11  SH12)    (1.E0  SH12)    (SH11  1.E0)    (1.E0  0.E0)
   H=(          )    (          )    (          )    (          )
     (SH21  SH22),   (SH21  1.E0),   (-1.E0 SH22),   (0.E0  1.E0).
   LOCATIONS 2-4 OF SPARAM CONTAIN SH11,SH21,SH12, AND SH22
   RESPECTIVELY. (VALUES OF 1.E0, -1.E0, OR 0.E0 IMPLIED BY THE
   VALUE OF SPARAM(1) ARE NOT STORED IN SPARAM.)
.br

   THE VALUES OF GAMSQ AND RGAMSQ SET IN THE DATA STATEMENT MAY BE
   INEXACT.  THIS IS OK AS THEY ARE ONLY USED FOR TESTING THE SIZE
   OF SD1 AND SD2.  ALL ACTUAL SCALING OF DATA IS DONE USING GAM.


.SH ARGUMENTS
.TP 7
SD1    (input/output) REAL
.TP 7
SD2    (input/output) REAL
.TP 7
SX1    (input/output) REAL
.TP 7
SY1    (input) REAL

SPARAM (input/output)  REAL array, dimension 5
SPARAM(1)=SFLAG
SPARAM(2)=SH11
SPARAM(3)=SH21
SPARAM(4)=SH12
SPARAM(5)=SH22
