/* valaforeachstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaforeachstatement.h>
#include <vala/valaexpression.h>
#include <vala/valalocalvariable.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaForeachStatementPrivate {
	char* _variable_name;
	ValaLocalVariable* _element_variable;
	ValaLocalVariable* _collection_variable;
	ValaLocalVariable* _iterator_variable;
	ValaExpression* _collection;
	ValaBlock* _body;
	ValaDataType* _data_type;
};

#define VALA_FOREACH_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementPrivate))
enum  {
	VALA_FOREACH_STATEMENT_DUMMY_PROPERTY
};
static void vala_foreach_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_foreach_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_foreach_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static void vala_foreach_statement_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gpointer vala_foreach_statement_parent_class = NULL;
static void vala_foreach_statement_finalize (ValaCodeNode* obj);



/**
 * Creates a new foreach statement.
 *
 * @param type   element type
 * @param id     element variable name
 * @param col    loop body
 * @param source reference to source code
 * @return       newly created foreach statement
 */
ValaForeachStatement* vala_foreach_statement_construct (GType object_type, ValaDataType* type_reference, const char* variable_name, ValaExpression* collection, ValaBlock* body, ValaSourceReference* source_reference) {
	ValaForeachStatement* self;
	g_return_val_if_fail (variable_name != NULL, NULL);
	g_return_val_if_fail (collection != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = ((ValaForeachStatement*) (g_type_create_instance (object_type)));
	self = ((ValaForeachStatement*) (vala_block_construct (object_type, source_reference)));
	vala_foreach_statement_set_variable_name (self, variable_name);
	vala_foreach_statement_set_collection (self, collection);
	vala_foreach_statement_set_body (self, body);
	vala_foreach_statement_set_type_reference (self, type_reference);
	return self;
}


ValaForeachStatement* vala_foreach_statement_new (ValaDataType* type_reference, const char* variable_name, ValaExpression* collection, ValaBlock* body, ValaSourceReference* source_reference) {
	return vala_foreach_statement_construct (VALA_TYPE_FOREACH_STATEMENT, type_reference, variable_name, collection, body, source_reference);
}


static void vala_foreach_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaForeachStatement * self;
	self = ((ValaForeachStatement*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_foreach_statement (visitor, self);
}


static void vala_foreach_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaForeachStatement * self;
	self = ((ValaForeachStatement*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept (((ValaCodeNode*) (vala_foreach_statement_get_collection (self))), visitor);
	vala_code_visitor_visit_end_full_expression (visitor, vala_foreach_statement_get_collection (self));
	if (vala_foreach_statement_get_type_reference (self) != NULL) {
		vala_code_node_accept (((ValaCodeNode*) (vala_foreach_statement_get_type_reference (self))), visitor);
	}
	vala_code_node_accept (((ValaCodeNode*) (vala_foreach_statement_get_body (self))), visitor);
}


static void vala_foreach_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaForeachStatement * self;
	self = ((ValaForeachStatement*) (base));
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (vala_foreach_statement_get_collection (self) == old_node) {
		vala_foreach_statement_set_collection (self, new_node);
	}
}


static void vala_foreach_statement_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaForeachStatement * self;
	self = ((ValaForeachStatement*) (base));
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_foreach_statement_get_type_reference (self) == old_type) {
		vala_foreach_statement_set_type_reference (self, new_type);
	}
}


ValaDataType* vala_foreach_statement_get_type_reference (ValaForeachStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_data_type;
}


void vala_foreach_statement_set_type_reference (ValaForeachStatement* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_data_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_data_type == NULL ? NULL : (self->priv->_data_type = (vala_code_node_unref (self->priv->_data_type), NULL))), _tmp2);
	if (self->priv->_data_type != NULL) {
		vala_code_node_set_parent_node (((ValaCodeNode*) (self->priv->_data_type)), ((ValaCodeNode*) (self)));
	}
}


const char* vala_foreach_statement_get_variable_name (ValaForeachStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_variable_name;
}


void vala_foreach_statement_set_variable_name (ValaForeachStatement* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_variable_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_variable_name = (g_free (self->priv->_variable_name), NULL)), _tmp2);
}


ValaExpression* vala_foreach_statement_get_collection (ValaForeachStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_collection;
}


void vala_foreach_statement_set_collection (ValaForeachStatement* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_collection = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_collection == NULL ? NULL : (self->priv->_collection = (vala_code_node_unref (self->priv->_collection), NULL))), _tmp2);
	vala_code_node_set_parent_node (((ValaCodeNode*) (self->priv->_collection)), ((ValaCodeNode*) (self)));
}


ValaBlock* vala_foreach_statement_get_body (ValaForeachStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_body;
}


void vala_foreach_statement_set_body (ValaForeachStatement* self, ValaBlock* value) {
	ValaBlock* _tmp2;
	ValaBlock* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_body = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (vala_code_node_unref (self->priv->_body), NULL))), _tmp2);
	vala_code_node_set_parent_node (((ValaCodeNode*) (self->priv->_body)), ((ValaCodeNode*) (self)));
}


ValaLocalVariable* vala_foreach_statement_get_element_variable (ValaForeachStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_element_variable;
}


void vala_foreach_statement_set_element_variable (ValaForeachStatement* self, ValaLocalVariable* value) {
	ValaLocalVariable* _tmp2;
	ValaLocalVariable* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_element_variable = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_element_variable == NULL ? NULL : (self->priv->_element_variable = (vala_code_node_unref (self->priv->_element_variable), NULL))), _tmp2);
}


ValaLocalVariable* vala_foreach_statement_get_collection_variable (ValaForeachStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_collection_variable;
}


void vala_foreach_statement_set_collection_variable (ValaForeachStatement* self, ValaLocalVariable* value) {
	ValaLocalVariable* _tmp2;
	ValaLocalVariable* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_collection_variable = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_collection_variable == NULL ? NULL : (self->priv->_collection_variable = (vala_code_node_unref (self->priv->_collection_variable), NULL))), _tmp2);
}


ValaLocalVariable* vala_foreach_statement_get_iterator_variable (ValaForeachStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_iterator_variable;
}


void vala_foreach_statement_set_iterator_variable (ValaForeachStatement* self, ValaLocalVariable* value) {
	ValaLocalVariable* _tmp2;
	ValaLocalVariable* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_iterator_variable = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_iterator_variable == NULL ? NULL : (self->priv->_iterator_variable = (vala_code_node_unref (self->priv->_iterator_variable), NULL))), _tmp2);
}


static void vala_foreach_statement_class_init (ValaForeachStatementClass * klass) {
	vala_foreach_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_foreach_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaForeachStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_foreach_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_foreach_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_foreach_statement_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_foreach_statement_real_replace_type;
}


static void vala_foreach_statement_instance_init (ValaForeachStatement * self) {
	self->priv = VALA_FOREACH_STATEMENT_GET_PRIVATE (self);
}


static void vala_foreach_statement_finalize (ValaCodeNode* obj) {
	ValaForeachStatement * self;
	self = VALA_FOREACH_STATEMENT (obj);
	self->priv->_variable_name = (g_free (self->priv->_variable_name), NULL);
	(self->priv->_element_variable == NULL ? NULL : (self->priv->_element_variable = (vala_code_node_unref (self->priv->_element_variable), NULL)));
	(self->priv->_collection_variable == NULL ? NULL : (self->priv->_collection_variable = (vala_code_node_unref (self->priv->_collection_variable), NULL)));
	(self->priv->_iterator_variable == NULL ? NULL : (self->priv->_iterator_variable = (vala_code_node_unref (self->priv->_iterator_variable), NULL)));
	(self->priv->_collection == NULL ? NULL : (self->priv->_collection = (vala_code_node_unref (self->priv->_collection), NULL)));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (vala_code_node_unref (self->priv->_body), NULL)));
	(self->priv->_data_type == NULL ? NULL : (self->priv->_data_type = (vala_code_node_unref (self->priv->_data_type), NULL)));
	VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->finalize (obj);
}


GType vala_foreach_statement_get_type (void) {
	static GType vala_foreach_statement_type_id = 0;
	if (vala_foreach_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaForeachStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_foreach_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForeachStatement), 0, (GInstanceInitFunc) vala_foreach_statement_instance_init, NULL };
		vala_foreach_statement_type_id = g_type_register_static (VALA_TYPE_BLOCK, "ValaForeachStatement", &g_define_type_info, 0);
	}
	return vala_foreach_statement_type_id;
}




