/* 
 * AppController.m created by phr on 2000-08-27 11:38:58 +0000
 *
 * Project TestApp
 *
 * Created with ProjectCenter - http://www.gnustep.org
 *
 * $Id: AppController.m,v 1.10 2003/06/29 17:28:34 probert Exp $
 */

#include "AppController.h"
#include "ImageWindow.h"
#include "ImagesWindow.h"
#include "Inspector.h"
#include "PrefController.h"

@implementation AppController

static NSDictionary *infoDict = nil;

+ (void)initialize
{
  NSMutableDictionary *defaults = [NSMutableDictionary dictionary];

  /*
   * Register your app's defaults here by adding objects to the
   * dictionary, eg
   *
   * [defaults setObject:anObject forKey:keyForThatObject];
   *
   */
  
  [[NSUserDefaults standardUserDefaults] registerDefaults:defaults];
  [[NSUserDefaults standardUserDefaults] synchronize];
}

- (id)init
{
  if ((self = [super init])) {
    images = [[NSMutableArray alloc] init];
  }
  return self;
}

- (void)dealloc
{
  RELEASE(images);

  [super dealloc];
}

- (void)applicationDidFinishLaunching:(NSNotification *)notif
{
}

- (BOOL)applicationShouldTerminate:(id)sender
{
  if (NSRunAlertPanel(_(@"Quit!"),
                      _(@"Do you really want to quit?"),
                      _(@"No"),
                      _(@"Yes"),
                      nil)) {
    return NO;
  }

  return YES;
}


- (void)applicationWillTerminate:(NSNotification *)notification
{
  [[NSUserDefaults standardUserDefaults] synchronize];
}

- (BOOL)application:(NSApplication *)application openFile:(NSString *)fileName
{
  //  [[NSApplication sharedApplication] activateIgnoringOtherApps: NO];
  return [self openImageAtPath:fileName]; 
}

- (void)showPrefPanel:(id)sender
{
    if( preferences == nil ) {
        preferences = [[PrefController alloc] init];
    }

    [preferences show];
}

- (void)showInfoPanel:(id)sender
{
  [[NSApplication sharedApplication] orderFrontStandardInfoPanel:sender];
}

- (void)showInspector:(id)sender
{
    if( inspector == nil ) {
        inspector = [Inspector sharedInspector];
    }

    [inspector show];
}

- (BOOL)openImageAtPath:(NSString *)path
{
  ImageWindow *win = [[ImageWindow alloc] initWithContentsOfFile:path];

  if (win) {
    [win setDelegate:self];
    [images addObject:win];
    return YES;
  }
  return NO;
}

- (void)openImage:(id)sender
{
  int result;  
  NSArray     *fileTypes = [NSImage imageFileTypes];
  NSOpenPanel *openPanel = [NSOpenPanel openPanel];
  NSString    *pth = [[NSUserDefaults standardUserDefaults] objectForKey:@"OpenDir"];

  [openPanel setAllowsMultipleSelection:YES];
  result = [openPanel runModalForDirectory:pth file:nil types:fileTypes];

  if (result == NSOKButton) 
  {
    NSArray *files = [openPanel filenames];
    int i;
    int count = [files count];
    NSString *_pth = [openPanel directory];

    [[NSUserDefaults standardUserDefaults] setObject:_pth forKey:@"OpenDir"];

    for (i=0; i<count; i++) 
    {
      NSString *imageFile = [files objectAtIndex:i];      
      if (![self openImageAtPath:imageFile]) 
      {
	NSRunAlertPanel(@"Error when opening file", 
			@"Couldn't open %@", 
                        @"OK", 
                        nil, 
                        nil,
                        imageFile);
      }
    }
  }  
}

- (BOOL)openImagesAtPath:(NSString *)path
{
  ImagesWindow *win = [[ImagesWindow alloc] initWithContentsAtPath:path];

  if (win) 
  {
    [win setDelegate:self];
    [images addObject:win];

    return YES;
  }

  return NO;
}

- (void)openImages:(id)sender
{
  int result;  
  NSOpenPanel    *openPanel = [NSOpenPanel openPanel];
  NSUserDefaults *defs = [NSUserDefaults standardUserDefaults];
  NSString       *pth = [defs objectForKey:@"OpenDir"];

  [openPanel setCanChooseDirectories:YES];
  [openPanel setCanChooseFiles:NO];
  [openPanel setAllowsMultipleSelection:NO];

  result = [openPanel runModalForDirectory:pth file:nil types:nil];

  if (result == NSOKButton) 
  {
    NSArray *files = [openPanel filenames];
    int i;
    int count = [files count];
    NSString *_pth = [openPanel directory];

    [defs setObject:_pth forKey:@"OpenDir"];

    if (count == 1) 
    {
      NSString *dir = [files objectAtIndex:0];      

      if (![self openImagesAtPath:dir]) 
      {
        NSRunAlertPanel(@"Error when opening files", 
                        @"Couldn't open directory %@", 
                        @"OK", 
                        nil, 
                        nil,
                        dir);
      }
    }
  }  
}

- (void)imageWindowWillClose:(id)sender
{
  if (sender) 
  {
    [images removeObject:sender];
    AUTORELEASE(sender);
  }
}

- (void)servicesOpenFileOrDirectory:(NSPasteboard *)pb     
                           userData:(NSString *)ud 
                              error:(NSString **)msg
{
  // TODO : be able to deal with a real property list
  // i.e. to deal with the different the property lists types :
  // - a string
  // - an array of string (this is what we do at this time)
  // (what to do with dictionary or data ?)

  NSString *s;
  id        fileNamesPl;
  int       i, count;
  
  fileNamesPl = [pb propertyListForType:NSFilenamesPboardType];
  
  if ([fileNamesPl respondsToSelector: @selector(count)] == NO)
  {
    // we only deal with NSArray
    // we cannot do a test on the class because the class
    // is NSDistantObject
    return;
  }
  
  count = [fileNamesPl count];
  
  for(i = 0; i < count; i++) 
  {
    BOOL isDir;
    NSFileManager *manager = [NSFileManager defaultManager];
    
    if ([manager fileExistsAtPath:[fileNamesPl objectAtIndex: i] 
                      isDirectory:&isDir] && isDir) 
    {
      [self openImagesAtPath: [fileNamesPl objectAtIndex: i]];
    }
  }
}

- (void)setDefaultSize:(id)sender
{
  NSWindow *mainWindow = [[NSApplication sharedApplication] mainWindow];
  
  if (mainWindow /* [mainWindow isKindOfClass: [ImagesWindow class]] */ ) 
  {
    [mainWindow saveFrameUsingName:@"default ImagesWindow"];
  }
}


@end
