/* options.c: options dialog boxes
   Copyright (c) 2001-2004 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Author contact information:

   E-mail: philip-fuse@shadowmagic.org.uk

*/

/* This file is autogenerated from options.dat by options.pl.
   Do not edit unless you know what you're doing! */

#include <config.h>

#ifdef USE_WIDGET

#include <stdio.h>
#include <string.h>

#include "display.h"
#include "fuse.h"
#include "options.h"
#include "periph.h"
#include "widget_internals.h"
#include "ui/uidisplay.h"

struct widget_option_entry;

/* A generic click function */
typedef void (*widget_option_click_fn)( void );
typedef void (*widget_option_draw_fn)( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );

/* A general menu */
typedef struct widget_option_entry {
  const char *text;
  int index;
  input_key key;		/* Which key to activate this option */
  const char *suffix;

  widget_option_click_fn click;
  widget_option_draw_fn draw;
} widget_option_entry;

static void widget_emulation_speed_click( void );
static void widget_option_emulation_speed_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_frame_rate_click( void );
static void widget_option_frame_rate_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_issue2_click( void );
static void widget_option_issue2_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_tape_traps_click( void );
static void widget_option_tape_traps_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_fastload_click( void );
static void widget_option_fastload_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_detect_loader_click( void );
static void widget_option_detect_loader_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_accelerate_loader_click( void );
static void widget_option_accelerate_loader_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_auto_load_click( void );
static void widget_option_auto_load_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_slt_traps_click( void );
static void widget_option_slt_traps_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_writable_roms_click( void );
static void widget_option_writable_roms_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_autosave_settings_click( void );
static void widget_option_autosave_settings_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_mdr_len_click( void );
static void widget_option_mdr_len_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_mdr_random_len_click( void );
static void widget_option_mdr_random_len_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_rs232_handshake_click( void );
static void widget_option_rs232_handshake_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_bw_tv_click( void );
static void widget_option_bw_tv_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_pal_tv2x_click( void );
static void widget_option_pal_tv2x_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_confirm_actions_click( void );
static void widget_option_confirm_actions_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_statusbar_click( void );
static void widget_option_statusbar_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_joy_prompt_click( void );
static void widget_option_joy_prompt_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_late_timings_click( void );
static void widget_option_late_timings_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_joy_kempston_click( void );
static void widget_option_joy_kempston_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_kempston_mouse_click( void );
static void widget_option_kempston_mouse_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_interface1_click( void );
static void widget_option_interface1_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_interface2_click( void );
static void widget_option_interface2_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_printer_click( void );
static void widget_option_printer_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_simpleide_active_click( void );
static void widget_option_simpleide_active_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_zxatasp_active_click( void );
static void widget_option_zxatasp_active_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_zxatasp_upload_click( void );
static void widget_option_zxatasp_upload_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_zxatasp_wp_click( void );
static void widget_option_zxatasp_wp_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_zxcf_active_click( void );
static void widget_option_zxcf_active_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_zxcf_upload_click( void );
static void widget_option_zxcf_upload_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_divide_enabled_click( void );
static void widget_option_divide_enabled_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_divide_wp_click( void );
static void widget_option_divide_wp_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_plusd_click( void );
static void widget_option_plusd_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_beta128_click( void );
static void widget_option_beta128_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_rzx_autosaves_click( void );
static void widget_option_rzx_autosaves_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_rzx_compression_click( void );
static void widget_option_rzx_compression_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_competition_mode_click( void );
static void widget_option_competition_mode_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_competition_code_click( void );
static void widget_option_competition_code_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_embed_snapshot_click( void );
static void widget_option_embed_snapshot_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_sound_click( void );
static void widget_option_sound_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_sound_load_click( void );
static void widget_option_sound_load_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_stereo_ay_click( void );
static void widget_option_stereo_ay_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_stereo_beeper_click( void );
static void widget_option_stereo_beeper_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_sound_force_8bit_click( void );
static void widget_option_sound_force_8bit_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );
static void widget_sound_hifi_click( void );
static void widget_option_sound_hifi_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show );

static widget_option_entry options_general[] = {
  { "General Options" },
  { "\012E\001mulation speed", 0, INPUT_KEY_e, "%", widget_emulation_speed_click, widget_option_emulation_speed_draw },
  { "F\012r\001ame rate (1:n)", 1, INPUT_KEY_r, "frames", widget_frame_rate_click, widget_option_frame_rate_draw },
  { "Issue \0122\001 keyboard", 2, INPUT_KEY_2, NULL, widget_issue2_click, widget_option_issue2_draw },
  { "Use \012t\001ape traps", 3, INPUT_KEY_t, NULL, widget_tape_traps_click, widget_option_tape_traps_draw },
  { "\012F\001astloading", 4, INPUT_KEY_f, NULL, widget_fastload_click, widget_option_fastload_draw },
  { "\012D\001etect loaders", 5, INPUT_KEY_d, NULL, widget_detect_loader_click, widget_option_detect_loader_draw },
  { "Accelerate l\012o\001aders", 6, INPUT_KEY_o, NULL, widget_accelerate_loader_click, widget_option_accelerate_loader_draw },
  { "\012A\001uto-load media", 7, INPUT_KEY_a, NULL, widget_auto_load_click, widget_option_auto_load_draw },
  { "Use .s\012l\001t traps", 8, INPUT_KEY_l, NULL, widget_slt_traps_click, widget_option_slt_traps_draw },
  { "Allow \012w\001rites to ROM", 9, INPUT_KEY_w, NULL, widget_writable_roms_click, widget_option_writable_roms_draw },
  { "A\012u\001to-save settings", 10, INPUT_KEY_u, NULL, widget_autosave_settings_click, widget_option_autosave_settings_draw },
  { "\012M\001DR cartridge len", 11, INPUT_KEY_m, "blocks", widget_mdr_len_click, widget_option_mdr_len_draw },
  { "Random len\012g\001th MDR cartridge", 12, INPUT_KEY_g, NULL, widget_mdr_random_len_click, widget_option_mdr_random_len_draw },
  { "RS-232 \012h\001andshake", 13, INPUT_KEY_h, NULL, widget_rs232_handshake_click, widget_option_rs232_handshake_draw },
  { "Black and white T\012V\001", 14, INPUT_KEY_v, NULL, widget_bw_tv_click, widget_option_bw_tv_draw },
  { "\012P\001AL-TV use TV2x effect", 15, INPUT_KEY_p, NULL, widget_pal_tv2x_click, widget_option_pal_tv2x_draw },
  { "\012C\001onfirm actions", 16, INPUT_KEY_c, NULL, widget_confirm_actions_click, widget_option_confirm_actions_draw },
  { "Show status\012b\001ar", 17, INPUT_KEY_b, NULL, widget_statusbar_click, widget_option_statusbar_draw },
  { "Snap \012j\001oystick prompt", 18, INPUT_KEY_j, NULL, widget_joy_prompt_click, widget_option_joy_prompt_draw },
  { "Late t\012i\001mings", 19, INPUT_KEY_i, NULL, widget_late_timings_click, widget_option_late_timings_draw },
  { NULL }
};

static widget_option_entry options_peripherals[] = {
  { "Peripheral Options" },
  { "\012K\001empston joystick", 0, INPUT_KEY_k, NULL, widget_joy_kempston_click, widget_option_joy_kempston_draw },
  { "Kempston \012m\001ouse", 1, INPUT_KEY_m, NULL, widget_kempston_mouse_click, widget_option_kempston_mouse_draw },
  { "Inter\012f\001ace I", 2, INPUT_KEY_f, NULL, widget_interface1_click, widget_option_interface1_draw },
  { "\012I\001nterface II", 3, INPUT_KEY_i, NULL, widget_interface2_click, widget_option_interface2_draw },
  { "Emulate \012p\001rinters", 4, INPUT_KEY_p, NULL, widget_printer_click, widget_option_printer_draw },
  { "Simple \0128\001-bit IDE", 5, INPUT_KEY_8, NULL, widget_simpleide_active_click, widget_option_simpleide_active_draw },
  { "\012Z\001XATASP interface", 6, INPUT_KEY_z, NULL, widget_zxatasp_active_click, widget_option_zxatasp_active_draw },
  { "ZXATASP \012u\001pload", 7, INPUT_KEY_u, NULL, widget_zxatasp_upload_click, widget_option_zxatasp_upload_draw },
  { "ZXATASP \012w\001rite protect", 8, INPUT_KEY_w, NULL, widget_zxatasp_wp_click, widget_option_zxatasp_wp_draw },
  { "ZX\012C\001F interface", 9, INPUT_KEY_c, NULL, widget_zxcf_active_click, widget_option_zxcf_active_draw },
  { "ZXCF up\012l\001oad", 10, INPUT_KEY_l, NULL, widget_zxcf_upload_click, widget_option_zxcf_upload_draw },
  { "\012D\001ivIDE interface", 11, INPUT_KEY_d, NULL, widget_divide_enabled_click, widget_option_divide_enabled_draw },
  { "DivIDE w\012r\001ite protect", 12, INPUT_KEY_r, NULL, widget_divide_wp_click, widget_option_divide_wp_draw },
  { "+D i\012n\001terface", 13, INPUT_KEY_n, NULL, widget_plusd_click, widget_option_plusd_draw },
  { "\012B\001eta 128 interface", 14, INPUT_KEY_b, NULL, widget_beta128_click, widget_option_beta128_draw },
  { NULL }
};

static widget_option_entry options_rzx[] = {
  { "RZX Options" },
  { "Create \012a\001utosaves", 0, INPUT_KEY_a, NULL, widget_rzx_autosaves_click, widget_option_rzx_autosaves_draw },
  { "\012C\001ompress RZX data", 1, INPUT_KEY_c, NULL, widget_rzx_compression_click, widget_option_rzx_compression_draw },
  { "C\012o\001mpetition mode", 2, INPUT_KEY_o, NULL, widget_competition_mode_click, widget_option_competition_mode_draw },
  { "Co\012m\001petition code", 3, INPUT_KEY_m, "", widget_competition_code_click, widget_option_competition_code_draw },
  { "Always \012e\001mbed snapshot", 4, INPUT_KEY_e, NULL, widget_embed_snapshot_click, widget_option_embed_snapshot_draw },
  { NULL }
};

static widget_option_entry options_sound[] = {
  { "Sound Options" },
  { "\012S\001ound enabled", 0, INPUT_KEY_s, NULL, widget_sound_click, widget_option_sound_draw },
  { "\012L\001oading sound", 1, INPUT_KEY_l, NULL, widget_sound_load_click, widget_option_sound_load_draw },
  { "\012A\001Y stereo separation", 2, INPUT_KEY_a, NULL, widget_stereo_ay_click, widget_option_stereo_ay_draw },
  { "\012B\001eeper pseudo-stereo", 3, INPUT_KEY_b, NULL, widget_stereo_beeper_click, widget_option_stereo_beeper_draw },
  { "\012F\001orce 8-bit", 4, INPUT_KEY_f, NULL, widget_sound_force_8bit_click, widget_option_sound_force_8bit_draw },
  { "\012H\001i-fi beeper", 5, INPUT_KEY_h, NULL, widget_sound_hifi_click, widget_option_sound_hifi_draw },
  { NULL }
};

static size_t highlight_line = 0;

/* General functions used by the options dialogs */
settings_info widget_options_settings;
int widget_options_print_option( int left_edge, int width, int number, const char* string, int value );
int widget_options_print_value( int left_edge, int width, int number, int value );
int widget_options_print_entry( int left_edge, int width, int number, const char *prefix, int value,
				const char *suffix );

static int widget_options_print_label( int left_edge, int width, int number, const char *string );
static int widget_options_print_data( int left_edge, int menu_width, int number, const char *string );
static int widget_calculate_option_width(widget_option_entry *menu);

static int
widget_options_show_all( widget_option_entry *options, settings_info *show )
{
  widget_option_entry *ptr;
  size_t height = 0;
  int menu_width = widget_calculate_option_width( options );
  int menu_left_edge_x;

  /* How many options do we have? */
  for( ptr = &options[1]; ptr->text; ptr++ )
    height ++;

  menu_left_edge_x = DISPLAY_WIDTH_COLS/2-menu_width/2;

  /* Draw the dialog box */
  widget_dialog_with_border( menu_left_edge_x, 2, menu_width, 2 + height );

  widget_printstring( menu_left_edge_x*8+2, 16, WIDGET_COLOUR_TITLE, options->text );

  for( ptr = &options[1]; ptr->text; ptr++ ) {
    ptr->draw( menu_left_edge_x, menu_width, ptr, show );
  }

  widget_display_lines( 2, 2 + height );

  return 0;
}

int
widget_options_print_option( int left_edge, int width, int number, const char* string, int value )
{
  widget_options_print_label( left_edge, width, number, string );
  widget_options_print_value( left_edge, width, number, value );
  return 0;
}

static int
widget_options_print_label( int left_edge, int width, int number, const char *string )
{
  char buffer[128];
  size_t l, w;
  int colour = WIDGET_COLOUR_BACKGROUND;

  if( number == highlight_line ) colour = WIDGET_COLOUR_HIGHLIGHT;
  widget_rectangle( left_edge*8+1, number*8+24, width*8-2, 1*8, colour );

  snprintf( buffer, sizeof( buffer ), "%s", string );
  l = strlen( buffer );

  if( l >= sizeof( buffer ) )
    l = sizeof( buffer ) - 1;
  while( ( w = widget_substringwidth( string, l ) ) >= (left_edge+width-2)*8 )
    --l;
  buffer[l] = '\0';
  w = widget_printstring( left_edge*8+8, number*8+24, WIDGET_COLOUR_FOREGROUND, buffer )
      - 1;
  while ((w += 3) < (left_edge+width-1)*8-2)
    widget_putpixel (w, number*8+31, 0);
  return 0;
}

int
widget_options_print_value( int left_edge, int width, int number, int value )
{
  int colour = WIDGET_COLOUR_BACKGROUND;
  int x = (left_edge+width-2)*8-2;
  int y = number * 8 + 24;

  if( number == highlight_line ) colour = WIDGET_COLOUR_HIGHLIGHT;
  widget_rectangle( x, y, 8, 8, colour );
  widget_print_checkbox( x, y, colour, value );
  widget_display_rasters( y, 8 );
  return 0;
}

static int
widget_options_print_data( int left_edge, int menu_width, int number, const char *string )
{
  int colour = WIDGET_COLOUR_BACKGROUND;
  size_t width = widget_stringwidth( string );
  int x = (left_edge + menu_width-1)*8 - width - 2;
  int y = number * 8 + 24;

  if( number == highlight_line ) colour = WIDGET_COLOUR_HIGHLIGHT;
  widget_rectangle( x, y, width, 8, colour );
  widget_printstring( x, y, WIDGET_COLOUR_FOREGROUND, string );
  widget_display_rasters( y, 8 );

  return 0;
}

int
widget_options_print_entry( int left_edge, int width, int number, const char *prefix, int value,
			    const char *suffix )
{
  char buffer[128];
  widget_options_print_label( left_edge, width, number, prefix );
  snprintf( buffer, sizeof( buffer ), "%d %s", value, suffix );
  return widget_options_print_data( left_edge, width, number, buffer );
}

int
widget_options_finish( widget_finish_state finished )
{
  int error;

  /* If we exited normally, actually set the options */
  if( finished == WIDGET_FINISHED_OK ) {
    error = settings_copy( &settings_current, &widget_options_settings );
    settings_free( &widget_options_settings );
    memset( &widget_options_settings, 0, sizeof( settings_info ) );
    if( error ) return error;

    /* Bring the peripherals list into sync with the new options */
    periph_update();
    /* make the needed UI changes */
    uidisplay_hotswap_gfx_mode();
  }

  return 0;
}

const int options_vert_external_margin = 8;

static int
widget_calculate_option_width(widget_option_entry *menu)
{
  widget_option_entry *ptr;
  int max_width=0;

  if (!menu) {
    return 64;
  }

  max_width = widget_stringwidth( menu->text )+5*8;

  for( ptr = &menu[1]; ptr->text; ptr++ ) {
    int total_width = widget_stringwidth(ptr->text)+3*8;

    /* If this is a number format, leave room for 4 digits as well as the
       text */
    if( ptr->suffix ) total_width += widget_stringwidth(ptr->suffix)+4*8;

    if (total_width > max_width)
      max_width = total_width;
  }

  return (max_width+options_vert_external_margin*2)/8;
}


int
widget_general_draw( void *data GCC_UNUSED )
{
  int error;
  highlight_line = 0;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  error = widget_options_show_all( options_general, &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  return 0;
}

static void
widget_emulation_speed_click( void )
{
  int error;
  widget_text_t text_data;

  text_data.title = "Emulation speed";
  text_data.allow = WIDGET_INPUT_DIGIT;
  snprintf( text_data.text, 40, "%d",
            widget_options_settings.emulation_speed );
  error = widget_do( WIDGET_TYPE_TEXT, &text_data );

  if( widget_text_text ) {
    widget_options_settings.emulation_speed = atoi( widget_text_text );
  }
}

static void
widget_option_emulation_speed_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_entry( left_edge, width, menu->index, menu->text, show->emulation_speed,
                              menu->suffix );
}

static void
widget_frame_rate_click( void )
{
  int error;
  widget_text_t text_data;

  text_data.title = "Frame rate (1:n)";
  text_data.allow = WIDGET_INPUT_DIGIT;
  snprintf( text_data.text, 40, "%d",
            widget_options_settings.frame_rate );
  error = widget_do( WIDGET_TYPE_TEXT, &text_data );

  if( widget_text_text ) {
    widget_options_settings.frame_rate = atoi( widget_text_text );
  }
}

static void
widget_option_frame_rate_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_entry( left_edge, width, menu->index, menu->text, show->frame_rate,
                              menu->suffix );
}

static void
widget_issue2_click( void )
{
  widget_options_settings.issue2 = ! widget_options_settings.issue2;
}

static void
widget_option_issue2_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->issue2 );
}

static void
widget_tape_traps_click( void )
{
  widget_options_settings.tape_traps = ! widget_options_settings.tape_traps;
}

static void
widget_option_tape_traps_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->tape_traps );
}

static void
widget_fastload_click( void )
{
  widget_options_settings.fastload = ! widget_options_settings.fastload;
}

static void
widget_option_fastload_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->fastload );
}

static void
widget_detect_loader_click( void )
{
  widget_options_settings.detect_loader = ! widget_options_settings.detect_loader;
}

static void
widget_option_detect_loader_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->detect_loader );
}

static void
widget_accelerate_loader_click( void )
{
  widget_options_settings.accelerate_loader = ! widget_options_settings.accelerate_loader;
}

static void
widget_option_accelerate_loader_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->accelerate_loader );
}

static void
widget_auto_load_click( void )
{
  widget_options_settings.auto_load = ! widget_options_settings.auto_load;
}

static void
widget_option_auto_load_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->auto_load );
}

static void
widget_slt_traps_click( void )
{
  widget_options_settings.slt_traps = ! widget_options_settings.slt_traps;
}

static void
widget_option_slt_traps_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->slt_traps );
}

static void
widget_writable_roms_click( void )
{
  widget_options_settings.writable_roms = ! widget_options_settings.writable_roms;
}

static void
widget_option_writable_roms_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->writable_roms );
}

static void
widget_autosave_settings_click( void )
{
  widget_options_settings.autosave_settings = ! widget_options_settings.autosave_settings;
}

static void
widget_option_autosave_settings_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->autosave_settings );
}

static void
widget_mdr_len_click( void )
{
  int error;
  widget_text_t text_data;

  text_data.title = "MDR cartridge len";
  text_data.allow = WIDGET_INPUT_DIGIT;
  snprintf( text_data.text, 40, "%d",
            widget_options_settings.mdr_len );
  error = widget_do( WIDGET_TYPE_TEXT, &text_data );

  if( widget_text_text ) {
    widget_options_settings.mdr_len = atoi( widget_text_text );
  }
}

static void
widget_option_mdr_len_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_entry( left_edge, width, menu->index, menu->text, show->mdr_len,
                              menu->suffix );
}

static void
widget_mdr_random_len_click( void )
{
  widget_options_settings.mdr_random_len = ! widget_options_settings.mdr_random_len;
}

static void
widget_option_mdr_random_len_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->mdr_random_len );
}

static void
widget_rs232_handshake_click( void )
{
  widget_options_settings.rs232_handshake = ! widget_options_settings.rs232_handshake;
}

static void
widget_option_rs232_handshake_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->rs232_handshake );
}

static void
widget_bw_tv_click( void )
{
  widget_options_settings.bw_tv = ! widget_options_settings.bw_tv;
}

static void
widget_option_bw_tv_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->bw_tv );
}

static void
widget_pal_tv2x_click( void )
{
  widget_options_settings.pal_tv2x = ! widget_options_settings.pal_tv2x;
}

static void
widget_option_pal_tv2x_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->pal_tv2x );
}

static void
widget_confirm_actions_click( void )
{
  widget_options_settings.confirm_actions = ! widget_options_settings.confirm_actions;
}

static void
widget_option_confirm_actions_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->confirm_actions );
}

static void
widget_statusbar_click( void )
{
  widget_options_settings.statusbar = ! widget_options_settings.statusbar;
}

static void
widget_option_statusbar_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->statusbar );
}

static void
widget_joy_prompt_click( void )
{
  widget_options_settings.joy_prompt = ! widget_options_settings.joy_prompt;
}

static void
widget_option_joy_prompt_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->joy_prompt );
}

static void
widget_late_timings_click( void )
{
  widget_options_settings.late_timings = ! widget_options_settings.late_timings;
}

static void
widget_option_late_timings_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->late_timings );
}

void
widget_general_keyhandler( input_key key )
{
  widget_text_t text_data;
  int new_highlight_line = 0;
  int cursor_pressed = 0;
  widget_option_entry *ptr;
  int menu_width = widget_calculate_option_width(options_general);
  int menu_left_edge_x = DISPLAY_WIDTH_COLS/2-menu_width/2;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 20 );
    widget_general_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
  case INPUT_JOYSTICK_FIRE_2:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_Up:
  case INPUT_KEY_7:
  case INPUT_JOYSTICK_UP:
    if ( highlight_line ) {
      new_highlight_line = highlight_line - 1;
      cursor_pressed = 1;
    }
    break;

  case INPUT_KEY_Down:
  case INPUT_KEY_6:
  case INPUT_JOYSTICK_DOWN:
    if ( highlight_line + 1 < 20 ) {
      new_highlight_line = highlight_line + 1;
      cursor_pressed = 1;
    }
    break;

  case INPUT_KEY_space:
  case INPUT_KEY_0:
  case INPUT_JOYSTICK_RIGHT:
    options_general[highlight_line+1].click();
    options_general[highlight_line+1].draw( menu_left_edge_x, menu_width, options_general + highlight_line + 1, &widget_options_settings );
    return;
    break;

  case INPUT_KEY_Return:
  case INPUT_JOYSTICK_FIRE_1:
    widget_end_all( WIDGET_FINISHED_OK );
    display_refresh_all();
    return;
    break;

  default:	/* Keep gcc happy */
    break;

  }

  if( cursor_pressed ) {
    int old_highlight_line = highlight_line;
    highlight_line = new_highlight_line;
    options_general[old_highlight_line+1].draw( menu_left_edge_x, menu_width, options_general + old_highlight_line + 1, &widget_options_settings );
    options_general[highlight_line+1].draw( menu_left_edge_x, menu_width, options_general + highlight_line + 1, &widget_options_settings );
    return;
  }

  for( ptr=&options_general[1]; ptr->text != NULL; ptr++ ) {
    if( key == ptr->key ) {
      int old_highlight_line = highlight_line;
      ptr->click();
      highlight_line = ptr->index;
      options_general[old_highlight_line+1].draw( menu_left_edge_x, menu_width, options_general + old_highlight_line + 1, &widget_options_settings );
      ptr->draw( menu_left_edge_x, menu_width, ptr, &widget_options_settings );
      break;
    }
  }
}

int
widget_peripherals_draw( void *data GCC_UNUSED )
{
  int error;
  highlight_line = 0;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  error = widget_options_show_all( options_peripherals, &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  return 0;
}

static void
widget_joy_kempston_click( void )
{
  widget_options_settings.joy_kempston = ! widget_options_settings.joy_kempston;
}

static void
widget_option_joy_kempston_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->joy_kempston );
}

static void
widget_kempston_mouse_click( void )
{
  widget_options_settings.kempston_mouse = ! widget_options_settings.kempston_mouse;
}

static void
widget_option_kempston_mouse_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->kempston_mouse );
}

static void
widget_interface1_click( void )
{
  widget_options_settings.interface1 = ! widget_options_settings.interface1;
}

static void
widget_option_interface1_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->interface1 );
}

static void
widget_interface2_click( void )
{
  widget_options_settings.interface2 = ! widget_options_settings.interface2;
}

static void
widget_option_interface2_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->interface2 );
}

static void
widget_printer_click( void )
{
  widget_options_settings.printer = ! widget_options_settings.printer;
}

static void
widget_option_printer_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->printer );
}

static void
widget_simpleide_active_click( void )
{
  widget_options_settings.simpleide_active = ! widget_options_settings.simpleide_active;
}

static void
widget_option_simpleide_active_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->simpleide_active );
}

static void
widget_zxatasp_active_click( void )
{
  widget_options_settings.zxatasp_active = ! widget_options_settings.zxatasp_active;
}

static void
widget_option_zxatasp_active_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->zxatasp_active );
}

static void
widget_zxatasp_upload_click( void )
{
  widget_options_settings.zxatasp_upload = ! widget_options_settings.zxatasp_upload;
}

static void
widget_option_zxatasp_upload_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->zxatasp_upload );
}

static void
widget_zxatasp_wp_click( void )
{
  widget_options_settings.zxatasp_wp = ! widget_options_settings.zxatasp_wp;
}

static void
widget_option_zxatasp_wp_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->zxatasp_wp );
}

static void
widget_zxcf_active_click( void )
{
  widget_options_settings.zxcf_active = ! widget_options_settings.zxcf_active;
}

static void
widget_option_zxcf_active_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->zxcf_active );
}

static void
widget_zxcf_upload_click( void )
{
  widget_options_settings.zxcf_upload = ! widget_options_settings.zxcf_upload;
}

static void
widget_option_zxcf_upload_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->zxcf_upload );
}

static void
widget_divide_enabled_click( void )
{
  widget_options_settings.divide_enabled = ! widget_options_settings.divide_enabled;
}

static void
widget_option_divide_enabled_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->divide_enabled );
}

static void
widget_divide_wp_click( void )
{
  widget_options_settings.divide_wp = ! widget_options_settings.divide_wp;
}

static void
widget_option_divide_wp_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->divide_wp );
}

static void
widget_plusd_click( void )
{
  widget_options_settings.plusd = ! widget_options_settings.plusd;
}

static void
widget_option_plusd_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->plusd );
}

static void
widget_beta128_click( void )
{
  widget_options_settings.beta128 = ! widget_options_settings.beta128;
}

static void
widget_option_beta128_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->beta128 );
}

void
widget_peripherals_keyhandler( input_key key )
{
  widget_text_t text_data;
  int new_highlight_line = 0;
  int cursor_pressed = 0;
  widget_option_entry *ptr;
  int menu_width = widget_calculate_option_width(options_peripherals);
  int menu_left_edge_x = DISPLAY_WIDTH_COLS/2-menu_width/2;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 15 );
    widget_peripherals_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
  case INPUT_JOYSTICK_FIRE_2:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_Up:
  case INPUT_KEY_7:
  case INPUT_JOYSTICK_UP:
    if ( highlight_line ) {
      new_highlight_line = highlight_line - 1;
      cursor_pressed = 1;
    }
    break;

  case INPUT_KEY_Down:
  case INPUT_KEY_6:
  case INPUT_JOYSTICK_DOWN:
    if ( highlight_line + 1 < 15 ) {
      new_highlight_line = highlight_line + 1;
      cursor_pressed = 1;
    }
    break;

  case INPUT_KEY_space:
  case INPUT_KEY_0:
  case INPUT_JOYSTICK_RIGHT:
    options_peripherals[highlight_line+1].click();
    options_peripherals[highlight_line+1].draw( menu_left_edge_x, menu_width, options_peripherals + highlight_line + 1, &widget_options_settings );
    return;
    break;

  case INPUT_KEY_Return:
  case INPUT_JOYSTICK_FIRE_1:
    widget_end_all( WIDGET_FINISHED_OK );
    periph_update();
    display_refresh_all();
    return;
    break;

  default:	/* Keep gcc happy */
    break;

  }

  if( cursor_pressed ) {
    int old_highlight_line = highlight_line;
    highlight_line = new_highlight_line;
    options_peripherals[old_highlight_line+1].draw( menu_left_edge_x, menu_width, options_peripherals + old_highlight_line + 1, &widget_options_settings );
    options_peripherals[highlight_line+1].draw( menu_left_edge_x, menu_width, options_peripherals + highlight_line + 1, &widget_options_settings );
    return;
  }

  for( ptr=&options_peripherals[1]; ptr->text != NULL; ptr++ ) {
    if( key == ptr->key ) {
      int old_highlight_line = highlight_line;
      ptr->click();
      highlight_line = ptr->index;
      options_peripherals[old_highlight_line+1].draw( menu_left_edge_x, menu_width, options_peripherals + old_highlight_line + 1, &widget_options_settings );
      ptr->draw( menu_left_edge_x, menu_width, ptr, &widget_options_settings );
      break;
    }
  }
}

int
widget_rzx_draw( void *data GCC_UNUSED )
{
  int error;
  highlight_line = 0;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  error = widget_options_show_all( options_rzx, &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  return 0;
}

static void
widget_rzx_autosaves_click( void )
{
  widget_options_settings.rzx_autosaves = ! widget_options_settings.rzx_autosaves;
}

static void
widget_option_rzx_autosaves_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->rzx_autosaves );
}

static void
widget_rzx_compression_click( void )
{
  widget_options_settings.rzx_compression = ! widget_options_settings.rzx_compression;
}

static void
widget_option_rzx_compression_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->rzx_compression );
}

static void
widget_competition_mode_click( void )
{
  widget_options_settings.competition_mode = ! widget_options_settings.competition_mode;
}

static void
widget_option_competition_mode_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->competition_mode );
}

static void
widget_competition_code_click( void )
{
  int error;
  widget_text_t text_data;

  text_data.title = "Competition code";
  text_data.allow = WIDGET_INPUT_DIGIT;
  snprintf( text_data.text, 40, "%d",
            widget_options_settings.competition_code );
  error = widget_do( WIDGET_TYPE_TEXT, &text_data );

  if( widget_text_text ) {
    widget_options_settings.competition_code = atoi( widget_text_text );
  }
}

static void
widget_option_competition_code_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_entry( left_edge, width, menu->index, menu->text, show->competition_code,
                              menu->suffix );
}

static void
widget_embed_snapshot_click( void )
{
  widget_options_settings.embed_snapshot = ! widget_options_settings.embed_snapshot;
}

static void
widget_option_embed_snapshot_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->embed_snapshot );
}

void
widget_rzx_keyhandler( input_key key )
{
  widget_text_t text_data;
  int new_highlight_line = 0;
  int cursor_pressed = 0;
  widget_option_entry *ptr;
  int menu_width = widget_calculate_option_width(options_rzx);
  int menu_left_edge_x = DISPLAY_WIDTH_COLS/2-menu_width/2;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 5 );
    widget_rzx_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
  case INPUT_JOYSTICK_FIRE_2:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_Up:
  case INPUT_KEY_7:
  case INPUT_JOYSTICK_UP:
    if ( highlight_line ) {
      new_highlight_line = highlight_line - 1;
      cursor_pressed = 1;
    }
    break;

  case INPUT_KEY_Down:
  case INPUT_KEY_6:
  case INPUT_JOYSTICK_DOWN:
    if ( highlight_line + 1 < 5 ) {
      new_highlight_line = highlight_line + 1;
      cursor_pressed = 1;
    }
    break;

  case INPUT_KEY_space:
  case INPUT_KEY_0:
  case INPUT_JOYSTICK_RIGHT:
    options_rzx[highlight_line+1].click();
    options_rzx[highlight_line+1].draw( menu_left_edge_x, menu_width, options_rzx + highlight_line + 1, &widget_options_settings );
    return;
    break;

  case INPUT_KEY_Return:
  case INPUT_JOYSTICK_FIRE_1:
    widget_end_all( WIDGET_FINISHED_OK );
    display_refresh_all();
    return;
    break;

  default:	/* Keep gcc happy */
    break;

  }

  if( cursor_pressed ) {
    int old_highlight_line = highlight_line;
    highlight_line = new_highlight_line;
    options_rzx[old_highlight_line+1].draw( menu_left_edge_x, menu_width, options_rzx + old_highlight_line + 1, &widget_options_settings );
    options_rzx[highlight_line+1].draw( menu_left_edge_x, menu_width, options_rzx + highlight_line + 1, &widget_options_settings );
    return;
  }

  for( ptr=&options_rzx[1]; ptr->text != NULL; ptr++ ) {
    if( key == ptr->key ) {
      int old_highlight_line = highlight_line;
      ptr->click();
      highlight_line = ptr->index;
      options_rzx[old_highlight_line+1].draw( menu_left_edge_x, menu_width, options_rzx + old_highlight_line + 1, &widget_options_settings );
      ptr->draw( menu_left_edge_x, menu_width, ptr, &widget_options_settings );
      break;
    }
  }
}

int
widget_sound_draw( void *data GCC_UNUSED )
{
  int error;
  highlight_line = 0;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  error = widget_options_show_all( options_sound, &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  return 0;
}

static void
widget_sound_click( void )
{
  widget_options_settings.sound = ! widget_options_settings.sound;
}

static void
widget_option_sound_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->sound );
}

static void
widget_sound_load_click( void )
{
  widget_options_settings.sound_load = ! widget_options_settings.sound_load;
}

static void
widget_option_sound_load_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->sound_load );
}

static void
widget_stereo_ay_click( void )
{
  widget_options_settings.stereo_ay = ! widget_options_settings.stereo_ay;
}

static void
widget_option_stereo_ay_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->stereo_ay );
}

static void
widget_stereo_beeper_click( void )
{
  widget_options_settings.stereo_beeper = ! widget_options_settings.stereo_beeper;
}

static void
widget_option_stereo_beeper_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->stereo_beeper );
}

static void
widget_sound_force_8bit_click( void )
{
  widget_options_settings.sound_force_8bit = ! widget_options_settings.sound_force_8bit;
}

static void
widget_option_sound_force_8bit_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->sound_force_8bit );
}

static void
widget_sound_hifi_click( void )
{
  widget_options_settings.sound_hifi = ! widget_options_settings.sound_hifi;
}

static void
widget_option_sound_hifi_draw( int left_edge, int width, struct widget_option_entry *menu, settings_info *show )
{
  widget_options_print_option( left_edge, width, menu->index, menu->text, show->sound_hifi );
}

void
widget_sound_keyhandler( input_key key )
{
  widget_text_t text_data;
  int new_highlight_line = 0;
  int cursor_pressed = 0;
  widget_option_entry *ptr;
  int menu_width = widget_calculate_option_width(options_sound);
  int menu_left_edge_x = DISPLAY_WIDTH_COLS/2-menu_width/2;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 6 );
    widget_sound_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
  case INPUT_JOYSTICK_FIRE_2:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_Up:
  case INPUT_KEY_7:
  case INPUT_JOYSTICK_UP:
    if ( highlight_line ) {
      new_highlight_line = highlight_line - 1;
      cursor_pressed = 1;
    }
    break;

  case INPUT_KEY_Down:
  case INPUT_KEY_6:
  case INPUT_JOYSTICK_DOWN:
    if ( highlight_line + 1 < 6 ) {
      new_highlight_line = highlight_line + 1;
      cursor_pressed = 1;
    }
    break;

  case INPUT_KEY_space:
  case INPUT_KEY_0:
  case INPUT_JOYSTICK_RIGHT:
    options_sound[highlight_line+1].click();
    options_sound[highlight_line+1].draw( menu_left_edge_x, menu_width, options_sound + highlight_line + 1, &widget_options_settings );
    return;
    break;

  case INPUT_KEY_Return:
  case INPUT_JOYSTICK_FIRE_1:
    widget_end_all( WIDGET_FINISHED_OK );
    display_refresh_all();
    return;
    break;

  default:	/* Keep gcc happy */
    break;

  }

  if( cursor_pressed ) {
    int old_highlight_line = highlight_line;
    highlight_line = new_highlight_line;
    options_sound[old_highlight_line+1].draw( menu_left_edge_x, menu_width, options_sound + old_highlight_line + 1, &widget_options_settings );
    options_sound[highlight_line+1].draw( menu_left_edge_x, menu_width, options_sound + highlight_line + 1, &widget_options_settings );
    return;
  }

  for( ptr=&options_sound[1]; ptr->text != NULL; ptr++ ) {
    if( key == ptr->key ) {
      int old_highlight_line = highlight_line;
      ptr->click();
      highlight_line = ptr->index;
      options_sound[old_highlight_line+1].draw( menu_left_edge_x, menu_width, options_sound + old_highlight_line + 1, &widget_options_settings );
      ptr->draw( menu_left_edge_x, menu_width, ptr, &widget_options_settings );
      break;
    }
  }
}

#endif				/* #ifdef USE_WIDGET */
