/* settings.c: Handling configuration settings
   Copyright (c) Copyright (c) 2002 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Author contact information:

   E-mail: philip-fuse@shadowmagic.org.uk

*/
#line 63"../settings.pl"

/* This file is autogenerated from settings.dat by settings.pl.
   Do not edit unless you know what will happen! */

#include <config.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#ifdef HAVE_GETOPT_LONG		/* Did our libc include getopt_long? */
#include <getopt.h>
#elif defined AMIGA || defined __MORPHOS__            /* #ifdef HAVE_GETOPT_LONG */
/* The platform uses GNU getopt, but not getopt_long, so we get
   symbol clashes on this platform. Just use getopt */
#else				/* #ifdef HAVE_GETOPT_LONG */
#include "compat.h"		/* If not, use ours */
#endif				/* #ifdef HAVE_GETOPT_LONG */

#ifdef HAVE_LIB_XML2
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#endif				/* #ifdef HAVE_LIB_XML2 */

#include "fuse.h"
#include "machine.h"
#include "settings.h"
#include "spectrum.h"
#include "ui/ui.h"
#include "utils.h"

/* The name of our configuration file */
#ifdef WIN32
#define CONFIG_FILE_NAME "fuse.cfg"
#else				/* #ifdef WIN32 */
#define CONFIG_FILE_NAME ".fuserc"
#endif				/* #ifdef WIN32 */

/* The current settings of options, etc */
settings_info settings_current;

/* The default settings of options, etc */
settings_info settings_default = {
  /* accelerate_loader */ 1,
  /* aspect_hint */ 1,
  /* auto_load */ 1,
  /* autosave_settings */ 0,
  /* beta128 */ 0,
  /* betadisk_file */ NULL,
  /* bw_tv */ 0,
  /* competition_code */ 0,
  /* competition_mode */ 0,
  /* confirm_actions */ 1,
  /* dck_file */ NULL,
  /* debugger_command */ NULL,
  /* detect_loader */ 1,
  /* divide_enabled */ 0,
  /* divide_master_file */ NULL,
  /* divide_slave_file */ NULL,
  /* divide_wp */ 0,
  /* doublescan_mode */ 1,
  /* embed_snapshot */ 1,
  /* emulation_speed */ 100,
  /* fastload */ 1,
  /* frame_rate */ 1,
  /* full_screen */ 0,
  /* if2_file */ NULL,
  /* interface1 */ 0,
  /* interface2 */ 1,
  /* issue2 */ 0,
  /* joy_kempston */ 0,
  /* joy_prompt */ 0,
  /* joystick_1 */ NULL,
  /* joystick_1_fire_1 */ 4096,
  /* joystick_1_fire_10 */ 4096,
  /* joystick_1_fire_2 */ 4096,
  /* joystick_1_fire_3 */ 4096,
  /* joystick_1_fire_4 */ 4096,
  /* joystick_1_fire_5 */ 4096,
  /* joystick_1_fire_6 */ 4096,
  /* joystick_1_fire_7 */ 4096,
  /* joystick_1_fire_8 */ 4096,
  /* joystick_1_fire_9 */ 4096,
  /* joystick_1_output */ 0,
  /* joystick_2 */ NULL,
  /* joystick_2_fire_1 */ 4096,
  /* joystick_2_fire_10 */ 4096,
  /* joystick_2_fire_2 */ 4096,
  /* joystick_2_fire_3 */ 4096,
  /* joystick_2_fire_4 */ 4096,
  /* joystick_2_fire_5 */ 4096,
  /* joystick_2_fire_6 */ 4096,
  /* joystick_2_fire_7 */ 4096,
  /* joystick_2_fire_8 */ 4096,
  /* joystick_2_fire_9 */ 4096,
  /* joystick_2_output */ 0,
  /* joystick_keyboard_down */ 97,
  /* joystick_keyboard_fire */ 32,
  /* joystick_keyboard_left */ 111,
  /* joystick_keyboard_output */ 0,
  /* joystick_keyboard_right */ 112,
  /* joystick_keyboard_up */ 113,
  /* kempston_mouse */ 0,
  /* late_timings */ 0,
  /* mdr_file */ NULL,
  /* mdr_file2 */ NULL,
  /* mdr_file3 */ NULL,
  /* mdr_file4 */ NULL,
  /* mdr_file5 */ NULL,
  /* mdr_file6 */ NULL,
  /* mdr_file7 */ NULL,
  /* mdr_file8 */ NULL,
  /* mdr_len */ 180,
  /* mdr_random_len */ 1,
  /* pal_tv2x */ 0,
  /* playback_file */ NULL,
  /* plus3disk_file */ NULL,
  /* plusd */ 0,
  /* plusddisk_file */ NULL,
  /* printer */ 0,
  /* printer_graphics_filename */ "printout.pbm",
  /* printer_text_filename */ "printout.txt",
  /* raw_s_net */ 0,
  /* record_file */ NULL,
  /* rom_128_0 */ "128-0.rom",
  /* rom_128_1 */ "128-1.rom",
  /* rom_16 */ "48.rom",
  /* rom_48 */ "48.rom",
  /* rom_beta128 */ "trdos.rom",
  /* rom_interface_i */ "if1-2.rom",
  /* rom_pentagon1024_0 */ "128p-0.rom",
  /* rom_pentagon1024_1 */ "128p-1.rom",
  /* rom_pentagon1024_2 */ "trdos.rom",
  /* rom_pentagon1024_3 */ "gluck.rom",
  /* rom_pentagon512_0 */ "128p-0.rom",
  /* rom_pentagon512_1 */ "128p-1.rom",
  /* rom_pentagon512_2 */ "trdos.rom",
  /* rom_pentagon512_3 */ "gluck.rom",
  /* rom_pentagon_0 */ "128p-0.rom",
  /* rom_pentagon_1 */ "128p-1.rom",
  /* rom_pentagon_2 */ "trdos.rom",
  /* rom_plus2_0 */ "plus2-0.rom",
  /* rom_plus2_1 */ "plus2-1.rom",
  /* rom_plus2a_0 */ "plus3-0.rom",
  /* rom_plus2a_1 */ "plus3-1.rom",
  /* rom_plus2a_2 */ "plus3-2.rom",
  /* rom_plus2a_3 */ "plus3-3.rom",
  /* rom_plus3_0 */ "plus3-0.rom",
  /* rom_plus3_1 */ "plus3-1.rom",
  /* rom_plus3_2 */ "plus3-2.rom",
  /* rom_plus3_3 */ "plus3-3.rom",
  /* rom_plus3e_0 */ "plus3e-0.rom",
  /* rom_plus3e_1 */ "plus3e-1.rom",
  /* rom_plus3e_2 */ "plus3e-2.rom",
  /* rom_plus3e_3 */ "plus3e-3.rom",
  /* rom_plusd */ "plusd.rom",
  /* rom_scorpion_0 */ "256s-0.rom",
  /* rom_scorpion_1 */ "256s-1.rom",
  /* rom_scorpion_2 */ "256s-2.rom",
  /* rom_scorpion_3 */ "256s-3.rom",
  /* rom_spec_se_0 */ "se-0.rom",
  /* rom_spec_se_1 */ "se-1.rom",
  /* rom_tc2048 */ "tc2048.rom",
  /* rom_tc2068_0 */ "tc2068-0.rom",
  /* rom_tc2068_1 */ "tc2068-1.rom",
  /* rom_ts2068_0 */ "tc2068-0.rom",
  /* rom_ts2068_1 */ "tc2068-1.rom",
  /* rs232_handshake */ 0,
  /* rs232_rx */ NULL,
  /* rs232_tx */ NULL,
  /* rzx_autosaves */ 1,
  /* rzx_compression */ 1,
  /* simpleide_active */ 0,
  /* simpleide_master_file */ NULL,
  /* simpleide_slave_file */ NULL,
  /* slt_traps */ 1,
  /* snapshot */ NULL,
  /* snet */ NULL,
  /* sound */ 1,
  /* sound_device */ NULL,
  /* sound_force_8bit */ 0,
  /* sound_freq */ 32000,
  /* sound_hifi */ 0,
  /* sound_load */ 1,
  /* start_machine */ "48",
  /* start_scaler_mode */ "normal",
  /* statusbar */ 1,
  /* stereo_ay */ 0,
  /* stereo_beeper */ 0,
  /* strict_aspect_hint */ 0,
  /* svga_mode */ 320,
  /* tape_file */ NULL,
  /* tape_traps */ 1,
  /* unittests */ 0,
  /* writable_roms */ 0,
  /* zxatasp_active */ 0,
  /* zxatasp_master_file */ NULL,
  /* zxatasp_slave_file */ NULL,
  /* zxatasp_upload */ 0,
  /* zxatasp_wp */ 0,
  /* zxcf_active */ 0,
  /* zxcf_pri_file */ NULL,
  /* zxcf_upload */ 0,
#line 118"../settings.pl"
  /* show_help */ 0,
  /* show_version */ 0,
};

#ifdef HAVE_LIB_XML2
static int read_config_file( settings_info *settings );
static int parse_xml( xmlDocPtr doc, settings_info *settings );
#endif				/* #ifdef HAVE_LIB_XML2 */

static int settings_command_line( settings_info *settings, int *first_arg,
				  int argc, char **argv );

static int settings_copy_internal( settings_info *dest, settings_info *src );

/* Called on emulator startup */
int
settings_init( int *first_arg, int argc, char **argv )
{
  int error;

  error = settings_defaults( &settings_current );
  if( error ) {
    ui_error( UI_ERROR_ERROR, "out of memory at %s:%d", __FILE__, __LINE__ );
    return error;
  }

#ifdef HAVE_LIB_XML2
  error = read_config_file( &settings_current );
  if( error ) return error;
#endif				/* #ifdef HAVE_LIB_XML2 */

  error = settings_command_line( &settings_current, first_arg, argc, argv );
  if( error ) return error;

  return 0;
}

/* Fill the settings structure with sensible defaults */
int settings_defaults( settings_info *settings )
{
  return settings_copy_internal( settings, &settings_default );
}

#ifdef HAVE_LIB_XML2

/* Read options from the config file (if libxml2 is available) */

static int
read_config_file( settings_info *settings )
{
  const char *home; char path[256];
  struct stat stat_info;

  xmlDocPtr doc;

  home = compat_get_home_path(); if( !home ) return 1;

  snprintf( path, 256, "%s/%s", home, CONFIG_FILE_NAME );

  /* See if the file exists; if doesn't, it's not a problem */
  if( stat( path, &stat_info ) ) {
    if( errno == ENOENT ) {
      return 0;
    } else {
      ui_error( UI_ERROR_ERROR, "couldn't stat '%s': %s", path,
		strerror( errno ) );
      return 1;
    }
  }

  doc = xmlParseFile( path );
  if( !doc ) {
    ui_error( UI_ERROR_ERROR, "error reading config file" );
    return 1;
  }

  if( parse_xml( doc, settings ) ) { xmlFreeDoc( doc ); return 1; }

  xmlFreeDoc( doc );

  return 0;
}

static int
parse_xml( xmlDocPtr doc, settings_info *settings )
{
  xmlNodePtr node;
  xmlChar *xmlstring;

  node = xmlDocGetRootElement( doc );
  if( xmlStrcmp( node->name, (const xmlChar*)"settings" ) ) {
    ui_error( UI_ERROR_ERROR, "config file's root node is not 'settings'" );
    return 1;
  }

  node = node->xmlChildrenNode;
  while( node ) {

    if( !strcmp( (const char*)node->name, "accelerateloader" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->accelerate_loader = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "aspecthint" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->aspect_hint = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "autoload" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->auto_load = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "autosavesettings" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->autosave_settings = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "beta128" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->beta128 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "betadisk" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->betadisk_file );
      settings->betadisk_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "bwtv" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->bw_tv = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "competitioncode" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->competition_code = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "competitionmode" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->competition_mode = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "confirmactions" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->confirm_actions = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "dock" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->dck_file );
      settings->dck_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "debuggercommand" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->debugger_command );
      settings->debugger_command = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "detectloader" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->detect_loader = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "divide" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->divide_enabled = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "dividemasterfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->divide_master_file );
      settings->divide_master_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "divideslavefile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->divide_slave_file );
      settings->divide_slave_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "dividewriteprotect" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->divide_wp = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "doublescreen" ) ) {
      /* Do nothing */
    } else
    if( !strcmp( (const char*)node->name, "doublescanmode" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->doublescan_mode = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "embedsnapshot" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->embed_snapshot = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "speed" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->emulation_speed = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "fastload" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->fastload = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rate" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->frame_rate = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "fullscreen" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->full_screen = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "if2cart" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->if2_file );
      settings->if2_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "interface1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->interface1 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "interface2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->interface2 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "issue2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->issue2 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "kempston" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joy_kempston = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystickprompt" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joy_prompt = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->joystick_1 );
      settings->joystick_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_1_fire_1 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire10" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_1_fire_10 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_1_fire_2 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_1_fire_3 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire4" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_1_fire_4 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire5" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_1_fire_5 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire6" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_1_fire_6 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire7" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_1_fire_7 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire8" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_1_fire_8 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire9" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_1_fire_9 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick1output" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_1_output = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->joystick_2 );
      settings->joystick_2 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_2_fire_1 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire10" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_2_fire_10 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_2_fire_2 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_2_fire_3 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire4" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_2_fire_4 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire5" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_2_fire_5 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire6" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_2_fire_6 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire7" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_2_fire_7 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire8" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_2_fire_8 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire9" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_2_fire_9 = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystick2output" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_2_output = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboarddown" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_keyboard_down = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboardfire" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_keyboard_fire = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboardleft" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_keyboard_left = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboardoutput" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_keyboard_output = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboardright" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_keyboard_right = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboardup" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->joystick_keyboard_up = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "kempstonmouse" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->kempston_mouse = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "latetimings" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->late_timings = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "microdrivefile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->mdr_file );
      settings->mdr_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "microdrive2file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->mdr_file2 );
      settings->mdr_file2 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "microdrive3file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->mdr_file3 );
      settings->mdr_file3 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "microdrive4file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->mdr_file4 );
      settings->mdr_file4 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "microdrive5file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->mdr_file5 );
      settings->mdr_file5 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "microdrive6file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->mdr_file6 );
      settings->mdr_file6 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "microdrive7file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->mdr_file7 );
      settings->mdr_file7 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "microdrive8file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->mdr_file8 );
      settings->mdr_file8 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "mdrlen" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->mdr_len = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "mdrrandomlen" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->mdr_random_len = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "paltv2x" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->pal_tv2x = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "playbackfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->playback_file );
      settings->playback_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "plus3disk" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->plus3disk_file );
      settings->plus3disk_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "plusd" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->plusd = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "plusddisk" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->plusddisk_file );
      settings->plusddisk_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "printer" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->printer = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "graphicsfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->printer_graphics_filename );
      settings->printer_graphics_filename = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "textfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->printer_text_filename );
      settings->printer_text_filename = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rawrs232" ) ) {
      /* Do nothing */
    } else
    if( !strcmp( (const char*)node->name, "rawsnet" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->raw_s_net = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "recordfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->record_file );
      settings->record_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rom1280" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_128_0 );
      settings->rom_128_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rom1281" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_128_1 );
      settings->rom_128_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rom16" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_16 );
      settings->rom_16 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rom48" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_48 );
      settings->rom_48 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rombeta128" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_beta128 );
      settings->rom_beta128 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rominterfacei" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_interface_i );
      settings->rom_interface_i = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rompentagon10240" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_pentagon1024_0 );
      settings->rom_pentagon1024_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rompentagon10241" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_pentagon1024_1 );
      settings->rom_pentagon1024_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rompentagon10242" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_pentagon1024_2 );
      settings->rom_pentagon1024_2 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rompentagon10243" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_pentagon1024_3 );
      settings->rom_pentagon1024_3 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rompentagon5120" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_pentagon512_0 );
      settings->rom_pentagon512_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rompentagon5121" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_pentagon512_1 );
      settings->rom_pentagon512_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rompentagon5122" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_pentagon512_2 );
      settings->rom_pentagon512_2 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rompentagon5123" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_pentagon512_3 );
      settings->rom_pentagon512_3 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rompentagon0" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_pentagon_0 );
      settings->rom_pentagon_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rompentagon1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_pentagon_1 );
      settings->rom_pentagon_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rompentagon2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_pentagon_2 );
      settings->rom_pentagon_2 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus20" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus2_0 );
      settings->rom_plus2_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus21" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus2_1 );
      settings->rom_plus2_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus2a0" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus2a_0 );
      settings->rom_plus2a_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus2a1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus2a_1 );
      settings->rom_plus2a_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus2a2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus2a_2 );
      settings->rom_plus2a_2 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus2a3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus2a_3 );
      settings->rom_plus2a_3 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus30" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus3_0 );
      settings->rom_plus3_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus31" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus3_1 );
      settings->rom_plus3_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus32" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus3_2 );
      settings->rom_plus3_2 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus33" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus3_3 );
      settings->rom_plus3_3 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus3e0" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus3e_0 );
      settings->rom_plus3e_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus3e1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus3e_1 );
      settings->rom_plus3e_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus3e2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus3e_2 );
      settings->rom_plus3e_2 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplus3e3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plus3e_3 );
      settings->rom_plus3e_3 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romplusd" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_plusd );
      settings->rom_plusd = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romscorpion0" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_scorpion_0 );
      settings->rom_scorpion_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romscorpion1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_scorpion_1 );
      settings->rom_scorpion_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romscorpion2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_scorpion_2 );
      settings->rom_scorpion_2 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romscorpion3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_scorpion_3 );
      settings->rom_scorpion_3 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romspecse0" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_spec_se_0 );
      settings->rom_spec_se_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romspecse1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_spec_se_1 );
      settings->rom_spec_se_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romtc2048" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_tc2048 );
      settings->rom_tc2048 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romtc20680" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_tc2068_0 );
      settings->rom_tc2068_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romtc20681" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_tc2068_1 );
      settings->rom_tc2068_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romts20680" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_ts2068_0 );
      settings->rom_ts2068_0 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "romts20681" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rom_ts2068_1 );
      settings->rom_ts2068_1 = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rs232handshake" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->rs232_handshake = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rs232rx" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rs232_rx );
      settings->rs232_rx = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rs232tx" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->rs232_tx );
      settings->rs232_tx = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "rzxautosaves" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->rzx_autosaves = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "compressrzx" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->rzx_compression = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "simpleide" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->simpleide_active = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "simpleidemasterfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->simpleide_master_file );
      settings->simpleide_master_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "simpleideslavefile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->simpleide_slave_file );
      settings->simpleide_slave_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "slttraps" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->slt_traps = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "snapsasz80" ) ) {
      /* Do nothing */
    } else
    if( !strcmp( (const char*)node->name, "snapshot" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->snapshot );
      settings->snapshot = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "snet" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->snet );
      settings->snet = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "sound" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->sound = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "sounddevice" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->sound_device );
      settings->sound_device = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "soundforce8bit" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->sound_force_8bit = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "soundfreq" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->sound_freq = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "soundhifi" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->sound_hifi = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "loadingsound" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->sound_load = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "machine" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->start_machine );
      settings->start_machine = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "graphicsfilter" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->start_scaler_mode );
      settings->start_scaler_mode = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "statusbar" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->statusbar = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "separation" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->stereo_ay = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "beeperstereo" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->stereo_beeper = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "strictaspecthint" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->strict_aspect_hint = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "svgamode" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->svga_mode = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "tapefile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->tape_file );
      settings->tape_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "tapetraps" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->tape_traps = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "unittests" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->unittests = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "writableroms" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->writable_roms = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "zxatasp" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->zxatasp_active = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "zxataspmasterfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->zxatasp_master_file );
      settings->zxatasp_master_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "zxataspslavefile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->zxatasp_slave_file );
      settings->zxatasp_slave_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "zxataspupload" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->zxatasp_upload = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "zxataspwriteprotect" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->zxatasp_wp = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "zxcf" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->zxcf_active = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "zxcfcffile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      free( settings->zxcf_pri_file );
      settings->zxcf_pri_file = strdup( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
    if( !strcmp( (const char*)node->name, "zxcfupload" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      settings->zxcf_upload = atoi( (char*)xmlstring );
      xmlFree( xmlstring );
    } else
#line 257"../settings.pl"
    if( !strcmp( (const char*)node->name, "text" ) ) {
      /* Do nothing */
    } else {
      ui_error( UI_ERROR_WARNING, "Unknown setting '%s' in config file",
		node->name );
    }

    node = node->next;
  }

  return 0;
}

int
settings_write_config( settings_info *settings )
{
  const char *home; char path[256], buffer[80]; 

  xmlDocPtr doc; xmlNodePtr root;

  home = compat_get_home_path(); if( !home ) return 1;

  snprintf( path, 256, "%s/%s", home, CONFIG_FILE_NAME );

  /* Create the XML document */
  doc = xmlNewDoc( (const xmlChar*)"1.0" );

  root = xmlNewNode( NULL, (const xmlChar*)"settings" );
  xmlDocSetRootElement( doc, root );
  xmlNewTextChild( root, NULL, (const xmlChar*)"accelerateloader", (const xmlChar*)(settings->accelerate_loader ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"aspecthint", (const xmlChar*)(settings->aspect_hint ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"autoload", (const xmlChar*)(settings->auto_load ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"autosavesettings", (const xmlChar*)(settings->autosave_settings ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"beta128", (const xmlChar*)(settings->beta128 ? "1" : "0") );
  if( settings->betadisk_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"betadisk", (const xmlChar*)settings->betadisk_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"bwtv", (const xmlChar*)(settings->bw_tv ? "1" : "0") );
  if( settings->competition_code ) {
    snprintf( buffer, 80, "%d", settings->competition_code );
    xmlNewTextChild( root, NULL, (const xmlChar*)"competitioncode", (const xmlChar*)buffer );
  }
  xmlNewTextChild( root, NULL, (const xmlChar*)"competitionmode", (const xmlChar*)(settings->competition_mode ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"confirmactions", (const xmlChar*)(settings->confirm_actions ? "1" : "0") );
  if( settings->dck_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"dock", (const xmlChar*)settings->dck_file );
  if( settings->debugger_command )
    xmlNewTextChild( root, NULL, (const xmlChar*)"debuggercommand", (const xmlChar*)settings->debugger_command );
  xmlNewTextChild( root, NULL, (const xmlChar*)"detectloader", (const xmlChar*)(settings->detect_loader ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"divide", (const xmlChar*)(settings->divide_enabled ? "1" : "0") );
  if( settings->divide_master_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"dividemasterfile", (const xmlChar*)settings->divide_master_file );
  if( settings->divide_slave_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"divideslavefile", (const xmlChar*)settings->divide_slave_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"dividewriteprotect", (const xmlChar*)(settings->divide_wp ? "1" : "0") );
  if( settings->doublescan_mode ) {
    snprintf( buffer, 80, "%d", settings->doublescan_mode );
    xmlNewTextChild( root, NULL, (const xmlChar*)"doublescanmode", (const xmlChar*)buffer );
  }
  xmlNewTextChild( root, NULL, (const xmlChar*)"embedsnapshot", (const xmlChar*)(settings->embed_snapshot ? "1" : "0") );
  if( settings->emulation_speed ) {
    snprintf( buffer, 80, "%d", settings->emulation_speed );
    xmlNewTextChild( root, NULL, (const xmlChar*)"speed", (const xmlChar*)buffer );
  }
  xmlNewTextChild( root, NULL, (const xmlChar*)"fastload", (const xmlChar*)(settings->fastload ? "1" : "0") );
  if( settings->frame_rate ) {
    snprintf( buffer, 80, "%d", settings->frame_rate );
    xmlNewTextChild( root, NULL, (const xmlChar*)"rate", (const xmlChar*)buffer );
  }
  xmlNewTextChild( root, NULL, (const xmlChar*)"fullscreen", (const xmlChar*)(settings->full_screen ? "1" : "0") );
  if( settings->if2_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"if2cart", (const xmlChar*)settings->if2_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"interface1", (const xmlChar*)(settings->interface1 ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"interface2", (const xmlChar*)(settings->interface2 ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"issue2", (const xmlChar*)(settings->issue2 ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"kempston", (const xmlChar*)(settings->joy_kempston ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystickprompt", (const xmlChar*)(settings->joy_prompt ? "1" : "0") );
  if( settings->joystick_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1", (const xmlChar*)settings->joystick_1 );
  if( settings->joystick_1_fire_1 ) {
    snprintf( buffer, 80, "%d", settings->joystick_1_fire_1 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire1", (const xmlChar*)buffer );
  }
  if( settings->joystick_1_fire_10 ) {
    snprintf( buffer, 80, "%d", settings->joystick_1_fire_10 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire10", (const xmlChar*)buffer );
  }
  if( settings->joystick_1_fire_2 ) {
    snprintf( buffer, 80, "%d", settings->joystick_1_fire_2 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire2", (const xmlChar*)buffer );
  }
  if( settings->joystick_1_fire_3 ) {
    snprintf( buffer, 80, "%d", settings->joystick_1_fire_3 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire3", (const xmlChar*)buffer );
  }
  if( settings->joystick_1_fire_4 ) {
    snprintf( buffer, 80, "%d", settings->joystick_1_fire_4 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire4", (const xmlChar*)buffer );
  }
  if( settings->joystick_1_fire_5 ) {
    snprintf( buffer, 80, "%d", settings->joystick_1_fire_5 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire5", (const xmlChar*)buffer );
  }
  if( settings->joystick_1_fire_6 ) {
    snprintf( buffer, 80, "%d", settings->joystick_1_fire_6 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire6", (const xmlChar*)buffer );
  }
  if( settings->joystick_1_fire_7 ) {
    snprintf( buffer, 80, "%d", settings->joystick_1_fire_7 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire7", (const xmlChar*)buffer );
  }
  if( settings->joystick_1_fire_8 ) {
    snprintf( buffer, 80, "%d", settings->joystick_1_fire_8 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire8", (const xmlChar*)buffer );
  }
  if( settings->joystick_1_fire_9 ) {
    snprintf( buffer, 80, "%d", settings->joystick_1_fire_9 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire9", (const xmlChar*)buffer );
  }
  if( settings->joystick_1_output ) {
    snprintf( buffer, 80, "%d", settings->joystick_1_output );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1output", (const xmlChar*)buffer );
  }
  if( settings->joystick_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2", (const xmlChar*)settings->joystick_2 );
  if( settings->joystick_2_fire_1 ) {
    snprintf( buffer, 80, "%d", settings->joystick_2_fire_1 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire1", (const xmlChar*)buffer );
  }
  if( settings->joystick_2_fire_10 ) {
    snprintf( buffer, 80, "%d", settings->joystick_2_fire_10 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire10", (const xmlChar*)buffer );
  }
  if( settings->joystick_2_fire_2 ) {
    snprintf( buffer, 80, "%d", settings->joystick_2_fire_2 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire2", (const xmlChar*)buffer );
  }
  if( settings->joystick_2_fire_3 ) {
    snprintf( buffer, 80, "%d", settings->joystick_2_fire_3 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire3", (const xmlChar*)buffer );
  }
  if( settings->joystick_2_fire_4 ) {
    snprintf( buffer, 80, "%d", settings->joystick_2_fire_4 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire4", (const xmlChar*)buffer );
  }
  if( settings->joystick_2_fire_5 ) {
    snprintf( buffer, 80, "%d", settings->joystick_2_fire_5 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire5", (const xmlChar*)buffer );
  }
  if( settings->joystick_2_fire_6 ) {
    snprintf( buffer, 80, "%d", settings->joystick_2_fire_6 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire6", (const xmlChar*)buffer );
  }
  if( settings->joystick_2_fire_7 ) {
    snprintf( buffer, 80, "%d", settings->joystick_2_fire_7 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire7", (const xmlChar*)buffer );
  }
  if( settings->joystick_2_fire_8 ) {
    snprintf( buffer, 80, "%d", settings->joystick_2_fire_8 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire8", (const xmlChar*)buffer );
  }
  if( settings->joystick_2_fire_9 ) {
    snprintf( buffer, 80, "%d", settings->joystick_2_fire_9 );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire9", (const xmlChar*)buffer );
  }
  if( settings->joystick_2_output ) {
    snprintf( buffer, 80, "%d", settings->joystick_2_output );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2output", (const xmlChar*)buffer );
  }
  if( settings->joystick_keyboard_down ) {
    snprintf( buffer, 80, "%d", settings->joystick_keyboard_down );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboarddown", (const xmlChar*)buffer );
  }
  if( settings->joystick_keyboard_fire ) {
    snprintf( buffer, 80, "%d", settings->joystick_keyboard_fire );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboardfire", (const xmlChar*)buffer );
  }
  if( settings->joystick_keyboard_left ) {
    snprintf( buffer, 80, "%d", settings->joystick_keyboard_left );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboardleft", (const xmlChar*)buffer );
  }
  if( settings->joystick_keyboard_output ) {
    snprintf( buffer, 80, "%d", settings->joystick_keyboard_output );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboardoutput", (const xmlChar*)buffer );
  }
  if( settings->joystick_keyboard_right ) {
    snprintf( buffer, 80, "%d", settings->joystick_keyboard_right );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboardright", (const xmlChar*)buffer );
  }
  if( settings->joystick_keyboard_up ) {
    snprintf( buffer, 80, "%d", settings->joystick_keyboard_up );
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboardup", (const xmlChar*)buffer );
  }
  xmlNewTextChild( root, NULL, (const xmlChar*)"kempstonmouse", (const xmlChar*)(settings->kempston_mouse ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"latetimings", (const xmlChar*)(settings->late_timings ? "1" : "0") );
  if( settings->mdr_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrivefile", (const xmlChar*)settings->mdr_file );
  if( settings->mdr_file2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive2file", (const xmlChar*)settings->mdr_file2 );
  if( settings->mdr_file3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive3file", (const xmlChar*)settings->mdr_file3 );
  if( settings->mdr_file4 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive4file", (const xmlChar*)settings->mdr_file4 );
  if( settings->mdr_file5 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive5file", (const xmlChar*)settings->mdr_file5 );
  if( settings->mdr_file6 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive6file", (const xmlChar*)settings->mdr_file6 );
  if( settings->mdr_file7 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive7file", (const xmlChar*)settings->mdr_file7 );
  if( settings->mdr_file8 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive8file", (const xmlChar*)settings->mdr_file8 );
  if( settings->mdr_len ) {
    snprintf( buffer, 80, "%d", settings->mdr_len );
    xmlNewTextChild( root, NULL, (const xmlChar*)"mdrlen", (const xmlChar*)buffer );
  }
  xmlNewTextChild( root, NULL, (const xmlChar*)"mdrrandomlen", (const xmlChar*)(settings->mdr_random_len ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"paltv2x", (const xmlChar*)(settings->pal_tv2x ? "1" : "0") );
  if( settings->playback_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"playbackfile", (const xmlChar*)settings->playback_file );
  if( settings->plus3disk_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"plus3disk", (const xmlChar*)settings->plus3disk_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"plusd", (const xmlChar*)(settings->plusd ? "1" : "0") );
  if( settings->plusddisk_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"plusddisk", (const xmlChar*)settings->plusddisk_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"printer", (const xmlChar*)(settings->printer ? "1" : "0") );
  if( settings->printer_graphics_filename )
    xmlNewTextChild( root, NULL, (const xmlChar*)"graphicsfile", (const xmlChar*)settings->printer_graphics_filename );
  if( settings->printer_text_filename )
    xmlNewTextChild( root, NULL, (const xmlChar*)"textfile", (const xmlChar*)settings->printer_text_filename );
  xmlNewTextChild( root, NULL, (const xmlChar*)"rawsnet", (const xmlChar*)(settings->raw_s_net ? "1" : "0") );
  if( settings->record_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"recordfile", (const xmlChar*)settings->record_file );
  if( settings->rom_128_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rom1280", (const xmlChar*)settings->rom_128_0 );
  if( settings->rom_128_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rom1281", (const xmlChar*)settings->rom_128_1 );
  if( settings->rom_16 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rom16", (const xmlChar*)settings->rom_16 );
  if( settings->rom_48 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rom48", (const xmlChar*)settings->rom_48 );
  if( settings->rom_beta128 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rombeta128", (const xmlChar*)settings->rom_beta128 );
  if( settings->rom_interface_i )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rominterfacei", (const xmlChar*)settings->rom_interface_i );
  if( settings->rom_pentagon1024_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon10240", (const xmlChar*)settings->rom_pentagon1024_0 );
  if( settings->rom_pentagon1024_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon10241", (const xmlChar*)settings->rom_pentagon1024_1 );
  if( settings->rom_pentagon1024_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon10242", (const xmlChar*)settings->rom_pentagon1024_2 );
  if( settings->rom_pentagon1024_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon10243", (const xmlChar*)settings->rom_pentagon1024_3 );
  if( settings->rom_pentagon512_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon5120", (const xmlChar*)settings->rom_pentagon512_0 );
  if( settings->rom_pentagon512_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon5121", (const xmlChar*)settings->rom_pentagon512_1 );
  if( settings->rom_pentagon512_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon5122", (const xmlChar*)settings->rom_pentagon512_2 );
  if( settings->rom_pentagon512_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon5123", (const xmlChar*)settings->rom_pentagon512_3 );
  if( settings->rom_pentagon_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon0", (const xmlChar*)settings->rom_pentagon_0 );
  if( settings->rom_pentagon_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon1", (const xmlChar*)settings->rom_pentagon_1 );
  if( settings->rom_pentagon_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon2", (const xmlChar*)settings->rom_pentagon_2 );
  if( settings->rom_plus2_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus20", (const xmlChar*)settings->rom_plus2_0 );
  if( settings->rom_plus2_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus21", (const xmlChar*)settings->rom_plus2_1 );
  if( settings->rom_plus2a_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus2a0", (const xmlChar*)settings->rom_plus2a_0 );
  if( settings->rom_plus2a_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus2a1", (const xmlChar*)settings->rom_plus2a_1 );
  if( settings->rom_plus2a_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus2a2", (const xmlChar*)settings->rom_plus2a_2 );
  if( settings->rom_plus2a_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus2a3", (const xmlChar*)settings->rom_plus2a_3 );
  if( settings->rom_plus3_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus30", (const xmlChar*)settings->rom_plus3_0 );
  if( settings->rom_plus3_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus31", (const xmlChar*)settings->rom_plus3_1 );
  if( settings->rom_plus3_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus32", (const xmlChar*)settings->rom_plus3_2 );
  if( settings->rom_plus3_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus33", (const xmlChar*)settings->rom_plus3_3 );
  if( settings->rom_plus3e_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus3e0", (const xmlChar*)settings->rom_plus3e_0 );
  if( settings->rom_plus3e_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus3e1", (const xmlChar*)settings->rom_plus3e_1 );
  if( settings->rom_plus3e_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus3e2", (const xmlChar*)settings->rom_plus3e_2 );
  if( settings->rom_plus3e_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus3e3", (const xmlChar*)settings->rom_plus3e_3 );
  if( settings->rom_plusd )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplusd", (const xmlChar*)settings->rom_plusd );
  if( settings->rom_scorpion_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romscorpion0", (const xmlChar*)settings->rom_scorpion_0 );
  if( settings->rom_scorpion_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romscorpion1", (const xmlChar*)settings->rom_scorpion_1 );
  if( settings->rom_scorpion_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romscorpion2", (const xmlChar*)settings->rom_scorpion_2 );
  if( settings->rom_scorpion_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romscorpion3", (const xmlChar*)settings->rom_scorpion_3 );
  if( settings->rom_spec_se_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romspecse0", (const xmlChar*)settings->rom_spec_se_0 );
  if( settings->rom_spec_se_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romspecse1", (const xmlChar*)settings->rom_spec_se_1 );
  if( settings->rom_tc2048 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romtc2048", (const xmlChar*)settings->rom_tc2048 );
  if( settings->rom_tc2068_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romtc20680", (const xmlChar*)settings->rom_tc2068_0 );
  if( settings->rom_tc2068_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romtc20681", (const xmlChar*)settings->rom_tc2068_1 );
  if( settings->rom_ts2068_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romts20680", (const xmlChar*)settings->rom_ts2068_0 );
  if( settings->rom_ts2068_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romts20681", (const xmlChar*)settings->rom_ts2068_1 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"rs232handshake", (const xmlChar*)(settings->rs232_handshake ? "1" : "0") );
  if( settings->rs232_rx )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rs232rx", (const xmlChar*)settings->rs232_rx );
  if( settings->rs232_tx )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rs232tx", (const xmlChar*)settings->rs232_tx );
  xmlNewTextChild( root, NULL, (const xmlChar*)"rzxautosaves", (const xmlChar*)(settings->rzx_autosaves ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"compressrzx", (const xmlChar*)(settings->rzx_compression ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"simpleide", (const xmlChar*)(settings->simpleide_active ? "1" : "0") );
  if( settings->simpleide_master_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"simpleidemasterfile", (const xmlChar*)settings->simpleide_master_file );
  if( settings->simpleide_slave_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"simpleideslavefile", (const xmlChar*)settings->simpleide_slave_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"slttraps", (const xmlChar*)(settings->slt_traps ? "1" : "0") );
  if( settings->snapshot )
    xmlNewTextChild( root, NULL, (const xmlChar*)"snapshot", (const xmlChar*)settings->snapshot );
  if( settings->snet )
    xmlNewTextChild( root, NULL, (const xmlChar*)"snet", (const xmlChar*)settings->snet );
  xmlNewTextChild( root, NULL, (const xmlChar*)"sound", (const xmlChar*)(settings->sound ? "1" : "0") );
  if( settings->sound_device )
    xmlNewTextChild( root, NULL, (const xmlChar*)"sounddevice", (const xmlChar*)settings->sound_device );
  xmlNewTextChild( root, NULL, (const xmlChar*)"soundforce8bit", (const xmlChar*)(settings->sound_force_8bit ? "1" : "0") );
  if( settings->sound_freq ) {
    snprintf( buffer, 80, "%d", settings->sound_freq );
    xmlNewTextChild( root, NULL, (const xmlChar*)"soundfreq", (const xmlChar*)buffer );
  }
  xmlNewTextChild( root, NULL, (const xmlChar*)"soundhifi", (const xmlChar*)(settings->sound_hifi ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"loadingsound", (const xmlChar*)(settings->sound_load ? "1" : "0") );
  if( settings->start_machine )
    xmlNewTextChild( root, NULL, (const xmlChar*)"machine", (const xmlChar*)settings->start_machine );
  if( settings->start_scaler_mode )
    xmlNewTextChild( root, NULL, (const xmlChar*)"graphicsfilter", (const xmlChar*)settings->start_scaler_mode );
  xmlNewTextChild( root, NULL, (const xmlChar*)"statusbar", (const xmlChar*)(settings->statusbar ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"separation", (const xmlChar*)(settings->stereo_ay ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"beeperstereo", (const xmlChar*)(settings->stereo_beeper ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"strictaspecthint", (const xmlChar*)(settings->strict_aspect_hint ? "1" : "0") );
  if( settings->svga_mode ) {
    snprintf( buffer, 80, "%d", settings->svga_mode );
    xmlNewTextChild( root, NULL, (const xmlChar*)"svgamode", (const xmlChar*)buffer );
  }
  if( settings->tape_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"tapefile", (const xmlChar*)settings->tape_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"tapetraps", (const xmlChar*)(settings->tape_traps ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"unittests", (const xmlChar*)(settings->unittests ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"writableroms", (const xmlChar*)(settings->writable_roms ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"zxatasp", (const xmlChar*)(settings->zxatasp_active ? "1" : "0") );
  if( settings->zxatasp_master_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"zxataspmasterfile", (const xmlChar*)settings->zxatasp_master_file );
  if( settings->zxatasp_slave_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"zxataspslavefile", (const xmlChar*)settings->zxatasp_slave_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"zxataspupload", (const xmlChar*)(settings->zxatasp_upload ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"zxataspwriteprotect", (const xmlChar*)(settings->zxatasp_wp ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"zxcf", (const xmlChar*)(settings->zxcf_active ? "1" : "0") );
  if( settings->zxcf_pri_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"zxcfcffile", (const xmlChar*)settings->zxcf_pri_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"zxcfupload", (const xmlChar*)(settings->zxcf_upload ? "1" : "0") );
#line 316"../settings.pl"

  xmlSaveFormatFile( path, doc, 1 );

  return 0;
}

#endif				/* #ifdef HAVE_LIB_XML2 */

/* Read options from the command line */
static int
settings_command_line( settings_info *settings, int *first_arg,
                       int argc, char **argv )
{

#if !defined AMIGA && !defined __MORPHOS__

  struct option long_options[] = {

    {    "accelerate-loader", 0, &(settings->accelerate_loader), 1 },
    { "no-accelerate-loader", 0, &(settings->accelerate_loader), 0 },
    {    "aspect-hint", 0, &(settings->aspect_hint), 1 },
    { "no-aspect-hint", 0, &(settings->aspect_hint), 0 },
    {    "auto-load", 0, &(settings->auto_load), 1 },
    { "no-auto-load", 0, &(settings->auto_load), 0 },
    {    "autosave-settings", 0, &(settings->autosave_settings), 1 },
    { "no-autosave-settings", 0, &(settings->autosave_settings), 0 },
    {    "beta128", 0, &(settings->beta128), 1 },
    { "no-beta128", 0, &(settings->beta128), 0 },
    { "betadisk", 1, NULL, 256 },
    {    "bw-tv", 0, &(settings->bw_tv), 1 },
    { "no-bw-tv", 0, &(settings->bw_tv), 0 },
    { "competition-code", 1, NULL, 257 },
    {    "competition-mode", 0, &(settings->competition_mode), 1 },
    { "no-competition-mode", 0, &(settings->competition_mode), 0 },
    {    "confirm-actions", 0, &(settings->confirm_actions), 1 },
    { "no-confirm-actions", 0, &(settings->confirm_actions), 0 },
    { "dock", 1, NULL, 258 },
    { "debugger-command", 1, NULL, 259 },
    {    "detect-loader", 0, &(settings->detect_loader), 1 },
    { "no-detect-loader", 0, &(settings->detect_loader), 0 },
    {    "divide", 0, &(settings->divide_enabled), 1 },
    { "no-divide", 0, &(settings->divide_enabled), 0 },
    { "divide-masterfile", 1, NULL, 260 },
    { "divide-slavefile", 1, NULL, 261 },
    {    "divide-write-protect", 0, &(settings->divide_wp), 1 },
    { "no-divide-write-protect", 0, &(settings->divide_wp), 0 },
    { "doublescan-mode", 1, NULL, 'D' },
    {    "embed-snapshot", 0, &(settings->embed_snapshot), 1 },
    { "no-embed-snapshot", 0, &(settings->embed_snapshot), 0 },
    { "speed", 1, NULL, 263 },
    {    "fastload", 0, &(settings->fastload), 1 },
    { "no-fastload", 0, &(settings->fastload), 0 },
    { "rate", 1, NULL, 264 },
    {    "full-screen", 0, &(settings->full_screen), 1 },
    { "no-full-screen", 0, &(settings->full_screen), 0 },
    { "if2cart", 1, NULL, 265 },
    {    "interface1", 0, &(settings->interface1), 1 },
    { "no-interface1", 0, &(settings->interface1), 0 },
    {    "interface2", 0, &(settings->interface2), 1 },
    { "no-interface2", 0, &(settings->interface2), 0 },
    {    "issue2", 0, &(settings->issue2), 1 },
    { "no-issue2", 0, &(settings->issue2), 0 },
    {    "kempston", 0, &(settings->joy_kempston), 1 },
    { "no-kempston", 0, &(settings->joy_kempston), 0 },
    {    "joystick-prompt", 0, &(settings->joy_prompt), 1 },
    { "no-joystick-prompt", 0, &(settings->joy_prompt), 0 },
    { "joystick-1", 1, NULL, 'j' },
    { "joystick-1-fire-1", 1, NULL, 266 },
    { "joystick-1-fire-10", 1, NULL, 267 },
    { "joystick-1-fire-2", 1, NULL, 268 },
    { "joystick-1-fire-3", 1, NULL, 269 },
    { "joystick-1-fire-4", 1, NULL, 270 },
    { "joystick-1-fire-5", 1, NULL, 271 },
    { "joystick-1-fire-6", 1, NULL, 272 },
    { "joystick-1-fire-7", 1, NULL, 273 },
    { "joystick-1-fire-8", 1, NULL, 274 },
    { "joystick-1-fire-9", 1, NULL, 275 },
    { "joystick-1-output", 1, NULL, 276 },
    { "joystick-2", 1, NULL, 277 },
    { "joystick-2-fire-1", 1, NULL, 278 },
    { "joystick-2-fire-10", 1, NULL, 279 },
    { "joystick-2-fire-2", 1, NULL, 280 },
    { "joystick-2-fire-3", 1, NULL, 281 },
    { "joystick-2-fire-4", 1, NULL, 282 },
    { "joystick-2-fire-5", 1, NULL, 283 },
    { "joystick-2-fire-6", 1, NULL, 284 },
    { "joystick-2-fire-7", 1, NULL, 285 },
    { "joystick-2-fire-8", 1, NULL, 286 },
    { "joystick-2-fire-9", 1, NULL, 287 },
    { "joystick-2-output", 1, NULL, 288 },
    { "joystick-keyboard-down", 1, NULL, 289 },
    { "joystick-keyboard-fire", 1, NULL, 290 },
    { "joystick-keyboard-left", 1, NULL, 291 },
    { "joystick-keyboard-output", 1, NULL, 292 },
    { "joystick-keyboard-right", 1, NULL, 293 },
    { "joystick-keyboard-up", 1, NULL, 294 },
    {    "kempston-mouse", 0, &(settings->kempston_mouse), 1 },
    { "no-kempston-mouse", 0, &(settings->kempston_mouse), 0 },
    {    "late-timings", 0, &(settings->late_timings), 1 },
    { "no-late-timings", 0, &(settings->late_timings), 0 },
    { "microdrive-file", 1, NULL, 295 },
    { "microdrive-2-file", 1, NULL, 296 },
    { "microdrive-3-file", 1, NULL, 297 },
    { "microdrive-4-file", 1, NULL, 298 },
    { "microdrive-5-file", 1, NULL, 299 },
    { "microdrive-6-file", 1, NULL, 300 },
    { "microdrive-7-file", 1, NULL, 301 },
    { "microdrive-8-file", 1, NULL, 302 },
    { "mdr-len", 1, NULL, 303 },
    {    "mdr-random-len", 0, &(settings->mdr_random_len), 1 },
    { "no-mdr-random-len", 0, &(settings->mdr_random_len), 0 },
    {    "pal-tv2x", 0, &(settings->pal_tv2x), 1 },
    { "no-pal-tv2x", 0, &(settings->pal_tv2x), 0 },
    { "playback", 1, NULL, 'p' },
    { "plus3disk", 1, NULL, 304 },
    {    "plusd", 0, &(settings->plusd), 1 },
    { "no-plusd", 0, &(settings->plusd), 0 },
    { "plusddisk", 1, NULL, 305 },
    {    "printer", 0, &(settings->printer), 1 },
    { "no-printer", 0, &(settings->printer), 0 },
    { "graphicsfile", 1, NULL, 306 },
    { "textfile", 1, NULL, 307 },
    {    "raw-s-net", 0, &(settings->raw_s_net), 1 },
    { "no-raw-s-net", 0, &(settings->raw_s_net), 0 },
    { "record", 1, NULL, 'r' },
    { "rom-128-0", 1, NULL, 309 },
    { "rom-128-1", 1, NULL, 310 },
    { "rom-16", 1, NULL, 311 },
    { "rom-48", 1, NULL, 312 },
    { "rom-beta128", 1, NULL, 313 },
    { "rom-interface-i", 1, NULL, 314 },
    { "rom-pentagon1024-0", 1, NULL, 315 },
    { "rom-pentagon1024-1", 1, NULL, 316 },
    { "rom-pentagon1024-2", 1, NULL, 317 },
    { "rom-pentagon1024-3", 1, NULL, 318 },
    { "rom-pentagon512-0", 1, NULL, 319 },
    { "rom-pentagon512-1", 1, NULL, 320 },
    { "rom-pentagon512-2", 1, NULL, 321 },
    { "rom-pentagon512-3", 1, NULL, 322 },
    { "rom-pentagon-0", 1, NULL, 323 },
    { "rom-pentagon-1", 1, NULL, 324 },
    { "rom-pentagon-2", 1, NULL, 325 },
    { "rom-plus2-0", 1, NULL, 326 },
    { "rom-plus2-1", 1, NULL, 327 },
    { "rom-plus2a-0", 1, NULL, 328 },
    { "rom-plus2a-1", 1, NULL, 329 },
    { "rom-plus2a-2", 1, NULL, 330 },
    { "rom-plus2a-3", 1, NULL, 331 },
    { "rom-plus3-0", 1, NULL, 332 },
    { "rom-plus3-1", 1, NULL, 333 },
    { "rom-plus3-2", 1, NULL, 334 },
    { "rom-plus3-3", 1, NULL, 335 },
    { "rom-plus3e-0", 1, NULL, 336 },
    { "rom-plus3e-1", 1, NULL, 337 },
    { "rom-plus3e-2", 1, NULL, 338 },
    { "rom-plus3e-3", 1, NULL, 339 },
    { "rom-plusd", 1, NULL, 340 },
    { "rom-scorpion-0", 1, NULL, 341 },
    { "rom-scorpion-1", 1, NULL, 342 },
    { "rom-scorpion-2", 1, NULL, 343 },
    { "rom-scorpion-3", 1, NULL, 344 },
    { "rom-spec-se-0", 1, NULL, 345 },
    { "rom-spec-se-1", 1, NULL, 346 },
    { "rom-tc2048", 1, NULL, 347 },
    { "rom-tc2068-0", 1, NULL, 348 },
    { "rom-tc2068-1", 1, NULL, 349 },
    { "rom-ts2068-0", 1, NULL, 350 },
    { "rom-ts2068-1", 1, NULL, 351 },
    {    "rs232-handshake", 0, &(settings->rs232_handshake), 1 },
    { "no-rs232-handshake", 0, &(settings->rs232_handshake), 0 },
    { "rs232-rx", 1, NULL, 352 },
    { "rs232-tx", 1, NULL, 353 },
    {    "rzx-autosaves", 0, &(settings->rzx_autosaves), 1 },
    { "no-rzx-autosaves", 0, &(settings->rzx_autosaves), 0 },
    {    "compress-rzx", 0, &(settings->rzx_compression), 1 },
    { "no-compress-rzx", 0, &(settings->rzx_compression), 0 },
    {    "simpleide", 0, &(settings->simpleide_active), 1 },
    { "no-simpleide", 0, &(settings->simpleide_active), 0 },
    { "simpleide-masterfile", 1, NULL, 354 },
    { "simpleide-slavefile", 1, NULL, 355 },
    {    "slt", 0, &(settings->slt_traps), 1 },
    { "no-slt", 0, &(settings->slt_traps), 0 },
    { "snapshot", 1, NULL, 's' },
    { "snet", 1, NULL, 357 },
    {    "sound", 0, &(settings->sound), 1 },
    { "no-sound", 0, &(settings->sound), 0 },
    { "sound-device", 1, NULL, 'd' },
    {    "sound-force-8bit", 0, &(settings->sound_force_8bit), 1 },
    { "no-sound-force-8bit", 0, &(settings->sound_force_8bit), 0 },
    { "sound-freq", 1, NULL, 'f' },
    {    "sound-hifi", 0, &(settings->sound_hifi), 1 },
    { "no-sound-hifi", 0, &(settings->sound_hifi), 0 },
    {    "loading-sound", 0, &(settings->sound_load), 1 },
    { "no-loading-sound", 0, &(settings->sound_load), 0 },
    { "machine", 1, NULL, 'm' },
    { "graphics-filter", 1, NULL, 'g' },
    {    "statusbar", 0, &(settings->statusbar), 1 },
    { "no-statusbar", 0, &(settings->statusbar), 0 },
    {    "separation", 0, &(settings->stereo_ay), 1 },
    { "no-separation", 0, &(settings->stereo_ay), 0 },
    {    "beeper-stereo", 0, &(settings->stereo_beeper), 1 },
    { "no-beeper-stereo", 0, &(settings->stereo_beeper), 0 },
    {    "strict-aspect-hint", 0, &(settings->strict_aspect_hint), 1 },
    { "no-strict-aspect-hint", 0, &(settings->strict_aspect_hint), 0 },
    { "svgamode", 1, NULL, 'v' },
    { "tape", 1, NULL, 't' },
    {    "traps", 0, &(settings->tape_traps), 1 },
    { "no-traps", 0, &(settings->tape_traps), 0 },
    {    "unittests", 0, &(settings->unittests), 1 },
    { "no-unittests", 0, &(settings->unittests), 0 },
    {    "writable-roms", 0, &(settings->writable_roms), 1 },
    { "no-writable-roms", 0, &(settings->writable_roms), 0 },
    {    "zxatasp", 0, &(settings->zxatasp_active), 1 },
    { "no-zxatasp", 0, &(settings->zxatasp_active), 0 },
    { "zxatasp-masterfile", 1, NULL, 358 },
    { "zxatasp-slavefile", 1, NULL, 359 },
    {    "zxatasp-upload", 0, &(settings->zxatasp_upload), 1 },
    { "no-zxatasp-upload", 0, &(settings->zxatasp_upload), 0 },
    {    "zxatasp-write-protect", 0, &(settings->zxatasp_wp), 1 },
    { "no-zxatasp-write-protect", 0, &(settings->zxatasp_wp), 0 },
    {    "zxcf", 0, &(settings->zxcf_active), 1 },
    { "no-zxcf", 0, &(settings->zxcf_active), 0 },
    { "zxcf-cffile", 1, NULL, 360 },
    {    "zxcf-upload", 0, &(settings->zxcf_upload), 1 },
    { "no-zxcf-upload", 0, &(settings->zxcf_upload), 0 },
#line 363"../settings.pl"

    { "help", 0, NULL, 'h' },
    { "version", 0, NULL, 'V' },

    { 0, 0, 0, 0 }		/* End marker: DO NOT REMOVE */
  };

#endif      /* #ifndef AMIGA */

  while( 1 ) {

    int c;

#if defined AMIGA || defined __MORPHOS__
    c = getopt( argc, argv, "d:hm:o:p:f:r:s:t:v:g:j:V" );
#else                    /* #ifdef AMIGA */
    c = getopt_long( argc, argv, "d:hm:o:p:f:r:s:t:v:g:j:V", long_options, NULL );
#endif                   /* #ifdef AMIGA */

    if( c == -1 ) break;	/* End of option list */

    switch( c ) {

    case 0: break;	/* Used for long option returns */

    case 256: settings_set_string( &settings->betadisk_file, optarg ); break;
    case 257: settings->competition_code = atoi( optarg ); break;
    case 258: settings_set_string( &settings->dck_file, optarg ); break;
    case 259: settings_set_string( &settings->debugger_command, optarg ); break;
    case 260: settings_set_string( &settings->divide_master_file, optarg ); break;
    case 261: settings_set_string( &settings->divide_slave_file, optarg ); break;
    case 'D': settings->doublescan_mode = atoi( optarg ); break;
    case 263: settings->emulation_speed = atoi( optarg ); break;
    case 264: settings->frame_rate = atoi( optarg ); break;
    case 265: settings_set_string( &settings->if2_file, optarg ); break;
    case 'j': settings_set_string( &settings->joystick_1, optarg ); break;
    case 266: settings->joystick_1_fire_1 = atoi( optarg ); break;
    case 267: settings->joystick_1_fire_10 = atoi( optarg ); break;
    case 268: settings->joystick_1_fire_2 = atoi( optarg ); break;
    case 269: settings->joystick_1_fire_3 = atoi( optarg ); break;
    case 270: settings->joystick_1_fire_4 = atoi( optarg ); break;
    case 271: settings->joystick_1_fire_5 = atoi( optarg ); break;
    case 272: settings->joystick_1_fire_6 = atoi( optarg ); break;
    case 273: settings->joystick_1_fire_7 = atoi( optarg ); break;
    case 274: settings->joystick_1_fire_8 = atoi( optarg ); break;
    case 275: settings->joystick_1_fire_9 = atoi( optarg ); break;
    case 276: settings->joystick_1_output = atoi( optarg ); break;
    case 277: settings_set_string( &settings->joystick_2, optarg ); break;
    case 278: settings->joystick_2_fire_1 = atoi( optarg ); break;
    case 279: settings->joystick_2_fire_10 = atoi( optarg ); break;
    case 280: settings->joystick_2_fire_2 = atoi( optarg ); break;
    case 281: settings->joystick_2_fire_3 = atoi( optarg ); break;
    case 282: settings->joystick_2_fire_4 = atoi( optarg ); break;
    case 283: settings->joystick_2_fire_5 = atoi( optarg ); break;
    case 284: settings->joystick_2_fire_6 = atoi( optarg ); break;
    case 285: settings->joystick_2_fire_7 = atoi( optarg ); break;
    case 286: settings->joystick_2_fire_8 = atoi( optarg ); break;
    case 287: settings->joystick_2_fire_9 = atoi( optarg ); break;
    case 288: settings->joystick_2_output = atoi( optarg ); break;
    case 289: settings->joystick_keyboard_down = atoi( optarg ); break;
    case 290: settings->joystick_keyboard_fire = atoi( optarg ); break;
    case 291: settings->joystick_keyboard_left = atoi( optarg ); break;
    case 292: settings->joystick_keyboard_output = atoi( optarg ); break;
    case 293: settings->joystick_keyboard_right = atoi( optarg ); break;
    case 294: settings->joystick_keyboard_up = atoi( optarg ); break;
    case 295: settings_set_string( &settings->mdr_file, optarg ); break;
    case 296: settings_set_string( &settings->mdr_file2, optarg ); break;
    case 297: settings_set_string( &settings->mdr_file3, optarg ); break;
    case 298: settings_set_string( &settings->mdr_file4, optarg ); break;
    case 299: settings_set_string( &settings->mdr_file5, optarg ); break;
    case 300: settings_set_string( &settings->mdr_file6, optarg ); break;
    case 301: settings_set_string( &settings->mdr_file7, optarg ); break;
    case 302: settings_set_string( &settings->mdr_file8, optarg ); break;
    case 303: settings->mdr_len = atoi( optarg ); break;
    case 'p': settings_set_string( &settings->playback_file, optarg ); break;
    case 304: settings_set_string( &settings->plus3disk_file, optarg ); break;
    case 305: settings_set_string( &settings->plusddisk_file, optarg ); break;
    case 306: settings_set_string( &settings->printer_graphics_filename, optarg ); break;
    case 307: settings_set_string( &settings->printer_text_filename, optarg ); break;
    case 'r': settings_set_string( &settings->record_file, optarg ); break;
    case 309: settings_set_string( &settings->rom_128_0, optarg ); break;
    case 310: settings_set_string( &settings->rom_128_1, optarg ); break;
    case 311: settings_set_string( &settings->rom_16, optarg ); break;
    case 312: settings_set_string( &settings->rom_48, optarg ); break;
    case 313: settings_set_string( &settings->rom_beta128, optarg ); break;
    case 314: settings_set_string( &settings->rom_interface_i, optarg ); break;
    case 315: settings_set_string( &settings->rom_pentagon1024_0, optarg ); break;
    case 316: settings_set_string( &settings->rom_pentagon1024_1, optarg ); break;
    case 317: settings_set_string( &settings->rom_pentagon1024_2, optarg ); break;
    case 318: settings_set_string( &settings->rom_pentagon1024_3, optarg ); break;
    case 319: settings_set_string( &settings->rom_pentagon512_0, optarg ); break;
    case 320: settings_set_string( &settings->rom_pentagon512_1, optarg ); break;
    case 321: settings_set_string( &settings->rom_pentagon512_2, optarg ); break;
    case 322: settings_set_string( &settings->rom_pentagon512_3, optarg ); break;
    case 323: settings_set_string( &settings->rom_pentagon_0, optarg ); break;
    case 324: settings_set_string( &settings->rom_pentagon_1, optarg ); break;
    case 325: settings_set_string( &settings->rom_pentagon_2, optarg ); break;
    case 326: settings_set_string( &settings->rom_plus2_0, optarg ); break;
    case 327: settings_set_string( &settings->rom_plus2_1, optarg ); break;
    case 328: settings_set_string( &settings->rom_plus2a_0, optarg ); break;
    case 329: settings_set_string( &settings->rom_plus2a_1, optarg ); break;
    case 330: settings_set_string( &settings->rom_plus2a_2, optarg ); break;
    case 331: settings_set_string( &settings->rom_plus2a_3, optarg ); break;
    case 332: settings_set_string( &settings->rom_plus3_0, optarg ); break;
    case 333: settings_set_string( &settings->rom_plus3_1, optarg ); break;
    case 334: settings_set_string( &settings->rom_plus3_2, optarg ); break;
    case 335: settings_set_string( &settings->rom_plus3_3, optarg ); break;
    case 336: settings_set_string( &settings->rom_plus3e_0, optarg ); break;
    case 337: settings_set_string( &settings->rom_plus3e_1, optarg ); break;
    case 338: settings_set_string( &settings->rom_plus3e_2, optarg ); break;
    case 339: settings_set_string( &settings->rom_plus3e_3, optarg ); break;
    case 340: settings_set_string( &settings->rom_plusd, optarg ); break;
    case 341: settings_set_string( &settings->rom_scorpion_0, optarg ); break;
    case 342: settings_set_string( &settings->rom_scorpion_1, optarg ); break;
    case 343: settings_set_string( &settings->rom_scorpion_2, optarg ); break;
    case 344: settings_set_string( &settings->rom_scorpion_3, optarg ); break;
    case 345: settings_set_string( &settings->rom_spec_se_0, optarg ); break;
    case 346: settings_set_string( &settings->rom_spec_se_1, optarg ); break;
    case 347: settings_set_string( &settings->rom_tc2048, optarg ); break;
    case 348: settings_set_string( &settings->rom_tc2068_0, optarg ); break;
    case 349: settings_set_string( &settings->rom_tc2068_1, optarg ); break;
    case 350: settings_set_string( &settings->rom_ts2068_0, optarg ); break;
    case 351: settings_set_string( &settings->rom_ts2068_1, optarg ); break;
    case 352: settings_set_string( &settings->rs232_rx, optarg ); break;
    case 353: settings_set_string( &settings->rs232_tx, optarg ); break;
    case 354: settings_set_string( &settings->simpleide_master_file, optarg ); break;
    case 355: settings_set_string( &settings->simpleide_slave_file, optarg ); break;
    case 's': settings_set_string( &settings->snapshot, optarg ); break;
    case 357: settings_set_string( &settings->snet, optarg ); break;
    case 'd': settings_set_string( &settings->sound_device, optarg ); break;
    case 'f': settings->sound_freq = atoi( optarg ); break;
    case 'm': settings_set_string( &settings->start_machine, optarg ); break;
    case 'g': settings_set_string( &settings->start_scaler_mode, optarg ); break;
    case 'v': settings->svga_mode = atoi( optarg ); break;
    case 't': settings_set_string( &settings->tape_file, optarg ); break;
    case 358: settings_set_string( &settings->zxatasp_master_file, optarg ); break;
    case 359: settings_set_string( &settings->zxatasp_slave_file, optarg ); break;
    case 360: settings_set_string( &settings->zxcf_pri_file, optarg ); break;
#line 413"../settings.pl"

    case 'h': settings->show_help = 1; break;
    case 'V': settings->show_version = 1; break;

    case ':':
    case '?':
      break;

    default:
      fprintf( stderr, "%s: getopt_long returned `%c'\n",
	       fuse_progname, (char)c );
      break;

    }
  }

  /* Store the location of the first non-option argument */
  *first_arg = optind;

  return 0;
}

/* Copy one settings object to another */
static int
settings_copy_internal( settings_info *dest, settings_info *src )
{
  if( dest->start_machine ) {
    free( dest->start_machine );
    dest->start_machine = NULL;
  }
  if( dest->start_scaler_mode ) {
    free( dest->start_scaler_mode );
    dest->start_scaler_mode = NULL;
  }

  dest->accelerate_loader = src->accelerate_loader;
  dest->aspect_hint = src->aspect_hint;
  dest->auto_load = src->auto_load;
  dest->autosave_settings = src->autosave_settings;
  dest->beta128 = src->beta128;
  dest->betadisk_file = NULL;
  if( src->betadisk_file ) {
    dest->betadisk_file = strdup( src->betadisk_file );
    if( !dest->betadisk_file ) { settings_free( dest ); return 1; }
  }
  dest->bw_tv = src->bw_tv;
  dest->competition_code = src->competition_code;
  dest->competition_mode = src->competition_mode;
  dest->confirm_actions = src->confirm_actions;
  dest->dck_file = NULL;
  if( src->dck_file ) {
    dest->dck_file = strdup( src->dck_file );
    if( !dest->dck_file ) { settings_free( dest ); return 1; }
  }
  dest->debugger_command = NULL;
  if( src->debugger_command ) {
    dest->debugger_command = strdup( src->debugger_command );
    if( !dest->debugger_command ) { settings_free( dest ); return 1; }
  }
  dest->detect_loader = src->detect_loader;
  dest->divide_enabled = src->divide_enabled;
  dest->divide_master_file = NULL;
  if( src->divide_master_file ) {
    dest->divide_master_file = strdup( src->divide_master_file );
    if( !dest->divide_master_file ) { settings_free( dest ); return 1; }
  }
  dest->divide_slave_file = NULL;
  if( src->divide_slave_file ) {
    dest->divide_slave_file = strdup( src->divide_slave_file );
    if( !dest->divide_slave_file ) { settings_free( dest ); return 1; }
  }
  dest->divide_wp = src->divide_wp;
  dest->doublescan_mode = src->doublescan_mode;
  dest->embed_snapshot = src->embed_snapshot;
  dest->emulation_speed = src->emulation_speed;
  dest->fastload = src->fastload;
  dest->frame_rate = src->frame_rate;
  dest->full_screen = src->full_screen;
  dest->if2_file = NULL;
  if( src->if2_file ) {
    dest->if2_file = strdup( src->if2_file );
    if( !dest->if2_file ) { settings_free( dest ); return 1; }
  }
  dest->interface1 = src->interface1;
  dest->interface2 = src->interface2;
  dest->issue2 = src->issue2;
  dest->joy_kempston = src->joy_kempston;
  dest->joy_prompt = src->joy_prompt;
  dest->joystick_1 = NULL;
  if( src->joystick_1 ) {
    dest->joystick_1 = strdup( src->joystick_1 );
    if( !dest->joystick_1 ) { settings_free( dest ); return 1; }
  }
  dest->joystick_1_fire_1 = src->joystick_1_fire_1;
  dest->joystick_1_fire_10 = src->joystick_1_fire_10;
  dest->joystick_1_fire_2 = src->joystick_1_fire_2;
  dest->joystick_1_fire_3 = src->joystick_1_fire_3;
  dest->joystick_1_fire_4 = src->joystick_1_fire_4;
  dest->joystick_1_fire_5 = src->joystick_1_fire_5;
  dest->joystick_1_fire_6 = src->joystick_1_fire_6;
  dest->joystick_1_fire_7 = src->joystick_1_fire_7;
  dest->joystick_1_fire_8 = src->joystick_1_fire_8;
  dest->joystick_1_fire_9 = src->joystick_1_fire_9;
  dest->joystick_1_output = src->joystick_1_output;
  dest->joystick_2 = NULL;
  if( src->joystick_2 ) {
    dest->joystick_2 = strdup( src->joystick_2 );
    if( !dest->joystick_2 ) { settings_free( dest ); return 1; }
  }
  dest->joystick_2_fire_1 = src->joystick_2_fire_1;
  dest->joystick_2_fire_10 = src->joystick_2_fire_10;
  dest->joystick_2_fire_2 = src->joystick_2_fire_2;
  dest->joystick_2_fire_3 = src->joystick_2_fire_3;
  dest->joystick_2_fire_4 = src->joystick_2_fire_4;
  dest->joystick_2_fire_5 = src->joystick_2_fire_5;
  dest->joystick_2_fire_6 = src->joystick_2_fire_6;
  dest->joystick_2_fire_7 = src->joystick_2_fire_7;
  dest->joystick_2_fire_8 = src->joystick_2_fire_8;
  dest->joystick_2_fire_9 = src->joystick_2_fire_9;
  dest->joystick_2_output = src->joystick_2_output;
  dest->joystick_keyboard_down = src->joystick_keyboard_down;
  dest->joystick_keyboard_fire = src->joystick_keyboard_fire;
  dest->joystick_keyboard_left = src->joystick_keyboard_left;
  dest->joystick_keyboard_output = src->joystick_keyboard_output;
  dest->joystick_keyboard_right = src->joystick_keyboard_right;
  dest->joystick_keyboard_up = src->joystick_keyboard_up;
  dest->kempston_mouse = src->kempston_mouse;
  dest->late_timings = src->late_timings;
  dest->mdr_file = NULL;
  if( src->mdr_file ) {
    dest->mdr_file = strdup( src->mdr_file );
    if( !dest->mdr_file ) { settings_free( dest ); return 1; }
  }
  dest->mdr_file2 = NULL;
  if( src->mdr_file2 ) {
    dest->mdr_file2 = strdup( src->mdr_file2 );
    if( !dest->mdr_file2 ) { settings_free( dest ); return 1; }
  }
  dest->mdr_file3 = NULL;
  if( src->mdr_file3 ) {
    dest->mdr_file3 = strdup( src->mdr_file3 );
    if( !dest->mdr_file3 ) { settings_free( dest ); return 1; }
  }
  dest->mdr_file4 = NULL;
  if( src->mdr_file4 ) {
    dest->mdr_file4 = strdup( src->mdr_file4 );
    if( !dest->mdr_file4 ) { settings_free( dest ); return 1; }
  }
  dest->mdr_file5 = NULL;
  if( src->mdr_file5 ) {
    dest->mdr_file5 = strdup( src->mdr_file5 );
    if( !dest->mdr_file5 ) { settings_free( dest ); return 1; }
  }
  dest->mdr_file6 = NULL;
  if( src->mdr_file6 ) {
    dest->mdr_file6 = strdup( src->mdr_file6 );
    if( !dest->mdr_file6 ) { settings_free( dest ); return 1; }
  }
  dest->mdr_file7 = NULL;
  if( src->mdr_file7 ) {
    dest->mdr_file7 = strdup( src->mdr_file7 );
    if( !dest->mdr_file7 ) { settings_free( dest ); return 1; }
  }
  dest->mdr_file8 = NULL;
  if( src->mdr_file8 ) {
    dest->mdr_file8 = strdup( src->mdr_file8 );
    if( !dest->mdr_file8 ) { settings_free( dest ); return 1; }
  }
  dest->mdr_len = src->mdr_len;
  dest->mdr_random_len = src->mdr_random_len;
  dest->pal_tv2x = src->pal_tv2x;
  dest->playback_file = NULL;
  if( src->playback_file ) {
    dest->playback_file = strdup( src->playback_file );
    if( !dest->playback_file ) { settings_free( dest ); return 1; }
  }
  dest->plus3disk_file = NULL;
  if( src->plus3disk_file ) {
    dest->plus3disk_file = strdup( src->plus3disk_file );
    if( !dest->plus3disk_file ) { settings_free( dest ); return 1; }
  }
  dest->plusd = src->plusd;
  dest->plusddisk_file = NULL;
  if( src->plusddisk_file ) {
    dest->plusddisk_file = strdup( src->plusddisk_file );
    if( !dest->plusddisk_file ) { settings_free( dest ); return 1; }
  }
  dest->printer = src->printer;
  dest->printer_graphics_filename = NULL;
  if( src->printer_graphics_filename ) {
    dest->printer_graphics_filename = strdup( src->printer_graphics_filename );
    if( !dest->printer_graphics_filename ) { settings_free( dest ); return 1; }
  }
  dest->printer_text_filename = NULL;
  if( src->printer_text_filename ) {
    dest->printer_text_filename = strdup( src->printer_text_filename );
    if( !dest->printer_text_filename ) { settings_free( dest ); return 1; }
  }
  dest->raw_s_net = src->raw_s_net;
  dest->record_file = NULL;
  if( src->record_file ) {
    dest->record_file = strdup( src->record_file );
    if( !dest->record_file ) { settings_free( dest ); return 1; }
  }
  dest->rom_128_0 = NULL;
  if( src->rom_128_0 ) {
    dest->rom_128_0 = strdup( src->rom_128_0 );
    if( !dest->rom_128_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_128_1 = NULL;
  if( src->rom_128_1 ) {
    dest->rom_128_1 = strdup( src->rom_128_1 );
    if( !dest->rom_128_1 ) { settings_free( dest ); return 1; }
  }
  dest->rom_16 = NULL;
  if( src->rom_16 ) {
    dest->rom_16 = strdup( src->rom_16 );
    if( !dest->rom_16 ) { settings_free( dest ); return 1; }
  }
  dest->rom_48 = NULL;
  if( src->rom_48 ) {
    dest->rom_48 = strdup( src->rom_48 );
    if( !dest->rom_48 ) { settings_free( dest ); return 1; }
  }
  dest->rom_beta128 = NULL;
  if( src->rom_beta128 ) {
    dest->rom_beta128 = strdup( src->rom_beta128 );
    if( !dest->rom_beta128 ) { settings_free( dest ); return 1; }
  }
  dest->rom_interface_i = NULL;
  if( src->rom_interface_i ) {
    dest->rom_interface_i = strdup( src->rom_interface_i );
    if( !dest->rom_interface_i ) { settings_free( dest ); return 1; }
  }
  dest->rom_pentagon1024_0 = NULL;
  if( src->rom_pentagon1024_0 ) {
    dest->rom_pentagon1024_0 = strdup( src->rom_pentagon1024_0 );
    if( !dest->rom_pentagon1024_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_pentagon1024_1 = NULL;
  if( src->rom_pentagon1024_1 ) {
    dest->rom_pentagon1024_1 = strdup( src->rom_pentagon1024_1 );
    if( !dest->rom_pentagon1024_1 ) { settings_free( dest ); return 1; }
  }
  dest->rom_pentagon1024_2 = NULL;
  if( src->rom_pentagon1024_2 ) {
    dest->rom_pentagon1024_2 = strdup( src->rom_pentagon1024_2 );
    if( !dest->rom_pentagon1024_2 ) { settings_free( dest ); return 1; }
  }
  dest->rom_pentagon1024_3 = NULL;
  if( src->rom_pentagon1024_3 ) {
    dest->rom_pentagon1024_3 = strdup( src->rom_pentagon1024_3 );
    if( !dest->rom_pentagon1024_3 ) { settings_free( dest ); return 1; }
  }
  dest->rom_pentagon512_0 = NULL;
  if( src->rom_pentagon512_0 ) {
    dest->rom_pentagon512_0 = strdup( src->rom_pentagon512_0 );
    if( !dest->rom_pentagon512_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_pentagon512_1 = NULL;
  if( src->rom_pentagon512_1 ) {
    dest->rom_pentagon512_1 = strdup( src->rom_pentagon512_1 );
    if( !dest->rom_pentagon512_1 ) { settings_free( dest ); return 1; }
  }
  dest->rom_pentagon512_2 = NULL;
  if( src->rom_pentagon512_2 ) {
    dest->rom_pentagon512_2 = strdup( src->rom_pentagon512_2 );
    if( !dest->rom_pentagon512_2 ) { settings_free( dest ); return 1; }
  }
  dest->rom_pentagon512_3 = NULL;
  if( src->rom_pentagon512_3 ) {
    dest->rom_pentagon512_3 = strdup( src->rom_pentagon512_3 );
    if( !dest->rom_pentagon512_3 ) { settings_free( dest ); return 1; }
  }
  dest->rom_pentagon_0 = NULL;
  if( src->rom_pentagon_0 ) {
    dest->rom_pentagon_0 = strdup( src->rom_pentagon_0 );
    if( !dest->rom_pentagon_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_pentagon_1 = NULL;
  if( src->rom_pentagon_1 ) {
    dest->rom_pentagon_1 = strdup( src->rom_pentagon_1 );
    if( !dest->rom_pentagon_1 ) { settings_free( dest ); return 1; }
  }
  dest->rom_pentagon_2 = NULL;
  if( src->rom_pentagon_2 ) {
    dest->rom_pentagon_2 = strdup( src->rom_pentagon_2 );
    if( !dest->rom_pentagon_2 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus2_0 = NULL;
  if( src->rom_plus2_0 ) {
    dest->rom_plus2_0 = strdup( src->rom_plus2_0 );
    if( !dest->rom_plus2_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus2_1 = NULL;
  if( src->rom_plus2_1 ) {
    dest->rom_plus2_1 = strdup( src->rom_plus2_1 );
    if( !dest->rom_plus2_1 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus2a_0 = NULL;
  if( src->rom_plus2a_0 ) {
    dest->rom_plus2a_0 = strdup( src->rom_plus2a_0 );
    if( !dest->rom_plus2a_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus2a_1 = NULL;
  if( src->rom_plus2a_1 ) {
    dest->rom_plus2a_1 = strdup( src->rom_plus2a_1 );
    if( !dest->rom_plus2a_1 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus2a_2 = NULL;
  if( src->rom_plus2a_2 ) {
    dest->rom_plus2a_2 = strdup( src->rom_plus2a_2 );
    if( !dest->rom_plus2a_2 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus2a_3 = NULL;
  if( src->rom_plus2a_3 ) {
    dest->rom_plus2a_3 = strdup( src->rom_plus2a_3 );
    if( !dest->rom_plus2a_3 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus3_0 = NULL;
  if( src->rom_plus3_0 ) {
    dest->rom_plus3_0 = strdup( src->rom_plus3_0 );
    if( !dest->rom_plus3_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus3_1 = NULL;
  if( src->rom_plus3_1 ) {
    dest->rom_plus3_1 = strdup( src->rom_plus3_1 );
    if( !dest->rom_plus3_1 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus3_2 = NULL;
  if( src->rom_plus3_2 ) {
    dest->rom_plus3_2 = strdup( src->rom_plus3_2 );
    if( !dest->rom_plus3_2 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus3_3 = NULL;
  if( src->rom_plus3_3 ) {
    dest->rom_plus3_3 = strdup( src->rom_plus3_3 );
    if( !dest->rom_plus3_3 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus3e_0 = NULL;
  if( src->rom_plus3e_0 ) {
    dest->rom_plus3e_0 = strdup( src->rom_plus3e_0 );
    if( !dest->rom_plus3e_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus3e_1 = NULL;
  if( src->rom_plus3e_1 ) {
    dest->rom_plus3e_1 = strdup( src->rom_plus3e_1 );
    if( !dest->rom_plus3e_1 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus3e_2 = NULL;
  if( src->rom_plus3e_2 ) {
    dest->rom_plus3e_2 = strdup( src->rom_plus3e_2 );
    if( !dest->rom_plus3e_2 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plus3e_3 = NULL;
  if( src->rom_plus3e_3 ) {
    dest->rom_plus3e_3 = strdup( src->rom_plus3e_3 );
    if( !dest->rom_plus3e_3 ) { settings_free( dest ); return 1; }
  }
  dest->rom_plusd = NULL;
  if( src->rom_plusd ) {
    dest->rom_plusd = strdup( src->rom_plusd );
    if( !dest->rom_plusd ) { settings_free( dest ); return 1; }
  }
  dest->rom_scorpion_0 = NULL;
  if( src->rom_scorpion_0 ) {
    dest->rom_scorpion_0 = strdup( src->rom_scorpion_0 );
    if( !dest->rom_scorpion_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_scorpion_1 = NULL;
  if( src->rom_scorpion_1 ) {
    dest->rom_scorpion_1 = strdup( src->rom_scorpion_1 );
    if( !dest->rom_scorpion_1 ) { settings_free( dest ); return 1; }
  }
  dest->rom_scorpion_2 = NULL;
  if( src->rom_scorpion_2 ) {
    dest->rom_scorpion_2 = strdup( src->rom_scorpion_2 );
    if( !dest->rom_scorpion_2 ) { settings_free( dest ); return 1; }
  }
  dest->rom_scorpion_3 = NULL;
  if( src->rom_scorpion_3 ) {
    dest->rom_scorpion_3 = strdup( src->rom_scorpion_3 );
    if( !dest->rom_scorpion_3 ) { settings_free( dest ); return 1; }
  }
  dest->rom_spec_se_0 = NULL;
  if( src->rom_spec_se_0 ) {
    dest->rom_spec_se_0 = strdup( src->rom_spec_se_0 );
    if( !dest->rom_spec_se_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_spec_se_1 = NULL;
  if( src->rom_spec_se_1 ) {
    dest->rom_spec_se_1 = strdup( src->rom_spec_se_1 );
    if( !dest->rom_spec_se_1 ) { settings_free( dest ); return 1; }
  }
  dest->rom_tc2048 = NULL;
  if( src->rom_tc2048 ) {
    dest->rom_tc2048 = strdup( src->rom_tc2048 );
    if( !dest->rom_tc2048 ) { settings_free( dest ); return 1; }
  }
  dest->rom_tc2068_0 = NULL;
  if( src->rom_tc2068_0 ) {
    dest->rom_tc2068_0 = strdup( src->rom_tc2068_0 );
    if( !dest->rom_tc2068_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_tc2068_1 = NULL;
  if( src->rom_tc2068_1 ) {
    dest->rom_tc2068_1 = strdup( src->rom_tc2068_1 );
    if( !dest->rom_tc2068_1 ) { settings_free( dest ); return 1; }
  }
  dest->rom_ts2068_0 = NULL;
  if( src->rom_ts2068_0 ) {
    dest->rom_ts2068_0 = strdup( src->rom_ts2068_0 );
    if( !dest->rom_ts2068_0 ) { settings_free( dest ); return 1; }
  }
  dest->rom_ts2068_1 = NULL;
  if( src->rom_ts2068_1 ) {
    dest->rom_ts2068_1 = strdup( src->rom_ts2068_1 );
    if( !dest->rom_ts2068_1 ) { settings_free( dest ); return 1; }
  }
  dest->rs232_handshake = src->rs232_handshake;
  dest->rs232_rx = NULL;
  if( src->rs232_rx ) {
    dest->rs232_rx = strdup( src->rs232_rx );
    if( !dest->rs232_rx ) { settings_free( dest ); return 1; }
  }
  dest->rs232_tx = NULL;
  if( src->rs232_tx ) {
    dest->rs232_tx = strdup( src->rs232_tx );
    if( !dest->rs232_tx ) { settings_free( dest ); return 1; }
  }
  dest->rzx_autosaves = src->rzx_autosaves;
  dest->rzx_compression = src->rzx_compression;
  dest->simpleide_active = src->simpleide_active;
  dest->simpleide_master_file = NULL;
  if( src->simpleide_master_file ) {
    dest->simpleide_master_file = strdup( src->simpleide_master_file );
    if( !dest->simpleide_master_file ) { settings_free( dest ); return 1; }
  }
  dest->simpleide_slave_file = NULL;
  if( src->simpleide_slave_file ) {
    dest->simpleide_slave_file = strdup( src->simpleide_slave_file );
    if( !dest->simpleide_slave_file ) { settings_free( dest ); return 1; }
  }
  dest->slt_traps = src->slt_traps;
  dest->snapshot = NULL;
  if( src->snapshot ) {
    dest->snapshot = strdup( src->snapshot );
    if( !dest->snapshot ) { settings_free( dest ); return 1; }
  }
  dest->snet = NULL;
  if( src->snet ) {
    dest->snet = strdup( src->snet );
    if( !dest->snet ) { settings_free( dest ); return 1; }
  }
  dest->sound = src->sound;
  dest->sound_device = NULL;
  if( src->sound_device ) {
    dest->sound_device = strdup( src->sound_device );
    if( !dest->sound_device ) { settings_free( dest ); return 1; }
  }
  dest->sound_force_8bit = src->sound_force_8bit;
  dest->sound_freq = src->sound_freq;
  dest->sound_hifi = src->sound_hifi;
  dest->sound_load = src->sound_load;
  dest->start_machine = NULL;
  if( src->start_machine ) {
    dest->start_machine = strdup( src->start_machine );
    if( !dest->start_machine ) { settings_free( dest ); return 1; }
  }
  dest->start_scaler_mode = NULL;
  if( src->start_scaler_mode ) {
    dest->start_scaler_mode = strdup( src->start_scaler_mode );
    if( !dest->start_scaler_mode ) { settings_free( dest ); return 1; }
  }
  dest->statusbar = src->statusbar;
  dest->stereo_ay = src->stereo_ay;
  dest->stereo_beeper = src->stereo_beeper;
  dest->strict_aspect_hint = src->strict_aspect_hint;
  dest->svga_mode = src->svga_mode;
  dest->tape_file = NULL;
  if( src->tape_file ) {
    dest->tape_file = strdup( src->tape_file );
    if( !dest->tape_file ) { settings_free( dest ); return 1; }
  }
  dest->tape_traps = src->tape_traps;
  dest->unittests = src->unittests;
  dest->writable_roms = src->writable_roms;
  dest->zxatasp_active = src->zxatasp_active;
  dest->zxatasp_master_file = NULL;
  if( src->zxatasp_master_file ) {
    dest->zxatasp_master_file = strdup( src->zxatasp_master_file );
    if( !dest->zxatasp_master_file ) { settings_free( dest ); return 1; }
  }
  dest->zxatasp_slave_file = NULL;
  if( src->zxatasp_slave_file ) {
    dest->zxatasp_slave_file = strdup( src->zxatasp_slave_file );
    if( !dest->zxatasp_slave_file ) { settings_free( dest ); return 1; }
  }
  dest->zxatasp_upload = src->zxatasp_upload;
  dest->zxatasp_wp = src->zxatasp_wp;
  dest->zxcf_active = src->zxcf_active;
  dest->zxcf_pri_file = NULL;
  if( src->zxcf_pri_file ) {
    dest->zxcf_pri_file = strdup( src->zxcf_pri_file );
    if( !dest->zxcf_pri_file ) { settings_free( dest ); return 1; }
  }
  dest->zxcf_upload = src->zxcf_upload;
#line 468"../settings.pl"

  return 0;
}

/* Copy one settings object to another */
int settings_copy( settings_info *dest, settings_info *src )
{
  if( settings_defaults( dest ) ) return 1;
  return settings_copy_internal( dest, src );
}

char **
settings_get_rom_setting( settings_info *settings, size_t which )
{
  switch( which ) {
  case  0: return &( settings->rom_16       );
  case  1: return &( settings->rom_48       );
  case  2: return &( settings->rom_128_0    );
  case  3: return &( settings->rom_128_1    );
  case  4: return &( settings->rom_plus2_0  );
  case  5: return &( settings->rom_plus2_1  );
  case  6: return &( settings->rom_plus2a_0 );
  case  7: return &( settings->rom_plus2a_1 );
  case  8: return &( settings->rom_plus2a_2 );
  case  9: return &( settings->rom_plus2a_3 );
  case 10: return &( settings->rom_plus3_0  );
  case 11: return &( settings->rom_plus3_1  );
  case 12: return &( settings->rom_plus3_2  );
  case 13: return &( settings->rom_plus3_3  );
  case 14: return &( settings->rom_plus3e_0 );
  case 15: return &( settings->rom_plus3e_1 );
  case 16: return &( settings->rom_plus3e_2 );
  case 17: return &( settings->rom_plus3e_3 );
  case 18: return &( settings->rom_tc2048   );
  case 19: return &( settings->rom_tc2068_0 );
  case 20: return &( settings->rom_tc2068_1 );
  case 21: return &( settings->rom_ts2068_0 );
  case 22: return &( settings->rom_ts2068_1 );
  case 23: return &( settings->rom_pentagon_0 );
  case 24: return &( settings->rom_pentagon_1 );
  case 25: return &( settings->rom_pentagon_2 );
  case 26: return &( settings->rom_pentagon512_0 );
  case 27: return &( settings->rom_pentagon512_1 );
  case 28: return &( settings->rom_pentagon512_2 );
  case 29: return &( settings->rom_pentagon512_3 );
  case 30: return &( settings->rom_pentagon1024_0 );
  case 31: return &( settings->rom_pentagon1024_1 );
  case 32: return &( settings->rom_pentagon1024_2 );
  case 33: return &( settings->rom_pentagon1024_3 );
  case 34: return &( settings->rom_scorpion_0 );
  case 35: return &( settings->rom_scorpion_1 );
  case 36: return &( settings->rom_scorpion_2 );
  case 37: return &( settings->rom_scorpion_3 );
  case 38: return &( settings->rom_spec_se_0 );
  case 39: return &( settings->rom_spec_se_1 );
  case 40: return &( settings->rom_interface_i );
  case 41: return &( settings->rom_beta128 );
  case 42: return &( settings->rom_plusd );
  default: return NULL;
  }
}

int
settings_set_string( char **string_setting, const char *value )
{
  /* No need to do anything if the two strings are in fact the
     same pointer */
  if( *string_setting == value ) return 0;

  if( *string_setting) free( *string_setting );
  *string_setting = strdup( value );
  if( !( *string_setting ) ) {
    ui_error( UI_ERROR_ERROR, "out of memory at %s:%d", __FILE__, __LINE__ );
    return 1;
  }

  return 0;
}

int
settings_free( settings_info *settings )
{
  if( settings->betadisk_file ) free( settings->betadisk_file );
  if( settings->dck_file ) free( settings->dck_file );
  if( settings->debugger_command ) free( settings->debugger_command );
  if( settings->divide_master_file ) free( settings->divide_master_file );
  if( settings->divide_slave_file ) free( settings->divide_slave_file );
  if( settings->if2_file ) free( settings->if2_file );
  if( settings->joystick_1 ) free( settings->joystick_1 );
  if( settings->joystick_2 ) free( settings->joystick_2 );
  if( settings->mdr_file ) free( settings->mdr_file );
  if( settings->mdr_file2 ) free( settings->mdr_file2 );
  if( settings->mdr_file3 ) free( settings->mdr_file3 );
  if( settings->mdr_file4 ) free( settings->mdr_file4 );
  if( settings->mdr_file5 ) free( settings->mdr_file5 );
  if( settings->mdr_file6 ) free( settings->mdr_file6 );
  if( settings->mdr_file7 ) free( settings->mdr_file7 );
  if( settings->mdr_file8 ) free( settings->mdr_file8 );
  if( settings->playback_file ) free( settings->playback_file );
  if( settings->plus3disk_file ) free( settings->plus3disk_file );
  if( settings->plusddisk_file ) free( settings->plusddisk_file );
  if( settings->printer_graphics_filename ) free( settings->printer_graphics_filename );
  if( settings->printer_text_filename ) free( settings->printer_text_filename );
  if( settings->record_file ) free( settings->record_file );
  if( settings->rom_128_0 ) free( settings->rom_128_0 );
  if( settings->rom_128_1 ) free( settings->rom_128_1 );
  if( settings->rom_16 ) free( settings->rom_16 );
  if( settings->rom_48 ) free( settings->rom_48 );
  if( settings->rom_beta128 ) free( settings->rom_beta128 );
  if( settings->rom_interface_i ) free( settings->rom_interface_i );
  if( settings->rom_pentagon1024_0 ) free( settings->rom_pentagon1024_0 );
  if( settings->rom_pentagon1024_1 ) free( settings->rom_pentagon1024_1 );
  if( settings->rom_pentagon1024_2 ) free( settings->rom_pentagon1024_2 );
  if( settings->rom_pentagon1024_3 ) free( settings->rom_pentagon1024_3 );
  if( settings->rom_pentagon512_0 ) free( settings->rom_pentagon512_0 );
  if( settings->rom_pentagon512_1 ) free( settings->rom_pentagon512_1 );
  if( settings->rom_pentagon512_2 ) free( settings->rom_pentagon512_2 );
  if( settings->rom_pentagon512_3 ) free( settings->rom_pentagon512_3 );
  if( settings->rom_pentagon_0 ) free( settings->rom_pentagon_0 );
  if( settings->rom_pentagon_1 ) free( settings->rom_pentagon_1 );
  if( settings->rom_pentagon_2 ) free( settings->rom_pentagon_2 );
  if( settings->rom_plus2_0 ) free( settings->rom_plus2_0 );
  if( settings->rom_plus2_1 ) free( settings->rom_plus2_1 );
  if( settings->rom_plus2a_0 ) free( settings->rom_plus2a_0 );
  if( settings->rom_plus2a_1 ) free( settings->rom_plus2a_1 );
  if( settings->rom_plus2a_2 ) free( settings->rom_plus2a_2 );
  if( settings->rom_plus2a_3 ) free( settings->rom_plus2a_3 );
  if( settings->rom_plus3_0 ) free( settings->rom_plus3_0 );
  if( settings->rom_plus3_1 ) free( settings->rom_plus3_1 );
  if( settings->rom_plus3_2 ) free( settings->rom_plus3_2 );
  if( settings->rom_plus3_3 ) free( settings->rom_plus3_3 );
  if( settings->rom_plus3e_0 ) free( settings->rom_plus3e_0 );
  if( settings->rom_plus3e_1 ) free( settings->rom_plus3e_1 );
  if( settings->rom_plus3e_2 ) free( settings->rom_plus3e_2 );
  if( settings->rom_plus3e_3 ) free( settings->rom_plus3e_3 );
  if( settings->rom_plusd ) free( settings->rom_plusd );
  if( settings->rom_scorpion_0 ) free( settings->rom_scorpion_0 );
  if( settings->rom_scorpion_1 ) free( settings->rom_scorpion_1 );
  if( settings->rom_scorpion_2 ) free( settings->rom_scorpion_2 );
  if( settings->rom_scorpion_3 ) free( settings->rom_scorpion_3 );
  if( settings->rom_spec_se_0 ) free( settings->rom_spec_se_0 );
  if( settings->rom_spec_se_1 ) free( settings->rom_spec_se_1 );
  if( settings->rom_tc2048 ) free( settings->rom_tc2048 );
  if( settings->rom_tc2068_0 ) free( settings->rom_tc2068_0 );
  if( settings->rom_tc2068_1 ) free( settings->rom_tc2068_1 );
  if( settings->rom_ts2068_0 ) free( settings->rom_ts2068_0 );
  if( settings->rom_ts2068_1 ) free( settings->rom_ts2068_1 );
  if( settings->rs232_rx ) free( settings->rs232_rx );
  if( settings->rs232_tx ) free( settings->rs232_tx );
  if( settings->simpleide_master_file ) free( settings->simpleide_master_file );
  if( settings->simpleide_slave_file ) free( settings->simpleide_slave_file );
  if( settings->snapshot ) free( settings->snapshot );
  if( settings->snet ) free( settings->snet );
  if( settings->sound_device ) free( settings->sound_device );
  if( settings->start_machine ) free( settings->start_machine );
  if( settings->start_scaler_mode ) free( settings->start_scaler_mode );
  if( settings->tape_file ) free( settings->tape_file );
  if( settings->zxatasp_master_file ) free( settings->zxatasp_master_file );
  if( settings->zxatasp_slave_file ) free( settings->zxatasp_slave_file );
  if( settings->zxcf_pri_file ) free( settings->zxcf_pri_file );
#line 559"../settings.pl"

  return 0;
}

int
settings_end( void )
{
#ifdef HAVE_LIB_XML2
  if( settings_current.autosave_settings )
    settings_write_config( &settings_current );
#endif			/* #ifdef HAVE_LIB_XML2 */

  settings_free( &settings_current );

  return 0;
}
