/*	$Id: smtp-vilter.h,v 1.56 2006/02/17 09:35:14 mbalmer Exp $	*/

/*
 * Copyright (c) 2003, 2004, 2005, 2006 Marc Balmer <marc@msys.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/time.h>

#include <sys/cdefs.h>
#include <stdio.h>
#include <unistd.h>

#define	VERSION	"1.3.2"

#define MAJOR	7	/* Major and minor version number */
#define MINOR	2	/* of shared libs (backends) */

#if __OpenBSD__
#define ENABLE_PF
#endif

#if __FreeBSD__
#include <sys/param.h>
#if (__FreeBSD_version >= 600026)
#define ENABLE_PF
#endif
#endif

/*
 *	The following values define reasons why an email might be rejected.
 */

#define SCAN_OK		0	/* Message is acceptable */
#define SCAN_VIRUS	1	/* Message contains a virus */
#define SCAN_SPAM	2	/* Message is considered spam */
#define SCAN_UNWANTED	3	/* Unwanted content, eg. attachement */
				/* of a certain type */
#define SCAN_ERROR 	-1

#define MAX_TIMEOUT	86400LL	/* max timeout at exit */

enum strategies {
	STRATEGY_UNSET	= -1,
	STRATEGY_DISCARD,
	STRATEGY_MARK,
	STRATEGY_NOTIFY_RECIPIENT,
	STRATEGY_TEMPFAIL,
	STRATEGY_REJECT,
	STRATEGY_IGNORE
};

/* Backend capabilities */

#define BE_SCAN_VIRUS		0x0001
#define BE_SCAN_SPAM		0x0002
#define BE_SCAN_UNWANTED	0x0004
#define BE_SCAN_PER_RCPT	0x0008

struct backend {
	char	*name;
	char	*config_file;
	void	*dlhandle;
	int	 type;
	int	 (*be_init)(char *);	/* One time initialization */
	char	*(*be_name)(void);
	int	 (*be_type)(void);
	int	 (*be_envfrom)(char *, FILE *);
	union {
		int (*be_scan_virus)(char *, size_t, char *, char *, size_t);
		int (*be_scan_spam)(char *, size_t, char *, double *, double *);
		int (*be_scan_unwanted)(char *, size_t, char *, char *, size_t);
	} be_scan;
	void	 (*be_exit)(void);
};

#define SOCK_BUFSIZE	1024

typedef struct _SOCK {
	int	 sock;	
	char	 buf[SOCK_BUFSIZE];
	int	 size;
	char	*pos;
} SOCK;

/* reactions */

enum reactions {
	REACTION_UNSET = -1,
	REACTION_ADDTBL,
	REACTION_DELTBL
};

extern int verbose;

__BEGIN_DECLS
extern SOCK *fdsock(int);
extern ssize_t to_recv(int, void *, size_t, int, struct timeval *);
extern ssize_t to_send(int, const char *, size_t, int, struct timeval *);
extern int to_readc(SOCK *, char *, struct timeval *);
extern ssize_t to_readln(char *, int, SOCK *, struct timeval *);
extern int *sputs(const char *, SOCK *, struct timeval *);
extern void sclose(SOCK *);
__END_DECLS
