<?php
/**
 * Implementation for horde user preferences in the Kolab XML format.
 *
 * $Horde: framework/Kolab_Format/lib/Horde/Kolab/Format/XML/hprefs.php,v 1.2.2.3 2008/08/20 20:25:28 wrobel Exp $
 *
 * @package Kolab_Format
 */

/**
 * Kolab XML handler for client preferences.
 *
 * $Horde: framework/Kolab_Format/lib/Horde/Kolab/Format/XML/hprefs.php,v 1.2.2.3 2008/08/20 20:25:28 wrobel Exp $
 *
 * Copyright 2007 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @since   Horde 3.2
 * @author  Gunnar Wrobel <wrobel@pardus.de>
 * @package Kolab_Format
 */
class Horde_Kolab_Format_XML_hprefs extends Horde_Kolab_Format_XML {
    /**
     * Specific data fields for the prefs object
     *
     * @var Kolab
     */
    var $_fields_specific;

    /**
     * Automatically create categories if they are missing?
     *
     * @var boolean
     */
    var $_create_categories = false;

    /**
     * Constructor
     */
    function Horde_Kolab_Format_XML_hprefs()
    {
        $this->_root_name = 'h-prefs';

        /** Specific preferences fields, in kolab format specification order
         */
        $this->_fields_specific = array(
            'pref' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_MULTIPLE,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
                'array'   => array(
                    'type' => HORDE_KOLAB_XML_TYPE_STRING,
                    'value' => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
                ),
            ),
        );

        parent::Horde_Kolab_Format_XML();
    }
}
