/*
    hunter -- ettercap plugin -- Promisc Finder

    Copyright (C) 2003  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#ifdef CYGWIN
   #include <windows.h>
   #include <winsock2.h> 
#else
   #include <sys/time.h>
   #include <unistd.h>
#endif

#include <stdlib.h>

#include "../../src/include/ec_main.h"
#include "../../src/include/ec_version.h"
#include "../../src/include/ec_plugins.h"
#include "../../src/include/ec_inet_structures.h"
#include "../../src/include/ec_inet.h"
#include "../../src/include/ec_inet_forge.h"


// protos...

int Plugin_Init(void *);
int Plugin_Fini(void *);
int hunter(void *dummy);

// plugin operation

struct plugin_ops hunter_ops = {
   ettercap_version: VERSION,
   plug_info:        "Search promisc NICs",
   plug_version:     10,
   plug_type:        PT_EXT,
   hook_point:       HOOK_NONE,
   hook_function:    &hunter,
};

struct recv_packet recvpck;
u_long sock, MyIP;
char   MyMAC[6]; 

//==================================

int Plugin_Init(void *params)
{
   return Plugin_Register(params, &hunter_ops);
}

int Plugin_Fini(void *params)
{
   return 0;
}

void SendProbes(char *DestMAC)
{
   char *to_send;
   int i;

   to_send = recvpck.aligned;
   to_send += Inet_Forge_ethernet(to_send, MyMAC, DestMAC, ETH_P_ARP);
      
   if (!strcmp(Host_Dest.ip, "") )
   {    
      for (i=1; i< number_of_hosts_in_lan; i++)
      {
          usleep(1500);
          Inet_Forge_arp(to_send, ARPOP_REQUEST, MyMAC, MyIP, DestMAC, inet_addr(Host_In_LAN[i].ip));
	  Inet_SendRawPacket(sock, recvpck.aligned, ETH_HEADER + ARP_HEADER);
      }
   }
   else
   {
      Inet_Forge_arp(to_send, ARPOP_REQUEST, MyMAC, MyIP, DestMAC, inet_addr(Host_Dest.ip));
      Inet_SendRawPacket(sock, recvpck.aligned, ETH_HEADER + ARP_HEADER);
   }    
}

// =================================

int hunter(void *dummy)
{
   int len=0, MTU, i, notrecv=1;
   u_long *Hosts;
   ETH_header *eth;
   ARP_header *arp;

   char OddMAC[6]={0xfd, 0xfd, 0x00, 0x00, 0x00, 0x00};
   char PassMAC[6]={0xff, 0xff, 0x00, 0x00, 0x00, 0x00};

   TIME_DECLARE;

   Plugin_Output("Scanning: ");
   if (!strcmp(Host_Dest.ip, "") )
         Plugin_Output("ANY\n");
   else
         Plugin_Output("%s\n", Host_Dest.ip);

   sock = Inet_OpenRawSock(Options.netiface);
   Inet_GetIfaceInfo(Options.netiface, &MTU, MyMAC, &MyIP, NULL);
   Inet_SetNonBlock(sock);

   recvpck.buf = Inet_Forge_packet( MTU + ALIGN_ETH_TO_WORD);
   recvpck.aligned = recvpck.buf + ALIGN_ETH_TO_WORD;

   SendProbes(OddMAC); 
   
   Hosts=calloc(number_of_hosts_in_lan*2,sizeof(u_long));
   
   TIME_START;
   do
   {
       short pkttype;
       len = Inet_GetRawPacket(sock, recvpck.aligned, MTU, &pkttype);
       TIME_FINISH;

       if ( len > 0 && pkttype == PACKET_HOST )
       {
          eth = (ETH_header *) recvpck.aligned;
          if (eth->type == htons(ETH_P_ARP))
          {
             arp = (ARP_header *)(eth+1);
	     
             if ( ntohs(arp->opcode) == ARPOP_REPLY )
	         for (i=0; i<number_of_hosts_in_lan*2-1; i++)
                 {
		     if (Hosts[i]==*(u_int32 *)arp->source_ip) break;
		     
		     if (!Hosts[i])
		     {
		         Hosts[i]=*(u_int32 *)arp->source_ip;
			 break;
		     }
                 }
          }
       }
       else
         if (len <=0 )
            usleep(1500);

   } while(TIME_ELAPSED < 3);

   SendProbes(PassMAC);

   Plugin_Output("\nMost probably sniffing NICs:");
   
   TIME_START;
   do
   {
       short pkttype;
       len = Inet_GetRawPacket(sock, recvpck.aligned, MTU, &pkttype);
       TIME_FINISH;

       if ( len > 0 && pkttype == PACKET_HOST )
       {
          eth = (ETH_header *) recvpck.aligned;
          if (eth->type == htons(ETH_P_ARP))
          {
             arp = (ARP_header *)(eth+1);
	     
             if ( ntohs(arp->opcode) == ARPOP_REPLY )
	         for (i=0; i<number_of_hosts_in_lan*2-1; i++)
                 {
		     if (Hosts[i]==*(u_int32 *)arp->source_ip) break;
		     
		     if (!Hosts[i])
		     {
		         struct in_addr conv;
		         
			 conv.s_addr = *(u_int32 *)arp->source_ip;
			 Plugin_Output("\n- %s",   inet_ntoa(conv));
			 notrecv = 0;
		    	 break;
		     }
                 }
          }
       }
       else
         if (len <=0 )
            usleep(1500);

   } while(TIME_ELAPSED < 3);
   
   if (notrecv)
       Plugin_Output("\n- NONE \n");
   else    
       Plugin_Output("\n");
       
   Plugin_Output("\nLess probably sniffing NICs:");
   
   if (!Hosts[0])
       Plugin_Output("\n- NONE");
   else
   {
       struct in_addr conv;
       for (i=0; Hosts[i]; i++)
       {
           conv.s_addr = Hosts[i];
           Plugin_Output("\n- %s",   inet_ntoa(conv));
       }
   }
   Plugin_Output("\n");
   
   Inet_Forge_packet_destroy( recvpck.buf );
   free(Hosts);
   return 0;
}

/* EOF */
