@ECHO OFF
REM *******************************************************************
REM wininstall.bat
REM
REM Batch file to install edict on windows.
REM
REM Author:	Vishal Verma <vermavee@users.sf.net>
REM Created:	Fri Dec 27 10:58:54 PST 2002
REM *******************************************************************

SET TARGETDIR=c:\windows\system32
IF EXIST %TARGETDIR% GOTO parseargs
SET TARGETDIR=c:\winnt\system32


:parseargs
REM If a target dir wasn't specified, start installing in default dir
IF "%1"=="" GOTO installit

REM target dir was specified, take it into account
SET TARGETDIR=%1

REM See if target dir is an absolute path
ECHO %TARGETDIR% | FIND ":\" > NUL
IF %ERRORLEVEL%==1 GOTO absolutepatherror

REM See if the target dir exists
IF EXIST %TARGETDIR% GOTO installit



:askcreatedir
REM Create the dir
yn yn The directory %TARGETDIR% doesn't exist. Do you want to create it? 
IF %ERRORLEVEL%==0 GOTO ynerror
IF %ERRORLEVEL%==2 GOTO exit
mkdir %TARGETDIR% > NUL
IF NOT %ERRORLEVEL%==0 GOTO exit



:installit
ECHO Installing edict in %TARGETDIR%
COPY /Y edict %TARGETDIR% > NUL
COPY /Y edict %TARGETDIR%\ethes > NUL
IF NOT %ERRORLEVEL%==0 GOTO exit
ECHO @perl %TARGETDIR%\edict %%1 > %TARGETDIR%\edict.bat
ECHO @perl %TARGETDIR%\ethes %%1 > %TARGETDIR%\ethes.bat
ECHO edict successfully installed in %TARGETDIR%

PATH | FIND /I "%TARGETDIR%" > NUL
IF %ERRORLEVEL%==0 GOTO checkperlexist
ECHO You should now modify your PATH to include the dir "%TARGETDIR%".
ECHO Click on the System icon in Control Panel and go to the Advanced tab.
ECHO Click on "Environment Variables..." to edit your PATH.


:checkperlexist
IF EXIST C:\PERL\BIN\PERL.EXE GOTO exit

ECHO+
ECHO Looks like you don't have PERL install on your system. You can
ECHO download PERL from 
ECHO http://www.activestate.com/Products/Download/Download.plex?id=ActivePerl
GOTO exit



:ynerror
REM Invalid option error
ECHO ERROR: Invalid option chosen. Please try again.
GOTO askcreatedir



:absolutepatherror
REM The path specified wasn't absolute
ECHO ERROR: The target path should be absolute path e.g. C:\MY\DIR
GOTO exit



:exit
ECHO You can run edict as:
ECHO     edict ^<word^>
ECHO which will show the meaning(s) of ^<word^>
ECHO You can also run:
ECHO     ethes ^<word^>
ECHO which will show the synonym(s)/antonym(s) for ^<word^>
