/***************************************************************************
                           test.cpp - 
                         ---------------------------
    begin                : Fri Mar 16 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kapp.h>
#include <kdebug.h>
#include <qtimer.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include "ktransfer.h"
#include "test.h"

static const char *description = I18N_NOOP("The KDE MAnager of Get Operations - A download manager.");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	

static KCmdLineOptions options[] = 
{
   { "+[File]", I18N_NOOP("file to open"), 0 },
   { "i ", I18N_NOOP("ID of transfer to start"), 0},
   { 0, 0, 0 }
   // INSERT YOUR COMMANDLINE OPTIONS HERE
};

TestApp::TestApp(const char *file, int id)
{
   init();
   KObject::initFactory();
   _m = KMManager::managerLoad(file, 
			       false, new NotifyChange(this));
   _id = id;
}

void TestApp::init()
{
   _view = new QWidget(this);
   QVBoxLayout *l = new QVBoxLayout(_view, 4);
   
   QPushButton *btn = new QPushButton("Start", _view);
   l->addWidget(btn);
   l->setStretchFactor(btn, 1);
   connect(btn, SIGNAL(clicked()), SLOT(slotStart()));
   btn = new QPushButton("Stop", _view);
   l->addWidget(btn);
   l->setStretchFactor(btn, 1);
   connect(btn, SIGNAL(clicked()), SLOT(slotStop()));
   btn = new QPushButton("Quit", _view);
   l->addWidget(btn);
   l->setStretchFactor(btn, 1);
   connect(btn, SIGNAL(clicked()), SLOT(slotQuit()));
   _text = new QLabel(_view);
   l->addWidget(_text);
   l->setStretchFactor(btn, 10);

   _view->adjustSize();

   setCentralWidget(_view);

   connect(&_timer, SIGNAL(timeout()), SLOT(slotRun()));
   _timer.start(2000);
}

void TestApp::run()
{
   KTransfer t = _m.itemSearch(_id).toTransfer();
   t.start();
}

void TestApp::slotStart() 
{ 
   if (!_m.isRunning())
   {
      run(); 
      //_timer.start(1000);
   }
}

void TestApp::slotStop() 
{ 
   _m.kill(true);
   //_timer.stop();
   _text->setText("");
}

void TestApp::slotQuit() 
{ 
   slotStop();
   close(); 
}

void TestApp::slotRun()
{
   _m.runPeriodically();
   //_m.updateItemsActive();
   //if (!_m.isRunning())
   // QTimer::singleShot(1000, this, SLOT(slotQuit()));
}

void TestApp::slotUpdate(KObject obj)
{
   //kdDebug() << obj.name() << ": " << obj.modString() << endl;
   //kdDebug() << obj.modString() << endl;
   kdDebug() << "XXXXXXXXXX" << endl;
   
   if (_text != 0)
      _text->setText(QString("%1 : %2\n").arg(obj.name()).arg(obj.modString()));

   if (obj.isMod(MDI_REMOVE))
      obj.deleteInstance();
   else
      obj.resetMods();
}

void NotifyChange::operator()(const KObject obj) const 
{
   _app->slotUpdate(obj);
}

int main(int argc, char *argv[]) 
{
   KAboutData aboutData( "kmago", I18N_NOOP("KMago"),
			 VERSION, description, KAboutData::License_GPL,
			 "(c) 2000, Sergio Moretti",
			 0,
			 "http://kmago.sourceforge.net",
			 "sermore@users.sourceforge.net");
   aboutData.addAuthor("Sergio Moretti",0, "sermore@libero.it");
   KCmdLineArgs::init( argc, argv, &aboutData );
   KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

   { 
      KApplication app;
      KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

      int id = 0;
      if (args->isSet("i"))
	 id = args->getOption("i").toInt();
      else
	 return -1;

      TestApp *test = new TestApp(args->arg(0), id);
      test->show();

      args->clear();
      app.exec();
   }

   fprintf(stderr, "fine!\n");
}

#include "test.moc"

/* Local Variables: */
/* mode: c++ */
/* End: */
