/***************************************************************************
                          ktmanagerlistview.h  -  description
                             -------------------
    begin                : Wed Dec 20 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.7 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTMANAGERLISTVIEW_H
#define KTMANAGERLISTVIEW_H

#include <qwidget.h>
#include <klistview.h>
#include <kaction.h>
#include <qdragobject.h>
#include "kcontainerview.h"
#include "ktransfer.h"

class KTManagerListItem;
class KTManagerListDrag;
class KMagoDoc;

/**
 * @short ListView to display @ref KTransfer list.
 *
 * @author Sergio Moretti
 *
 * @version $Id: ktmanagerlistview.h,v 1.7 2001/03/23 17:14:59 sergio Exp $
 */

class KTManagerListView : public KListView, public KContainerView 
{
   Q_OBJECT

public:
   KTManagerListView(KMagoDoc *doc, Callback cb, QWidget *parent, 
		     const char *name = 0);
   virtual ~KTManagerListView();
   virtual const char * name() const { return KListView::name(); }

   //virtual QSize sizeHint() const { return QSize(200, 100); }
   virtual QSize minimumSizeHint() const { return QSize(0, 0); }

   KTManagerListItem * itemFind(KObject item) const;
   virtual void itemAdd(KObject item);
   virtual void itemRemove(KObject item);
   virtual void itemSelect(KObject item);
   virtual void itemUpdate(KObject item);
   virtual void itemUpdateText(KObject item);
   virtual KObject itemFirst() const;
   virtual KObject itemAbove(KObject item) const;
   virtual KObject itemBelow(KObject item) const;
   virtual void clear() { KListView::clear(); }
   virtual void initView();
   virtual void applySettings(KConfig *config);
   virtual void saveSettings(KConfig *config);
   virtual void setSortBy(ModIndex p, bool increasing = true);
   virtual ModIndex sortBy() const { return _sortBy; }
   virtual bool sortDir() const { return _sortDir; }
   int column(int i) const;
   bool showStateStr() const { return _viewStateStr->isChecked(); }
   void setShowStateStr(bool s) { _viewStateStr->setChecked(s); }

protected:
   void initActions();
   virtual QDragObject* dragObject() const;
   virtual bool acceptDrag(QDropEvent *event) const;
   virtual void setSorting (int column, bool increasing = true);

protected slots:
   void slotDropped(QDropEvent *e, QListViewItem *after);
   //void slotExecuted(QListViewItem *item);
   void slotContextMenu(KListView *l, QListViewItem *i, const QPoint &p);
   void slotSelectionChanged(QListViewItem *item);
   void slotInitView();
   void slotShowStateStr();

signals:
   void sigSelectionChanged(KObject item);

private:
   KToggleAction 
      *_viewState,
      *_viewURL,
      *_viewLocal,
      *_viewResuming,
      *_viewPercent,
      *_viewPartial,
      *_viewLen,
      *_viewTime,
      *_viewBand,
      *_viewMBand,
      *_viewID,
      *_viewError,
      *_viewPriority,
      *_viewType,
      *_viewStateStr;
   int _columnMap[14];
   ModIndex _sortBy;
   int _sortByCol;
   bool _sortDir;
   ModIndex _sortIdx[14];
};


/**
 * @short ListView item to display @ref KTransfer.
 *
 * @author Sergio Moretti
 *
 * @version $Id: ktmanagerlistview.h,v 1.7 2001/03/23 17:14:59 sergio Exp $
 */

class KTManagerListItem : public QListViewItem 
{
public:
   KTManagerListItem(KListView *parent, KTransfer tr);
   virtual ~KTManagerListItem() {}
   virtual QString text(int column) const;
   virtual QString key(int column, bool ascending) const;
   KTransfer transfer() const { return t; }
   /** update the icons visualization */
   void update();

protected:
   //void activate();

private:
   KTransfer t;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
