/***************************************************************************
                          ksystrayview.cpp  -  description
                             -------------------
    begin                : Tue Oct 10 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.12 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <qdom.h>
#include <kdebug.h>
#include <klocale.h>
#include <qdragobject.h>
#include <kapp.h>
#include <kmainwindow.h>
#include "kmagodoc.h"
#include "kmagoview.h"
#include "kcontainerview.h"
#include "utils.h"
#include "ksystrayview.h"

KSysTrayView::KSysTrayView(KMagoDoc *doc, QWidget *parent, const char *name )
   : KSystemTray(parent,name), _doc(doc)
{
   //setPixmap(SmallIcon("kmago"));
   updateIcon();
   setAcceptDrops(true);

   KPopupMenu * menu = dynamic_cast<KPopupMenu*>(
      doc->mainWindow()->factory()->container("systray", doc->mainWindow()));
   _titleId = menu->insertTitle( kapp->miniIcon(), doc->mainWindow()->caption(),
				 -1, 0);
   menu->insertSeparator();
   _minimizeId =
      menu->insertItem(i18n("Minimize"), this, SLOT(toggleMinimizeRestore()));
   menu->insertItem(SmallIcon("fileclose"), i18n("&Close"), doc->mainWindow(),
		    SLOT(slotFileClose()));
   menu->insertItem(SmallIcon("exit"), i18n("&Quit"), doc->mainWindow(),
		    SLOT(slotFileQuit()));
}

KSysTrayView::~KSysTrayView()
{
   kdDebug(D_INI) << name() << ": destroy" << endl;
}

KMagoDoc * KSysTrayView::doc() const
{
   return _doc;
}

void KSysTrayView::updateIcon()
{
   if (doc() && !doc()->manager().isNull() && doc()->manager().isRunning())
      setPixmap(UserIcon("kmago-active"));
   else
      setPixmap(UserIcon("kmago-idle"));
}

void KSysTrayView::updateMenuTitle()
{
   if (isSingleDoc() && !doc()->isTmp())
      contextMenu()->changeTitle(contextMenu()->idAt(0), doc()->currentManager().title());
   else
      contextMenu()->changeTitle(contextMenu()->idAt(0), doc()->title() + " - " + doc()->currentManager().title());
}

void KSysTrayView::dragEnterEvent(QDragEnterEvent *event)
{
   kdDebug() << name() << ": drag enter" << endl;
   event->accept(dynamic_cast<KContainerView*>(event->source()) !=
		 doc()->view()->transferView()
		 && (KContainerView::transferCanDecode(event)));
   //event->accept(QTextDrag::canDecode(event) || QUriDrag::canDecode(event));
}

void KSysTrayView::dropEvent(QDropEvent *event)
{
   kdDebug() << name() << ": drop event " << endl;
   KTManager m =
      (doc()->getListOnDrop() ?
       KContainerView::selectManager(doc()) : doc()->currentManager());
   if (!m.isNull())
      KContainerView::dropTransferList(event, doc(), m);
}

void KSysTrayView::mousePressEvent(QMouseEvent *event)
{
   KPopupMenu * menu =  dynamic_cast<KPopupMenu*>(
      doc()->mainWindow()->factory()->container("systray", doc()->mainWindow()));
   switch ( event->button() )
   {
   case LeftButton:
      if ( parentWidget()->isVisible() )
      {
	 parentWidget()->hide();
      }
      else
      {
	 parentWidget()->show();
	 //KWin::setActiveWindow( parentWidget()->winId() );
      }
      break;
   case MidButton:
      // fall through
   case RightButton:
      if (parentWidget()->isVisible())
	 menu->changeItem(_minimizeId, i18n("Minimize"));
      else
	 menu->changeItem(_minimizeId, i18n("Restore"));
      menu->changeTitle(_titleId, kapp->miniIcon(), doc()->currentManager().title() + " - " + kapp->caption());
      menu->exec(mapToGlobal(event->pos()));
      break;
   default:
      break;
   }
}

#include "ksystrayview.moc"
