/***************************************************************************
                           krootcontainerimpl.h - 
                         ---------------------------
    begin                : Sat Feb 10 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.3 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KROOTCONTAINERIMPL_H
#define KROOTCONTAINERIMPL_H

#include "kcontainerimpl.h"

class KNotifyChange;

/**
 * @short root container for @ref KObjectImpl hierarchy objects
 *
 * @author Sergio Moretti
 *
 * @version $Id: krootcontainerimpl.h,v 1.3 2001/03/23 17:14:59 sergio Exp $
 */

class KRootContainerImpl : public KContainerImpl 
{
   Q_OBJECT

   static const char DOCID[];
   static const char DOCTYPE[];

public:
   KRootContainerImpl(int type);
   virtual ~KRootContainerImpl();

   bool init(const QString &fileName, bool createMode, KNotifyChange *cb);

   /** document name */
   virtual const char * docId() const { return DOCID; }

   /** dom document type */
   virtual const char * docType() const { return DOCTYPE; }

   /** dom document */
   virtual QDomDocument domDoc() const { return _doc; }

   virtual QDomElement domDefaults() const { return _domDefaults; }

   /** default items management */
   virtual ObjDict & defaults() { return _defaults; }

   /** document file name */
   QString fileName() const { return _fileName; }

   /** assign an id */
   virtual int assignId();

   /** return true if object's hierarchy is modified */
   virtual bool isModified() const { return _modified; }

   /** set the need saving flag for object hierarchy */
   virtual void setModified() { _modified = true; }

   /** reset the modified flag for object hierarchy */
   void resetModified() { _modified = false; }

   virtual void initDefaults();

   virtual KObjectImpl * defaultLoad(const QDomElement &e);

   virtual KObjectImpl * findDefault(int type);

   int itemCountGlobal() const { return _itemCountGlobal; }

   void incrItemGlobal(int v) { _itemCountGlobal += v; }

   int itemActiveCountGlobal() const { return _itemActiveCountGlobal; }

   void incrItemActiveGlobal(int v);

   virtual void loadData();

   /** save data */
   virtual bool save(const QString &filename = QString::null);

   /** emit signal of obj modification */
   virtual void signalMod(KObjectImpl *obj);
   
   /** set callback */
   void setCallback(KNotifyChange *cb) { _callback = cb; }
   
protected:
   //KRootContainerImpl(int type);

   const KRootContainerImpl * global() const;

private:
   /** global dom document */
   QDomDocument _doc;
   QDomElement _domDefaults;
   ObjDict _defaults;
   KNotifyChange *_callback;
   QString _fileName;
   /** id counter */
   int _idCnt;
   /** flag to signal modified tree */
   bool _modified;
   /** total number of leaf items active */
   int _itemActiveCountGlobal;
   /** total number of leafs */
   int _itemCountGlobal;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
