/***************************************************************************
                           krootcontainerimpl.cpp -
                         ---------------------------
    begin                : Sat Feb 10 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.7 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <qtextstream.h>
#include "knotifychange.h"
#include "kfactoryimpl.h"
#include "krootcontainerimpl.h"

const char KRootContainerImpl::DOCID[] = "Root";
const char KRootContainerImpl::DOCTYPE[] = "<!DOCTYPE Root >";

KRootContainerImpl::KRootContainerImpl(int type)
   : KContainerImpl(type), _callback(0), _idCnt(0), _modified(false),
     _itemActiveCountGlobal(0), _itemCountGlobal(0)
{
   _defaults.setAutoDelete(true);
}

KRootContainerImpl::~KRootContainerImpl()
{
   kdDebug(D_INI) << name() << ": KRootContainer destroy" << endl;
   kdError(isModified(), D_INI) << name() << ": destroying modified root" << endl;
   delete _callback;
   _domDefaults.clear();
}

bool KRootContainerImpl::init(const QString &fileName,
			  bool createMode,
			  KNotifyChange *cb)
{
   QFile file(fileName);
   if (!file.exists() && !createMode)
   {
      kdDebug(D_INI) << "Document File not Exist" << endl;
      return false;
   }
   if (!file.open(IO_ReadWrite))
   {
      kdDebug(D_INI) << "Document File Open Error" << endl;
      return false;
   }
   QDomDocument doc(DOC);
   if (file.size() == 0)
      if (createMode)
      {
	 // create a new document
	 QDomElement e = doc.createElement(DOC);
	 e.setAttribute("Version", DOCVERS);
	 doc.appendChild(e);
      }
      else
      {
	 kdDebug(D_INI) << "Document File Empty" << endl;
	 return false;
      }
   else if (!doc.setContent(&file))
   {
      kdError(D_INI) << "Error in reading document" << endl;
      file.close();
      return false;
   }
   file.close();
   // check for document correctness
   if (doc.doctype().name() != DOC)
   {
      kdError(D_INI) << "Document type " << doc.doctype().name() << " != " << DOC << endl;
      return false;
   }
   QDomElement e = doc.documentElement();
   if (e.attribute("Version") != DOCVERS)
   {
      kdError(D_INI) << "Document Version " << e.attribute("Version") << " != " << DOCVERS << endl;
      return false;
   }
   // load root container object
   e = e.namedItem(docId()).toElement();
   if (e.isNull())
   {
      // create root container
      e = doc.createElement(docId());
      e.setAttribute("Version", DOCVERS);
      doc.documentElement().appendChild(e);
      e.setAttribute("Id", "2");
      e.setAttribute("Name", QString("%1-%2").arg(docId()).arg(QFileInfo(fileName).fileName()));
      e.setAttribute("Type", QString().setNum(type()));
      // itemType hardcoded in KMManager::loadData
      //e.setAttribute("ItemType", QString().setNum(TYP_TMANAGER_T));
      //kdDebug(D_INI) << "DOC: " << doc.toString() << endl;
   }
   _doc = doc;
   _fileName = fileName;
   load(0, e);
   resetMods();
   resetModified();
   // init callback after tree initialization
   _callback = cb;
   //kdDebug(D_INI) << "D2:" << domDoc().toString() << endl;
   return true;
}

int KRootContainerImpl::assignId()
{
   dom().setAttribute("IdCnt", ++_idCnt);
   return _idCnt;
}

KObjectImpl * KRootContainerImpl::defaultLoad(const QDomElement &e)
{
   kdDebug(D_INI) << name() << ": default item load " << e.attribute("Name") << endl;
   // load and insert default instance
   int type = e.attribute("Type").toInt();
   KObjectImpl * obj = KFactoryImpl::factory()->createObject(type);
   obj->load(this, e);
   defaults().insert(type, obj);
   return obj;
}

KObjectImpl * KRootContainerImpl::findDefault(int type)
{
   KObjectImpl *def = defaults()[type];
   kdError(def == 0, D_INI) << name() << ": unknown default " << type << endl;
   return def;
}

void KRootContainerImpl::initDefaults()
{
   kdDebug(D_INI) << name() << ": init defaults" << endl;
   _domDefaults = dom().namedItem("Defaults").toElement();
   if (_domDefaults.isNull())
   {
      // create defaults
      _domDefaults = domDoc().createElement("Defaults");
      dom().appendChild(_domDefaults);
      IntList lst = KFactoryImpl::factory()->typeList(TYP_OBJECT_T);
      lst.remove(type()); // remove root type
      for (IntList::Iterator i = lst.begin(); i != lst.end(); ++i)
	 objectNew(*i, NEW_DEFAULT);
      setModified();
   }
   else
   {
      // load defaults
      QDomNode n = domDefaults().firstChild();
      while (!n.isNull())
      {
	 QDomElement item = n.toElement();
	 if (item.isNull())
	    /* throw */
	    new DomError(name(), i18n("node unknown"), n);
	 if (KFactoryImpl::factory()->prototype(item.attribute("Type").toInt()) != 0)
	    defaultLoad(item);
	 else
	    kdWarning(D_RUN) << name() << " skip unknown default " << item.attribute("Name") << endl;
	 n = n.nextSibling();
      }
      // check to see if all defaults are loaded
      IntList lst = KFactoryImpl::factory()->typeList(TYP_OBJECT_T);
      lst.remove(type()); // remove root type
      for(IntList::Iterator i = lst.begin(); i != lst.end(); i++)
	 if (findDefault(*i) == 0)
	 {
	    kdWarning(D_RUN) << name() << " add Default " << KFactoryImpl::factory()->typeStr(*i) << endl;
	    objectNew(*i, NEW_DEFAULT);
	    setModified();
	 }
   }
}

void KRootContainerImpl::incrItemActiveGlobal(int v)
{
   if (v == 0)
      return;
   if (_itemActiveCountGlobal == 0)
      setMod(MDI_START);
   _itemActiveCountGlobal += v;
   if (_itemActiveCountGlobal == 0)
      setMod(MDI_STOP);
}

void KRootContainerImpl::loadData()
{
   //FIXME _doc needs to be already defined
   initDefaults();
   _idCnt = dom().attribute("IdCnt", "2").toInt();

   // main manager has no global
   dom().setAttribute("GlobalCfg", 0);
   KContainerImpl::loadData();
   kdDebug(D_INI) << name() << ": RootContainer loadData" << endl;
}

bool KRootContainerImpl::save(const QString &f)
{
   kdDebug(D_RUN) << name() << ": save document" << endl;
   //<< domDoc().toString() << "END DOCUMENT" << endl;
   QString filename;
   if (f.isEmpty())
      filename = _fileName;
   else
      filename = f;
   QFile file(filename);
   if (!file.open(IO_WriteOnly | IO_Truncate))
      return false;
   QTextStream s(&file);
   //FIXME!!!!
   s << domDoc().toString();
   //s << "<?xml version = '1.0'?><!DOCTYPE " << DOC "-" DOCVERS << " >";
   //domDoc().documentElement().save(s, 0);
   file.close();
   _fileName = filename;
   setName(QString("MManager-%1").arg(QFileInfo(filename).fileName()));
   resetModified();
   return true;
}

void KRootContainerImpl::signalMod(KObjectImpl *obj)
{
   if (_callback)
      (*_callback)(KObject(obj));
   //obj->resetMods(); call this in event handler
}

#include "krootcontainerimpl.moc"

/* Local Variables: */
/* mode: c++ */
/* End: */
