/***************************************************************************
                          kmmanagericonview.h  -  description
                             -------------------
    begin                : Wed Dec 20 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.9 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMMANAGERICONVIEW_H
#define KMMANAGERICONVIEW_H

#include <kiconview.h>
#include <kaction.h>
#include <kconfig.h>
#include "kcontainerview.h"
#include "ktmanager.h"

class KMagoView;
class KMManagerIconItem;
class KMManagerIconDrag;

/**
 * @short IconView to display @ref KMManager contents.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kmmanagericonview.h,v 1.9 2001/03/23 17:14:59 sergio Exp $
 */

class KMManagerIconView : public KIconView, public KContainerView 
{
   Q_OBJECT

public:
   KMManagerIconView(KMManager m, KMagoDoc *doc, Callback cb, QWidget *parent, 
		     const char *name = 0);
   virtual ~KMManagerIconView();

   virtual KMagoView * view() const;
   virtual const char * name() const { return KIconView::name(); }

   //virtual QSize sizeHint() const { return QSize(200, 100); }
   virtual QSize minimumSizeHint() const { return QSize(0, 0); }
   virtual void setOrientation(bool vert);

   KMManagerIconItem * itemFind(KObject item) const;
   virtual void itemAdd(KObject item);
   virtual void itemRemove(KObject item);
   virtual void itemSelect(KObject item);
   virtual void itemUpdate(KObject item);
   virtual void itemUpdateText(KObject item);
   virtual KObject itemFirst() const;
   virtual KObject itemAbove(KObject item) const;
   virtual KObject itemBelow(KObject item) const;
   virtual void clear() { KIconView::clear(); }
   virtual void initView();
   virtual void applySettings(KConfig *);
   virtual void saveSettings(KConfig *);
   virtual void setSortBy(ModIndex p, bool increasing = true);
   virtual ModIndex sortBy() const { return _sortIdx[_sortingMode->currentItem()]; }
   virtual bool sortDir() const { return _sortingDir->currentItem() == 0; }

protected:
   void initActions();
   virtual QDragObject* dragObject();
   void contentsDragMoveEvent(QDragMoveEvent *event);
   //void contentsDropEvent(QDropEvent *event);

protected slots:
   void slotDropped(QDropEvent * e, const QValueList<QIconDragItem> & lst);
   void slotExecuted(QIconViewItem *item);
   void slotRightButtonPressed(QIconViewItem *i, const QPoint &p);
   void slotSelectionChanged(QIconViewItem *i);
   void slotItemRenamed(QIconViewItem * item, const QString &name);
   void slotSortingMode();
   void slotSortingDir();

signals:
   void sigSelectionChanged(KObject item);

private:
   KSelectAction *_sortingMode;
   KSelectAction *_sortingDir;
   ModIndex _sortIdx[2];
};


/**
 * @short IconView Item to display @ref KTManager.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kmmanagericonview.h,v 1.9 2001/03/23 17:14:59 sergio Exp $
 */

class KMManagerIconItem : public QIconViewItem 
{
public:
   KMManagerIconItem(KIconView *parent, KTManager mngr);
   virtual ~KMManagerIconItem() {}
   KTManager manager() const { return m; }
   void update();
   virtual bool acceptDrop ( const QMimeSource * mime ) const;

protected:
   virtual void dropped (QDropEvent * e, const QValueList<QIconDragItem> & lst);
   virtual QString key() const;
   QString sortByTitle() const;
   QString sortByPriority() const;

private:
   KTManager m;
   QString (KMManagerIconItem::*_sortFunction)() const;
};

/**
 * @short Drag object for @ref KTManager object.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kmmanagericonview.h,v 1.9 2001/03/23 17:14:59 sergio Exp $
 */

class KMManagerIconDrag : public QIconDrag 
{
   Q_OBJECT

public:
   KMManagerIconDrag(QWidget *dragSource, const char *name = 0);
   virtual ~KMManagerIconDrag() {}
   const char * format(int i) const;
   virtual QByteArray encodedData(const char* mimetype) const;
   static bool canDecode(const QMimeSource *e);
   virtual void append(const KTManager item, const QRect &pr, const QRect &tr);

private:
   KTManager::List mngrs;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
