/***************************************************************************
                          kmagoview.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.18 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMAGOVIEW_H
#define KMAGOVIEW_H

#include <qwidget.h>
#include <klistview.h>
#include <kiconview.h>
#include <qsplitter.h>
#include <kaction.h>
#include <qdatetime.h>
#include "ktransfer.h"
#include "ktmanager.h"

class KMagoDoc;
class KContainerView;
class KMManagerIconView;
class KMManagerListView;

/** 
 * @short The KMagoView class provides the view widget for KMagoApp instance.
 * 	
 * @author Sergio Moretti
 * 
 * @version $Id: kmagoview.h,v 1.18 2001/03/23 17:14:59 sergio Exp $
 * 
 * The View instance inherits QWidget as a base class and represents the view 
 * object of a KTMainWindow. As KMagoView is part of the docuement-view model, 
 * it needs a reference to the document object connected with it by the 
 * KMagoApp class to manipulate and display the document structure provided by 
 * the KMagoDoc class.
 */

class KMagoView : public QSplitter 
{
   Q_OBJECT

public:
   /** Constructor for the main view */
   KMagoView(KMagoDoc *doc, QWidget *parent, const char *name=0);
   /** Destructor for the main view */
   ~KMagoView();

   virtual QSize sizeHint() const { return QSize(300, 200); }

   KContainerView * managerView() const { return _managerView; }
   KContainerView * transferView() const { return _transferView; }

   /** init menus variables, to be called after main->createGUI */
   void initMenu();
   void initView();
   /** reset view */
   void reset();
   /** apply settings */
   void applySettings(KConfig *config);
   /** save settings */
   void saveSettings(KConfig *config);

   /** show/hide managers view */
   void showManagers(bool on);
   /** set split orientation */
   void setOrientation(bool vert);

   QPopupMenu * transferMenu() const { return _transferMenu; }
   QPopupMenu * managerMenu() const { return _managerMenu; }

protected:
   /** 
    * returns a pointer to the document connected to the view instance. Mind 
    * that this method requires a KMagoApp instance as a parent widget to get 
    * to the window document pointer by calling the KMagoApp::getDocument() 
    * method.
    * @see KMagoApp#getDocument
    */
   KMagoDoc *doc() const;
   void initActions();

protected slots:
   /** 
    * change the current manager/transfer in response to a change in the 
    * selected item 
    */
   void slotSetCurrentManager(KObject item);
   void slotSetCurrentTransfer(KObject item);
   void slotManagerViewMode();
   /** set splitter orientation */
   void slotOrientation();

private:
   KMagoDoc *_doc;
   KContainerView * _managerView;
   KContainerView * _transferView;
   KMManagerIconView *_miv;
   KMManagerListView *_mlv;
   KSelectAction * _managerViewMode;
   KToggleAction *_orientation;

   QPopupMenu
   *_transferMenu,
      *_managerMenu;
};

#endif // KMAGOVIEW_H

/* Local Variables: */
/* mode: c++ */
/* End: */
